/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.core.api;

import com.mojang.blaze3d.matrix.MatrixStack;
import mod.chiselsandbits.api.APIExceptions;
import mod.chiselsandbits.api.IBitAccess;
import mod.chiselsandbits.api.IBitBag;
import mod.chiselsandbits.api.IBitBrush;
import mod.chiselsandbits.api.IBitLocation;
import mod.chiselsandbits.api.IChiselAndBitsAPI;
import mod.chiselsandbits.api.ItemType;
import mod.chiselsandbits.api.ModKeyBinding;
import mod.chiselsandbits.api.ParameterType;
import mod.chiselsandbits.chiseledblock.BlockBitInfo;
import mod.chiselsandbits.chiseledblock.BlockChiseled;
import mod.chiselsandbits.chiseledblock.ItemBlockChiseled;
import mod.chiselsandbits.chiseledblock.TileEntityBlockChiseled;
import mod.chiselsandbits.chiseledblock.data.BitLocation;
import mod.chiselsandbits.chiseledblock.data.VoxelBlob;
import mod.chiselsandbits.client.RenderHelper;
import mod.chiselsandbits.client.UndoTracker;
import mod.chiselsandbits.core.ChiselsAndBits;
import mod.chiselsandbits.core.ClientSide;
import mod.chiselsandbits.core.api.BitAccess;
import mod.chiselsandbits.core.api.BitBrush;
import mod.chiselsandbits.helpers.BitInventoryFeeder;
import mod.chiselsandbits.helpers.BitOperation;
import mod.chiselsandbits.helpers.DeprecationHelper;
import mod.chiselsandbits.helpers.ModUtil;
import mod.chiselsandbits.items.ItemBitBag;
import mod.chiselsandbits.items.ItemChisel;
import mod.chiselsandbits.items.ItemChiseledBit;
import mod.chiselsandbits.items.ItemMirrorPrint;
import mod.chiselsandbits.items.ItemNegativePrint;
import mod.chiselsandbits.items.ItemPositivePrint;
import mod.chiselsandbits.items.ItemWrench;
import mod.chiselsandbits.modes.ChiselMode;
import mod.chiselsandbits.modes.PositivePatternMode;
import mod.chiselsandbits.modes.TapeMeasureModes;
import mod.chiselsandbits.registry.ModBlocks;
import mod.chiselsandbits.registry.ModItems;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItem;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;

public class ChiselAndBitsAPI
implements IChiselAndBitsAPI {
    @Override
    public void addEquivilantMaterial(Material newMaterial, Material target) {
        ModBlocks.convertMaterialTo(newMaterial, target);
    }

    @Override
    public boolean canBeChiseled(World world, BlockPos pos) {
        if (world == null || pos == null) {
            return false;
        }
        BlockState state = world.func_180495_p(pos);
        return state.func_177230_c() == Blocks.field_150350_a || BlockBitInfo.canChisel(state) || ModUtil.getChiseledTileEntity(world, pos, false) != null;
    }

    @Override
    public boolean isBlockChiseled(World world, BlockPos pos) {
        if (world == null || pos == null) {
            return false;
        }
        return ModUtil.getChiseledTileEntity(world, pos, false) != null;
    }

    @Override
    public IBitAccess getBitAccess(World world, BlockPos pos) throws APIExceptions.CannotBeChiseled {
        if (world == null || pos == null) {
            throw new APIExceptions.CannotBeChiseled();
        }
        BlockState state = world.func_180495_p(pos);
        if (BlockBitInfo.isSupported(state) && !(state.func_177230_c() instanceof BlockChiseled)) {
            VoxelBlob blob = new VoxelBlob();
            blob.fill(ModUtil.getStateId(state));
            return new BitAccess(world, pos, blob, VoxelBlob.NULL_BLOB);
        }
        if (world.func_175623_d(pos)) {
            VoxelBlob blob = new VoxelBlob();
            return new BitAccess(world, pos, blob, VoxelBlob.NULL_BLOB);
        }
        TileEntityBlockChiseled te = ModUtil.getChiseledTileEntity(world, pos, true);
        if (te != null) {
            VoxelBlob mask = new VoxelBlob();
            return new BitAccess(world, pos, te.getBlob(), mask);
        }
        throw new APIExceptions.CannotBeChiseled();
    }

    @Override
    public IBitBrush createBrush(ItemStack stack) throws APIExceptions.InvalidBitItem {
        int stateID;
        BlockState state;
        if (ModUtil.isEmpty(stack)) {
            return new BitBrush(0);
        }
        if (this.getItemType(stack) == ItemType.CHISLED_BIT && (state = ModUtil.getStateById(stateID = ItemChiseledBit.getStackState(stack))) != null && BlockBitInfo.canChisel(state)) {
            return new BitBrush(stateID);
        }
        throw new APIExceptions.InvalidBitItem();
    }

    @Override
    public IBitLocation getBitPos(double hitX, double hitY, double hitZ, Direction side, BlockPos pos, boolean placement) {
        BlockRayTraceResult mop = new BlockRayTraceResult(new Vector3d(hitX, hitY, hitZ), side, pos, false);
        return new BitLocation(mop, placement ? BitOperation.PLACE : BitOperation.CHISEL);
    }

    @Override
    public ItemType getItemType(ItemStack stack) {
        if (stack.func_77973_b() instanceof ItemChiseledBit) {
            return ItemType.CHISLED_BIT;
        }
        if (stack.func_77973_b() instanceof ItemBitBag) {
            return ItemType.BIT_BAG;
        }
        if (stack.func_77973_b() instanceof ItemChisel) {
            return ItemType.CHISEL;
        }
        if (stack.func_77973_b() instanceof ItemBlockChiseled) {
            return ItemType.CHISLED_BLOCK;
        }
        if (stack.func_77973_b() instanceof ItemMirrorPrint) {
            return ItemType.MIRROR_DESIGN;
        }
        if (stack.func_77973_b() instanceof ItemPositivePrint) {
            return ItemType.POSITIVE_DESIGN;
        }
        if (stack.func_77973_b() instanceof ItemNegativePrint) {
            return ItemType.NEGATIVE_DESIGN;
        }
        if (stack.func_77973_b() instanceof ItemWrench) {
            return ItemType.WRENCH;
        }
        return null;
    }

    @Override
    public IBitAccess createBitItem(ItemStack stack) {
        BlockState state;
        if (ModUtil.isEmpty(stack)) {
            return new BitAccess(null, null, new VoxelBlob(), VoxelBlob.NULL_BLOB);
        }
        ItemType type = this.getItemType(stack);
        if (type != null && type.isBitAccess) {
            VoxelBlob blob = ModUtil.getBlobFromStack(stack, null);
            return new BitAccess(null, null, blob, VoxelBlob.NULL_BLOB);
        }
        if (stack.func_77973_b() instanceof BlockItem && BlockBitInfo.canChisel(state = DeprecationHelper.getStateFromItem(stack))) {
            VoxelBlob blob = new VoxelBlob();
            blob.fill(ModUtil.getStateId(state));
            return new BitAccess(null, null, blob, VoxelBlob.NULL_BLOB);
        }
        return null;
    }

    @Override
    public IBitBrush createBrushFromState(BlockState state) throws APIExceptions.InvalidBitItem {
        if (state == null || state.func_177230_c() == Blocks.field_150350_a) {
            return new BitBrush(0);
        }
        if (!BlockBitInfo.canChisel(state)) {
            throw new APIExceptions.InvalidBitItem();
        }
        return new BitBrush(ModUtil.getStateId(state));
    }

    @Override
    public ItemStack getBitItem(BlockState state) throws APIExceptions.InvalidBitItem {
        if (!BlockBitInfo.canChisel(state)) {
            throw new APIExceptions.InvalidBitItem();
        }
        return ItemChiseledBit.createStack(ModUtil.getStateId(state), 1, true);
    }

    @Override
    public void giveBitToPlayer(PlayerEntity player, ItemStack stack, Vector3d spawnPos) {
        if (ModUtil.isEmpty(stack)) {
            return;
        }
        if (spawnPos == null) {
            spawnPos = new Vector3d(player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_());
        }
        ItemEntity ei = new ItemEntity(player.func_130014_f_(), spawnPos.field_72450_a, spawnPos.field_72448_b, spawnPos.field_72449_c, stack);
        if (stack.func_77973_b() == ModItems.ITEM_BLOCK_BIT.get()) {
            if (player.func_130014_f_().field_72995_K) {
                return;
            }
            BitInventoryFeeder feeder = new BitInventoryFeeder(player, player.func_130014_f_());
            feeder.addItem(ei);
            return;
        }
        if (!player.field_71071_by.func_70441_a(stack)) {
            ei.func_92058_a(stack);
            player.func_130014_f_().func_217376_c((Entity)ei);
        }
    }

    @Override
    public IBitBag getBitbag(ItemStack stack) {
        LazyOptional o;
        if (!ModUtil.isEmpty(stack) && (o = stack.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, Direction.UP)) instanceof IBitBag) {
            return (IBitBag)o;
        }
        return null;
    }

    @Override
    public void beginUndoGroup(PlayerEntity player) {
        UndoTracker.getInstance().beginGroup(player);
    }

    @Override
    public void endUndoGroup(PlayerEntity player) {
        UndoTracker.getInstance().endGroup(player);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public KeyBinding getKeyBinding(ModKeyBinding modKeyBinding) {
        switch (modKeyBinding) {
            case SINGLE: {
                return (KeyBinding)ChiselMode.SINGLE.binding;
            }
            case SNAP2: {
                return (KeyBinding)ChiselMode.SNAP2.binding;
            }
            case SNAP4: {
                return (KeyBinding)ChiselMode.SNAP4.binding;
            }
            case SNAP8: {
                return (KeyBinding)ChiselMode.SNAP8.binding;
            }
            case LINE: {
                return (KeyBinding)ChiselMode.LINE.binding;
            }
            case PLANE: {
                return (KeyBinding)ChiselMode.PLANE.binding;
            }
            case CONNECTED_PLANE: {
                return (KeyBinding)ChiselMode.CONNECTED_PLANE.binding;
            }
            case CUBE_SMALL: {
                return (KeyBinding)ChiselMode.CUBE_SMALL.binding;
            }
            case CUBE_MEDIUM: {
                return (KeyBinding)ChiselMode.CUBE_MEDIUM.binding;
            }
            case CUBE_LARGE: {
                return (KeyBinding)ChiselMode.CUBE_LARGE.binding;
            }
            case SAME_MATERIAL: {
                return (KeyBinding)ChiselMode.SAME_MATERIAL.binding;
            }
            case DRAWN_REGION: {
                return (KeyBinding)ChiselMode.DRAWN_REGION.binding;
            }
            case CONNECTED_MATERIAL: {
                return (KeyBinding)ChiselMode.CONNECTED_MATERIAL.binding;
            }
            case REPLACE: {
                return (KeyBinding)PositivePatternMode.REPLACE.binding;
            }
            case ADDITIVE: {
                return (KeyBinding)PositivePatternMode.ADDITIVE.binding;
            }
            case PLACEMENT: {
                return (KeyBinding)PositivePatternMode.PLACEMENT.binding;
            }
            case IMPOSE: {
                return (KeyBinding)PositivePatternMode.IMPOSE.binding;
            }
            case BIT: {
                return (KeyBinding)TapeMeasureModes.BIT.binding;
            }
            case BLOCK: {
                return (KeyBinding)TapeMeasureModes.BLOCK.binding;
            }
            case DISTANCE: {
                return (KeyBinding)TapeMeasureModes.DISTANCE.binding;
            }
        }
        return ClientSide.instance.getKeyBinding(modKeyBinding);
    }

    public Object getParameter(ParameterType which) {
        switch (which.getType()) {
            case BOOLEAN: {
                switch ((ParameterType.BooleanParam)which) {
                    case ENABLE_DAMAGE_TOOLS: {
                        return ChiselsAndBits.getConfig().getServer().damageTools.get();
                    }
                    case ENABLE_BIT_LIGHT_SOURCE: {
                        return ChiselsAndBits.getConfig().getServer().enableBitLightSource.get();
                    }
                }
                break;
            }
            case DOUBLE: {
                switch ((ParameterType.DoubleParam)which) {
                    case BIT_MAX_DRAWN_REGION_SIZE: {
                        return ChiselsAndBits.getConfig().getClient().maxDrawnRegionSize.get();
                    }
                }
                break;
            }
            case FLOAT: {
                switch ((ParameterType.FloatParam)which) {
                    case BLOCK_FULL_LIGHT_PERCENTAGE: {
                        return ChiselsAndBits.getConfig().getServer().bitLightPercentage.get();
                    }
                }
                break;
            }
            case INTEGER: {
                switch ((ParameterType.IntegerParam)which) {
                    case BIT_BAG_MAX_STACK_SIZE: {
                        return ChiselsAndBits.getConfig().getServer().bagStackSize.get();
                    }
                }
            }
        }
        return null;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void renderModel(MatrixStack stack, IBakedModel model, World world, BlockPos pos, int alpha, int combinedLight, int combinedOverlay) {
        RenderHelper.renderModel(stack, model, world, pos, alpha << 24, combinedLight, combinedOverlay);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void renderGhostModel(MatrixStack stack, IBakedModel model, World world, BlockPos pos, boolean isUnplaceable, int combinedLight, int combinedOverlay) {
        RenderHelper.renderGhostModel(stack, model, world, pos, isUnplaceable, combinedLight, combinedOverlay);
    }
}

