/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.core;

import java.lang.reflect.Field;
import java.util.Map;
import mod.chiselsandbits.helpers.ModUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.IngameGui;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.loading.FMLLoader;

public class ReflectionWrapper {
    public static final ReflectionWrapper instance = new ReflectionWrapper();
    private Field highlightingItemStack = null;
    private Field mapRegSprites = null;

    private Field findField(Class<?> clz, String ... methods) throws Exception {
        while (clz != null && clz != Object.class) {
            for (String name : methods) {
                try {
                    Field f = clz.getDeclaredField(name);
                    if (f == null) continue;
                    return f;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            clz = clz.getSuperclass();
        }
        throw new Exception("Unable to find field " + methods[0]);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void setHighlightStack(ItemStack is) {
        try {
            IngameGui o = Minecraft.func_71410_x().field_71456_v;
            if (this.highlightingItemStack == null) {
                this.highlightingItemStack = this.findField(o.getClass(), "highlightingItemStack", "field_92016_l");
            }
            this.highlightingItemStack.setAccessible(true);
            this.highlightingItemStack.set(o, is);
        }
        catch (Throwable t) {
            this.notifyDeveloper(t);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void clearHighlightedStack() {
        this.setHighlightStack(ModUtil.getEmptyStack());
    }

    @OnlyIn(value=Dist.CLIENT)
    public void endHighlightedStack() {
        this.setHighlightStack(Minecraft.func_71410_x().field_71439_g.func_184614_ca());
    }

    @OnlyIn(value=Dist.CLIENT)
    public Map<String, TextureAtlasSprite> getRegSprite(AtlasTexture map) {
        try {
            if (this.mapRegSprites == null) {
                this.mapRegSprites = this.findField(map.getClass(), "mapUploadedSprites", "field_94252_e");
            }
            this.mapRegSprites.setAccessible(true);
            return (Map)this.mapRegSprites.get(map);
        }
        catch (Throwable t) {
            this.notifyDeveloper(t);
            return null;
        }
    }

    private void notifyDeveloper(Throwable t) {
        if (this.deobfuscatedEnvironment()) {
            throw new RuntimeException(t);
        }
    }

    private boolean deobfuscatedEnvironment() {
        return !FMLLoader.isProduction();
    }
}

