/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.client;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import mod.chiselsandbits.chiseledblock.data.VoxelBlobStateReference;
import mod.chiselsandbits.client.UndoStep;
import mod.chiselsandbits.core.ChiselsAndBits;
import mod.chiselsandbits.core.ClientSide;
import mod.chiselsandbits.helpers.ActingPlayer;
import mod.chiselsandbits.interfaces.ICacheClearable;
import mod.chiselsandbits.network.packets.PacketUndo;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class UndoTracker
implements ICacheClearable {
    private static final UndoTracker instance = new UndoTracker();
    private int level = -1;
    private boolean recording = true;
    private boolean grouping = false;
    private boolean hasCreatedGroup = false;
    private final List<UndoStep> undoLevels = new ArrayList<UndoStep>();
    private final Set<String> errors = new HashSet<String>();
    private RuntimeException groupStarted;

    public static UndoTracker getInstance() {
        return instance;
    }

    public UndoTracker() {
        ChiselsAndBits.getInstance().addClearable(this);
    }

    public void add(World world, BlockPos pos, VoxelBlobStateReference before, VoxelBlobStateReference after) {
        if (pos != null && world != null && world.field_72995_K && this.recording) {
            if (this.undoLevels.size() > this.level && !this.undoLevels.isEmpty()) {
                int end = Math.max(-1, this.level);
                for (int x = this.undoLevels.size() - 1; x > end; --x) {
                    this.undoLevels.remove(x);
                }
            }
            if (this.undoLevels.size() > (Integer)ChiselsAndBits.getConfig().getClient().maxUndoLevel.get()) {
                this.undoLevels.remove(0);
            }
            if (this.level >= this.undoLevels.size()) {
                this.level = this.undoLevels.size() - 1;
            }
            if (this.grouping && this.hasCreatedGroup) {
                UndoStep current = this.undoLevels.get(this.undoLevels.size() - 1);
                UndoStep newest = new UndoStep(world.func_234923_W_().getRegistryName(), pos, before, after);
                this.undoLevels.set(this.undoLevels.size() - 1, newest);
                newest.next = current;
                return;
            }
            this.undoLevels.add(new UndoStep(world.func_234923_W_().getRegistryName(), pos, before, after));
            this.hasCreatedGroup = true;
            this.level = this.undoLevels.size() - 1;
        }
    }

    public void undo() {
        if (this.level > -1) {
            UndoStep step = this.undoLevels.get(this.level);
            PlayerEntity who = ClientSide.instance.getPlayer();
            if (this.correctWorld(who, step) && step.after != null && step.before != null) {
                ActingPlayer player;
                ActingPlayer testPlayer = ActingPlayer.testingAs(who, Hand.MAIN_HAND);
                boolean result = this.replayChanges(testPlayer, step, true, false);
                if (result && this.replayChanges(player = ActingPlayer.actingAs(who, Hand.MAIN_HAND), step, true, true)) {
                    --this.level;
                }
                this.displayError();
            }
        } else {
            ClientSide.instance.getPlayer().func_145747_a((ITextComponent)new TranslationTextComponent("mod.chiselsandbits.result.nothing_to_undo"), null);
        }
    }

    public void redo() {
        if (this.level + 1 < this.undoLevels.size()) {
            UndoStep step = this.undoLevels.get(this.level + 1);
            PlayerEntity who = ClientSide.instance.getPlayer();
            if (this.correctWorld(who, step)) {
                ActingPlayer player;
                ActingPlayer testPlayer = ActingPlayer.testingAs(who, Hand.MAIN_HAND);
                boolean result = this.replayChanges(testPlayer, step, false, false);
                if (result && this.replayChanges(player = ActingPlayer.actingAs(who, Hand.MAIN_HAND), step, false, true)) {
                    ++this.level;
                }
                this.displayError();
            }
        } else {
            ClientSide.instance.getPlayer().func_145747_a((ITextComponent)new TranslationTextComponent("mod.chiselsandbits.result.nothing_to_redo"), null);
        }
    }

    private boolean replayChanges(ActingPlayer player, UndoStep step, boolean backwards, boolean spawnItemsAndCommitWorldChanges) {
        boolean done = false;
        while (step != null && this.replaySingleAction(player, step.pos, backwards ? step.after : step.before, backwards ? step.before : step.after, spawnItemsAndCommitWorldChanges)) {
            step = step.next;
            if (step != null) continue;
            done = true;
        }
        return done;
    }

    private boolean correctWorld(PlayerEntity player, UndoStep step) {
        return player.func_130014_f_().func_234923_W_().getRegistryName().equals((Object)step.dimensionId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean replaySingleAction(ActingPlayer player, BlockPos pos, VoxelBlobStateReference before, VoxelBlobStateReference after, boolean spawnItemsAndCommitWorldChanges) {
        try {
            this.recording = false;
            PacketUndo packet = new PacketUndo(pos, before, after);
            if (packet.preformAction(player, spawnItemsAndCommitWorldChanges)) {
                ChiselsAndBits.getNetworkChannel().sendToServer(packet);
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.recording = true;
        }
    }

    public boolean ignorePlayer(PlayerEntity player) {
        return player.func_130014_f_() == null || !player.func_130014_f_().field_72995_K;
    }

    public void beginGroup(PlayerEntity player) {
        if (this.ignorePlayer(player)) {
            return;
        }
        if (this.grouping) {
            throw new RuntimeException("Opening a new group, previous group already started.", this.groupStarted);
        }
        this.groupStarted = new RuntimeException("Group was not closed properly.");
        this.groupStarted.fillInStackTrace();
        this.grouping = true;
        this.hasCreatedGroup = false;
    }

    public void endGroup(PlayerEntity player) {
        if (this.ignorePlayer(player)) {
            return;
        }
        if (!this.grouping) {
            throw new RuntimeException("Closing undo group, but no undogroup was started.");
        }
        this.groupStarted = null;
        this.grouping = false;
    }

    @OnlyIn(value=Dist.CLIENT)
    private void displayError() {
        for (String err : this.errors) {
            ClientSide.instance.getPlayer().func_145747_a((ITextComponent)new TranslationTextComponent(err), null);
        }
        this.errors.clear();
    }

    public void addError(ActingPlayer player, String string) {
        if (!player.isReal() && player.getWorld().field_72995_K) {
            this.errors.add(string);
        }
    }

    public void onNetworkUpdate(VoxelBlobStateReference beforeUpdate, VoxelBlobStateReference afterUpdate) {
        this.undoLevels.forEach(step -> step.onNetworkUpdate(beforeUpdate, afterUpdate));
    }

    @Override
    public void clearCache() {
        this.level = -1;
        this.undoLevels.clear();
    }
}

