/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.chiseledblock.data;

import java.util.Collection;
import mod.chiselsandbits.api.BoxType;
import mod.chiselsandbits.chiseledblock.data.VoxelBlob;
import mod.chiselsandbits.chiseledblock.data.VoxelBlobStateReference;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.shapes.IBooleanFunction;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;

public class VoxelShapeCalculator {
    public static VoxelShape calculate(VoxelBlob blob, BoxType type) {
        VoxelBlobStateReference reference = new VoxelBlobStateReference(blob, 0L);
        return VoxelShapeCalculator.calculateFromBB(reference.getBoxes(type));
    }

    private static VoxelShape calculateFromBB(Collection<AxisAlignedBB> bbList) {
        return bbList.stream().reduce(VoxelShapes.func_197880_a(), (voxelShape, axisAlignedBB) -> {
            VoxelShape bbShape = VoxelShapes.func_197881_a((AxisAlignedBB)axisAlignedBB);
            return VoxelShapes.func_197882_b((VoxelShape)voxelShape, (VoxelShape)bbShape, (IBooleanFunction)IBooleanFunction.field_223244_o_);
        }, (voxelShape, voxelShape2) -> VoxelShapes.func_197882_b((VoxelShape)voxelShape, (VoxelShape)voxelShape2, (IBooleanFunction)IBooleanFunction.field_223244_o_)).func_197753_c();
    }

    private static VoxelShape calculateFromBlob(VoxelBlob blob) {
        VoxelShape collisionShape = VoxelShapes.func_197880_a();
        int x1 = 15;
        int y1 = 15;
        int z1 = 15;
        int x2 = 0;
        int y2 = 0;
        int z2 = 0;
        double bitDimension = 0.0625;
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                double dx = (double)x / 16.0;
                double dz = (double)z / 16.0;
                int start = -1;
                for (int y = 0; y < 16; ++y) {
                    if (blob.get(x, y, z) != 0) {
                        if (start != -1) continue;
                        start = y;
                        if (y >= y1) continue;
                        y1 = y;
                        continue;
                    }
                    if (start == -1) continue;
                    collisionShape = VoxelShapes.func_197872_a((VoxelShape)collisionShape, (VoxelShape)VoxelShapes.func_197873_a((double)dx, (double)((double)start / 16.0), (double)dz, (double)(dx + bitDimension), (double)((double)y / 16.0), (double)(dz + bitDimension)));
                    start = -1;
                    if (x < x1) {
                        x1 = x;
                    }
                    if (z < z1) {
                        z1 = z;
                    }
                    if (x > x2) {
                        x2 = x;
                    }
                    if (y > y2) {
                        y2 = y - 1;
                    }
                    if (z <= z2) continue;
                    z2 = z;
                }
                if (start == -1) continue;
                collisionShape = VoxelShapes.func_197872_a((VoxelShape)collisionShape, (VoxelShape)VoxelShapes.func_197873_a((double)dx, (double)((double)start / 16.0), (double)dz, (double)(dx + bitDimension), (double)1.0, (double)(dz + bitDimension)));
                y2 = 15;
                if (x < x1) {
                    x1 = x;
                }
                if (z < z1) {
                    z1 = z;
                }
                if (x > x2) {
                    x2 = x;
                }
                if (z <= z2) continue;
                z2 = z;
            }
        }
        return collisionShape;
    }
}

