/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.bitbag;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.annotation.Nonnull;
import mod.chiselsandbits.bitbag.BagCapabilityProvider;
import mod.chiselsandbits.bitbag.BagStorage;
import mod.chiselsandbits.core.ChiselsAndBits;
import mod.chiselsandbits.helpers.LocalStrings;
import mod.chiselsandbits.helpers.ModUtil;
import mod.chiselsandbits.items.ItemChiseledBit;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.items.CapabilityItemHandler;

public class BagInventory
implements IInventory {
    BagStorage inv;
    ItemStack[] stackSlots;

    public BagInventory(ItemStack is) {
        this.inv = CapabilityItemHandler.ITEM_HANDLER_CAPABILITY != null ? (BagStorage)is.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null).orElseThrow(() -> new IllegalStateException("Failed to get IItemHandler from Bag!")) : null;
        this.stackSlots = new ItemStack[63];
        if (this.inv == null) {
            this.inv = new BagStorage();
            this.inv.stack = is;
            this.inv.setStorage(BagCapabilityProvider.getStorageArray(is, 126));
        }
        for (int x = 0; x < this.stackSlots.length; ++x) {
            this.stackSlots[x] = ModUtil.getEmptyStack();
        }
    }

    public ItemStack getItemStack() {
        return this.inv.stack;
    }

    public int func_70302_i_() {
        return this.stackSlots.length;
    }

    private int getStateInSlot(int index) {
        int qty = this.inv.contents[2 * index + 1];
        int id = this.inv.contents[2 * index + 0];
        if (qty > 0) {
            return id;
        }
        return 0;
    }

    @Nonnull
    public ItemStack func_70301_a(int index) {
        int qty = this.inv.contents[2 * index + 1];
        int id = this.inv.contents[2 * index + 0];
        if (ModUtil.notEmpty(this.stackSlots[index])) {
            ItemStack which = ModUtil.nonNull(this.stackSlots[index]);
            ModUtil.setStackSize(which, qty);
            return which;
        }
        if (qty == 0 || id == 0) {
            return ModUtil.getEmptyStack();
        }
        this.stackSlots[index] = ItemChiseledBit.createStack(id, qty, false);
        return this.stackSlots[index];
    }

    public ItemStack func_70298_a(int index, int count) {
        int qty = this.inv.contents[2 * index + 1];
        int id = this.inv.contents[2 * index + 0];
        if (qty == 0 || id == 0) {
            return ModUtil.getEmptyStack();
        }
        if (count > qty) {
            count = qty;
        }
        int n = 2 * index + 1;
        this.inv.contents[n] = this.inv.contents[n] - count;
        this.inv.onChange();
        if (ModUtil.notEmpty(this.stackSlots[index])) {
            ModUtil.adjustStackSize(ModUtil.nonNull(this.stackSlots[index]), -count);
        }
        return ItemChiseledBit.createStack(id, count, false);
    }

    public ItemStack func_70304_b(int index) {
        return ModUtil.getEmptyStack();
    }

    public void func_70299_a(int index, ItemStack stack) {
        this.stackSlots[index] = ModUtil.getEmptyStack();
        if (stack != null && stack.func_77973_b() instanceof ItemChiseledBit) {
            this.inv.contents[2 * index + 1] = ModUtil.getStackSize(stack);
            this.inv.contents[2 * index + 0] = ItemChiseledBit.getStackState(stack);
        } else {
            this.inv.contents[2 * index + 1] = 0;
            this.inv.contents[2 * index + 0] = 0;
        }
        this.inv.onChange();
    }

    public int func_70297_j_() {
        return (Integer)ChiselsAndBits.getConfig().getServer().bagStackSize.get();
    }

    public void func_70296_d() {
        for (int x = 0; x < this.func_70302_i_(); ++x) {
            if (!ModUtil.notEmpty(this.stackSlots[x])) continue;
            this.inv.contents[2 * x + 1] = ModUtil.getStackSize(this.stackSlots[x]);
            this.stackSlots[x] = ModUtil.getEmptyStack();
            this.inv.onChange();
        }
    }

    public boolean func_70300_a(PlayerEntity player) {
        return true;
    }

    public void func_174889_b(PlayerEntity player) {
    }

    public void func_174886_c(PlayerEntity player) {
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return stack != null && stack.func_77973_b() instanceof ItemChiseledBit;
    }

    public void sort() {
        int x;
        ArrayList<StateQtyPair> stacks = new ArrayList<StateQtyPair>();
        for (x = 0; x < this.stackSlots.length; ++x) {
            int state = this.inv.contents[x * 2 + 0];
            int qty = this.inv.contents[x * 2 + 1];
            if (state <= 0 || qty <= 0) continue;
            stacks.add(new StateQtyPair(state, qty));
        }
        stacks.sort(new Comparator<StateQtyPair>(){

            @Override
            public int compare(StateQtyPair o1, StateQtyPair o2) {
                if (o1.state < o2.state) {
                    return 1;
                }
                if (o1.state > o2.state) {
                    return -1;
                }
                if (o1.qty < o2.qty) {
                    return 1;
                }
                if (o1.qty > o2.qty) {
                    return -1;
                }
                return 0;
            }
        });
        for (x = 0; x < stacks.size() - 1; ++x) {
            StateQtyPair a = (StateQtyPair)stacks.get(x);
            StateQtyPair b = (StateQtyPair)stacks.get(x + 1);
            if (a.state != b.state || a.qty >= this.func_70297_j_()) continue;
            int shiftSize = this.func_70297_j_() - a.qty;
            shiftSize = Math.min(shiftSize, b.qty);
            a.qty += shiftSize;
            b.qty -= shiftSize;
            if (b.qty <= 0) {
                stacks.remove(x + 1);
            }
            --x;
        }
        for (x = 0; x < this.stackSlots.length; ++x) {
            int state = 0;
            int qty = 0;
            if (stacks.size() > x) {
                state = ((StateQtyPair)stacks.get((int)x)).state;
                qty = ((StateQtyPair)stacks.get((int)x)).qty;
            }
            this.inv.contents[x * 2 + 0] = state;
            this.inv.contents[x * 2 + 1] = qty;
            this.stackSlots[x] = ModUtil.getEmptyStack();
        }
        this.inv.onChange();
    }

    public void clear(ItemStack stack) {
        for (int x = 0; x < this.stackSlots.length; ++x) {
            if (!this.matches(stack, this.stackSlots[x])) continue;
            this.stackSlots[x] = ModUtil.getEmptyStack();
            this.inv.contents[x * 2 + 0] = 0;
            this.inv.contents[x * 2 + 1] = 0;
        }
        this.inv.onChange();
    }

    public boolean matches(ItemStack cmpStack, ItemStack invStack) {
        if (ModUtil.isEmpty(cmpStack) || invStack == null) {
            return true;
        }
        return cmpStack.func_77973_b() == invStack.func_77973_b() && ItemStack.func_77970_a((ItemStack)cmpStack, (ItemStack)invStack);
    }

    public ItemStack restockItem(ItemStack target, ItemStack targetType) {
        int outSize = ModUtil.getStackSize(target);
        for (int x = this.func_70302_i_() - 1; x >= 0; --x) {
            if (!ItemChiseledBit.sameBit(targetType, this.getStateInSlot(x))) continue;
            ItemStack is = this.func_70301_a(x);
            outSize += ModUtil.getStackSize(is);
            int total = outSize;
            int overage = total - (outSize = Math.min(is.func_77976_d(), outSize));
            if (overage > 0) {
                ModUtil.setStackSize(is, overage);
            } else {
                this.func_70299_a(x, ModUtil.getEmptyStack());
            }
            this.func_70296_d();
            if (outSize == is.func_77976_d()) break;
        }
        ItemStack out = ModUtil.copy(targetType);
        ModUtil.setStackSize(out, outSize);
        return out;
    }

    @Nonnull
    public ItemStack insertItem(@Nonnull ItemStack which) {
        for (int x = 0; x < this.func_70302_i_(); ++x) {
            ItemStack is = this.func_70301_a(x);
            if (!ModUtil.isEmpty(is) && ItemChiseledBit.getStackState(which) == ItemChiseledBit.getStackState(is)) {
                ModUtil.adjustStackSize(is, ModUtil.getStackSize(which));
                int total = ModUtil.getStackSize(is);
                ModUtil.setStackSize(is, Math.min(this.func_70297_j_(), ModUtil.getStackSize(is)));
                int overage = total - ModUtil.getStackSize(is);
                if (overage > 0) {
                    ModUtil.setStackSize(which, overage);
                    this.func_70296_d();
                    continue;
                }
                this.func_70296_d();
                return ModUtil.getEmptyStack();
            }
            if (!ModUtil.isEmpty(is)) continue;
            this.func_70299_a(x, which);
            this.func_70296_d();
            return ModUtil.getEmptyStack();
        }
        return which;
    }

    public int extractBit(int bitMeta, int total) {
        int used = 0;
        for (int index = this.stackSlots.length - 1; index >= 0; --index) {
            int qty_idx = 2 * index + 1;
            int qty = this.inv.contents[qty_idx];
            int id = this.inv.contents[2 * index + 0];
            if (id != bitMeta || qty <= 0) continue;
            int n = qty_idx;
            this.inv.contents[n] = this.inv.contents[n] - total;
            if (this.inv.contents[qty_idx] < 0) {
                this.inv.contents[qty_idx] = 0;
            }
            this.inv.onChange();
            int diff = qty - this.inv.contents[qty_idx];
            used += diff;
            if (0 != (total -= diff)) continue;
            return used;
        }
        return used;
    }

    @OnlyIn(value=Dist.CLIENT)
    public List<ITextComponent> listContents(List<ITextComponent> details) {
        TreeMap<String, Integer> contents = new TreeMap<String, Integer>();
        for (int x = 0; x < this.func_70302_i_(); ++x) {
            ITextComponent name;
            BlockState blockState;
            ItemStack is = this.func_70301_a(x);
            if (ModUtil.isEmpty(is) || (blockState = ModUtil.getStateById(ItemChiseledBit.getStackState(is))) == null || (name = ItemChiseledBit.getBitStateName(blockState)) == null) continue;
            Integer count = (Integer)contents.get(name.getString());
            count = count == null ? Integer.valueOf(ModUtil.getStackSize(is)) : Integer.valueOf(count + ModUtil.getStackSize(is));
            contents.put(name.getString(), count);
        }
        if (contents.isEmpty()) {
            details.add((ITextComponent)new StringTextComponent(LocalStrings.Empty.getLocal()));
        }
        ArrayList list = new ArrayList();
        list.addAll(contents.entrySet());
        Collections.sort(list, (o1, o2) -> {
            int y = (Integer)o1.getValue();
            int x = (Integer)o2.getValue();
            return Integer.compare(x, y);
        });
        for (Map.Entry entry : list) {
            details.add((ITextComponent)new StringTextComponent(((Integer)entry.getValue()).toString()).func_240702_b_(" ").func_240702_b_((String)entry.getKey()));
        }
        return details;
    }

    public void func_174888_l() {
        this.clear(null);
    }

    public boolean func_191420_l() {
        for (ItemStack itemstack : this.stackSlots) {
            if (itemstack.func_190926_b()) continue;
            return false;
        }
        return true;
    }

    private static class StateQtyPair {
        int qty;
        int state;

        public StateQtyPair(int state, int qty) {
            this.qty = qty;
            this.state = state;
        }
    }
}

