/*
 * Decompiled with CFR 0.152.
 */
package team.chisel.world;

import com.google.common.collect.Maps;
import cpw.mods.fml.common.IWorldGenerator;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.feature.WorldGenMinable;

public class GeneratorChisel
implements IWorldGenerator {
    public static final GeneratorChisel INSTANCE = new GeneratorChisel();
    private final Map<WorldGenMinable, WorldGenInfo> map = Maps.newHashMap();

    public void addFeature(Block block, int count, int amount) {
        this.addFeature(block, count, amount, 40, 128);
    }

    public void addFeature(Block block, int count, int amount, int minY, int maxY) {
        this.addFeature(block, count, amount, minY, maxY, 1.0);
    }

    public void addFeature(Block block, int count, int amount, int minY, int maxY, double chance) {
        this.map.put(new WorldGenMinable(block, count), new WorldGenInfo(amount, minY, maxY, chance));
    }

    protected void genStandardOre(WorldGenMinable gen, WorldGenInfo info, World world, Random random, int x, int z) {
        for (int l = 0; l < info.amount; ++l) {
            if (!(random.nextDouble() < info.chance)) continue;
            int avgX = x + random.nextInt(16);
            int avgY = info.minY + random.nextInt(info.maxY - info.minY) + 1;
            int avgZ = z + random.nextInt(16);
            gen.func_76484_a(world, random, avgX, avgY, avgZ);
        }
    }

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkProvider chunkGenerator, IChunkProvider chunkProvider) {
        for (WorldGenMinable gen : this.map.keySet()) {
            this.genStandardOre(gen, this.map.get(gen), world, random, chunkX * 16, chunkZ * 16);
        }
    }

    private class WorldGenInfo {
        private int amount;
        private int minY;
        private int maxY;
        private double chance;

        private WorldGenInfo(int amount, int minY, int maxY, double chance) {
            this.amount = amount;
            this.minY = minY;
            this.maxY = maxY;
            this.chance = chance;
        }
    }
}

