/*
 * Decompiled with CFR 0.152.
 */
package team.chisel;

import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.IFuelHandler;
import net.minecraftforge.fml.common.IWorldGenerator;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLInterModComms;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import team.chisel.api.ChiselAPIProps;
import team.chisel.api.carving.CarvingUtils;
import team.chisel.client.gui.ChiselGuiHandler;
import team.chisel.client.gui.PacketChiselButton;
import team.chisel.client.gui.PacketHitechSettings;
import team.chisel.common.CommonProxy;
import team.chisel.common.Reference;
import team.chisel.common.block.MessageAutochiselFX;
import team.chisel.common.block.MessageUpdateAutochiselSource;
import team.chisel.common.carving.Carving;
import team.chisel.common.carving.ChiselModeRegistry;
import team.chisel.common.config.Configurations;
import team.chisel.common.init.ChiselBlocks;
import team.chisel.common.init.ChiselFuelHandler;
import team.chisel.common.init.ChiselSounds;
import team.chisel.common.integration.imc.IMCHandler;
import team.chisel.common.item.ChiselController;
import team.chisel.common.item.ChiselMode;
import team.chisel.common.item.PacketChiselMode;
import team.chisel.common.util.GenerationHandler;
import team.chisel.common.util.PerChunkData;

@Mod(modid="chisel", version="MC1.12.2-1.0.1.44", name="Chisel", dependencies="required-after:forge@[14.23.5.2806,);required-after-client:ctm;after:jei@[4.12.0,5)", acceptedMinecraftVersions="[1.12.2, 1.13)")
public class Chisel
implements Reference {
    public static final Logger logger = LogManager.getLogger((String)"Chisel");
    @Mod.Instance(value="chisel")
    @Nonnull
    public static Chisel instance;
    @SidedProxy(clientSide="team.chisel.client.ClientProxy", serverSide="team.chisel.common.CommonProxy", modId="chisel")
    public static CommonProxy proxy;
    public static final boolean debug = false;
    public static final SimpleNetworkWrapper network;
    private static Map<String, Block> remaps;

    public Chisel() {
        CarvingUtils.chisel = Carving.chisel;
        CarvingUtils.modes = ChiselModeRegistry.INSTANCE;
        ChiselMode.values();
        ChiselAPIProps.MOD_ID = "chisel";
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)this);
        ChiselSounds.init();
        proxy.construct(event);
        File configFile = event.getSuggestedConfigurationFile();
        Configurations.configExists = configFile.exists();
        Configurations.config = new Configuration(configFile);
        Configurations.config.load();
        Configurations.refreshConfig();
        MinecraftForge.EVENT_BUS.register((Object)PerChunkData.INSTANCE);
        MinecraftForge.EVENT_BUS.register(ChiselController.class);
        GameRegistry.registerWorldGenerator((IWorldGenerator)GenerationHandler.INSTANCE, (int)2);
        MinecraftForge.EVENT_BUS.register((Object)GenerationHandler.INSTANCE);
        MinecraftForge.TERRAIN_GEN_BUS.register((Object)GenerationHandler.INSTANCE);
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)this, (IGuiHandler)new ChiselGuiHandler());
        proxy.preInit(event);
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        proxy.init();
        remaps = ImmutableMap.builder().put((Object)"concrete_powder", (Object)Blocks.field_192444_dS).put((Object)"concrete", (Object)Blocks.field_192443_dR).build();
        GameRegistry.registerFuelHandler((IFuelHandler)new ChiselFuelHandler());
        Chisel.addCompactorPressRecipe(1000, new ItemStack(Blocks.field_189880_di), new ItemStack((Block)ChiselBlocks.limestone2, 1, 7));
        Chisel.addCompactorPressRecipe(1000, new ItemStack((Block)ChiselBlocks.limestone2, 1, 7), new ItemStack((Block)ChiselBlocks.marble2, 1, 7));
    }

    private static void addCompactorPressRecipe(int energy, ItemStack input, ItemStack output) {
        NBTTagCompound message = new NBTTagCompound();
        message.func_74768_a("energy", energy);
        message.func_74782_a("input", (NBTBase)new NBTTagCompound());
        message.func_74782_a("output", (NBTBase)new NBTTagCompound());
        input.func_77955_b(message.func_74775_l("input"));
        output.func_77955_b(message.func_74775_l("output"));
        FMLInterModComms.sendMessage((String)"thermalexpansion", (String)"addcompactorpressrecipe", (NBTTagCompound)message);
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        proxy.postInit();
    }

    public static void debug(String message) {
    }

    public static void debug(float[] array) {
    }

    @Mod.EventHandler
    public void onIMC(FMLInterModComms.IMCEvent event) {
        for (FMLInterModComms.IMCMessage msg : event.getMessages()) {
            IMCHandler.INSTANCE.handleMessage(msg);
        }
        IMCHandler.INSTANCE.imcCounts.forEachEntry((s, c) -> {
            logger.info("Received {} IMC messages from mod {}.", (Object)c, s);
            return true;
        });
        IMCHandler.INSTANCE.imcCounts.clear();
    }

    @SubscribeEvent
    public void onMissingBlock(RegistryEvent.MissingMappings<Block> event) {
        for (RegistryEvent.MissingMappings.Mapping mapping : event.getMappings()) {
            Optional.ofNullable(remaps.get(mapping.key.func_110623_a())).ifPresent(arg_0 -> ((RegistryEvent.MissingMappings.Mapping)mapping).remap(arg_0));
        }
    }

    @SubscribeEvent
    public void onMissingItem(RegistryEvent.MissingMappings<Item> event) {
        for (RegistryEvent.MissingMappings.Mapping mapping : event.getMappings()) {
            Optional.ofNullable(remaps.get(mapping.key.func_110623_a())).map(Item::func_150898_a).ifPresent(arg_0 -> ((RegistryEvent.MissingMappings.Mapping)mapping).remap(arg_0));
        }
    }

    static {
        network = NetworkRegistry.INSTANCE.newSimpleChannel("chisel");
        network.registerMessage(PacketChiselButton.Handler.class, PacketChiselButton.class, 0, Side.SERVER);
        network.registerMessage(PacketHitechSettings.Handler.class, PacketHitechSettings.class, 1, Side.SERVER);
        network.registerMessage(PerChunkData.MessageChunkDataHandler.class, PerChunkData.MessageChunkData.class, 2, Side.CLIENT);
        network.registerMessage(PacketChiselMode.Handler.class, PacketChiselMode.class, 3, Side.SERVER);
        network.registerMessage(MessageUpdateAutochiselSource.Handler.class, MessageUpdateAutochiselSource.class, 4, Side.CLIENT);
        network.registerMessage(MessageAutochiselFX.Handler.class, MessageAutochiselFX.class, 5, Side.CLIENT);
        remaps = ImmutableMap.of();
    }
}

