/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport.client.model;

import buildcraft.api.transport.pipe.IPipeHolder;
import buildcraft.api.transport.pluggable.IPluggableStaticBaker;
import buildcraft.api.transport.pluggable.PipePluggable;
import buildcraft.api.transport.pluggable.PluggableModelKey;
import buildcraft.lib.client.model.IModelCache;
import buildcraft.lib.client.model.ModelCache;
import buildcraft.lib.client.model.ModelCacheMultipleSame;
import buildcraft.transport.client.PipeRegistryClient;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.List;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;

public class PipeModelCachePluggable {
    public static final IModelCache<PluggableKey> cacheCutoutAll;
    public static final IModelCache<PluggableKey> cacheTranslucentAll;
    public static final ModelCache<PluggableModelKey> cacheCutoutSingle;
    public static final ModelCache<PluggableModelKey> cacheTranslucentSingle;

    private static <K extends PluggableModelKey> List<BakedQuad> generate(K key) {
        if (key == null) {
            return ImmutableList.of();
        }
        IPluggableStaticBaker<K> baker = PipeRegistryClient.getPlugBaker(key);
        if (baker == null) {
            return ImmutableList.of();
        }
        return baker.bake(key);
    }

    static {
        cacheCutoutSingle = new ModelCache<PluggableModelKey>(PipeModelCachePluggable::generate);
        cacheCutoutAll = new ModelCacheMultipleSame<PluggableKey, PluggableModelKey>(PluggableKey::getKeys, cacheCutoutSingle);
        cacheTranslucentSingle = new ModelCache<PluggableModelKey>(PipeModelCachePluggable::generate);
        cacheTranslucentAll = new ModelCacheMultipleSame<PluggableKey, PluggableModelKey>(PluggableKey::getKeys, cacheTranslucentSingle);
    }

    public static class PluggableKey {
        private final ImmutableSet<PluggableModelKey> pluggables;
        private final int hash;

        public PluggableKey(BlockRenderLayer layer, IPipeHolder holder) {
            ImmutableSet.Builder builder = ImmutableSet.builder();
            for (EnumFacing side : EnumFacing.field_82609_l) {
                PluggableModelKey key;
                PipePluggable pluggable = holder.getPluggable(side);
                if (pluggable == null || (key = pluggable.getModelRenderKey(layer)) == null) continue;
                builder.add((Object)key);
            }
            this.pluggables = builder.build();
            this.hash = this.pluggables.hashCode();
        }

        public ImmutableSet<PluggableModelKey> getKeys() {
            return this.pluggables;
        }

        public int hashCode() {
            return this.hash;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            PluggableKey other = (PluggableKey)obj;
            return this.pluggables.equals(other.pluggables);
        }
    }
}

