/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.registry;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class CreativeTabManager {
    private static final Map<String, CreativeTabBC> tabMap = new HashMap<String, CreativeTabBC>();

    public static CreativeTabs getTab(String name) {
        if (name.startsWith("vanilla.")) {
            String after;
            switch (after = name.substring("vanilla.".length())) {
                case "misc": {
                    return CreativeTabs.field_78026_f;
                }
                case "materials": {
                    return CreativeTabs.field_78035_l;
                }
            }
        }
        if (tabMap.containsKey(name)) {
            return tabMap.get(name);
        }
        throw new IllegalArgumentException("Unknown tab " + name);
    }

    public static CreativeTabBC createTab(String name) {
        CreativeTabBC tab = tabMap.get(name);
        if (tab != null) {
            return tab;
        }
        tab = new CreativeTabBC(name);
        tabMap.put(name, tab);
        return tab;
    }

    public static void setItem(String name, Item item) {
        if (item != null) {
            CreativeTabManager.setItemStack(name, new ItemStack(item));
        }
    }

    public static void setItemStack(String name, ItemStack item) {
        CreativeTabBC tab = tabMap.get(name);
        if (tab != null) {
            tab.setItem(item);
        }
    }

    public static class CreativeTabBC
    extends CreativeTabs {
        private ItemStack item = new ItemStack(Items.field_151132_bS);

        private CreativeTabBC(String name) {
            super(name);
        }

        public void setItem(Item item) {
            if (item != null) {
                this.item = new ItemStack(item);
            }
        }

        public void setItem(ItemStack stack) {
            if (stack == null || stack.func_190926_b()) {
                return;
            }
            this.item = stack;
        }

        public ItemStack func_78016_d() {
            return this.item;
        }
    }
}

