/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.api.robots;

import buildcraft.api.core.BCLog;
import buildcraft.api.core.EnumPipePart;
import buildcraft.api.robots.EntityRobotBase;
import buildcraft.api.robots.IRequestProvider;
import buildcraft.api.robots.IRobotRegistry;
import buildcraft.api.robots.RobotManager;
import buildcraft.api.statements.StatementSlot;
import buildcraft.api.transport.IInjectable;
import java.util.Arrays;
import net.minecraft.inventory.IInventory;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fluids.capability.IFluidHandler;

public abstract class DockingStation {
    public EnumFacing side;
    public World world;
    private long robotTakingId = Long.MAX_VALUE;
    private EntityRobotBase robotTaking;
    private boolean linkIsMain = false;
    private BlockPos pos;

    public DockingStation(BlockPos iIndex, EnumFacing iSide) {
        this.pos = iIndex;
        this.side = iSide;
    }

    public DockingStation() {
    }

    public boolean isMainStation() {
        return this.linkIsMain;
    }

    public BlockPos getPos() {
        return this.pos;
    }

    public EnumFacing side() {
        return this.side;
    }

    public EntityRobotBase robotTaking() {
        if (this.robotTakingId == Long.MAX_VALUE) {
            return null;
        }
        if (this.robotTaking == null) {
            this.robotTaking = RobotManager.registryProvider.getRegistry(this.world).getLoadedRobot(this.robotTakingId);
        }
        return this.robotTaking;
    }

    public void invalidateRobotTakingEntity() {
        this.robotTaking = null;
    }

    public long linkedId() {
        return this.robotTakingId;
    }

    public boolean takeAsMain(EntityRobotBase robot) {
        if (this.robotTakingId == Long.MAX_VALUE) {
            IRobotRegistry registry = RobotManager.registryProvider.getRegistry(this.world);
            this.linkIsMain = true;
            this.robotTaking = robot;
            this.robotTakingId = robot.getRobotId();
            registry.registryMarkDirty();
            robot.setMainStation(this);
            registry.take(this, robot.getRobotId());
            return true;
        }
        return this.robotTakingId == robot.getRobotId();
    }

    public boolean take(EntityRobotBase robot) {
        if (this.robotTaking == null) {
            IRobotRegistry registry = RobotManager.registryProvider.getRegistry(this.world);
            this.linkIsMain = false;
            this.robotTaking = robot;
            this.robotTakingId = robot.getRobotId();
            registry.registryMarkDirty();
            registry.take(this, robot.getRobotId());
            return true;
        }
        return robot.getRobotId() == this.robotTakingId;
    }

    public void release(EntityRobotBase robot) {
        if (this.robotTaking == robot && !this.linkIsMain) {
            IRobotRegistry registry = RobotManager.registryProvider.getRegistry(this.world);
            this.unsafeRelease(robot);
            registry.registryMarkDirty();
            registry.release(this, robot.getRobotId());
        }
    }

    public void unsafeRelease(EntityRobotBase robot) {
        if (this.robotTaking == robot) {
            this.linkIsMain = false;
            this.robotTaking = null;
            this.robotTakingId = Long.MAX_VALUE;
        }
    }

    public void writeToNBT(NBTTagCompound nbt) {
        nbt.func_74783_a("pos", new int[]{this.getPos().func_177958_n(), this.getPos().func_177956_o(), this.getPos().func_177952_p()});
        nbt.func_74774_a("side", (byte)this.side.ordinal());
        nbt.func_74757_a("isMain", this.linkIsMain);
        nbt.func_74772_a("robotId", this.robotTakingId);
    }

    public void readFromNBT(NBTTagCompound nbt) {
        if (nbt.func_74764_b("index")) {
            NBTTagCompound indexNBT = nbt.func_74775_l("index");
            int x = indexNBT.func_74762_e("i");
            int y = indexNBT.func_74762_e("j");
            int z = indexNBT.func_74762_e("k");
            this.pos = new BlockPos(x, y, z);
        } else {
            int[] array = nbt.func_74759_k("pos");
            if (array.length == 3) {
                this.pos = new BlockPos(array[0], array[1], array[2]);
            } else if (array.length != 0) {
                BCLog.logger.warn("Found an integer array that was not the right length! (" + Arrays.toString(array) + ")");
            } else {
                BCLog.logger.warn("Did not find any integer positions! This is a bug!");
            }
        }
        this.side = EnumFacing.values()[nbt.func_74771_c("side")];
        this.linkIsMain = nbt.func_74767_n("isMain");
        this.robotTakingId = nbt.func_74763_f("robotId");
    }

    public boolean isTaken() {
        return this.robotTakingId != Long.MAX_VALUE;
    }

    public long robotIdTaking() {
        return this.robotTakingId;
    }

    public BlockPos index() {
        return this.pos;
    }

    public String toString() {
        return "{" + this.pos + ", " + this.side + " :" + this.robotTakingId + "}";
    }

    public boolean linkIsDocked() {
        if (this.robotTaking() != null) {
            return this.robotTaking().getDockingStation() == this;
        }
        return false;
    }

    public boolean canRelease() {
        return !this.isMainStation() && !this.linkIsDocked();
    }

    public boolean isInitialized() {
        return true;
    }

    public abstract Iterable<StatementSlot> getActiveActions();

    public IInjectable getItemOutput() {
        return null;
    }

    public EnumPipePart getItemOutputSide() {
        return EnumPipePart.CENTER;
    }

    public IInventory getItemInput() {
        return null;
    }

    public EnumPipePart getItemInputSide() {
        return EnumPipePart.CENTER;
    }

    public IFluidHandler getFluidOutput() {
        return null;
    }

    public EnumPipePart getFluidOutputSide() {
        return EnumPipePart.CENTER;
    }

    public IFluidHandler getFluidInput() {
        return null;
    }

    public EnumPipePart getFluidInputSide() {
        return EnumPipePart.CENTER;
    }

    public boolean providesPower() {
        return false;
    }

    public IRequestProvider getRequestProvider() {
        return null;
    }

    public void onChunkUnload() {
    }
}

