/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.misc;

import buildcraft.api.core.render.ISprite;
import buildcraft.lib.client.guide.font.IFontRenderer;
import buildcraft.lib.client.render.fluid.FluidRenderer;
import buildcraft.lib.client.sprite.SpriteNineSliced;
import buildcraft.lib.client.sprite.SubSprite;
import buildcraft.lib.expression.api.IConstantNode;
import buildcraft.lib.fluid.Tank;
import buildcraft.lib.gui.elem.ToolTip;
import buildcraft.lib.gui.pos.GuiRectangle;
import buildcraft.lib.gui.pos.IGuiArea;
import buildcraft.lib.gui.pos.IGuiPosition;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import java.util.function.DoubleSupplier;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.RenderItem;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.client.config.GuiUtils;
import org.lwjgl.opengl.GL11;

public class GuiUtil {
    public static final IGuiArea AREA_WHOLE_SCREEN;
    private static final Deque<GuiRectangle> scissorRegions;

    public static int getScreenWidth() {
        return Minecraft.func_71410_x().field_71462_r.field_146294_l;
    }

    public static int getScreenHeight() {
        return Minecraft.func_71410_x().field_71462_r.field_146295_m;
    }

    public static IGuiArea moveRectangleToCentre(GuiRectangle area) {
        double w = area.width;
        double h = area.height;
        DoubleSupplier posX = () -> (AREA_WHOLE_SCREEN.getWidth() - w) / 2.0;
        DoubleSupplier posY = () -> (AREA_WHOLE_SCREEN.getHeight() - h) / 2.0;
        IGuiPosition position = IGuiPosition.create(posX, posY);
        return IGuiArea.create(position, area.width, area.height);
    }

    public static IGuiArea moveAreaToCentre(IGuiArea area) {
        if (area instanceof GuiRectangle || area instanceof IConstantNode) {
            return GuiUtil.moveRectangleToCentre(area.asImmutable());
        }
        DoubleSupplier posX = () -> (AREA_WHOLE_SCREEN.getWidth() - area.getWidth()) / 2.0;
        DoubleSupplier posY = () -> (AREA_WHOLE_SCREEN.getHeight() - area.getHeight()) / 2.0;
        return IGuiArea.create(posX, posY, area::getWidth, area::getHeight);
    }

    public static ToolTip createToolTip(final Supplier<ItemStack> stackRef) {
        return new ToolTip(new String[0]){

            @Override
            public void refresh() {
                this.delegate().clear();
                ItemStack stack = (ItemStack)stackRef.get();
                if (!stack.func_190926_b()) {
                    this.delegate().addAll(GuiUtil.getFormattedTooltip(stack));
                }
            }
        };
    }

    public static <D> void drawVerticallyAppending(IGuiPosition element, Iterable<? extends D> iterable, IVerticalAppendingDrawer<D> drawer) {
        double x = element.getX();
        double y = element.getY();
        for (D drawable : iterable) {
            y += drawer.draw(drawable, x, y);
        }
    }

    public static void drawItemStackAt(ItemStack stack, int x, int y) {
        RenderHelper.func_74520_c();
        Minecraft mc = Minecraft.func_71410_x();
        RenderItem itemRender = mc.func_175599_af();
        itemRender.func_184391_a((EntityLivingBase)mc.field_71439_g, stack, x, y);
        itemRender.func_180453_a(mc.field_71466_p, stack, x, y, null);
        RenderHelper.func_74518_a();
    }

    public static int drawHoveringText(List<String> textLines, int mouseX, int mouseY, int screenWidth, int screenHeight, int maxTextWidth, FontRenderer font) {
        if (!textLines.isEmpty()) {
            GlStateManager.func_179101_C();
            RenderHelper.func_74518_a();
            GlStateManager.func_179140_f();
            GlStateManager.func_179097_i();
            int tooltipTextWidth = 0;
            for (String textLine : textLines) {
                int textLineWidth = font.func_78256_a(textLine);
                if (textLineWidth <= tooltipTextWidth) continue;
                tooltipTextWidth = textLineWidth;
            }
            boolean needsWrap = false;
            int titleLinesCount = 1;
            int tooltipX = mouseX + 12;
            if (tooltipX + tooltipTextWidth + 4 > screenWidth && (tooltipX = mouseX - 16 - tooltipTextWidth) < 4) {
                tooltipTextWidth = mouseX > screenWidth / 2 ? mouseX - 12 - 8 : screenWidth - 16 - mouseX;
                needsWrap = true;
            }
            if (maxTextWidth > 0 && tooltipTextWidth > maxTextWidth) {
                tooltipTextWidth = maxTextWidth;
                needsWrap = true;
            }
            if (needsWrap) {
                int wrappedTooltipWidth = 0;
                ArrayList<String> wrappedTextLines = new ArrayList<String>();
                for (int i = 0; i < textLines.size(); ++i) {
                    String textLine = textLines.get(i);
                    List wrappedLine = font.func_78271_c(textLine, tooltipTextWidth);
                    if (i == 0) {
                        titleLinesCount = wrappedLine.size();
                    }
                    for (String line : wrappedLine) {
                        int lineWidth = font.func_78256_a(line);
                        if (lineWidth > wrappedTooltipWidth) {
                            wrappedTooltipWidth = lineWidth;
                        }
                        wrappedTextLines.add(line);
                    }
                }
                tooltipTextWidth = wrappedTooltipWidth;
                textLines = wrappedTextLines;
                tooltipX = mouseX > screenWidth / 2 ? mouseX - 16 - tooltipTextWidth : mouseX + 12;
            }
            int tooltipY = mouseY - 12;
            int tooltipHeight = 8;
            if (textLines.size() > 1) {
                tooltipHeight += (textLines.size() - 1) * 10;
                if (textLines.size() > titleLinesCount) {
                    tooltipHeight += 2;
                }
            }
            if (tooltipY + tooltipHeight + 6 > screenHeight) {
                tooltipY = screenHeight - tooltipHeight - 6;
            }
            int zLevel = 300;
            int backgroundColor = -267386864;
            GuiUtils.drawGradientRect((int)300, (int)(tooltipX - 3), (int)(tooltipY - 4), (int)(tooltipX + tooltipTextWidth + 3), (int)(tooltipY - 3), (int)-267386864, (int)-267386864);
            GuiUtils.drawGradientRect((int)300, (int)(tooltipX - 3), (int)(tooltipY + tooltipHeight + 3), (int)(tooltipX + tooltipTextWidth + 3), (int)(tooltipY + tooltipHeight + 4), (int)-267386864, (int)-267386864);
            GuiUtils.drawGradientRect((int)300, (int)(tooltipX - 3), (int)(tooltipY - 3), (int)(tooltipX + tooltipTextWidth + 3), (int)(tooltipY + tooltipHeight + 3), (int)-267386864, (int)-267386864);
            GuiUtils.drawGradientRect((int)300, (int)(tooltipX - 4), (int)(tooltipY - 3), (int)(tooltipX - 3), (int)(tooltipY + tooltipHeight + 3), (int)-267386864, (int)-267386864);
            GuiUtils.drawGradientRect((int)300, (int)(tooltipX + tooltipTextWidth + 3), (int)(tooltipY - 3), (int)(tooltipX + tooltipTextWidth + 4), (int)(tooltipY + tooltipHeight + 3), (int)-267386864, (int)-267386864);
            int borderColorStart = 0x505000FF;
            int borderColorEnd = 1344798847;
            GuiUtils.drawGradientRect((int)300, (int)(tooltipX - 3), (int)(tooltipY - 3 + 1), (int)(tooltipX - 3 + 1), (int)(tooltipY + tooltipHeight + 3 - 1), (int)0x505000FF, (int)1344798847);
            GuiUtils.drawGradientRect((int)300, (int)(tooltipX + tooltipTextWidth + 2), (int)(tooltipY - 3 + 1), (int)(tooltipX + tooltipTextWidth + 3), (int)(tooltipY + tooltipHeight + 3 - 1), (int)0x505000FF, (int)1344798847);
            GuiUtils.drawGradientRect((int)300, (int)(tooltipX - 3), (int)(tooltipY - 3), (int)(tooltipX + tooltipTextWidth + 3), (int)(tooltipY - 3 + 1), (int)0x505000FF, (int)0x505000FF);
            GuiUtils.drawGradientRect((int)300, (int)(tooltipX - 3), (int)(tooltipY + tooltipHeight + 2), (int)(tooltipX + tooltipTextWidth + 3), (int)(tooltipY + tooltipHeight + 3), (int)1344798847, (int)1344798847);
            for (int lineNumber = 0; lineNumber < textLines.size(); ++lineNumber) {
                String line = textLines.get(lineNumber);
                font.func_175063_a(line, (float)tooltipX, (float)tooltipY, -1);
                if (lineNumber + 1 == titleLinesCount) {
                    tooltipY += 2;
                }
                tooltipY += 10;
            }
            GlStateManager.func_179145_e();
            GlStateManager.func_179126_j();
            RenderHelper.func_74519_b();
            GlStateManager.func_179091_B();
            return tooltipHeight + 5;
        }
        return 0;
    }

    public static void drawHorizontalLine(int startX, int endX, int y, int color) {
        if (endX < startX) {
            int i = startX;
            startX = endX;
            endX = i;
        }
        Gui.func_73734_a((int)startX, (int)y, (int)(endX + 1), (int)(y + 1), (int)color);
    }

    public static void drawVerticalLine(int x, int startY, int endY, int color) {
        if (endY < startY) {
            int i = startY;
            startY = endY;
            endY = i;
        }
        Gui.func_73734_a((int)x, (int)(startY + 1), (int)(x + 1), (int)endY, (int)color);
    }

    public static void drawRect(IGuiArea area, int colour) {
        int xMin = (int)area.getX();
        int yMin = (int)area.getY();
        int xMax = (int)area.getEndX();
        int yMax = (int)area.getEndY();
        Gui.func_73734_a((int)xMin, (int)yMin, (int)xMax, (int)yMax, (int)colour);
    }

    public static void drawTexturedModalRect(double posX, double posY, double textureX, double textureY, double width, double height) {
        int x = MathHelper.func_76128_c((double)posX);
        int y = MathHelper.func_76128_c((double)posY);
        int u = MathHelper.func_76128_c((double)textureX);
        int v = MathHelper.func_76128_c((double)textureY);
        int w = MathHelper.func_76128_c((double)width);
        int h = MathHelper.func_76128_c((double)height);
        GuiScreen gui = Minecraft.func_71410_x().field_71462_r;
        gui.func_73729_b(x, y, u, v, w, h);
    }

    public static void drawFluid(IGuiArea position, Tank tank) {
        GuiUtil.drawFluid(position, tank.getFluidForRender(), tank.getCapacity());
    }

    public static void drawFluid(IGuiArea position, FluidStack fluid, int capacity) {
        if (fluid == null || fluid.amount <= 0) {
            return;
        }
        GuiUtil.drawFluid(position, fluid, fluid.amount, capacity);
    }

    public static void drawFluid(IGuiArea position, FluidStack fluid, int amount, int capacity) {
        double endY;
        double startY;
        if (fluid == null || amount <= 0) {
            return;
        }
        double height = (double)amount * position.getHeight() / (double)capacity;
        double startX = position.getX();
        double endX = startX + position.getWidth();
        if (fluid.getFluid().isGaseous(fluid)) {
            startY = position.getY() + height;
            endY = position.getY();
        } else {
            startY = position.getEndY();
            endY = startY - height;
        }
        FluidRenderer.drawFluidForGui(fluid, startX, startY, endX, endY);
    }

    public static AutoGlScissor scissor(double x, double y, double width, double height) {
        return GuiUtil.scissor(new GuiRectangle(x, y, width, height));
    }

    public static AutoGlScissor scissor(IGuiArea area) {
        final GuiRectangle rect = area.asImmutable();
        if (scissorRegions.isEmpty()) {
            GL11.glEnable((int)3089);
        }
        scissorRegions.push(rect);
        GuiUtil.scissor0();
        return new AutoGlScissor(){

            @Override
            public void close() {
                GuiRectangle last = (GuiRectangle)scissorRegions.pop();
                if (last != rect) {
                    throw new IllegalStateException("Popped rectangles in the wrong order!");
                }
                GuiRectangle next = (GuiRectangle)scissorRegions.peek();
                if (next == null) {
                    GL11.glDisable((int)3089);
                } else {
                    GuiUtil.scissor0();
                }
            }
        };
    }

    private static void scissor0() {
        GuiRectangle total = null;
        for (GuiRectangle rect2 : scissorRegions) {
            if (total == null) {
                total = rect2;
                continue;
            }
            double minX = Math.max(total.x, rect2.x);
            double minY = Math.max(total.y, rect2.y);
            double maxX = Math.min(total.getEndX(), rect2.getEndX());
            double maxY = Math.min(total.getEndY(), rect2.getEndY());
            total = new GuiRectangle(minX, minY, maxX - minX, maxY - minY);
        }
        if (total == null) {
            throw new IllegalStateException("Cannot call scissor0 when there are no more regions!");
        }
        GuiUtil.scissor0(total);
    }

    private static void scissor0(IGuiArea area) {
        GuiUtil.scissor0(area.getX(), area.getY(), area.getWidth(), area.getHeight());
    }

    private static void scissor0(double x, double y, double width, double height) {
        Minecraft mc = Minecraft.func_71410_x();
        ScaledResolution res = new ScaledResolution(mc);
        double scaleW = (double)mc.field_71443_c / res.func_78327_c();
        double scaleH = (double)mc.field_71440_d / res.func_78324_d();
        int rx = (int)(x * scaleW);
        int ry = (int)((double)mc.field_71440_d - (y + height) * scaleH);
        GL11.glScissor((int)rx, (int)ry, (int)((int)(width * scaleW)), (int)((int)(height * scaleH)));
    }

    public static ISprite subRelative(ISprite sprite, double u, double v, double width, double height, double size) {
        return GuiUtil.subRelative(sprite, u / size, v / size, width / size, height / size);
    }

    public static ISprite subAbsolute(ISprite sprite, double uMin, double vMin, double uMax, double vMax, double spriteSize) {
        double size = spriteSize;
        return GuiUtil.subAbsolute(sprite, uMin / size, vMin / size, uMax / size, vMax / size);
    }

    public static ISprite subRelative(ISprite sprite, double u, double v, double width, double height) {
        return GuiUtil.subAbsolute(sprite, u, v, u + width, v + height);
    }

    public static ISprite subAbsolute(ISprite sprite, double uMin, double vMin, double uMax, double vMax) {
        if (uMin == 0.0 && vMin == 0.0 && uMax == 1.0 && vMax == 1.0) {
            return sprite;
        }
        return new SubSprite(sprite, uMin, vMin, uMax, vMax);
    }

    public static SpriteNineSliced slice(ISprite sprite, int uMin, int vMin, int uMax, int vMax, int textureSize) {
        return new SpriteNineSliced(sprite, uMin, vMin, uMax, vMax, textureSize);
    }

    public static SpriteNineSliced slice(ISprite sprite, double uMin, double vMin, double uMax, double vMax, double scale) {
        return new SpriteNineSliced(sprite, uMin, vMin, uMax, vMax, scale);
    }

    public static List<String> getFormattedTooltip(ItemStack stack) {
        List<String> list = GuiUtil.getUnFormattedTooltip(stack);
        if (!list.isEmpty()) {
            list.set(0, stack.func_77953_t().field_77937_e + list.get(0));
        }
        for (int i = 1; i < list.size(); ++i) {
            list.set(i, TextFormatting.GRAY + list.get(i));
        }
        return list;
    }

    public static List<String> getUnFormattedTooltip(ItemStack stack) {
        Minecraft mc = Minecraft.func_71410_x();
        return stack.func_82840_a((EntityPlayer)mc.field_71439_g, GuiUtil.getTooltipFlags());
    }

    private static ITooltipFlag getTooltipFlags() {
        boolean adv = Minecraft.func_71410_x().field_71474_y.field_82882_x;
        return adv ? ITooltipFlag.TooltipFlags.ADVANCED : ITooltipFlag.TooltipFlags.NORMAL;
    }

    public static WrappedTextData getWrappedTextData(String text, IFontRenderer fontRenderer, int maxWidth, boolean shadow, float scale) {
        List<String> lines = fontRenderer.wrapString(text, maxWidth, shadow, scale);
        return new WrappedTextData(fontRenderer, lines.toArray(new String[0]), shadow, scale, maxWidth, (int)((float)(lines.size() * fontRenderer.getFontHeight("Ly")) * scale));
    }

    static {
        scissorRegions = new ArrayDeque<GuiRectangle>();
        AREA_WHOLE_SCREEN = IGuiArea.create(() -> 0.0, () -> 0.0, GuiUtil::getScreenWidth, GuiUtil::getScreenHeight);
    }

    public static class WrappedTextData {
        public final IFontRenderer renderer;
        public final String[] lines;
        public final float scale;
        public final boolean shadow;
        public final int width;
        public final int height;

        public WrappedTextData(IFontRenderer renderer, String[] lines, boolean shadow, float scale, int width, int height) {
            this.renderer = renderer;
            this.lines = lines;
            this.shadow = shadow;
            this.scale = scale;
            this.width = width;
            this.height = height;
        }

        public void drawAt(int x, int y, int colour, boolean centered) {
            for (String line : this.lines) {
                this.renderer.drawString(line, x, y, colour, this.shadow, centered, this.scale);
                y = (int)((float)y + (float)this.renderer.getFontHeight(line) * this.scale);
            }
        }
    }

    public static interface AutoGlScissor
    extends AutoCloseable {
        @Override
        public void close();
    }

    @FunctionalInterface
    public static interface IVerticalAppendingDrawer<D> {
        public double draw(D var1, double var2, double var4);
    }
}

