/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.misc;

import buildcraft.api.inventory.IItemTransactor;
import java.util.concurrent.Callable;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTBase;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.LoaderState;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class CapUtil {
    @Nonnull
    public static final Capability<IItemHandler> CAP_ITEMS;
    @Nonnull
    public static final Capability<IFluidHandler> CAP_FLUIDS;
    @Nonnull
    public static final Capability<IItemTransactor> CAP_ITEM_TRANSACTOR;
    @CapabilityInject(value=IItemTransactor.class)
    private static Capability<IItemTransactor> capTransactor;

    @Nonnull
    private static <T> Capability<T> getCapNonNull(Capability<T> cap, Class<T> clazz) {
        if (cap == null) {
            throw new NullPointerException("The capability " + clazz + " was null!");
        }
        return cap;
    }

    private static <T> void registerAbstractCapability(final Class<T> clazz) {
        Capability.IStorage ourStorage = new Capability.IStorage<T>(){

            public NBTBase writeNBT(Capability<T> capability, T instance, EnumFacing side) {
                throw new IllegalStateException("You must provide your own implementations of " + clazz);
            }

            public void readNBT(Capability<T> capability, T instance, EnumFacing side, NBTBase nbt) {
                throw new IllegalStateException("You must provide your own implementations of " + clazz);
            }
        };
        Callable<Object> factory = () -> {
            throw new IllegalStateException("You must provide your own instances of " + clazz);
        };
        CapabilityManager.INSTANCE.register(clazz, ourStorage, factory);
    }

    @Nullable
    public static <T> T getCapability(ICapabilityProvider provider, Capability<T> capability, EnumFacing facing) {
        if (provider == null || capability == null) {
            return null;
        }
        return (T)provider.getCapability(capability, facing);
    }

    static {
        if (!Loader.instance().hasReachedState(LoaderState.INITIALIZATION)) {
            throw new IllegalStateException("Used CapUtil too early, you must wait until init or later!");
        }
        CAP_ITEMS = CapUtil.getCapNonNull(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, IItemHandler.class);
        CAP_FLUIDS = CapUtil.getCapNonNull(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, IFluidHandler.class);
        CapUtil.registerAbstractCapability(IItemTransactor.class);
        CAP_ITEM_TRANSACTOR = CapUtil.getCapNonNull(capTransactor, IItemTransactor.class);
    }
}

