/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.expression.node.value;

import buildcraft.lib.expression.api.IDependancyVisitor;
import buildcraft.lib.expression.api.IDependantNode;
import buildcraft.lib.expression.api.IExpressionNode;
import buildcraft.lib.expression.api.IVariableNode;
import buildcraft.lib.expression.api.NodeType;
import buildcraft.lib.expression.api.NodeTypes;
import buildcraft.lib.expression.node.value.NodeConstantObject;
import buildcraft.lib.expression.node.value.NodeVariable;

public class NodeVariableObject<T>
extends NodeVariable
implements IVariableNode.IVariableNodeObject<T>,
IDependantNode {
    public final Class<T> type;
    public T value;
    private IExpressionNode.INodeObject<T> src;

    public NodeVariableObject(String name, Class<T> type) {
        super(name);
        this.type = type;
        NodeType<T> nodeType = NodeTypes.getType(type);
        if (nodeType == null) {
            throw new IllegalArgumentException("Unknown NodeType " + type);
        }
        this.value = nodeType.defaultValue;
    }

    @Override
    public Class<T> getType() {
        return this.type;
    }

    @Override
    public T evaluate() {
        return this.src != null ? this.src.evaluate() : this.value;
    }

    @Override
    public IExpressionNode.INodeObject<T> inline() {
        if (this.isConst) {
            return new NodeConstantObject<T>(this.getType(), this.value);
        }
        if (this.src != null) {
            return this.src.inline();
        }
        return this;
    }

    @Override
    public void set(T value) {
        this.value = value;
    }

    @Override
    public void setConstantSource(IExpressionNode source) {
        if (this.src != null) {
            throw new IllegalStateException("Already have a constant source");
        }
        IExpressionNode.INodeObject obj = (IExpressionNode.INodeObject)source;
        if (obj.getType() != this.getType()) {
            throw new IllegalArgumentException("Cannot convert " + obj.getType() + " to " + this.getType());
        }
        this.src = (IExpressionNode.INodeObject)source;
    }

    @Override
    public void visitDependants(IDependancyVisitor visitor) {
        if (this.src != null) {
            visitor.dependOn((IExpressionNode)this.src);
        } else {
            visitor.dependOnExplictly(this);
        }
    }
}

