/* 
BSL Shaders v7.1.05 by Capt Tatsu 
https://bitslablab.com 
*/ 

//Settings//
#include "/lib/settings.glsl"

//Fragment Shader///////////////////////////////////////////////////////////////////////////////////
#ifdef FSH

//Varyings//
varying vec2 texCoord;

//Uniforms//
uniform float viewWidth, viewHeight, aspectRatio;

uniform sampler2D colortex0;

//Optifine Constants//
const bool colortex0MipmapEnabled = true;

//Common Variables//
float pw = 1.0 / viewWidth;
float ph = 1.0 / viewHeight;

//Includes//
#include "/lib/post/bloomTile.glsl"

//Program//
void main(){
    //Bloom Tile
	vec3 blur =  BloomTile(2.0, vec2(0.0      , 0.0   ));
	     blur += BloomTile(3.0, vec2(0.0      , 0.26  ));
	     blur += BloomTile(4.0, vec2(0.135    , 0.26  ));
	     blur += BloomTile(5.0, vec2(0.2075   , 0.26  ));
	     blur += BloomTile(6.0, vec2(0.135    , 0.3325));
	     blur += BloomTile(7.0, vec2(0.160625 , 0.3325));
	     blur += BloomTile(8.0, vec2(0.1784375, 0.3325));

    /* DRAWBUFFERS:1 */
	gl_FragData[0] = vec4(blur, 1.0);
}

#endif

//Vertex Shader/////////////////////////////////////////////////////////////////////////////////////
#ifdef VSH

//Varyings//
varying vec2 texCoord;

//Program//
void main(){
	texCoord = gl_MultiTexCoord0.xy;
	
	gl_Position = ftransform();
}

#endif