/*
 * Decompiled with CFR 0.152.
 */
package mod.pianomanu.blockcarpentry.tileentity;

import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mod.pianomanu.blockcarpentry.block.ChestFrameBlock;
import mod.pianomanu.blockcarpentry.container.ChestFrameContainer;
import mod.pianomanu.blockcarpentry.setup.Registration;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.model.ModelDataManager;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.data.ModelDataMap;
import net.minecraftforge.client.model.data.ModelProperty;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.wrapper.InvWrapper;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ChestFrameBlockEntity
extends ChestBlockEntity {
    private NonNullList<ItemStack> chestContents = NonNullList.m_122780_((int)27, (Object)ItemStack.f_41583_);
    protected int numPlayersUsing;
    private final IItemHandlerModifiable items = this.createHandler();
    private LazyOptional<IItemHandlerModifiable> itemHandler = LazyOptional.of(() -> this.items);
    public static final ModelProperty<Integer> ROTATION = new ModelProperty();
    private Integer rotation = 0;
    public static final ModelProperty<BlockState> MIMIC = new ModelProperty();
    public static final ModelProperty<Integer> TEXTURE = new ModelProperty();
    public static final ModelProperty<Integer> DESIGN = new ModelProperty();
    public static final ModelProperty<Integer> DESIGN_TEXTURE = new ModelProperty();
    public static final ModelProperty<Integer> GLASS_COLOR = new ModelProperty();
    public final int maxTextures = 8;
    public final int maxDesignTextures = 4;
    public final int maxDesigns = 4;
    private BlockState mimic;
    private Integer texture = 0;
    private Integer design = 0;
    private Integer designTexture = 0;
    private Integer glassColor = 0;
    private static final Logger LOGGER = LogManager.getLogger();

    public ChestFrameBlockEntity(BlockEntityType<?> typeIn, BlockPos pos, BlockState state) {
        super(typeIn, pos, state);
    }

    public ChestFrameBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)Registration.CHEST_FRAME_TILE.get(), pos, state);
    }

    public static void swapContents(ChestFrameBlockEntity te, ChestFrameBlockEntity otherTe) {
        NonNullList<ItemStack> list = te.m_7086_();
        te.m_6520_(otherTe.m_7086_());
        otherTe.m_6520_(list);
    }

    private static Integer readInteger(CompoundTag tag) {
        if (!tag.m_128425_("number", 8)) {
            return 0;
        }
        try {
            return Integer.parseInt(tag.m_128461_("number"));
        }
        catch (NumberFormatException e) {
            LOGGER.error("Not a valid Number Format: " + tag.m_128461_("number"));
            return 0;
        }
    }

    private static CompoundTag writeInteger(Integer tag) {
        CompoundTag compoundnbt = new CompoundTag();
        compoundnbt.m_128359_("number", tag.toString());
        return compoundnbt;
    }

    public int m_6643_() {
        return 27;
    }

    public NonNullList<ItemStack> m_7086_() {
        return this.chestContents;
    }

    public void m_6520_(NonNullList<ItemStack> itemsIn) {
        this.chestContents = itemsIn;
    }

    public TranslatableComponent getCustomName() {
        return new TranslatableComponent("container.frame_chest");
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int p_59637_, Inventory inventory, Player player) {
        return super.m_7208_(p_59637_, inventory, player);
    }

    protected AbstractContainerMenu m_6555_(int id, Inventory inventory) {
        return ChestFrameContainer.createFrameContainerMenu(id, inventory, (Container)this);
    }

    private void playSound(SoundEvent sound) {
        double dx = (double)this.f_58858_.m_123341_() + 0.5;
        double dy = (double)this.f_58858_.m_123342_() + 0.5;
        double dz = (double)this.f_58858_.m_123343_() + 0.5;
        this.f_58857_.m_6263_(null, dx, dy, dz, sound, SoundSource.BLOCKS, 0.5f, this.f_58857_.f_46441_.nextFloat() * 0.1f + 0.9f);
    }

    public void m_5856_(Player player) {
        if (!player.m_5833_()) {
            if (this.numPlayersUsing < 0) {
                this.numPlayersUsing = 0;
            }
            ++this.numPlayersUsing;
            this.onOpenOrClose();
        }
    }

    public void m_5785_(Player player) {
        if (!player.m_5833_()) {
            --this.numPlayersUsing;
            this.onOpenOrClose();
        }
    }

    protected void onOpenOrClose() {
        Block block = this.m_58900_().m_60734_();
        if (block instanceof ChestFrameBlock) {
            this.f_58857_.m_7696_(this.f_58858_, block, 1, this.numPlayersUsing);
            this.f_58857_.m_46672_(this.f_58858_, block);
        }
    }

    private IItemHandlerModifiable createHandler() {
        return new InvWrapper((Container)this);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        if (this.itemHandler != null) {
            this.itemHandler.invalidate();
            this.itemHandler = null;
        }
    }

    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        if (this.mimic != null) {
            tag.m_128365_("mimic", (Tag)NbtUtils.m_129202_((BlockState)this.mimic));
        }
        if (this.texture != null) {
            tag.m_128365_("texture", (Tag)ChestFrameBlockEntity.writeInteger(this.texture));
        }
        if (this.design != null) {
            tag.m_128365_("design", (Tag)ChestFrameBlockEntity.writeInteger(this.design));
        }
        if (this.designTexture != null) {
            tag.m_128365_("design_texture", (Tag)ChestFrameBlockEntity.writeInteger(this.designTexture));
        }
        if (this.glassColor != null) {
            tag.m_128365_("glass_color", (Tag)ChestFrameBlockEntity.writeInteger(this.glassColor));
        }
        if (this.rotation != null) {
            tag.m_128365_("rotation", (Tag)ChestFrameBlockEntity.writeInteger(this.rotation));
        }
        if (!this.m_59634_(tag)) {
            ContainerHelper.m_18973_((CompoundTag)tag, this.chestContents);
        }
    }

    public void m_142466_(CompoundTag compound) {
        super.m_142466_(compound);
        if (compound.m_128441_("mimic")) {
            this.mimic = NbtUtils.m_129241_((CompoundTag)compound.m_128469_("mimic"));
        }
        if (compound.m_128441_("texture")) {
            this.texture = ChestFrameBlockEntity.readInteger(compound.m_128469_("texture"));
        }
        if (compound.m_128441_("design")) {
            this.design = ChestFrameBlockEntity.readInteger(compound.m_128469_("design"));
        }
        if (compound.m_128441_("design_texture")) {
            this.designTexture = ChestFrameBlockEntity.readInteger(compound.m_128469_("design_texture"));
        }
        if (compound.m_128441_("glass_color")) {
            this.glassColor = ChestFrameBlockEntity.readInteger(compound.m_128469_("glass_color"));
        }
        if (compound.m_128441_("rotation")) {
            this.rotation = ChestFrameBlockEntity.readInteger(compound.m_128469_("rotation"));
        }
        this.chestContents = NonNullList.m_122780_((int)this.m_6643_(), (Object)ItemStack.f_41583_);
        if (!this.m_59631_(compound)) {
            ContainerHelper.m_18980_((CompoundTag)compound, this.chestContents);
        }
    }

    public BlockState getMimic() {
        return this.mimic;
    }

    public Integer getDesign() {
        return this.design;
    }

    public void setMimic(BlockState mimic) {
        this.mimic = mimic;
        this.m_6596_();
        this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
    }

    public Integer getDesignTexture() {
        return this.designTexture;
    }

    public void setDesign(Integer design) {
        this.design = design;
        this.m_6596_();
        this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
    }

    public Integer getTexture() {
        return this.texture;
    }

    public void setDesignTexture(Integer designTexture) {
        this.designTexture = designTexture;
        this.m_6596_();
        this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
    }

    public Integer getGlassColor() {
        return this.glassColor;
    }

    public void setTexture(Integer texture) {
        this.texture = texture;
        this.m_6596_();
        this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
    }

    public Integer getRotation() {
        return this.rotation;
    }

    public void setGlassColor(Integer colorNumber) {
        this.glassColor = colorNumber;
        this.m_6596_();
        this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
    }

    public void setRotation(Integer rotation) {
        this.rotation = rotation;
        this.m_6596_();
        this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
    }

    public CompoundTag m_5995_() {
        CompoundTag tag = super.m_5995_();
        if (this.mimic != null) {
            tag.m_128365_("mimic", (Tag)NbtUtils.m_129202_((BlockState)this.mimic));
        }
        if (this.texture != null) {
            tag.m_128365_("texture", (Tag)ChestFrameBlockEntity.writeInteger(this.texture));
        }
        if (this.design != null) {
            tag.m_128365_("design", (Tag)ChestFrameBlockEntity.writeInteger(this.design));
        }
        if (this.designTexture != null) {
            tag.m_128365_("design_texture", (Tag)ChestFrameBlockEntity.writeInteger(this.designTexture));
        }
        if (this.glassColor != null) {
            tag.m_128365_("glass_color", (Tag)ChestFrameBlockEntity.writeInteger(this.glassColor));
        }
        if (this.rotation != null) {
            tag.m_128365_("rotation", (Tag)ChestFrameBlockEntity.writeInteger(this.rotation));
        }
        return tag;
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        BlockState oldMimic = this.mimic;
        Integer oldTexture = this.texture;
        Integer oldDesign = this.design;
        Integer oldDesignTexture = this.designTexture;
        Integer oldGlassColor = this.glassColor;
        Integer oldRotation = this.rotation;
        CompoundTag tag = pkt.m_131708_();
        if (tag.m_128441_("mimic")) {
            this.mimic = NbtUtils.m_129241_((CompoundTag)tag.m_128469_("mimic"));
            if (!Objects.equals(oldMimic, this.mimic)) {
                ModelDataManager.requestModelDataRefresh((BlockEntity)this);
                this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
            }
        }
        if (tag.m_128441_("texture")) {
            this.texture = ChestFrameBlockEntity.readInteger(tag.m_128469_("texture"));
            if (!Objects.equals(oldTexture, this.texture)) {
                ModelDataManager.requestModelDataRefresh((BlockEntity)this);
                this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
            }
        }
        if (tag.m_128441_("design")) {
            this.design = ChestFrameBlockEntity.readInteger(tag.m_128469_("design"));
            if (!Objects.equals(oldDesign, this.design)) {
                ModelDataManager.requestModelDataRefresh((BlockEntity)this);
                this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
            }
        }
        if (tag.m_128441_("design_texture")) {
            this.designTexture = ChestFrameBlockEntity.readInteger(tag.m_128469_("design_texture"));
            if (!Objects.equals(oldDesignTexture, this.designTexture)) {
                ModelDataManager.requestModelDataRefresh((BlockEntity)this);
                this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
            }
        }
        if (tag.m_128441_("glass_color")) {
            this.glassColor = ChestFrameBlockEntity.readInteger(tag.m_128469_("glass_color"));
            if (!Objects.equals(oldGlassColor, this.glassColor)) {
                ModelDataManager.requestModelDataRefresh((BlockEntity)this);
                this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
            }
        }
        if (tag.m_128441_("rotation")) {
            this.rotation = ChestFrameBlockEntity.readInteger(tag.m_128469_("rotation"));
            if (!Objects.equals(oldRotation, this.rotation)) {
                ModelDataManager.requestModelDataRefresh((BlockEntity)this);
                this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
            }
        }
    }

    @Nonnull
    public IModelData getModelData() {
        return new ModelDataMap.Builder().withInitial(MIMIC, (Object)this.mimic).withInitial(TEXTURE, (Object)this.texture).withInitial(DESIGN, (Object)this.design).withInitial(DESIGN_TEXTURE, (Object)this.designTexture).withInitial(GLASS_COLOR, (Object)this.glassColor).withInitial(ROTATION, (Object)this.rotation).build();
    }

    public void clear() {
        this.setMimic(null);
        this.setDesign(0);
        this.setDesign(0);
        this.setDesign(0);
        this.setGlassColor(0);
        this.setRotation(0);
    }

    @Nullable
    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }
}

