/*
 * Decompiled with CFR 0.152.
 */
package mod.pianomanu.blockcarpentry.block;

import java.util.Objects;
import javax.annotation.Nullable;
import mod.pianomanu.blockcarpentry.setup.Registration;
import mod.pianomanu.blockcarpentry.setup.config.BCModConfig;
import mod.pianomanu.blockcarpentry.tileentity.FrameBlockTile;
import mod.pianomanu.blockcarpentry.tileentity.LockableFrameTile;
import mod.pianomanu.blockcarpentry.util.BCBlockStateProperties;
import mod.pianomanu.blockcarpentry.util.BlockAppearanceHelper;
import mod.pianomanu.blockcarpentry.util.BlockSavingHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;

public class TrapdoorFrameBlock
extends TrapDoorBlock
implements EntityBlock {
    public static final BooleanProperty CONTAINS_BLOCK = BCBlockStateProperties.CONTAINS_BLOCK;
    public static final IntegerProperty LIGHT_LEVEL = BCBlockStateProperties.LIGHT_LEVEL;

    public TrapdoorFrameBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)Direction.NORTH)).m_61124_((Property)f_57514_, (Comparable)Boolean.valueOf(false))).m_61124_((Property)f_57515_, (Comparable)Half.BOTTOM)).m_61124_((Property)f_57516_, (Comparable)Boolean.valueOf(false))).m_61124_((Property)f_57517_, (Comparable)Boolean.valueOf(false))).m_61124_((Property)CONTAINS_BLOCK, (Comparable)Boolean.FALSE)).m_61124_((Property)LIGHT_LEVEL, (Comparable)Integer.valueOf(0)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{BlockStateProperties.f_61374_, f_57514_, f_57515_, f_57516_, f_57517_, CONTAINS_BLOCK, LIGHT_LEVEL});
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new LockableFrameTile(pos, state);
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitresult) {
        ItemStack item = player.m_21120_(hand);
        if (!level.f_46443_) {
            BlockEntity tileEntity;
            if (BlockAppearanceHelper.setLightLevel(item, state, level, pos, player, hand) || BlockAppearanceHelper.setTexture(item, state, level, player, pos) || BlockAppearanceHelper.setDesign(level, pos, player, item) || BlockAppearanceHelper.setDesignTexture(level, pos, player, item) || BlockAppearanceHelper.setGlassColor(level, pos, player, hand) || BlockAppearanceHelper.setOverlay(level, pos, player, item) || BlockAppearanceHelper.setRotation(level, pos, player, item)) {
                return InteractionResult.CONSUME;
            }
            if (item.m_41720_() == Items.f_42451_) {
                LockableFrameTile newTile;
                BlockEntity tileEntity2 = level.m_7702_(pos);
                if (tileEntity2 instanceof LockableFrameTile) {
                    LockableFrameTile doorTileEntity = (LockableFrameTile)tileEntity2;
                    if (doorTileEntity.canBeOpenedByRedstoneSignal()) {
                        player.m_5661_((Component)new TranslatableComponent("message.blockcarpentry.redstone_off"), true);
                    } else {
                        player.m_5661_((Component)new TranslatableComponent("message.blockcarpentry.redstone_on"), true);
                    }
                    doorTileEntity.setCanBeOpenedByRedstoneSignal(!doorTileEntity.canBeOpenedByRedstoneSignal());
                } else if (tileEntity2 instanceof FrameBlockTile && (newTile = (LockableFrameTile)this.m_142194_(pos, state)) != null) {
                    newTile.addFromOutdatedTileEntity((FrameBlockTile)tileEntity2);
                    level.m_151523_((BlockEntity)newTile);
                    player.m_5661_((Component)new TranslatableComponent("message.blockcarpentry.converting_outdated_block"), true);
                }
                return InteractionResult.CONSUME;
            }
            if (item.m_41720_() == Items.f_42416_) {
                LockableFrameTile newTile;
                BlockEntity tileEntity3 = level.m_7702_(pos);
                if (tileEntity3 instanceof LockableFrameTile) {
                    LockableFrameTile doorTileEntity = (LockableFrameTile)tileEntity3;
                    if (doorTileEntity.canBeOpenedByPlayers()) {
                        player.m_5661_((Component)new TranslatableComponent("message.blockcarpentry.lock"), true);
                    } else {
                        player.m_5661_((Component)new TranslatableComponent("message.blockcarpentry.unlock"), true);
                    }
                    doorTileEntity.setCanBeOpenedByPlayers(!doorTileEntity.canBeOpenedByPlayers());
                } else if (tileEntity3 instanceof FrameBlockTile && (newTile = (LockableFrameTile)this.m_142194_(pos, state)) != null) {
                    newTile.addFromOutdatedTileEntity((FrameBlockTile)tileEntity3);
                    level.m_151523_((BlockEntity)newTile);
                    player.m_5661_((Component)new TranslatableComponent("message.blockcarpentry.converting_outdated_block"), true);
                }
                return InteractionResult.CONSUME;
            }
            if (item.m_41720_() instanceof BlockItem) {
                if (Objects.requireNonNull(item.m_41720_().getRegistryName()).m_135827_().equals("blockcarpentry")) {
                    return InteractionResult.PASS;
                }
                tileEntity = level.m_7702_(pos);
                int count = player.m_21120_(hand).m_41613_();
                Block heldBlock = ((BlockItem)item.m_41720_()).m_40614_();
                if (tileEntity instanceof FrameBlockTile && !item.m_41619_() && BlockSavingHelper.isValidBlock(heldBlock) && !((Boolean)state.m_61143_((Property)CONTAINS_BLOCK)).booleanValue()) {
                    BlockState handBlockState = ((BlockItem)item.m_41720_()).m_40614_().m_49966_();
                    this.insertBlock(level, pos, state, handBlockState);
                    if (!player.m_7500_()) {
                        player.m_21120_(hand).m_41764_(count - 1);
                    }
                    return InteractionResult.SUCCESS;
                }
            }
            if (!item.m_41720_().getRegistryName().m_135827_().equals("blockcarpentry")) {
                LockableFrameTile newTile;
                tileEntity = level.m_7702_(pos);
                if (tileEntity instanceof LockableFrameTile) {
                    LockableFrameTile trapdoorTileEntity = (LockableFrameTile)tileEntity;
                    if (trapdoorTileEntity.canBeOpenedByPlayers()) {
                        if (((Boolean)state.m_61143_((Property)f_57514_)).booleanValue()) {
                            state = (BlockState)state.m_61124_((Property)f_57514_, (Comparable)Boolean.valueOf(false));
                            level.m_5898_(null, 1007, pos, 0);
                        } else {
                            state = (BlockState)state.m_61124_((Property)f_57514_, (Comparable)Boolean.valueOf(true));
                            level.m_5898_(null, 1013, pos, 0);
                        }
                        level.m_7731_(pos, state, 2);
                        if (((Boolean)state.m_61143_((Property)f_57517_)).booleanValue()) {
                            level.m_186469_(pos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)level));
                        }
                    }
                } else if (tileEntity instanceof FrameBlockTile && (newTile = (LockableFrameTile)this.m_142194_(pos, state)) != null) {
                    newTile.addFromOutdatedTileEntity((FrameBlockTile)tileEntity);
                    level.m_151523_((BlockEntity)newTile);
                    player.m_5661_((Component)new TranslatableComponent("message.blockcarpentry.converting_outdated_block"), true);
                }
                return InteractionResult.PASS;
            }
            if (player.m_21120_(hand).m_41720_() == Registration.HAMMER.get() || !((Boolean)BCModConfig.HAMMER_NEEDED.get()).booleanValue() && player.m_6047_()) {
                if (!player.m_7500_()) {
                    this.dropContainedBlock(level, pos);
                }
                state = (BlockState)state.m_61124_((Property)CONTAINS_BLOCK, (Comparable)Boolean.FALSE);
                level.m_7731_(pos, state, 2);
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.SUCCESS;
    }

    protected void dropContainedBlock(Level levelIn, BlockPos pos) {
        FrameBlockTile frameBlockEntity;
        BlockState blockState;
        BlockEntity tileentity;
        if (!levelIn.f_46443_ && (tileentity = levelIn.m_7702_(pos)) instanceof FrameBlockTile && (blockState = (frameBlockEntity = (FrameBlockTile)tileentity).getMimic()) != null) {
            levelIn.m_46796_(1010, pos, 0);
            frameBlockEntity.clear();
            float f = 0.7f;
            double d0 = (double)(levelIn.f_46441_.nextFloat() * 0.7f) + (double)0.15f;
            double d1 = (double)(levelIn.f_46441_.nextFloat() * 0.7f) + 0.06000000238418579 + 0.6;
            double d2 = (double)(levelIn.f_46441_.nextFloat() * 0.7f) + (double)0.15f;
            ItemStack itemstack1 = new ItemStack((ItemLike)blockState.m_60734_());
            ItemEntity itementity = new ItemEntity(levelIn, (double)pos.m_123341_() + d0, (double)pos.m_123342_() + d1, (double)pos.m_123343_() + d2, itemstack1);
            itementity.m_32060_();
            levelIn.m_7967_((Entity)itementity);
            frameBlockEntity.clear();
        }
    }

    public void insertBlock(Level levelIn, BlockPos pos, BlockState state, BlockState handBlock) {
        BlockEntity tileentity = levelIn.m_7702_(pos);
        if (tileentity instanceof FrameBlockTile) {
            FrameBlockTile frameBlockEntity = (FrameBlockTile)tileentity;
            frameBlockEntity.clear();
            frameBlockEntity.setMimic(handBlock);
            levelIn.m_7731_(pos, (BlockState)state.m_61124_((Property)CONTAINS_BLOCK, (Comparable)Boolean.TRUE), 2);
        }
    }

    public void m_6810_(BlockState state, Level levelIn, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.m_60734_() != newState.m_60734_()) {
            this.dropContainedBlock(levelIn, pos);
            super.m_6810_(state, levelIn, pos, newState, isMoving);
        }
    }

    public int getLightEmission(BlockState state, BlockGetter level, BlockPos pos) {
        if ((Integer)state.m_61143_((Property)LIGHT_LEVEL) > 15) {
            return 15;
        }
        return (Integer)state.m_61143_((Property)LIGHT_LEVEL);
    }

    public void m_6861_(BlockState state, Level level, BlockPos pos, Block block, BlockPos pos2, boolean update) {
        boolean flag;
        LockableFrameTile trapdoorTileEntity;
        BlockEntity tileEntity;
        if (!level.f_46443_ && (tileEntity = level.m_7702_(pos)) instanceof LockableFrameTile && (trapdoorTileEntity = (LockableFrameTile)tileEntity).canBeOpenedByRedstoneSignal() && (flag = level.m_46753_(pos)) != (Boolean)state.m_61143_((Property)f_57516_)) {
            if ((Boolean)state.m_61143_((Property)f_57514_) != flag) {
                state = (BlockState)state.m_61124_((Property)f_57514_, (Comparable)Boolean.valueOf(flag));
                this.m_57527_(null, level, pos, flag);
            }
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)f_57516_, (Comparable)Boolean.valueOf(flag)), 2);
            if (((Boolean)state.m_61143_((Property)f_57517_)).booleanValue()) {
                level.m_186469_(pos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)level));
            }
        }
    }
}

