/*
 * Decompiled with CFR 0.152.
 */
package mod.pianomanu.blockcarpentry.block;

import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mod.pianomanu.blockcarpentry.block.AbstractSixWayFrameBlock;
import mod.pianomanu.blockcarpentry.block.FrameBlock;
import mod.pianomanu.blockcarpentry.setup.Registration;
import mod.pianomanu.blockcarpentry.setup.config.BCModConfig;
import mod.pianomanu.blockcarpentry.tileentity.TwoBlocksFrameBlockTile;
import mod.pianomanu.blockcarpentry.util.BCBlockStateProperties;
import mod.pianomanu.blockcarpentry.util.BlockAppearanceHelper;
import mod.pianomanu.blockcarpentry.util.BlockSavingHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class SixWaySlabFrameBlock
extends AbstractSixWayFrameBlock
implements SimpleWaterloggedBlock,
EntityBlock {
    public static final DirectionProperty FACING = BlockStateProperties.f_61372_;
    public static final BooleanProperty CONTAINS_BLOCK = BCBlockStateProperties.CONTAINS_BLOCK;
    public static final BooleanProperty CONTAINS_2ND_BLOCK = BCBlockStateProperties.CONTAINS_2ND_BLOCK;
    public static final IntegerProperty LIGHT_LEVEL = BCBlockStateProperties.LIGHT_LEVEL;
    public static final BooleanProperty DOUBLE_SLAB = BCBlockStateProperties.DOUBLE;
    protected static final VoxelShape BOTTOM = Block.m_49796_((double)0.0, (double)8.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape TOP = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0);
    protected static final VoxelShape EAST = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)8.0, (double)16.0, (double)16.0);
    protected static final VoxelShape SOUTH = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)8.0);
    protected static final VoxelShape WEST = Block.m_49796_((double)8.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape NORTH = Block.m_49796_((double)0.0, (double)0.0, (double)8.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape CUBE = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);

    public SixWaySlabFrameBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.DOWN)).m_61124_((Property)CONTAINS_BLOCK, (Comparable)Boolean.FALSE)).m_61124_((Property)LIGHT_LEVEL, (Comparable)Integer.valueOf(0))).m_61124_((Property)FrameBlock.WATERLOGGED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)DOUBLE_SLAB, (Comparable)Boolean.valueOf(false))).m_61124_((Property)CONTAINS_2ND_BLOCK, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{FrameBlock.WATERLOGGED, DOUBLE_SLAB, CONTAINS_2ND_BLOCK});
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        if (((Boolean)state.m_61143_((Property)DOUBLE_SLAB)).booleanValue()) {
            return CUBE;
        }
        return switch ((Direction)state.m_61143_((Property)FACING)) {
            case Direction.EAST -> EAST;
            case Direction.NORTH -> NORTH;
            case Direction.SOUTH -> SOUTH;
            case Direction.WEST -> WEST;
            case Direction.UP -> TOP;
            default -> BOTTOM;
        };
    }

    @Override
    public BlockState m_5573_(BlockPlaceContext context) {
        BlockPos blockpos = context.m_8083_();
        FluidState fluidstate = context.m_43725_().m_6425_(blockpos);
        BlockState blockState = context.m_43725_().m_8055_(blockpos);
        if (blockState.m_60713_((Block)this)) {
            return (BlockState)((BlockState)blockState.m_61124_((Property)DOUBLE_SLAB, (Comparable)Boolean.valueOf(true))).m_61124_((Property)FrameBlock.WATERLOGGED, (Comparable)Boolean.valueOf(false));
        }
        if (Objects.requireNonNull(context.m_43723_()).m_6047_() && ((Boolean)BCModConfig.SNEAK_FOR_VERTICAL_SLABS.get()).booleanValue() || !Objects.requireNonNull(context.m_43723_()).m_6047_() && !((Boolean)BCModConfig.SNEAK_FOR_VERTICAL_SLABS.get()).booleanValue()) {
            if (fluidstate.m_76152_() == Fluids.f_76193_) {
                return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_7820_().m_122424_())).m_61124_((Property)FrameBlock.WATERLOGGED, (Comparable)Boolean.valueOf(fluidstate.m_76170_()));
            }
            return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_7820_().m_122424_());
        }
        BlockState blockstate1 = (BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)Direction.UP)).m_61124_((Property)FrameBlock.WATERLOGGED, (Comparable)Boolean.valueOf(fluidstate.m_76152_() == Fluids.f_76193_));
        Direction direction = context.m_43719_();
        return !(direction == Direction.DOWN || direction != Direction.UP && context.m_43720_().f_82480_ - (double)blockpos.m_123342_() > 0.5) ? blockstate1 : (BlockState)blockstate1.m_61124_((Property)FACING, (Comparable)Direction.DOWN);
    }

    @Override
    public VoxelShape m_5909_(BlockState state, BlockGetter getter, BlockPos pos, CollisionContext context) {
        return this.m_5940_(state, getter, pos, context);
    }

    public boolean m_6864_(BlockState state, BlockPlaceContext useContext) {
        ItemStack itemstack = useContext.m_43722_();
        boolean slabType = (Boolean)state.m_61143_((Property)DOUBLE_SLAB);
        if (!slabType && itemstack.m_150930_(this.m_5456_())) {
            if (useContext.m_7058_()) {
                Direction direction = useContext.m_43719_();
                return switch ((Direction)state.m_61143_((Property)FACING)) {
                    case Direction.EAST -> {
                        if (direction == Direction.EAST) {
                            yield true;
                        }
                        yield false;
                    }
                    case Direction.SOUTH -> {
                        if (direction == Direction.SOUTH) {
                            yield true;
                        }
                        yield false;
                    }
                    case Direction.WEST -> {
                        if (direction == Direction.WEST) {
                            yield true;
                        }
                        yield false;
                    }
                    case Direction.NORTH -> {
                        if (direction == Direction.NORTH) {
                            yield true;
                        }
                        yield false;
                    }
                    case Direction.UP -> {
                        if (direction == Direction.UP) {
                            yield true;
                        }
                        yield false;
                    }
                    default -> direction == Direction.DOWN;
                };
            }
            return true;
        }
        return false;
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new TwoBlocksFrameBlockTile(pos, state);
    }

    @Override
    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitresult) {
        ItemStack item = player.m_21120_(hand);
        if (!level.f_46443_) {
            if (BlockAppearanceHelper.setLightLevel(item, state, level, pos, player, hand) || BlockAppearanceHelper.setTexture(item, state, level, player, pos) || BlockAppearanceHelper.setDesign(level, pos, player, item) || BlockAppearanceHelper.setDesignTexture(level, pos, player, item) || BlockAppearanceHelper.setOverlay(level, pos, player, item) || BlockAppearanceHelper.setRotation(level, pos, player, item)) {
                return InteractionResult.SUCCESS;
            }
            if (item.m_41720_() instanceof BlockItem) {
                if (((Boolean)state.m_61143_((Property)BCBlockStateProperties.CONTAINS_BLOCK)).booleanValue() && !((Boolean)state.m_61143_((Property)DOUBLE_SLAB)).booleanValue() || ((Boolean)state.m_61143_((Property)BCBlockStateProperties.CONTAINS_2ND_BLOCK)).booleanValue() || Objects.requireNonNull(item.m_41720_().getRegistryName()).m_135827_().equals("blockcarpentry")) {
                    return InteractionResult.PASS;
                }
                BlockEntity tileEntity = level.m_7702_(pos);
                int count = player.m_21120_(hand).m_41613_();
                Block heldBlock = ((BlockItem)item.m_41720_()).m_40614_();
                if (tileEntity instanceof TwoBlocksFrameBlockTile && !item.m_41619_() && BlockSavingHelper.isValidBlock(heldBlock) && !((Boolean)state.m_61143_((Property)CONTAINS_2ND_BLOCK)).booleanValue()) {
                    BlockState handBlockState = ((BlockItem)item.m_41720_()).m_40614_().m_49966_();
                    this.insertBlock(level, pos, state, handBlockState);
                    if (!player.m_7500_()) {
                        player.m_21120_(hand).m_41764_(count - 1);
                    }
                    this.checkForVisibility(state, level, pos, (TwoBlocksFrameBlockTile)tileEntity);
                }
            }
            if (player.m_21120_(hand).m_41720_() == Registration.HAMMER.get() || !((Boolean)BCModConfig.HAMMER_NEEDED.get()).booleanValue() && player.m_6047_()) {
                if (!player.m_7500_()) {
                    this.dropContainedBlock(level, pos);
                }
                state = (BlockState)state.m_61124_((Property)CONTAINS_BLOCK, (Comparable)Boolean.FALSE);
                state = (BlockState)state.m_61124_((Property)CONTAINS_2ND_BLOCK, (Comparable)Boolean.FALSE);
                level.m_7731_(pos, state, 2);
            }
        }
        return item.m_41720_() instanceof BlockItem ? InteractionResult.SUCCESS : InteractionResult.PASS;
    }

    @Override
    protected void dropContainedBlock(Level levelIn, BlockPos pos) {
        BlockEntity tileentity;
        if (!levelIn.f_46443_ && (tileentity = levelIn.m_7702_(pos)) instanceof TwoBlocksFrameBlockTile) {
            ItemEntity itementity;
            ItemStack itemstack1;
            double d2;
            double d1;
            double d0;
            float f;
            TwoBlocksFrameBlockTile frameBlockEntity = (TwoBlocksFrameBlockTile)tileentity;
            BlockState blockState = frameBlockEntity.getMimic_1();
            if (blockState != null) {
                levelIn.m_46796_(1010, pos, 0);
                f = 0.7f;
                d0 = (double)(levelIn.f_46441_.nextFloat() * 0.7f) + (double)0.15f;
                d1 = (double)(levelIn.f_46441_.nextFloat() * 0.7f) + 0.06000000238418579 + 0.6;
                d2 = (double)(levelIn.f_46441_.nextFloat() * 0.7f) + (double)0.15f;
                itemstack1 = new ItemStack((ItemLike)blockState.m_60734_());
                itementity = new ItemEntity(levelIn, (double)pos.m_123341_() + d0, (double)pos.m_123342_() + d1, (double)pos.m_123343_() + d2, itemstack1);
                itementity.m_32060_();
                levelIn.m_7967_((Entity)itementity);
            }
            if ((blockState = frameBlockEntity.getMimic_2()) != null) {
                levelIn.m_46796_(1010, pos, 0);
                f = 0.7f;
                d0 = (double)(levelIn.f_46441_.nextFloat() * 0.7f) + (double)0.15f;
                d1 = (double)(levelIn.f_46441_.nextFloat() * 0.7f) + 0.06000000238418579 + 0.6;
                d2 = (double)(levelIn.f_46441_.nextFloat() * 0.7f) + (double)0.15f;
                itemstack1 = new ItemStack((ItemLike)blockState.m_60734_());
                itementity = new ItemEntity(levelIn, (double)pos.m_123341_() + d0, (double)pos.m_123342_() + d1, (double)pos.m_123343_() + d2, itemstack1);
                itementity.m_32060_();
                levelIn.m_7967_((Entity)itementity);
            }
            frameBlockEntity.clear();
        }
    }

    @Override
    public void insertBlock(Level levelIn, BlockPos pos, BlockState state, BlockState handBlock) {
        BlockEntity tileentity = levelIn.m_7702_(pos);
        if (tileentity instanceof TwoBlocksFrameBlockTile) {
            if (!((Boolean)state.m_61143_((Property)CONTAINS_BLOCK)).booleanValue()) {
                TwoBlocksFrameBlockTile frameBlockEntity = (TwoBlocksFrameBlockTile)tileentity;
                frameBlockEntity.clear();
                frameBlockEntity.setMimic_1(handBlock);
                levelIn.m_7731_(pos, (BlockState)state.m_61124_((Property)CONTAINS_BLOCK, (Comparable)Boolean.TRUE), 2);
            } else if (((Boolean)state.m_61143_((Property)DOUBLE_SLAB)).booleanValue()) {
                TwoBlocksFrameBlockTile frameBlockEntity = (TwoBlocksFrameBlockTile)tileentity;
                frameBlockEntity.setMimic_2(handBlock);
                levelIn.m_7731_(pos, (BlockState)state.m_61124_((Property)CONTAINS_2ND_BLOCK, (Comparable)Boolean.TRUE), 2);
            }
        }
    }

    public void m_6810_(BlockState state, @Nonnull Level levelIn, @Nonnull BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.m_60734_() != newState.m_60734_()) {
            this.dropContainedBlock(levelIn, pos);
            super.m_6810_(state, levelIn, pos, newState, isMoving);
        }
    }

    @Override
    public int getLightEmission(BlockState state, BlockGetter level, BlockPos pos) {
        if ((Integer)state.m_61143_((Property)LIGHT_LEVEL) > 15) {
            return 15;
        }
        return (Integer)state.m_61143_((Property)LIGHT_LEVEL);
    }

    @Nonnull
    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)FrameBlock.WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    @Nonnull
    public BlockState m_7417_(BlockState stateIn, @Nonnull Direction facing, @Nonnull BlockState facingState, @Nonnull LevelAccessor levelIn, @Nonnull BlockPos currentPos, @Nonnull BlockPos facingPos) {
        if (((Boolean)stateIn.m_61143_((Property)FrameBlock.WATERLOGGED)).booleanValue()) {
            levelIn.m_186469_(currentPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)levelIn));
        }
        return super.m_7417_(stateIn, facing, facingState, levelIn, currentPos, facingPos);
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean isSideInvisible(BlockState state, BlockState adjacentBlockState, Direction side) {
        return adjacentBlockState.m_60713_((Block)this);
    }

    private void checkForVisibility(BlockState state, Level level, BlockPos pos, TwoBlocksFrameBlockTile tileEntity) {
        for (Direction d : Direction.values()) {
            BlockPos.MutableBlockPos mutablePos = pos.m_122032_();
            BlockState blockState = level.m_8055_((BlockPos)mutablePos.m_122173_(d));
        }
    }
}

