/*
 * Decompiled with CFR 0.152.
 */
package mod.pianomanu.blockcarpentry.bakedmodels.helper;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.VertexFormatElement;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.model.pipeline.BakedQuadBuilder;

public class HandleBakedModel {
    private static void putVertex(BakedQuadBuilder builder, Vec3 normal, double x, double y, double z, float u, float v, TextureAtlasSprite sprite, float r, float g, float b) {
        ImmutableList elements = builder.getVertexFormat().m_86023_().asList();
        block10: for (int j = 0; j < elements.size(); ++j) {
            VertexFormatElement e = (VertexFormatElement)elements.get(j);
            switch (e.m_86048_()) {
                case POSITION: {
                    builder.put(j, new float[]{(float)x, (float)y, (float)z, 1.0f});
                    continue block10;
                }
                case COLOR: {
                    builder.put(j, new float[]{r, g, b, 1.0f});
                    continue block10;
                }
                case UV: {
                    switch (e.m_86049_()) {
                        case 0: {
                            float iu = sprite.m_118367_((double)u);
                            float iv = sprite.m_118393_((double)v);
                            builder.put(j, new float[]{iu, iv});
                            continue block10;
                        }
                        case 2: {
                            builder.put(j, new float[]{0.0f, 0.0f});
                            continue block10;
                        }
                    }
                    builder.put(j, new float[0]);
                    continue block10;
                }
                case NORMAL: {
                    builder.put(j, new float[]{(float)normal.f_82479_, (float)normal.f_82480_, (float)normal.f_82481_});
                    continue block10;
                }
                default: {
                    builder.put(j, new float[0]);
                }
            }
        }
        builder.setApplyDiffuseLighting(true);
    }

    private static BakedQuad create5x4Quad(Vec3 v1, Vec3 v2, Vec3 v3, Vec3 v4, TextureAtlasSprite sprite, int flag) {
        Vec3 normal = v3.m_82546_(v2).m_82537_(v1.m_82546_(v2)).m_82541_();
        BakedQuadBuilder builder = new BakedQuadBuilder(sprite);
        builder.setQuadOrientation(Direction.m_122366_((double)normal.f_82479_, (double)normal.f_82480_, (double)normal.f_82481_));
        builder.setApplyDiffuseLighting(true);
        float ul = 0.0f;
        float uh = 5.0f;
        float vl = 0.0f;
        float vh = 4.0f;
        if (flag == 0) {
            uh = 1.0f;
        } else if (flag == 1) {
            uh = 4.0f;
            vh = 1.0f;
        } else if (flag == 2) {
            uh = 4.0f;
            vh = 5.0f;
        }
        HandleBakedModel.putVertex(builder, normal, v1.f_82479_, v1.f_82480_, v1.f_82481_, ul, vl, sprite, 1.0f, 1.0f, 1.0f);
        HandleBakedModel.putVertex(builder, normal, v2.f_82479_, v2.f_82480_, v2.f_82481_, ul, vh, sprite, 1.0f, 1.0f, 1.0f);
        HandleBakedModel.putVertex(builder, normal, v3.f_82479_, v3.f_82480_, v3.f_82481_, uh, vh, sprite, 1.0f, 1.0f, 1.0f);
        HandleBakedModel.putVertex(builder, normal, v4.f_82479_, v4.f_82480_, v4.f_82481_, uh, vl, sprite, 1.0f, 1.0f, 1.0f);
        return builder.build();
    }

    private static BakedQuad create1x4Quad(Vec3 v1, Vec3 v2, Vec3 v3, Vec3 v4, TextureAtlasSprite sprite, int flag) {
        Vec3 normal = v3.m_82546_(v2).m_82537_(v1.m_82546_(v2)).m_82541_();
        BakedQuadBuilder builder = new BakedQuadBuilder(sprite);
        builder.setQuadOrientation(Direction.m_122366_((double)normal.f_82479_, (double)normal.f_82480_, (double)normal.f_82481_));
        builder.setApplyDiffuseLighting(true);
        float ul = 0.0f;
        float uh = 4.0f;
        float vl = 0.0f;
        float vh = 1.0f;
        if (flag == 3) {
            uh = 5.0f;
            vh = 1.0f;
        } else if (flag == 1) {
            uh = 4.0f;
            vh = 5.0f;
        } else if (flag == 2) {
            uh = 4.0f;
            vh = 1.0f;
        } else if (flag == 0) {
            uh = 1.0f;
            vh = 5.0f;
        }
        HandleBakedModel.putVertex(builder, normal, v1.f_82479_, v1.f_82480_, v1.f_82481_, ul, vl, sprite, 1.0f, 1.0f, 1.0f);
        HandleBakedModel.putVertex(builder, normal, v2.f_82479_, v2.f_82480_, v2.f_82481_, ul, vh, sprite, 1.0f, 1.0f, 1.0f);
        HandleBakedModel.putVertex(builder, normal, v3.f_82479_, v3.f_82480_, v3.f_82481_, uh, vh, sprite, 1.0f, 1.0f, 1.0f);
        HandleBakedModel.putVertex(builder, normal, v4.f_82479_, v4.f_82480_, v4.f_82481_, uh, vl, sprite, 1.0f, 1.0f, 1.0f);
        return builder.build();
    }

    private static BakedQuad create1x5Quad(Vec3 v1, Vec3 v2, Vec3 v3, Vec3 v4, TextureAtlasSprite sprite, int flag) {
        Vec3 normal = v3.m_82546_(v2).m_82537_(v1.m_82546_(v2)).m_82541_();
        BakedQuadBuilder builder = new BakedQuadBuilder(sprite);
        builder.setQuadOrientation(Direction.m_122366_((double)normal.f_82479_, (double)normal.f_82480_, (double)normal.f_82481_));
        builder.setApplyDiffuseLighting(true);
        float ul = 0.0f;
        float uh = 1.0f;
        float vl = 0.0f;
        float vh = 5.0f;
        if (flag == 3) {
            vh = 4.0f;
        } else if (flag == 1) {
            uh = 4.0f;
            vh = 1.0f;
        } else if (flag == 0) {
            vh = 4.0f;
            uh = 5.0f;
        }
        HandleBakedModel.putVertex(builder, normal, v1.f_82479_, v1.f_82480_, v1.f_82481_, ul, vl, sprite, 1.0f, 1.0f, 1.0f);
        HandleBakedModel.putVertex(builder, normal, v2.f_82479_, v2.f_82480_, v2.f_82481_, ul, vh, sprite, 1.0f, 1.0f, 1.0f);
        HandleBakedModel.putVertex(builder, normal, v3.f_82479_, v3.f_82480_, v3.f_82481_, uh, vh, sprite, 1.0f, 1.0f, 1.0f);
        HandleBakedModel.putVertex(builder, normal, v4.f_82479_, v4.f_82480_, v4.f_82481_, uh, vl, sprite, 1.0f, 1.0f, 1.0f);
        return builder.build();
    }

    public static List<BakedQuad> createHandle(float xl, float xh, float yl, float yh, float zl, float zh, int flag, int design_texture) {
        TextureAtlasSprite texture = design_texture == 0 ? (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(new ResourceLocation("minecraft", "block/iron_block")) : (design_texture == 1 ? (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(new ResourceLocation("minecraft", "block/obsidian")) : (design_texture == 2 ? (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(new ResourceLocation("minecraft", "block/stone")) : (design_texture == 3 ? (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(new ResourceLocation("minecraft", "block/gold_block")) : (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(new ResourceLocation("minecraft", "block/oak_log")))));
        ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
        Vec3 NWU = HandleBakedModel.v(xl, yh, zl);
        Vec3 NEU = HandleBakedModel.v(xl, yh, zh);
        Vec3 NWD = HandleBakedModel.v(xl, yl, zl);
        Vec3 NED = HandleBakedModel.v(xl, yl, zh);
        Vec3 SWU = HandleBakedModel.v(xh, yh, zl);
        Vec3 SEU = HandleBakedModel.v(xh, yh, zh);
        Vec3 SWD = HandleBakedModel.v(xh, yl, zl);
        Vec3 SED = HandleBakedModel.v(xh, yl, zh);
        quads.add(HandleBakedModel.create5x4Quad(NWU, NEU, SEU, SWU, texture, flag));
        quads.add(HandleBakedModel.create5x4Quad(SWD, SED, NED, NWD, texture, flag));
        quads.add(HandleBakedModel.create1x4Quad(NWD, NWU, SWU, SWD, texture, flag));
        quads.add(HandleBakedModel.create1x4Quad(SED, SEU, NEU, NED, texture, flag));
        quads.add(HandleBakedModel.create1x5Quad(NWD, NED, NEU, NWU, texture, flag));
        quads.add(HandleBakedModel.create1x5Quad(SWU, SEU, SED, SWD, texture, flag));
        return quads;
    }

    private static Vec3 v(double x, double y, double z) {
        return new Vec3(x, y, z);
    }
}

