/*
 * Decompiled with CFR 0.152.
 */
package mod.pianomanu.blockcarpentry.bakedmodels;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mod.pianomanu.blockcarpentry.tileentity.FrameBlockTile;
import mod.pianomanu.blockcarpentry.util.BlockAppearanceHelper;
import mod.pianomanu.blockcarpentry.util.ModelHelper;
import mod.pianomanu.blockcarpentry.util.TextureHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.BlockModelShaper;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.StairsShape;
import net.minecraftforge.client.model.data.IDynamicBakedModel;
import net.minecraftforge.client.model.data.IModelData;

public class StairsBakedModel
implements IDynamicBakedModel {
    public static final ResourceLocation TEXTURE = new ResourceLocation("minecraft", "block/oak_planks");

    private TextureAtlasSprite getTexture() {
        return (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(TEXTURE);
    }

    @Nonnull
    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, @Nonnull Random rand, @Nonnull IModelData extraData) {
        BlockState mimic = (BlockState)extraData.getData(FrameBlockTile.MIMIC);
        if (mimic != null) {
            ModelResourceLocation location = BlockModelShaper.m_110895_((BlockState)mimic);
            BakedModel model = Minecraft.m_91087_().m_91304_().m_119422_(location);
            return this.getMimicQuads(state, side, rand, extraData, model);
        }
        return Collections.emptyList();
    }

    public List<BakedQuad> getMimicQuads(@Nullable BlockState state, @Nullable Direction side, @Nonnull Random rand, @Nonnull IModelData extraData, BakedModel model) {
        if (side != null) {
            return Collections.emptyList();
        }
        BlockState mimic = (BlockState)extraData.getData(FrameBlockTile.MIMIC);
        int tex = (Integer)extraData.getData(FrameBlockTile.TEXTURE);
        if (mimic != null && state != null) {
            List<TextureAtlasSprite> textureList = TextureHelper.getTextureFromModel(model, extraData, rand);
            if (textureList.size() <= tex) {
                extraData.setData(FrameBlockTile.TEXTURE, (Object)0);
                tex = 0;
            }
            if (textureList.size() == 0) {
                if (Minecraft.m_91087_().f_91074_ != null) {
                    Minecraft.m_91087_().f_91074_.m_5661_((Component)new TranslatableComponent("message.blockcarpentry.block_not_available"), true);
                }
                return Collections.emptyList();
            }
            TextureAtlasSprite texture = textureList.get(tex);
            int tintIndex = BlockAppearanceHelper.setTintIndex(mimic);
            ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
            float yl = 0.0f;
            float yh = 0.5f;
            boolean cullUpDown = false;
            if (((Half)state.m_61143_((Property)StairBlock.f_56842_)).equals((Object)Half.TOP)) {
                yl = 0.5f;
                yh = 1.0f;
                cullUpDown = true;
            }
            block0 : switch ((StairsShape)state.m_61143_((Property)StairBlock.f_56843_)) {
                case STRAIGHT: {
                    switch ((Direction)state.m_61143_((Property)StairBlock.f_56841_)) {
                        case NORTH: {
                            quads.addAll(ModelHelper.createCuboid(0.0f, 1.0f, yl, yh, 0.0f, 0.5f, texture, tintIndex, true, false, true, true, cullUpDown, !cullUpDown));
                            quads.addAll(ModelHelper.createCuboid(0.0f, 1.0f, yl, yh, 0.5f, 1.0f, texture, tintIndex, false, true, true, true, true, true));
                            quads.addAll(ModelHelper.createCuboid(0.0f, 1.0f, 1.0f - yh, 1.0f - yl, 0.0f, 0.5f, texture, tintIndex, true, true, true, true, !cullUpDown, cullUpDown));
                            break;
                        }
                        case SOUTH: {
                            quads.addAll(ModelHelper.createCuboid(0.0f, 1.0f, yl, yh, 0.0f, 0.5f, texture, tintIndex, true, false, true, true, true, true));
                            quads.addAll(ModelHelper.createCuboid(0.0f, 1.0f, yl, yh, 0.5f, 1.0f, texture, tintIndex, false, true, true, true, cullUpDown, !cullUpDown));
                            quads.addAll(ModelHelper.createCuboid(0.0f, 1.0f, 1.0f - yh, 1.0f - yl, 0.5f, 1.0f, texture, tintIndex, true, true, true, true, !cullUpDown, cullUpDown));
                            break;
                        }
                        case WEST: {
                            quads.addAll(ModelHelper.createCuboid(0.0f, 0.5f, yl, yh, 0.0f, 1.0f, texture, tintIndex, true, true, false, true, cullUpDown, !cullUpDown));
                            quads.addAll(ModelHelper.createCuboid(0.5f, 1.0f, yl, yh, 0.0f, 1.0f, texture, tintIndex, true, true, true, false, true, true));
                            quads.addAll(ModelHelper.createCuboid(0.0f, 0.5f, 1.0f - yh, 1.0f - yl, 0.0f, 1.0f, texture, tintIndex, true, true, true, true, !cullUpDown, cullUpDown));
                            break;
                        }
                        case EAST: {
                            quads.addAll(ModelHelper.createCuboid(0.0f, 0.5f, yl, yh, 0.0f, 1.0f, texture, tintIndex, true, true, false, true, true, true));
                            quads.addAll(ModelHelper.createCuboid(0.5f, 1.0f, yl, yh, 0.0f, 1.0f, texture, tintIndex, true, true, true, false, cullUpDown, !cullUpDown));
                            quads.addAll(ModelHelper.createCuboid(0.5f, 1.0f, 1.0f - yh, 1.0f - yl, 0.0f, 1.0f, texture, tintIndex, true, true, true, true, !cullUpDown, cullUpDown));
                        }
                    }
                    break;
                }
                case INNER_LEFT: {
                    switch ((Direction)state.m_61143_((Property)StairBlock.f_56841_)) {
                        case NORTH: {
                            quads.addAll(ModelHelper.createCuboid(0.0f, 0.5f, yl, yh, 0.0f, 0.5f, texture, tintIndex, true, false, false, true, cullUpDown, !cullUpDown));
                            quads.addAll(ModelHelper.createCuboid(0.0f, 0.5f, yl, yh, 0.5f, 1.0f, texture, tintIndex, false, true, false, true, cullUpDown, !cullUpDown));
                            quads.addAll(ModelHelper.createCuboid(0.5f, 1.0f, yl, yh, 0.5f, 1.0f, texture, tintIndex, false, true, true, false, true, true));
                            quads.addAll(ModelHelper.createCuboid(0.5f, 1.0f, yl, yh, 0.0f, 0.5f, texture, tintIndex, true, false, true, false, cullUpDown, !cullUpDown));
                            quads.addAll(ModelHelper.createCuboid(0.0f, 0.5f, 1.0f - yh, 1.0f - yl, 0.0f, 0.5f, texture, tintIndex, true, false, false, true, !cullUpDown, cullUpDown));
                            quads.addAll(ModelHelper.createCuboid(0.0f, 0.5f, 1.0f - yh, 1.0f - yl, 0.5f, 1.0f, texture, tintIndex, false, true, true, true, !cullUpDown, cullUpDown));
                            quads.addAll(ModelHelper.createCuboid(0.5f, 1.0f, 1.0f - yh, 1.0f - yl, 0.0f, 0.5f, texture, tintIndex, true, true, true, false, !cullUpDown, cullUpDown));
                            break;
                        }
                        case SOUTH: {
                            quads.addAll(ModelHelper.createCuboid(0.0f, 0.5f, yl, yh, 0.0f, 0.5f, texture, tintIndex, true, false, false, true, true, true));
                            quads.addAll(ModelHelper.createCuboid(0.0f, 0.5f, yl, yh, 0.5f, 1.0f, texture, tintIndex, false, true, false, true, cullUpDown, !cullUpDown));
                            quads.addAll(ModelHelper.createCuboid(0.5f, 1.0f, yl, yh, 0.5f, 1.0f, texture, tintIndex, false, true, true, false, cullUpDown, !cullUpDown));
                            quads.addAll(ModelHelper.createCuboid(0.5f, 1.0f, yl, yh, 0.0f, 0.5f, texture, tintIndex, true, false, true, false, cullUpDown, !cullUpDown));
                            quads.addAll(ModelHelper.createCuboid(0.0f, 0.5f, 1.0f - yh, 1.0f - yl, 0.5f, 1.0f, texture, tintIndex, true, true, false, true, !cullUpDown, cullUpDown));
                            quads.addAll(ModelHelper.createCuboid(0.5f, 1.0f, 1.0f - yh, 1.0f - yl, 0.5f, 1.0f, texture, tintIndex, false, true, true, false, !cullUpDown, cullUpDown));
                            quads.addAll(ModelHelper.createCuboid(0.5f, 1.0f, 1.0f - yh, 1.0f - yl, 0.0f, 0.5f, texture, tintIndex, true, false, true, true, !cullUpDown, cullUpDown));
                            break;
                        }
                        case WEST: {
                            quads.addAll(ModelHelper.createCuboid(0.0f, 0.5f, yl, yh, 0.0f, 0.5f, texture, tintIndex, true, false, false, true, cullUpDown, !cullUpDown));
                            quads.addAll(ModelHelper.createCuboid(0.0f, 0.5f, yl, yh, 0.5f, 1.0f, texture, tintIndex, false, true, false, true, cullUpDown, !cullUpDown));
                            quads.addAll(ModelHelper.createCuboid(0.5f, 1.0f, yl, yh, 0.5f, 1.0f, texture, tintIndex, false, true, true, false, cullUpDown, !cullUpDown));
                            quads.addAll(ModelHelper.createCuboid(0.5f, 1.0f, yl, yh, 0.0f, 0.5f, texture, tintIndex, true, false, true, false, true, true));
                            quads.addAll(ModelHelper.createCuboid(0.0f, 0.5f, 1.0f - yh, 1.0f - yl, 0.0f, 0.5f, texture, tintIndex, true, false, true, true, !cullUpDown, cullUpDown));
                            quads.addAll(ModelHelper.createCuboid(0.0f, 0.5f, 1.0f - yh, 1.0f - yl, 0.5f, 1.0f, texture, tintIndex, false, true, false, true, !cullUpDown, cullUpDown));
                            quads.addAll(ModelHelper.createCuboid(0.5f, 1.0f, 1.0f - yh, 1.0f - yl, 0.5f, 1.0f, texture, tintIndex, true, true, true, false, !cullUpDown, cullUpDown));
                            break;
                        }
                        case EAST: {
                            quads.addAll(ModelHelper.createCuboid(0.0f, 0.5f, yl, yh, 0.0f, 0.5f, texture, tintIndex, true, false, false, true, cullUpDown, !cullUpDown));
                            quads.addAll(ModelHelper.createCuboid(0.0f, 0.5f, yl, yh, 0.5f, 1.0f, texture, tintIndex, false, true, false, true, true, true));
                            quads.addAll(ModelHelper.createCuboid(0.5f, 1.0f, yl, yh, 0.5f, 1.0f, texture, tintIndex, false, true, true, false, cullUpDown, !cullUpDown));
                            quads.addAll(ModelHelper.createCuboid(0.5f, 1.0f, yl, yh, 0.0f, 0.5f, texture, tintIndex, true, false, true, false, cullUpDown, !cullUpDown));
                            quads.addAll(ModelHelper.createCuboid(0.0f, 0.5f, 1.0f - yh, 1.0f - yl, 0.0f, 0.5f, texture, tintIndex, true, true, false, true, !cullUpDown, cullUpDown));
                            quads.addAll(ModelHelper.createCuboid(0.5f, 1.0f, 1.0f - yh, 1.0f - yl, 0.5f, 1.0f, texture, tintIndex, false, true, true, true, !cullUpDown, cullUpDown));
                            quads.addAll(ModelHelper.createCuboid(0.5f, 1.0f, 1.0f - yh, 1.0f - yl, 0.0f, 0.5f, texture, tintIndex, true, false, true, false, !cullUpDown, cullUpDown));
                        }
                    }
                    break;
                }
                case INNER_RIGHT: {
                    switch ((Direction)state.m_61143_((Property)StairBlock.f_56841_)) {
                        case WEST: {
                            quads.addAll(ModelHelper.createCuboid(0.0f, 0.5f, yl, yh, 0.0f, 0.5f, texture, tintIndex, true, false, false, true, cullUpDown, !cullUpDown));
                            quads.addAll(ModelHelper.createCuboid(0.0f, 0.5f, yl, yh, 0.5f, 1.0f, texture, tintIndex, false, true, false, true, cullUpDown, !cullUpDown));
                            quads.addAll(ModelHelper.createCuboid(0.5f, 1.0f, yl, yh, 0.5f, 1.0f, texture, tintIndex, false, true, true, false, true, true));
                            quads.addAll(ModelHelper.createCuboid(0.5f, 1.0f, yl, yh, 0.0f, 0.5f, texture, tintIndex, true, false, true, false, cullUpDown, !cullUpDown));
                            quads.addAll(ModelHelper.createCuboid(0.0f, 0.5f, 1.0f - yh, 1.0f - yl, 0.0f, 0.5f, texture, tintIndex, true, false, false, true, !cullUpDown, cullUpDown));
                            quads.addAll(ModelHelper.createCuboid(0.0f, 0.5f, 1.0f - yh, 1.0f - yl, 0.5f, 1.0f, texture, tintIndex, false, true, true, true, !cullUpDown, cullUpDown));
                            quads.addAll(ModelHelper.createCuboid(0.5f, 1.0f, 1.0f - yh, 1.0f - yl, 0.0f, 0.5f, texture, tintIndex, true, true, true, false, !cullUpDown, cullUpDown));
                            break;
                        }
                        case EAST: {
                            quads.addAll(ModelHelper.createCuboid(0.0f, 0.5f, yl, yh, 0.0f, 0.5f, texture, tintIndex, true, false, false, true, true, true));
                            quads.addAll(ModelHelper.createCuboid(0.0f, 0.5f, yl, yh, 0.5f, 1.0f, texture, tintIndex, false, true, false, true, cullUpDown, !cullUpDown));
                            quads.addAll(ModelHelper.createCuboid(0.5f, 1.0f, yl, yh, 0.5f, 1.0f, texture, tintIndex, false, true, true, false, cullUpDown, !cullUpDown));
                            quads.addAll(ModelHelper.createCuboid(0.5f, 1.0f, yl, yh, 0.0f, 0.5f, texture, tintIndex, true, false, true, false, cullUpDown, !cullUpDown));
                            quads.addAll(ModelHelper.createCuboid(0.0f, 0.5f, 1.0f - yh, 1.0f - yl, 0.5f, 1.0f, texture, tintIndex, true, true, false, true, !cullUpDown, cullUpDown));
                            quads.addAll(ModelHelper.createCuboid(0.5f, 1.0f, 1.0f - yh, 1.0f - yl, 0.5f, 1.0f, texture, tintIndex, false, true, true, false, !cullUpDown, cullUpDown));
                            quads.addAll(ModelHelper.createCuboid(0.5f, 1.0f, 1.0f - yh, 1.0f - yl, 0.0f, 0.5f, texture, tintIndex, true, false, true, true, !cullUpDown, cullUpDown));
                            break;
                        }
                        case SOUTH: {
                            quads.addAll(ModelHelper.createCuboid(0.0f, 0.5f, yl, yh, 0.0f, 0.5f, texture, tintIndex, true, false, false, true, cullUpDown, !cullUpDown));
                            quads.addAll(ModelHelper.createCuboid(0.0f, 0.5f, yl, yh, 0.5f, 1.0f, texture, tintIndex, false, true, false, true, cullUpDown, !cullUpDown));
                            quads.addAll(ModelHelper.createCuboid(0.5f, 1.0f, yl, yh, 0.5f, 1.0f, texture, tintIndex, false, true, true, false, cullUpDown, !cullUpDown));
                            quads.addAll(ModelHelper.createCuboid(0.5f, 1.0f, yl, yh, 0.0f, 0.5f, texture, tintIndex, true, false, true, false, true, true));
                            quads.addAll(ModelHelper.createCuboid(0.0f, 0.5f, 1.0f - yh, 1.0f - yl, 0.0f, 0.5f, texture, tintIndex, true, false, true, true, !cullUpDown, cullUpDown));
                            quads.addAll(ModelHelper.createCuboid(0.0f, 0.5f, 1.0f - yh, 1.0f - yl, 0.5f, 1.0f, texture, tintIndex, false, true, false, true, !cullUpDown, cullUpDown));
                            quads.addAll(ModelHelper.createCuboid(0.5f, 1.0f, 1.0f - yh, 1.0f - yl, 0.5f, 1.0f, texture, tintIndex, true, true, true, false, !cullUpDown, cullUpDown));
                            break;
                        }
                        case NORTH: {
                            quads.addAll(ModelHelper.createCuboid(0.0f, 0.5f, yl, yh, 0.0f, 0.5f, texture, tintIndex, true, false, false, true, cullUpDown, !cullUpDown));
                            quads.addAll(ModelHelper.createCuboid(0.0f, 0.5f, yl, yh, 0.5f, 1.0f, texture, tintIndex, false, true, false, true, true, true));
                            quads.addAll(ModelHelper.createCuboid(0.5f, 1.0f, yl, yh, 0.5f, 1.0f, texture, tintIndex, false, true, true, false, cullUpDown, !cullUpDown));
                            quads.addAll(ModelHelper.createCuboid(0.5f, 1.0f, yl, yh, 0.0f, 0.5f, texture, tintIndex, true, false, true, false, cullUpDown, !cullUpDown));
                            quads.addAll(ModelHelper.createCuboid(0.0f, 0.5f, 1.0f - yh, 1.0f - yl, 0.0f, 0.5f, texture, tintIndex, true, true, false, true, !cullUpDown, cullUpDown));
                            quads.addAll(ModelHelper.createCuboid(0.5f, 1.0f, 1.0f - yh, 1.0f - yl, 0.5f, 1.0f, texture, tintIndex, false, true, true, true, !cullUpDown, cullUpDown));
                            quads.addAll(ModelHelper.createCuboid(0.5f, 1.0f, 1.0f - yh, 1.0f - yl, 0.0f, 0.5f, texture, tintIndex, true, false, true, false, !cullUpDown, cullUpDown));
                        }
                    }
                    break;
                }
                case OUTER_LEFT: {
                    switch ((Direction)state.m_61143_((Property)StairBlock.f_56841_)) {
                        case NORTH: {
                            quads.addAll(ModelHelper.createCuboid(0.0f, 0.5f, yl, yh, 0.0f, 0.5f, texture, tintIndex, true, false, false, true, cullUpDown, !cullUpDown));
                            quads.addAll(ModelHelper.createCuboid(0.0f, 0.5f, yl, yh, 0.5f, 1.0f, texture, tintIndex, false, true, false, true, true, true));
                            quads.addAll(ModelHelper.createCuboid(0.5f, 1.0f, yl, yh, 0.5f, 1.0f, texture, tintIndex, false, true, true, false, true, true));
                            quads.addAll(ModelHelper.createCuboid(0.5f, 1.0f, yl, yh, 0.0f, 0.5f, texture, tintIndex, true, false, true, false, true, true));
                            quads.addAll(ModelHelper.createCuboid(0.0f, 0.5f, 1.0f - yh, 1.0f - yl, 0.0f, 0.5f, texture, tintIndex, true, true, true, true, !cullUpDown, cullUpDown));
                            break;
                        }
                        case SOUTH: {
                            quads.addAll(ModelHelper.createCuboid(0.0f, 0.5f, yl, yh, 0.0f, 0.5f, texture, tintIndex, true, false, false, true, true, true));
                            quads.addAll(ModelHelper.createCuboid(0.0f, 0.5f, yl, yh, 0.5f, 1.0f, texture, tintIndex, false, true, false, true, true, true));
                            quads.addAll(ModelHelper.createCuboid(0.5f, 1.0f, yl, yh, 0.5f, 1.0f, texture, tintIndex, false, true, true, false, cullUpDown, !cullUpDown));
                            quads.addAll(ModelHelper.createCuboid(0.5f, 1.0f, yl, yh, 0.0f, 0.5f, texture, tintIndex, true, false, true, false, true, true));
                            quads.addAll(ModelHelper.createCuboid(0.5f, 1.0f, 1.0f - yh, 1.0f - yl, 0.5f, 1.0f, texture, tintIndex, true, true, true, true, !cullUpDown, cullUpDown));
                            break;
                        }
                        case WEST: {
                            quads.addAll(ModelHelper.createCuboid(0.0f, 0.5f, yl, yh, 0.0f, 0.5f, texture, tintIndex, true, false, false, true, true, true));
                            quads.addAll(ModelHelper.createCuboid(0.0f, 0.5f, yl, yh, 0.5f, 1.0f, texture, tintIndex, false, true, false, true, cullUpDown, !cullUpDown));
                            quads.addAll(ModelHelper.createCuboid(0.5f, 1.0f, yl, yh, 0.5f, 1.0f, texture, tintIndex, false, true, true, false, true, true));
                            quads.addAll(ModelHelper.createCuboid(0.5f, 1.0f, yl, yh, 0.0f, 0.5f, texture, tintIndex, true, false, true, false, true, true));
                            quads.addAll(ModelHelper.createCuboid(0.0f, 0.5f, 1.0f - yh, 1.0f - yl, 0.5f, 1.0f, texture, tintIndex, true, true, true, true, !cullUpDown, cullUpDown));
                            break;
                        }
                        case EAST: {
                            quads.addAll(ModelHelper.createCuboid(0.0f, 0.5f, yl, yh, 0.0f, 0.5f, texture, tintIndex, true, false, false, true, true, true));
                            quads.addAll(ModelHelper.createCuboid(0.0f, 0.5f, yl, yh, 0.5f, 1.0f, texture, tintIndex, false, true, false, true, true, true));
                            quads.addAll(ModelHelper.createCuboid(0.5f, 1.0f, yl, yh, 0.5f, 1.0f, texture, tintIndex, false, true, true, false, true, true));
                            quads.addAll(ModelHelper.createCuboid(0.5f, 1.0f, yl, yh, 0.0f, 0.5f, texture, tintIndex, true, false, true, false, cullUpDown, !cullUpDown));
                            quads.addAll(ModelHelper.createCuboid(0.5f, 1.0f, 1.0f - yh, 1.0f - yl, 0.0f, 0.5f, texture, tintIndex, true, true, true, true, !cullUpDown, cullUpDown));
                        }
                    }
                    break;
                }
                case OUTER_RIGHT: {
                    switch ((Direction)state.m_61143_((Property)StairBlock.f_56841_)) {
                        case WEST: {
                            quads.addAll(ModelHelper.createCuboid(0.0f, 0.5f, yl, yh, 0.0f, 0.5f, texture, tintIndex, true, false, false, true, cullUpDown, !cullUpDown));
                            quads.addAll(ModelHelper.createCuboid(0.0f, 0.5f, yl, yh, 0.5f, 1.0f, texture, tintIndex, false, true, false, true, true, true));
                            quads.addAll(ModelHelper.createCuboid(0.5f, 1.0f, yl, yh, 0.5f, 1.0f, texture, tintIndex, false, true, true, false, true, true));
                            quads.addAll(ModelHelper.createCuboid(0.5f, 1.0f, yl, yh, 0.0f, 0.5f, texture, tintIndex, true, false, true, false, true, true));
                            quads.addAll(ModelHelper.createCuboid(0.0f, 0.5f, 1.0f - yh, 1.0f - yl, 0.0f, 0.5f, texture, tintIndex, true, true, true, true, !cullUpDown, cullUpDown));
                            break block0;
                        }
                        case EAST: {
                            quads.addAll(ModelHelper.createCuboid(0.0f, 0.5f, yl, yh, 0.0f, 0.5f, texture, tintIndex, true, false, false, true, true, true));
                            quads.addAll(ModelHelper.createCuboid(0.0f, 0.5f, yl, yh, 0.5f, 1.0f, texture, tintIndex, false, true, false, true, true, true));
                            quads.addAll(ModelHelper.createCuboid(0.5f, 1.0f, yl, yh, 0.5f, 1.0f, texture, tintIndex, false, true, true, false, cullUpDown, !cullUpDown));
                            quads.addAll(ModelHelper.createCuboid(0.5f, 1.0f, yl, yh, 0.0f, 0.5f, texture, tintIndex, true, false, true, false, true, true));
                            quads.addAll(ModelHelper.createCuboid(0.5f, 1.0f, 1.0f - yh, 1.0f - yl, 0.5f, 1.0f, texture, tintIndex, true, true, true, true, !cullUpDown, cullUpDown));
                            break block0;
                        }
                        case SOUTH: {
                            quads.addAll(ModelHelper.createCuboid(0.0f, 0.5f, yl, yh, 0.0f, 0.5f, texture, tintIndex, true, false, false, true, true, true));
                            quads.addAll(ModelHelper.createCuboid(0.0f, 0.5f, yl, yh, 0.5f, 1.0f, texture, tintIndex, false, true, false, true, cullUpDown, !cullUpDown));
                            quads.addAll(ModelHelper.createCuboid(0.5f, 1.0f, yl, yh, 0.5f, 1.0f, texture, tintIndex, false, true, true, false, true, true));
                            quads.addAll(ModelHelper.createCuboid(0.5f, 1.0f, yl, yh, 0.0f, 0.5f, texture, tintIndex, true, false, true, false, true, true));
                            quads.addAll(ModelHelper.createCuboid(0.0f, 0.5f, 1.0f - yh, 1.0f - yl, 0.5f, 1.0f, texture, tintIndex, true, true, true, true, !cullUpDown, cullUpDown));
                            break block0;
                        }
                        case NORTH: {
                            quads.addAll(ModelHelper.createCuboid(0.0f, 0.5f, yl, yh, 0.0f, 0.5f, texture, tintIndex, true, false, false, true, true, true));
                            quads.addAll(ModelHelper.createCuboid(0.0f, 0.5f, yl, yh, 0.5f, 1.0f, texture, tintIndex, false, true, false, true, true, true));
                            quads.addAll(ModelHelper.createCuboid(0.5f, 1.0f, yl, yh, 0.5f, 1.0f, texture, tintIndex, false, true, true, false, true, true));
                            quads.addAll(ModelHelper.createCuboid(0.5f, 1.0f, yl, yh, 0.0f, 0.5f, texture, tintIndex, true, false, true, false, cullUpDown, !cullUpDown));
                            quads.addAll(ModelHelper.createCuboid(0.5f, 1.0f, 1.0f - yh, 1.0f - yl, 0.0f, 0.5f, texture, tintIndex, true, true, true, true, !cullUpDown, cullUpDown));
                        }
                    }
                }
            }
            int overlayIndex = (Integer)extraData.getData(FrameBlockTile.OVERLAY);
            if (overlayIndex != 0) {
                block37 : switch ((StairsShape)state.m_61143_((Property)StairBlock.f_56843_)) {
                    case STRAIGHT: {
                        switch ((Direction)state.m_61143_((Property)StairBlock.f_56841_)) {
                            case NORTH: {
                                quads.addAll(ModelHelper.createOverlay(0.0f, 1.0f, yl, yh, 0.0f, 0.5f, overlayIndex, true, true, false, true, cullUpDown, !cullUpDown, false));
                                quads.addAll(ModelHelper.createOverlay(0.0f, 1.0f, yl, yh, 0.5f, 1.0f, overlayIndex, true, true, true, false, true, true, !cullUpDown));
                                quads.addAll(ModelHelper.createOverlay(0.0f, 1.0f, 1.0f - yh, 1.0f - yl, 0.0f, 0.5f, overlayIndex, true, true, true, true, !cullUpDown, cullUpDown, false));
                                break;
                            }
                            case SOUTH: {
                                quads.addAll(ModelHelper.createOverlay(0.0f, 1.0f, yl, yh, 0.0f, 0.5f, overlayIndex, true, true, false, true, true, true, !cullUpDown));
                                quads.addAll(ModelHelper.createOverlay(0.0f, 1.0f, yl, yh, 0.5f, 1.0f, overlayIndex, true, true, true, false, cullUpDown, !cullUpDown, false));
                                quads.addAll(ModelHelper.createOverlay(0.0f, 1.0f, 1.0f - yh, 1.0f - yl, 0.5f, 1.0f, overlayIndex, true, true, true, true, !cullUpDown, cullUpDown, false));
                                break;
                            }
                            case WEST: {
                                quads.addAll(ModelHelper.createOverlay(0.0f, 0.5f, yl, yh, 0.0f, 1.0f, overlayIndex, true, false, true, true, cullUpDown, !cullUpDown, false));
                                quads.addAll(ModelHelper.createOverlay(0.5f, 1.0f, yl, yh, 0.0f, 1.0f, overlayIndex, false, true, true, true, true, true, !cullUpDown));
                                quads.addAll(ModelHelper.createOverlay(0.0f, 0.5f, 1.0f - yh, 1.0f - yl, 0.0f, 1.0f, overlayIndex, true, true, true, true, !cullUpDown, cullUpDown, false));
                                break;
                            }
                            case EAST: {
                                quads.addAll(ModelHelper.createOverlay(0.0f, 0.5f, yl, yh, 0.0f, 1.0f, overlayIndex, true, false, true, true, true, true, !cullUpDown));
                                quads.addAll(ModelHelper.createOverlay(0.5f, 1.0f, yl, yh, 0.0f, 1.0f, overlayIndex, false, true, true, true, cullUpDown, !cullUpDown, false));
                                quads.addAll(ModelHelper.createOverlay(0.5f, 1.0f, 1.0f - yh, 1.0f - yl, 0.0f, 1.0f, overlayIndex, true, true, true, true, !cullUpDown, cullUpDown, false));
                            }
                        }
                        break;
                    }
                    case INNER_LEFT: {
                        switch ((Direction)state.m_61143_((Property)StairBlock.f_56841_)) {
                            case NORTH: {
                                quads.addAll(ModelHelper.createOverlay(0.0f, 0.5f, yl, yh, 0.0f, 0.5f, overlayIndex, true, false, false, true, cullUpDown, !cullUpDown, false));
                                quads.addAll(ModelHelper.createOverlay(0.0f, 0.5f, yl, yh, 0.5f, 1.0f, overlayIndex, true, false, true, false, cullUpDown, !cullUpDown, false));
                                quads.addAll(ModelHelper.createOverlay(0.5f, 1.0f, yl, yh, 0.5f, 1.0f, overlayIndex, false, true, true, false, true, true, !cullUpDown));
                                quads.addAll(ModelHelper.createOverlay(0.5f, 1.0f, yl, yh, 0.0f, 0.5f, overlayIndex, false, true, false, true, cullUpDown, !cullUpDown, false));
                                quads.addAll(ModelHelper.createOverlay(0.0f, 0.5f, 1.0f - yh, 1.0f - yl, 0.0f, 0.5f, overlayIndex, true, false, false, true, true, cullUpDown, false));
                                quads.addAll(ModelHelper.createOverlay(0.0f, 0.5f, 1.0f - yh, 1.0f - yl, 0.5f, 1.0f, overlayIndex, true, true, true, false, true, cullUpDown, false));
                                quads.addAll(ModelHelper.createOverlay(0.5f, 1.0f, 1.0f - yh, 1.0f - yl, 0.0f, 0.5f, overlayIndex, false, true, true, true, true, cullUpDown, false));
                                break;
                            }
                            case SOUTH: {
                                quads.addAll(ModelHelper.createOverlay(0.0f, 0.5f, yl, yh, 0.0f, 0.5f, overlayIndex, true, false, false, true, true, true, !cullUpDown));
                                quads.addAll(ModelHelper.createOverlay(0.0f, 0.5f, yl, yh, 0.5f, 1.0f, overlayIndex, true, false, true, false, cullUpDown, !cullUpDown, false));
                                quads.addAll(ModelHelper.createOverlay(0.5f, 1.0f, yl, yh, 0.5f, 1.0f, overlayIndex, false, true, true, false, cullUpDown, !cullUpDown, false));
                                quads.addAll(ModelHelper.createOverlay(0.5f, 1.0f, yl, yh, 0.0f, 0.5f, overlayIndex, false, true, false, true, cullUpDown, !cullUpDown, false));
                                quads.addAll(ModelHelper.createOverlay(0.0f, 0.5f, 1.0f - yh, 1.0f - yl, 0.5f, 1.0f, overlayIndex, true, false, true, true, true, cullUpDown, false));
                                quads.addAll(ModelHelper.createOverlay(0.5f, 1.0f, 1.0f - yh, 1.0f - yl, 0.5f, 1.0f, overlayIndex, false, true, true, false, true, cullUpDown, false));
                                quads.addAll(ModelHelper.createOverlay(0.5f, 1.0f, 1.0f - yh, 1.0f - yl, 0.0f, 0.5f, overlayIndex, true, true, false, true, true, cullUpDown, false));
                                break;
                            }
                            case WEST: {
                                quads.addAll(ModelHelper.createOverlay(0.0f, 0.5f, yl, yh, 0.0f, 0.5f, overlayIndex, true, false, false, true, cullUpDown, !cullUpDown, false));
                                quads.addAll(ModelHelper.createOverlay(0.0f, 0.5f, yl, yh, 0.5f, 1.0f, overlayIndex, true, false, true, false, cullUpDown, !cullUpDown, false));
                                quads.addAll(ModelHelper.createOverlay(0.5f, 1.0f, yl, yh, 0.5f, 1.0f, overlayIndex, false, true, true, false, cullUpDown, !cullUpDown, false));
                                quads.addAll(ModelHelper.createOverlay(0.5f, 1.0f, yl, yh, 0.0f, 0.5f, overlayIndex, false, true, false, true, true, true, !cullUpDown));
                                quads.addAll(ModelHelper.createOverlay(0.0f, 0.5f, 1.0f - yh, 1.0f - yl, 0.0f, 0.5f, overlayIndex, true, true, false, true, true, cullUpDown, false));
                                quads.addAll(ModelHelper.createOverlay(0.0f, 0.5f, 1.0f - yh, 1.0f - yl, 0.5f, 1.0f, overlayIndex, true, false, true, false, true, cullUpDown, false));
                                quads.addAll(ModelHelper.createOverlay(0.5f, 1.0f, 1.0f - yh, 1.0f - yl, 0.5f, 1.0f, overlayIndex, false, true, true, true, true, cullUpDown, false));
                                break;
                            }
                            case EAST: {
                                quads.addAll(ModelHelper.createOverlay(0.0f, 0.5f, yl, yh, 0.0f, 0.5f, overlayIndex, true, false, false, true, cullUpDown, !cullUpDown, false));
                                quads.addAll(ModelHelper.createOverlay(0.0f, 0.5f, yl, yh, 0.5f, 1.0f, overlayIndex, true, false, true, false, true, true, !cullUpDown));
                                quads.addAll(ModelHelper.createOverlay(0.5f, 1.0f, yl, yh, 0.5f, 1.0f, overlayIndex, false, true, true, false, cullUpDown, !cullUpDown, false));
                                quads.addAll(ModelHelper.createOverlay(0.5f, 1.0f, yl, yh, 0.0f, 0.5f, overlayIndex, false, true, false, true, cullUpDown, !cullUpDown, false));
                                quads.addAll(ModelHelper.createOverlay(0.0f, 0.5f, 1.0f - yh, 1.0f - yl, 0.0f, 0.5f, overlayIndex, true, false, true, true, true, cullUpDown, false));
                                quads.addAll(ModelHelper.createOverlay(0.5f, 1.0f, 1.0f - yh, 1.0f - yl, 0.5f, 1.0f, overlayIndex, true, true, true, false, true, cullUpDown, false));
                                quads.addAll(ModelHelper.createOverlay(0.5f, 1.0f, 1.0f - yh, 1.0f - yl, 0.0f, 0.5f, overlayIndex, false, true, false, true, true, cullUpDown, false));
                            }
                        }
                        break;
                    }
                    case INNER_RIGHT: {
                        switch ((Direction)state.m_61143_((Property)StairBlock.f_56841_)) {
                            case WEST: {
                                quads.addAll(ModelHelper.createOverlay(0.0f, 0.5f, yl, yh, 0.0f, 0.5f, overlayIndex, true, false, false, true, cullUpDown, !cullUpDown, false));
                                quads.addAll(ModelHelper.createOverlay(0.0f, 0.5f, yl, yh, 0.5f, 1.0f, overlayIndex, true, false, true, false, cullUpDown, !cullUpDown, false));
                                quads.addAll(ModelHelper.createOverlay(0.5f, 1.0f, yl, yh, 0.5f, 1.0f, overlayIndex, false, true, true, false, true, true, !cullUpDown));
                                quads.addAll(ModelHelper.createOverlay(0.5f, 1.0f, yl, yh, 0.0f, 0.5f, overlayIndex, false, true, false, true, cullUpDown, !cullUpDown, false));
                                quads.addAll(ModelHelper.createOverlay(0.0f, 0.5f, 1.0f - yh, 1.0f - yl, 0.0f, 0.5f, overlayIndex, true, false, false, true, true, cullUpDown, false));
                                quads.addAll(ModelHelper.createOverlay(0.0f, 0.5f, 1.0f - yh, 1.0f - yl, 0.5f, 1.0f, overlayIndex, true, true, true, false, true, cullUpDown, false));
                                quads.addAll(ModelHelper.createOverlay(0.5f, 1.0f, 1.0f - yh, 1.0f - yl, 0.0f, 0.5f, overlayIndex, false, true, true, true, true, cullUpDown, false));
                                break;
                            }
                            case EAST: {
                                quads.addAll(ModelHelper.createOverlay(0.0f, 0.5f, yl, yh, 0.0f, 0.5f, overlayIndex, true, false, false, true, true, true, !cullUpDown));
                                quads.addAll(ModelHelper.createOverlay(0.0f, 0.5f, yl, yh, 0.5f, 1.0f, overlayIndex, true, false, true, false, cullUpDown, !cullUpDown, false));
                                quads.addAll(ModelHelper.createOverlay(0.5f, 1.0f, yl, yh, 0.5f, 1.0f, overlayIndex, false, true, true, false, cullUpDown, !cullUpDown, false));
                                quads.addAll(ModelHelper.createOverlay(0.5f, 1.0f, yl, yh, 0.0f, 0.5f, overlayIndex, false, true, false, true, cullUpDown, !cullUpDown, false));
                                quads.addAll(ModelHelper.createOverlay(0.0f, 0.5f, 1.0f - yh, 1.0f - yl, 0.5f, 1.0f, overlayIndex, true, false, true, true, true, cullUpDown, false));
                                quads.addAll(ModelHelper.createOverlay(0.5f, 1.0f, 1.0f - yh, 1.0f - yl, 0.5f, 1.0f, overlayIndex, false, true, true, false, true, cullUpDown, false));
                                quads.addAll(ModelHelper.createOverlay(0.5f, 1.0f, 1.0f - yh, 1.0f - yl, 0.0f, 0.5f, overlayIndex, true, true, false, true, true, cullUpDown, false));
                                break;
                            }
                            case SOUTH: {
                                quads.addAll(ModelHelper.createOverlay(0.0f, 0.5f, yl, yh, 0.0f, 0.5f, overlayIndex, true, false, false, true, cullUpDown, !cullUpDown, false));
                                quads.addAll(ModelHelper.createOverlay(0.0f, 0.5f, yl, yh, 0.5f, 1.0f, overlayIndex, true, false, true, false, cullUpDown, !cullUpDown, false));
                                quads.addAll(ModelHelper.createOverlay(0.5f, 1.0f, yl, yh, 0.5f, 1.0f, overlayIndex, false, true, true, false, cullUpDown, !cullUpDown, false));
                                quads.addAll(ModelHelper.createOverlay(0.5f, 1.0f, yl, yh, 0.0f, 0.5f, overlayIndex, false, true, false, true, true, true, !cullUpDown));
                                quads.addAll(ModelHelper.createOverlay(0.0f, 0.5f, 1.0f - yh, 1.0f - yl, 0.0f, 0.5f, overlayIndex, true, true, false, true, true, cullUpDown, false));
                                quads.addAll(ModelHelper.createOverlay(0.0f, 0.5f, 1.0f - yh, 1.0f - yl, 0.5f, 1.0f, overlayIndex, true, false, true, false, true, cullUpDown, false));
                                quads.addAll(ModelHelper.createOverlay(0.5f, 1.0f, 1.0f - yh, 1.0f - yl, 0.5f, 1.0f, overlayIndex, false, true, true, true, true, cullUpDown, false));
                                break;
                            }
                            case NORTH: {
                                quads.addAll(ModelHelper.createOverlay(0.0f, 0.5f, yl, yh, 0.0f, 0.5f, overlayIndex, true, false, false, true, cullUpDown, !cullUpDown, false));
                                quads.addAll(ModelHelper.createOverlay(0.0f, 0.5f, yl, yh, 0.5f, 1.0f, overlayIndex, true, false, true, false, true, true, !cullUpDown));
                                quads.addAll(ModelHelper.createOverlay(0.5f, 1.0f, yl, yh, 0.5f, 1.0f, overlayIndex, false, true, true, false, cullUpDown, !cullUpDown, false));
                                quads.addAll(ModelHelper.createOverlay(0.5f, 1.0f, yl, yh, 0.0f, 0.5f, overlayIndex, false, true, false, true, cullUpDown, !cullUpDown, false));
                                quads.addAll(ModelHelper.createOverlay(0.0f, 0.5f, 1.0f - yh, 1.0f - yl, 0.0f, 0.5f, overlayIndex, true, false, true, true, true, cullUpDown, false));
                                quads.addAll(ModelHelper.createOverlay(0.5f, 1.0f, 1.0f - yh, 1.0f - yl, 0.5f, 1.0f, overlayIndex, true, true, true, false, true, cullUpDown, false));
                                quads.addAll(ModelHelper.createOverlay(0.5f, 1.0f, 1.0f - yh, 1.0f - yl, 0.0f, 0.5f, overlayIndex, false, true, false, true, true, cullUpDown, false));
                            }
                        }
                        break;
                    }
                    case OUTER_LEFT: {
                        switch ((Direction)state.m_61143_((Property)StairBlock.f_56841_)) {
                            case NORTH: {
                                quads.addAll(ModelHelper.createOverlay(0.0f, 0.5f, yl, yh, 0.0f, 0.5f, overlayIndex, true, false, false, true, cullUpDown, !cullUpDown, false));
                                quads.addAll(ModelHelper.createOverlay(0.0f, 0.5f, yl, yh, 0.5f, 1.0f, overlayIndex, true, false, true, false, true, true, !cullUpDown));
                                quads.addAll(ModelHelper.createOverlay(0.5f, 1.0f, yl, yh, 0.5f, 1.0f, overlayIndex, false, true, true, false, true, true, !cullUpDown));
                                quads.addAll(ModelHelper.createOverlay(0.5f, 1.0f, yl, yh, 0.0f, 0.5f, overlayIndex, false, true, false, true, true, true, !cullUpDown));
                                quads.addAll(ModelHelper.createOverlay(0.0f, 0.5f, 1.0f - yh, 1.0f - yl, 0.0f, 0.5f, overlayIndex, true, true, true, true, !cullUpDown, cullUpDown, false));
                                break;
                            }
                            case SOUTH: {
                                quads.addAll(ModelHelper.createOverlay(0.0f, 0.5f, yl, yh, 0.0f, 0.5f, overlayIndex, true, false, false, true, true, true, !cullUpDown));
                                quads.addAll(ModelHelper.createOverlay(0.0f, 0.5f, yl, yh, 0.5f, 1.0f, overlayIndex, true, false, true, false, true, true, !cullUpDown));
                                quads.addAll(ModelHelper.createOverlay(0.5f, 1.0f, yl, yh, 0.5f, 1.0f, overlayIndex, false, true, true, false, cullUpDown, !cullUpDown, false));
                                quads.addAll(ModelHelper.createOverlay(0.5f, 1.0f, yl, yh, 0.0f, 0.5f, overlayIndex, false, true, false, true, true, true, !cullUpDown));
                                quads.addAll(ModelHelper.createOverlay(0.5f, 1.0f, 1.0f - yh, 1.0f - yl, 0.5f, 1.0f, overlayIndex, true, true, true, true, !cullUpDown, cullUpDown, false));
                                break;
                            }
                            case WEST: {
                                quads.addAll(ModelHelper.createOverlay(0.0f, 0.5f, yl, yh, 0.0f, 0.5f, overlayIndex, true, false, false, true, true, true, !cullUpDown));
                                quads.addAll(ModelHelper.createOverlay(0.0f, 0.5f, yl, yh, 0.5f, 1.0f, overlayIndex, true, false, true, false, cullUpDown, !cullUpDown, false));
                                quads.addAll(ModelHelper.createOverlay(0.5f, 1.0f, yl, yh, 0.5f, 1.0f, overlayIndex, false, true, true, false, true, true, !cullUpDown));
                                quads.addAll(ModelHelper.createOverlay(0.5f, 1.0f, yl, yh, 0.0f, 0.5f, overlayIndex, false, true, false, true, true, true, !cullUpDown));
                                quads.addAll(ModelHelper.createOverlay(0.0f, 0.5f, 1.0f - yh, 1.0f - yl, 0.5f, 1.0f, overlayIndex, true, true, true, true, !cullUpDown, cullUpDown, false));
                                break;
                            }
                            case EAST: {
                                quads.addAll(ModelHelper.createOverlay(0.0f, 0.5f, yl, yh, 0.0f, 0.5f, overlayIndex, true, false, false, true, true, true, !cullUpDown));
                                quads.addAll(ModelHelper.createOverlay(0.0f, 0.5f, yl, yh, 0.5f, 1.0f, overlayIndex, true, false, true, false, true, true, !cullUpDown));
                                quads.addAll(ModelHelper.createOverlay(0.5f, 1.0f, yl, yh, 0.5f, 1.0f, overlayIndex, false, true, true, false, true, true, !cullUpDown));
                                quads.addAll(ModelHelper.createOverlay(0.5f, 1.0f, yl, yh, 0.0f, 0.5f, overlayIndex, false, true, false, true, cullUpDown, !cullUpDown, false));
                                quads.addAll(ModelHelper.createOverlay(0.5f, 1.0f, 1.0f - yh, 1.0f - yl, 0.0f, 0.5f, overlayIndex, true, true, true, true, !cullUpDown, cullUpDown, false));
                            }
                        }
                        break;
                    }
                    case OUTER_RIGHT: {
                        switch ((Direction)state.m_61143_((Property)StairBlock.f_56841_)) {
                            case WEST: {
                                quads.addAll(ModelHelper.createOverlay(0.0f, 0.5f, yl, yh, 0.0f, 0.5f, overlayIndex, true, false, false, true, cullUpDown, !cullUpDown, false));
                                quads.addAll(ModelHelper.createOverlay(0.0f, 0.5f, yl, yh, 0.5f, 1.0f, overlayIndex, true, false, true, false, true, true, !cullUpDown));
                                quads.addAll(ModelHelper.createOverlay(0.5f, 1.0f, yl, yh, 0.5f, 1.0f, overlayIndex, false, true, true, false, true, true, !cullUpDown));
                                quads.addAll(ModelHelper.createOverlay(0.5f, 1.0f, yl, yh, 0.0f, 0.5f, overlayIndex, false, true, false, true, true, true, !cullUpDown));
                                quads.addAll(ModelHelper.createOverlay(0.0f, 0.5f, 1.0f - yh, 1.0f - yl, 0.0f, 0.5f, overlayIndex, true, true, true, true, !cullUpDown, cullUpDown, false));
                                break block37;
                            }
                            case EAST: {
                                quads.addAll(ModelHelper.createOverlay(0.0f, 0.5f, yl, yh, 0.0f, 0.5f, overlayIndex, true, false, false, true, true, true, !cullUpDown));
                                quads.addAll(ModelHelper.createOverlay(0.0f, 0.5f, yl, yh, 0.5f, 1.0f, overlayIndex, true, false, true, false, true, true, !cullUpDown));
                                quads.addAll(ModelHelper.createOverlay(0.5f, 1.0f, yl, yh, 0.5f, 1.0f, overlayIndex, false, true, true, false, cullUpDown, !cullUpDown, false));
                                quads.addAll(ModelHelper.createOverlay(0.5f, 1.0f, yl, yh, 0.0f, 0.5f, overlayIndex, false, true, false, true, true, true, !cullUpDown));
                                quads.addAll(ModelHelper.createOverlay(0.5f, 1.0f, 1.0f - yh, 1.0f - yl, 0.5f, 1.0f, overlayIndex, true, true, true, true, !cullUpDown, cullUpDown, false));
                                break block37;
                            }
                            case SOUTH: {
                                quads.addAll(ModelHelper.createOverlay(0.0f, 0.5f, yl, yh, 0.0f, 0.5f, overlayIndex, true, false, false, true, true, true, !cullUpDown));
                                quads.addAll(ModelHelper.createOverlay(0.0f, 0.5f, yl, yh, 0.5f, 1.0f, overlayIndex, true, false, true, false, cullUpDown, !cullUpDown, false));
                                quads.addAll(ModelHelper.createOverlay(0.5f, 1.0f, yl, yh, 0.5f, 1.0f, overlayIndex, false, true, true, false, true, true, !cullUpDown));
                                quads.addAll(ModelHelper.createOverlay(0.5f, 1.0f, yl, yh, 0.0f, 0.5f, overlayIndex, false, true, false, true, true, true, !cullUpDown));
                                quads.addAll(ModelHelper.createOverlay(0.0f, 0.5f, 1.0f - yh, 1.0f - yl, 0.5f, 1.0f, overlayIndex, true, true, true, true, !cullUpDown, cullUpDown, false));
                                break block37;
                            }
                            case NORTH: {
                                quads.addAll(ModelHelper.createOverlay(0.0f, 0.5f, yl, yh, 0.0f, 0.5f, overlayIndex, true, false, false, true, true, true, !cullUpDown));
                                quads.addAll(ModelHelper.createOverlay(0.0f, 0.5f, yl, yh, 0.5f, 1.0f, overlayIndex, true, false, true, false, true, true, !cullUpDown));
                                quads.addAll(ModelHelper.createOverlay(0.5f, 1.0f, yl, yh, 0.5f, 1.0f, overlayIndex, false, true, true, false, true, true, !cullUpDown));
                                quads.addAll(ModelHelper.createOverlay(0.5f, 1.0f, yl, yh, 0.0f, 0.5f, overlayIndex, false, true, false, true, cullUpDown, !cullUpDown, false));
                                quads.addAll(ModelHelper.createOverlay(0.5f, 1.0f, 1.0f - yh, 1.0f - yl, 0.0f, 0.5f, overlayIndex, true, true, true, true, !cullUpDown, cullUpDown, false));
                            }
                        }
                    }
                }
            }
            return quads;
        }
        return Collections.emptyList();
    }

    public boolean m_7541_() {
        return true;
    }

    public boolean m_7539_() {
        return false;
    }

    public boolean m_7547_() {
        return false;
    }

    public boolean m_7521_() {
        return false;
    }

    @Nonnull
    public TextureAtlasSprite m_6160_() {
        return this.getTexture();
    }

    @Nonnull
    public ItemOverrides m_7343_() {
        return ItemOverrides.f_111734_;
    }
}

