/*
 * Decompiled with CFR 0.152.
 */
package mod.pianomanu.blockcarpentry.bakedmodels;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mod.pianomanu.blockcarpentry.block.LayeredBlock;
import mod.pianomanu.blockcarpentry.block.SixWaySlabFrameBlock;
import mod.pianomanu.blockcarpentry.tileentity.FrameBlockTile;
import mod.pianomanu.blockcarpentry.util.ModelHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.model.data.IDynamicBakedModel;
import net.minecraftforge.client.model.data.IModelData;

public class LayeredBlockEmptyBakedModel
implements IDynamicBakedModel {
    public static final ResourceLocation TEXTURE = new ResourceLocation("minecraft", "block/oak_planks");

    private TextureAtlasSprite getTexture() {
        return (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(TEXTURE);
    }

    @Nonnull
    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, @Nonnull Random rand, @Nonnull IModelData extraData) {
        BlockState mimic = (BlockState)extraData.getData(FrameBlockTile.MIMIC);
        if (mimic == null) {
            return this.getMimicQuads(state, side, extraData);
        }
        return Collections.emptyList();
    }

    public List<BakedQuad> getMimicQuads(@Nullable BlockState state, @Nullable Direction side, @Nonnull IModelData extraData) {
        if (side == null) {
            return Collections.emptyList();
        }
        if (state != null) {
            int layers = (Integer)state.m_61143_((Property)LayeredBlock.LAYERS);
            boolean renderNorth = side == Direction.NORTH && (Boolean)extraData.getData(FrameBlockTile.NORTH_VISIBLE) != false;
            boolean renderEast = side == Direction.EAST && (Boolean)extraData.getData(FrameBlockTile.EAST_VISIBLE) != false;
            boolean renderSouth = side == Direction.SOUTH && (Boolean)extraData.getData(FrameBlockTile.SOUTH_VISIBLE) != false;
            boolean renderWest = side == Direction.WEST && (Boolean)extraData.getData(FrameBlockTile.WEST_VISIBLE) != false;
            boolean renderUp = side == Direction.UP && (Boolean)extraData.getData(FrameBlockTile.UP_VISIBLE) != false;
            boolean renderDown = side == Direction.DOWN && (Boolean)extraData.getData(FrameBlockTile.DOWN_VISIBLE) != false;
            TextureAtlasSprite textureUp = (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(new ResourceLocation("minecraft", "block/oak_planks"));
            TextureAtlasSprite textureDown = (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(new ResourceLocation("minecraft", "block/oak_planks"));
            TextureAtlasSprite textureNorth = (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(new ResourceLocation("minecraft", "block/spruce_trapdoor"));
            TextureAtlasSprite textureSouth = (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(new ResourceLocation("minecraft", "block/spruce_trapdoor"));
            TextureAtlasSprite textureEast = (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(new ResourceLocation("minecraft", "block/spruce_trapdoor"));
            TextureAtlasSprite textureWest = (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(new ResourceLocation("minecraft", "block/spruce_trapdoor"));
            ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
            switch ((Direction)state.m_61143_((Property)SixWaySlabFrameBlock.FACING)) {
                case UP: {
                    int i;
                    for (i = 0; i < layers; ++i) {
                        quads.addAll(ModelHelper.createSixFaceCuboid(0.0f, 1.0f, 1.0f - (float)(i + 1) / 8.0f, 1.0f - ((float)i + 0.5f) / 8.0f, 0.0f, 1.0f, -1, textureNorth, textureSouth, textureEast, textureWest, textureUp, textureDown, 0));
                        quads.addAll(ModelHelper.createSixFaceCuboid(0.0625f, 0.9375f, 1.0f - ((float)i + 0.5f) / 8.0f, 1.0f - (float)i / 8.0f, 0.0625f, 0.9375f, -1, textureNorth, textureSouth, textureEast, textureWest, textureUp, textureDown, 0));
                    }
                    break;
                }
                case DOWN: {
                    int i;
                    for (i = 0; i < layers; ++i) {
                        quads.addAll(ModelHelper.createSixFaceCuboid(0.0f, 1.0f, ((float)i + 0.5f) / 8.0f, (float)(i + 1) / 8.0f, 0.0f, 1.0f, -1, textureNorth, textureSouth, textureEast, textureWest, textureUp, textureDown, 0));
                        quads.addAll(ModelHelper.createSixFaceCuboid(0.06666667f, 0.9375f, (float)i / 8.0f, ((float)i + 0.5f) / 8.0f, 0.0625f, 0.9375f, -1, textureNorth, textureSouth, textureEast, textureWest, textureUp, textureDown, 0));
                    }
                    break;
                }
                case WEST: {
                    int i;
                    for (i = 0; i < layers; ++i) {
                        quads.addAll(ModelHelper.createSixFaceCuboid(((float)i + 0.5f) / 8.0f, (float)(i + 1) / 8.0f, 0.0f, 1.0f, 0.0f, 1.0f, -1, textureUp, textureDown, textureEast, textureWest, textureNorth, textureSouth, 0));
                        quads.addAll(ModelHelper.createSixFaceCuboid((float)i / 8.0f, ((float)i + 0.5f) / 8.0f, 0.06666667f, 0.9375f, 0.06666667f, 0.9375f, -1, textureUp, textureDown, textureEast, textureWest, textureNorth, textureSouth, 0));
                    }
                    break;
                }
                case SOUTH: {
                    int i;
                    for (i = 0; i < layers; ++i) {
                        quads.addAll(ModelHelper.createSixFaceCuboid(0.0f, 1.0f, 0.0f, 1.0f, 1.0f - (float)(i + 1) / 8.0f, 1.0f - ((float)i + 0.5f) / 8.0f, -1, textureNorth, textureSouth, textureUp, textureDown, textureEast, textureWest, 0));
                        quads.addAll(ModelHelper.createSixFaceCuboid(0.06666667f, 0.9375f, 0.06666667f, 0.9375f, 1.0f - ((float)i + 0.5f) / 8.0f, 1.0f - (float)i / 8.0f, -1, textureNorth, textureSouth, textureUp, textureDown, textureEast, textureWest, 0));
                    }
                    break;
                }
                case NORTH: {
                    int i;
                    for (i = 0; i < layers; ++i) {
                        quads.addAll(ModelHelper.createSixFaceCuboid(0.0f, 1.0f, 0.0f, 1.0f, ((float)i + 0.5f) / 8.0f, (float)(i + 1) / 8.0f, -1, textureNorth, textureSouth, textureUp, textureDown, textureEast, textureWest, 0));
                        quads.addAll(ModelHelper.createSixFaceCuboid(0.06666667f, 0.9375f, 0.06666667f, 0.9375f, (float)i / 8.0f, ((float)i + 0.5f) / 8.0f, -1, textureNorth, textureSouth, textureUp, textureDown, textureEast, textureWest, 0));
                    }
                    break;
                }
                case EAST: {
                    int i;
                    for (i = 0; i < layers; ++i) {
                        quads.addAll(ModelHelper.createSixFaceCuboid(1.0f - (float)(i + 1) / 8.0f, 1.0f - ((float)i + 0.5f) / 8.0f, 0.0f, 1.0f, 0.0f, 1.0f, -1, textureUp, textureDown, textureEast, textureWest, textureNorth, textureSouth, 0));
                        quads.addAll(ModelHelper.createSixFaceCuboid(1.0f - ((float)i + 0.5f) / 8.0f, 1.0f - (float)i / 8.0f, 0.06666667f, 0.9375f, 0.06666667f, 0.9375f, -1, textureUp, textureDown, textureEast, textureWest, textureNorth, textureSouth, 0));
                    }
                    break;
                }
            }
            int overlayIndex_1 = (Integer)extraData.getData(FrameBlockTile.OVERLAY);
            if ((Integer)extraData.getData(FrameBlockTile.OVERLAY) != 0) {
                switch ((Direction)state.m_61143_((Property)SixWaySlabFrameBlock.FACING)) {
                    case UP: {
                        quads.addAll(ModelHelper.createOverlay(0.0f, 1.0f, 0.0f, 0.5f, 0.0f, 1.0f, overlayIndex_1, renderWest, renderEast, renderSouth, renderNorth, renderUp, renderDown, true));
                        break;
                    }
                    case DOWN: {
                        quads.addAll(ModelHelper.createOverlay(0.0f, 1.0f, 0.5f, 1.0f, 0.0f, 1.0f, overlayIndex_1, renderWest, renderEast, renderSouth, renderNorth, renderUp, renderDown, true));
                        break;
                    }
                    case WEST: {
                        quads.addAll(ModelHelper.createOverlay(0.5f, 1.0f, 0.0f, 1.0f, 0.0f, 1.0f, overlayIndex_1, renderWest, renderEast, renderSouth, renderNorth, renderUp, renderDown, true));
                        break;
                    }
                    case SOUTH: {
                        quads.addAll(ModelHelper.createOverlay(0.0f, 1.0f, 0.0f, 1.0f, 0.0f, 0.5f, overlayIndex_1, renderWest, renderEast, renderSouth, renderNorth, renderUp, renderDown, true));
                        break;
                    }
                    case NORTH: {
                        quads.addAll(ModelHelper.createOverlay(0.0f, 1.0f, 0.0f, 1.0f, 0.5f, 1.0f, overlayIndex_1, renderWest, renderEast, renderSouth, renderNorth, renderUp, renderDown, true));
                        break;
                    }
                    case EAST: {
                        quads.addAll(ModelHelper.createOverlay(0.0f, 0.5f, 0.0f, 1.0f, 0.0f, 1.0f, overlayIndex_1, renderWest, renderEast, renderSouth, renderNorth, renderUp, renderDown, true));
                    }
                }
            }
            return quads;
        }
        return Collections.emptyList();
    }

    public boolean m_7541_() {
        return true;
    }

    public boolean m_7539_() {
        return false;
    }

    public boolean m_7547_() {
        return false;
    }

    public boolean m_7521_() {
        return false;
    }

    @Nonnull
    public TextureAtlasSprite m_6160_() {
        return this.getTexture();
    }

    @Nonnull
    public ItemOverrides m_7343_() {
        return ItemOverrides.f_111734_;
    }
}

