/*
 * Decompiled with CFR 0.152.
 */
package its_meow.betteranimalsplus.util;

import java.util.HashSet;
import java.util.function.Supplier;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;

public class EntityContainer {
    public Class<? extends EntityLiving> entityClazz;
    public String entityName;
    public EnumCreatureType type;
    public int eggColorSolid;
    public int eggColorSpot;
    public int weight;
    public int minGroup;
    public int maxGroup;
    public Biome[] spawnBiomes = new Biome[0];
    public boolean doSpawning = true;
    public BiomeDictionary.Type[] types = new BiomeDictionary.Type[0];
    public String[] tameItems;
    public boolean despawn;
    public Supplier<Biome[]> biomeSupplier;

    @SafeVarargs
    public EntityContainer(Class<? extends EntityLiving> EntityClass, String entityNameIn, EnumCreatureType type, int solidColorIn, int spotColorIn, int prob, int min, int max, boolean despawn, String[] tameItems, BiomeDictionary.Type ... types) {
        this.entityClazz = EntityClass;
        this.entityName = entityNameIn;
        this.eggColorSolid = solidColorIn;
        this.eggColorSpot = spotColorIn;
        this.weight = prob;
        this.minGroup = min;
        this.maxGroup = max;
        this.type = type;
        this.tameItems = tameItems == null ? new String[0] : tameItems;
        this.types = types;
        this.despawn = despawn;
    }

    public EntityContainer(Class<? extends EntityLiving> EntityClass, String entityNameIn, EnumCreatureType type, int solidColorIn, int spotColorIn, int prob, int min, int max, boolean despawn, String[] tameItems, Supplier<Biome[]> getBiomes) {
        this.entityClazz = EntityClass;
        this.entityName = entityNameIn;
        this.eggColorSolid = solidColorIn;
        this.eggColorSpot = spotColorIn;
        this.weight = prob;
        this.minGroup = min;
        this.maxGroup = max;
        this.type = type;
        this.tameItems = tameItems == null ? new String[0] : tameItems;
        this.types = null;
        this.biomeSupplier = getBiomes;
        this.despawn = despawn;
    }

    public void populateBiomes() {
        if (this.types != null) {
            HashSet biomesetAdd = new HashSet();
            for (BiomeDictionary.Type type : this.types) {
                biomesetAdd.addAll(BiomeDictionary.getBiomes((BiomeDictionary.Type)type));
            }
            try {
                this.spawnBiomes = biomesetAdd.toArray(this.spawnBiomes);
            }
            catch (NullPointerException e) {
                this.spawnBiomes = new Biome[0];
            }
        } else {
            this.spawnBiomes = this.biomeSupplier != null ? this.biomeSupplier.get() : new Biome[0];
        }
    }
}

