/*
 * Decompiled with CFR 0.152.
 */
package its_meow.betteranimalsplus.fixers;

import its_meow.betteranimalsplus.BetterAnimalsPlusMod;
import its_meow.betteranimalsplus.common.block.BlockAnimalSkull;
import its_meow.betteranimalsplus.common.block.BlockGenericSkull;
import its_meow.betteranimalsplus.util.HeadTypes;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ObjectIntIdentityMap;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.datafix.IFixableData;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.chunk.NibbleArray;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.registries.ForgeRegistry;
import net.minecraftforge.registries.GameData;
import org.apache.commons.lang3.tuple.Pair;

public class HeadBlockDataFixer
implements IFixableData {
    private static Map<String, HeadTypes> headIDs = new HashMap<String, HeadTypes>();
    private final List<FlatteningDefinition> flatteningDefinitions = new ArrayList<FlatteningDefinition>();

    public int func_188216_a() {
        return 1;
    }

    public HeadBlockDataFixer() {
        for (String id : headIDs.keySet()) {
            for (int i = 0; i < EnumFacing.values().length; ++i) {
                this.flatteningDefinitions.add(new FlatteningDefinition(id, i, (oldID, meta, tag) -> {
                    BlockGenericSkull newBlock = headIDs.get(oldID).getBlock(tag.func_74762_e("TYPENUM"));
                    return newBlock.func_176223_P().func_177226_a((IProperty)BlockAnimalSkull.FACING, (Comparable)EnumFacing.values()[meta]);
                }));
            }
        }
    }

    public NBTTagCompound func_188217_a(NBTTagCompound compound) {
        ForgeRegistry blockRegistry = (ForgeRegistry)ForgeRegistries.BLOCKS;
        HashMap flattingDefinitionsPerBlockID = new HashMap();
        this.flatteningDefinitions.stream().map(flatteningDefinition -> {
            int oldID = blockRegistry.getID(flatteningDefinition.oldName);
            return Optional.ofNullable(oldID > 0 ? Pair.of((Object)oldID, (Object)flatteningDefinition) : null);
        }).forEach(optionalPair -> optionalPair.ifPresent(pair -> {
            Integer blockID = (Integer)pair.getKey();
            FlatteningDefinition flatteningDefinition = (FlatteningDefinition)pair.getValue();
            FlatteningDefinition[] flatteningDefinitions = flattingDefinitionsPerBlockID.computeIfAbsent(blockID, id -> new FlatteningDefinition[16]);
            flatteningDefinitions[flatteningDefinition.oldMetadata] = flatteningDefinition;
        }));
        if (flattingDefinitionsPerBlockID.isEmpty()) {
            return compound;
        }
        ObjectIntIdentityMap blockStateIDMap = GameData.getBlockStateIDMap();
        try {
            NBTTagCompound level = compound.func_74775_l("Level");
            int chunkX = level.func_74762_e("xPos");
            int chunkZ = level.func_74762_e("zPos");
            NBTTagList tileEntities = level.func_150295_c("TileEntities", 10);
            NBTTagList sections = level.func_150295_c("Sections", 10);
            ChunkPos chunkPos = new ChunkPos(chunkX, chunkZ);
            HashMap<BlockPos, Pair> tileEntityMap = new HashMap<BlockPos, Pair>();
            for (int tileEntityIndex = 0; tileEntityIndex < tileEntities.func_74745_c(); ++tileEntityIndex) {
                NBTTagCompound tileEntityNBT = tileEntities.func_150305_b(tileEntityIndex);
                if (tileEntityNBT.func_82582_d()) continue;
                BlockPos pos = new BlockPos(tileEntityNBT.func_74762_e("x"), tileEntityNBT.func_74762_e("y"), tileEntityNBT.func_74762_e("z"));
                tileEntityMap.put(pos, Pair.of((Object)tileEntityIndex, (Object)tileEntityNBT));
            }
            for (int sectionIndex = 0; sectionIndex < sections.func_74745_c(); ++sectionIndex) {
                NBTTagCompound section = sections.func_150305_b(sectionIndex);
                byte sectionY = section.func_74771_c("Y");
                byte[] blockIDs = section.func_74770_j("Blocks");
                NibbleArray metadataArray = new NibbleArray(section.func_74770_j("Data"));
                NibbleArray blockIDsExtension = section.func_150297_b("Add", 7) ? new NibbleArray(section.func_74770_j("Add")) : new NibbleArray();
                boolean hasExtendedBlockIDs = section.func_150297_b("Add", 7);
                for (int blockIndex = 0; blockIndex < blockIDs.length; ++blockIndex) {
                    FlatteningDefinition flatteningDefinition2;
                    int x = blockIndex & 0xF;
                    int y = blockIndex >> 8 & 0xF;
                    int z = blockIndex >> 4 & 0xF;
                    int blockIDExtension = blockIDsExtension.func_76582_a(x, y, z);
                    int blockID = blockIDExtension << 8 | blockIDs[blockIndex] & 0xFF;
                    int metadata = metadataArray.func_76582_a(x, y, z);
                    FlatteningDefinition[] flatteningDefinitions = (FlatteningDefinition[])flattingDefinitionsPerBlockID.get(blockID);
                    if (flatteningDefinitions == null || (flatteningDefinition2 = flatteningDefinitions[metadata]) == null) continue;
                    BlockPos blockPos = chunkPos.func_180331_a(x, sectionY << 4 | y, z);
                    Pair tileEntityPair = (Pair)tileEntityMap.get(blockPos);
                    NBTTagCompound tileEntityNBT = tileEntityPair != null ? (NBTTagCompound)tileEntityPair.getValue() : null;
                    IBlockState newBlockState = flatteningDefinition2.blockStateGetter.getBlockState(flatteningDefinition2.oldName.func_110623_a().toString(), flatteningDefinition2.oldMetadata, tileEntityNBT);
                    int blockStateID = blockStateIDMap.func_148747_b((Object)newBlockState);
                    byte newBlockID = (byte)(blockStateID >> 4 & 0xFF);
                    byte newBlockIDExtension = (byte)(blockStateID >> 12 & 0xF);
                    byte newMetadata = (byte)(blockStateID & 0xF);
                    blockIDs[blockIndex] = newBlockID;
                    metadataArray.func_76581_a(x, y, z, (int)newMetadata);
                    if (newBlockIDExtension == 0) continue;
                    hasExtendedBlockIDs = true;
                    blockIDsExtension.func_76581_a(x, y, z, (int)newBlockIDExtension);
                }
                section.func_74773_a("Blocks", blockIDs);
                section.func_74773_a("Data", metadataArray.func_177481_a());
                if (!hasExtendedBlockIDs) continue;
                section.func_74773_a("Add", blockIDsExtension.func_177481_a());
            }
        }
        catch (Exception e) {
            BetterAnimalsPlusMod.logger.error("Unable to flatten blocks, level format may be missing tags.");
            e.printStackTrace();
        }
        return compound;
    }

    static {
        headIDs.put("foxhead", HeadTypes.FOXHEAD);
        headIDs.put("boarhead", HeadTypes.BOARHEAD);
        headIDs.put("deerhead", HeadTypes.DEERHEAD);
        headIDs.put("hirschgeistskull", HeadTypes.HIRSCHGEIST);
        headIDs.put("wolfhead", HeadTypes.WOLFHEAD);
        headIDs.put("reindeerhead", HeadTypes.REINDEERHEAD);
    }

    @FunctionalInterface
    public static interface BlockStateGetter {
        public IBlockState getBlockState(String var1, int var2, @Nullable NBTTagCompound var3);
    }

    static class FlatteningDefinition {
        final ResourceLocation oldName;
        final int oldMetadata;
        final BlockStateGetter blockStateGetter;

        FlatteningDefinition(ResourceLocation oldName, int oldMetadata, BlockStateGetter blockStateGetter) {
            this.oldName = oldName;
            this.oldMetadata = oldMetadata;
            this.blockStateGetter = blockStateGetter;
        }

        FlatteningDefinition(String oldName, int oldMetadata, BlockStateGetter blockStateGetter) {
            this(new ResourceLocation("betteranimalsplus", oldName), oldMetadata, blockStateGetter);
        }
    }
}

