/*
 * Decompiled with CFR 0.152.
 */
package its_meow.betteranimalsplus;

import its_meow.betteranimalsplus.common.item.ItemBlockHeadType;
import its_meow.betteranimalsplus.config.BetterAnimalsPlusConfig;
import its_meow.betteranimalsplus.fixers.BearDataFixer;
import its_meow.betteranimalsplus.fixers.HeadBlockDataFixer;
import its_meow.betteranimalsplus.fixers.HeadItemDataFixer;
import its_meow.betteranimalsplus.fixers.HeadTileDataFixer;
import its_meow.betteranimalsplus.init.ModBlocks;
import its_meow.betteranimalsplus.init.ModEntities;
import its_meow.betteranimalsplus.init.ModItems;
import its_meow.betteranimalsplus.init.ModLootTables;
import its_meow.betteranimalsplus.init.ModOreDictSmelting;
import its_meow.betteranimalsplus.init.ModTriggers;
import its_meow.betteranimalsplus.integration.BaubleIntegration;
import its_meow.betteranimalsplus.network.ClientConfigurationPacket;
import its_meow.betteranimalsplus.util.EntityContainer;
import its_meow.betteranimalsplus.util.HeadTypes;
import its_meow.betteranimalsplus.world.gen.TrilliumGenerator;
import java.io.File;
import java.util.function.Supplier;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemMonsterPlacer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.datafix.FixTypes;
import net.minecraft.util.datafix.IFixType;
import net.minecraft.util.datafix.IFixableData;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.util.ModFixs;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.IWorldGenerator;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod.EventBusSubscriber(modid="betteranimalsplus")
@Mod(modid="betteranimalsplus", name="Better Animals Plus", version="7.1.0", acceptedMinecraftVersions="[1.12,1.12.2]", updateJSON="http://modmanagement.net16.net/updateJSON5.json")
public class BetterAnimalsPlusMod {
    public static final int FIXER_VERSION = 3;
    public static final SimpleNetworkWrapper NETWORK_INSTANCE = NetworkRegistry.INSTANCE.newSimpleChannel("betteranimalsplus");
    public static int packets = 0;
    @Mod.Instance(value="betteranimalsplus")
    public static BetterAnimalsPlusMod mod;
    public static CreativeTabs tab;
    public static Logger logger;
    public static Configuration config;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        logger = LogManager.getLogger((String)"betteranimalsplus");
        File directory = event.getModConfigurationDirectory();
        config = new Configuration(new File(directory.getPath(), "betteranimalsplus.cfg"));
        BetterAnimalsPlusConfig.readConfig(true);
        NETWORK_INSTANCE.registerMessage(ClientConfigurationPacket.class, ClientConfigurationPacket.class, packets++, Side.CLIENT);
        ModLootTables.register();
        ModTriggers.register();
        if (Loader.isModLoaded((String)"baubles")) {
            Supplier<Supplier> registerBaubleHandler = () -> () -> BaubleIntegration::preInit;
            ((Runnable)registerBaubleHandler.get().get()).run();
        }
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent e) {
        ModOreDictSmelting.register();
        if (BetterAnimalsPlusConfig.spawnTrillium) {
            GameRegistry.registerWorldGenerator((IWorldGenerator)new TrilliumGenerator(ModBlocks.trillium), (int)1);
        }
        ModFixs fixer = FMLCommonHandler.instance().getDataFixer().init("betteranimalsplus", 3);
        fixer.registerFix((IFixType)FixTypes.CHUNK, (IFixableData)new HeadBlockDataFixer());
        fixer.registerFix((IFixType)FixTypes.BLOCK_ENTITY, (IFixableData)new HeadTileDataFixer());
        fixer.registerFix((IFixType)FixTypes.ITEM_INSTANCE, (IFixableData)new HeadItemDataFixer());
        fixer.registerFix((IFixType)FixTypes.ENTITY, (IFixableData)new BearDataFixer());
        logger.log(Level.INFO, "Overspawning lammergeiers...");
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent e) {
        if (config.hasChanged()) {
            config.save();
        }
        logger.log(Level.INFO, "Crazy bird creation complete.");
    }

    @Mod.EventHandler
    public static void serverStart(FMLServerStartingEvent e) {
        BetterAnimalsPlusConfig.readConfig(false);
    }

    @SubscribeEvent
    public static void onPlayerJoin(PlayerEvent.PlayerLoggedInEvent e) {
        if (e.player instanceof EntityPlayerMP) {
            NETWORK_INSTANCE.sendTo((IMessage)new ClientConfigurationPacket(BetterAnimalsPlusConfig.coyotesHostileDaytime, BetterAnimalsPlusConfig.getTameItemsMap()), (EntityPlayerMP)e.player);
        }
    }

    static {
        tab = new CreativeTabs("Better Animals+"){

            public ItemStack func_78016_d() {
                return new ItemStack(ModItems.antler);
            }

            public void func_78018_a(NonNullList<ItemStack> toDisplay) {
                super.func_78018_a(toDisplay);
                for (HeadTypes type : HeadTypes.values()) {
                    for (ItemBlockHeadType item : type.getItems()) {
                        toDisplay.add((Object)new ItemStack((Item)item));
                    }
                }
                for (EntityContainer cont : ModEntities.entityList) {
                    ItemStack stack = new ItemStack(Items.field_151063_bx);
                    ItemMonsterPlacer.func_185078_a((ItemStack)stack, (ResourceLocation)new ResourceLocation("betteranimalsplus", cont.entityName));
                    toDisplay.add((Object)stack);
                }
            }
        };
    }
}

