/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.aquaculture.loot;

import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.teammetallurgy.aquaculture.Aquaculture;
import com.teammetallurgy.aquaculture.misc.BiomeDictionaryHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import javax.annotation.Nullable;
import net.minecraft.advancements.criterion.MinMaxBounds;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.BiomeDictionary;

public class BiomeTagPredicate {
    private static final BiomeTagPredicate ANY = new BiomeTagPredicate(MinMaxBounds.FloatBound.field_211359_e, MinMaxBounds.FloatBound.field_211359_e, MinMaxBounds.FloatBound.field_211359_e, Lists.newArrayList(), Lists.newArrayList(), false);
    private static final HashMap<CheckType, List<ResourceLocation>> CACHE = new HashMap();
    private static final List<BiomeDictionary.Type> INVALID_TYPES = Arrays.asList(BiomeDictionary.Type.NETHER, BiomeDictionary.Type.END);
    private final MinMaxBounds.FloatBound x;
    private final MinMaxBounds.FloatBound y;
    private final MinMaxBounds.FloatBound z;
    private final List<BiomeDictionary.Type> include;
    private final List<BiomeDictionary.Type> exclude;
    private final boolean and;

    public BiomeTagPredicate(MinMaxBounds.FloatBound x, MinMaxBounds.FloatBound y, MinMaxBounds.FloatBound z, List<BiomeDictionary.Type> include, List<BiomeDictionary.Type> exclude, boolean and) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.include = include;
        this.exclude = exclude;
        this.and = and;
    }

    public boolean test(ServerWorld world, float x, float y, float z) {
        if (!this.x.func_211354_d(x)) {
            return false;
        }
        if (!this.y.func_211354_d(y)) {
            return false;
        }
        if (!this.z.func_211354_d(z)) {
            return false;
        }
        BlockPos pos = new BlockPos((double)x, (double)y, (double)z);
        Biome biome = world.func_226691_t_(pos);
        ResourceLocation biomeFromRegistry = world.func_241828_r().func_243612_b(Registry.field_239720_u_).func_177774_c((Object)biome);
        CheckType checkType = CheckType.getOrCreate(this.include, this.exclude, this.and);
        List<ResourceLocation> validBiomes = CACHE.get(checkType);
        if (validBiomes == null) {
            validBiomes = BiomeTagPredicate.getValidBiomes(checkType);
            CACHE.put(checkType, validBiomes);
        }
        return validBiomes.contains(biomeFromRegistry);
    }

    public static List<ResourceLocation> getValidBiomes(CheckType checkType) {
        return BiomeTagPredicate.getValidBiomes(checkType.getInclude(), checkType.getExclude(), checkType.isAnd());
    }

    public static List<ResourceLocation> getValidBiomes(List<BiomeDictionary.Type> includeList, List<BiomeDictionary.Type> excludeList, boolean and) {
        ArrayList biomes = Lists.newArrayList();
        if (includeList.isEmpty() && !excludeList.isEmpty()) {
            HashSet validTypes = new HashSet(BiomeDictionary.Type.getAll());
            includeList.addAll(validTypes);
            excludeList.addAll(INVALID_TYPES);
        }
        if (!includeList.isEmpty()) {
            ArrayList addBiomes = Lists.newArrayList();
            for (BiomeDictionary.Type type : includeList) {
                addBiomes.addAll(BiomeDictionary.getBiomes((BiomeDictionary.Type)type));
            }
            if (and) {
                for (BiomeDictionary.Type type : includeList) {
                    addBiomes.removeIf(biome -> !BiomeDictionary.getBiomes((BiomeDictionary.Type)type).contains(biome));
                }
            }
            if (includeList.stream().noneMatch(INVALID_TYPES::contains)) {
                excludeList.addAll(INVALID_TYPES);
            }
            for (RegistryKey addBiome : addBiomes) {
                if (biomes.contains(addBiome.func_240901_a_())) continue;
                biomes.add(addBiome.func_240901_a_());
            }
        }
        if (!excludeList.isEmpty()) {
            for (BiomeDictionary.Type type : excludeList) {
                for (RegistryKey biome2 : BiomeDictionary.getBiomes((BiomeDictionary.Type)type)) {
                    biomes.remove(biome2.func_240901_a_());
                }
            }
        }
        return biomes;
    }

    public JsonElement serialize() {
        if (this == ANY) {
            return JsonNull.INSTANCE;
        }
        JsonObject object = new JsonObject();
        if (!(this.x.func_211335_c() && this.y.func_211335_c() && this.z.func_211335_c())) {
            JsonObject posObj = new JsonObject();
            posObj.add("x", this.x.func_200321_c());
            posObj.add("y", this.y.func_200321_c());
            posObj.add("z", this.z.func_200321_c());
            object.add("position", (JsonElement)posObj);
        }
        if (this.include != null) {
            for (BiomeDictionary.Type type : this.include) {
                object.add("include", (JsonElement)object.getAsJsonArray(type.getName()));
            }
        }
        if (this.exclude != null) {
            for (BiomeDictionary.Type type : this.exclude) {
                object.add("exclude", (JsonElement)object.getAsJsonArray(type.getName()));
            }
        }
        object.addProperty("add", Boolean.valueOf(object.getAsBoolean()));
        return object;
    }

    public static BiomeTagPredicate deserialize(@Nullable JsonElement element) {
        if (element != null && !element.isJsonNull()) {
            JsonObject location = JSONUtils.func_151210_l((JsonElement)element, (String)"location");
            JsonObject position = JSONUtils.func_151218_a((JsonObject)location, (String)"position", (JsonObject)new JsonObject());
            MinMaxBounds.FloatBound x = MinMaxBounds.FloatBound.func_211356_a((JsonElement)position.get("x"));
            MinMaxBounds.FloatBound y = MinMaxBounds.FloatBound.func_211356_a((JsonElement)position.get("y"));
            MinMaxBounds.FloatBound z = MinMaxBounds.FloatBound.func_211356_a((JsonElement)position.get("z"));
            ArrayList include = Lists.newArrayList();
            if (location.has("include")) {
                JsonArray includeArray = JSONUtils.func_151214_t((JsonObject)location, (String)"include");
                for (int entry = 0; entry < includeArray.size(); ++entry) {
                    String name = includeArray.get(entry).getAsString().toLowerCase(Locale.ROOT);
                    BiomeDictionary.Type type = BiomeDictionaryHelper.getType(name);
                    if (type == null) {
                        Aquaculture.LOG.error("Failed to include BiomeDictionary Type: " + name + ". Please check your loot tables");
                        continue;
                    }
                    include.add(type);
                }
            }
            ArrayList exclude = Lists.newArrayList();
            if (location.has("exclude")) {
                JsonArray excludeArray = JSONUtils.func_151214_t((JsonObject)location, (String)"exclude");
                for (int entry = 0; entry < excludeArray.size(); ++entry) {
                    String name = excludeArray.get(entry).getAsString().toLowerCase(Locale.ROOT);
                    BiomeDictionary.Type type = BiomeDictionaryHelper.getType(name);
                    if (type == null) {
                        Aquaculture.LOG.error("Failed to exclude BiomeDictionary Type: " + name + ". Please check your loot tables");
                        continue;
                    }
                    exclude.add(type);
                }
            }
            boolean and = false;
            if (location.has("and")) {
                and = JSONUtils.func_151212_i((JsonObject)location, (String)"and");
            }
            return new BiomeTagPredicate(x, y, z, include, exclude, and);
        }
        return ANY;
    }

    public static class CheckType {
        private static final Map<Integer, CheckType> BY_NAME = new TreeMap<Integer, CheckType>();
        private final List<BiomeDictionary.Type> include;
        private final List<BiomeDictionary.Type> exclude;
        private final boolean and;

        private CheckType(List<BiomeDictionary.Type> include, List<BiomeDictionary.Type> exclude, boolean and) {
            this.include = include;
            this.exclude = exclude;
            this.and = and;
            BY_NAME.put(this.hashCode(), this);
        }

        public List<BiomeDictionary.Type> getInclude() {
            return this.include;
        }

        public List<BiomeDictionary.Type> getExclude() {
            return this.exclude;
        }

        public boolean isAnd() {
            return this.and;
        }

        public static CheckType getOrCreate(List<BiomeDictionary.Type> include, List<BiomeDictionary.Type> exclude, boolean and) {
            CheckType checkType = BY_NAME.get(Objects.hash(include, exclude, and));
            if (checkType == null) {
                checkType = new CheckType(include, exclude, and);
            }
            return checkType;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CheckType checkType = (CheckType)o;
            return this.and == checkType.and && Objects.equals(this.include, checkType.include) && Objects.equals(this.exclude, checkType.exclude);
        }

        public int hashCode() {
            return Objects.hash(this.include, this.exclude, this.and);
        }
    }
}

