/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.aquaculture.item.neptunium;

import com.teammetallurgy.aquaculture.Aquaculture;
import com.teammetallurgy.aquaculture.init.AquaItems;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.ModifiableAttributeInstance;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ArmorItem;
import net.minecraft.item.IArmorMaterial;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="aquaculture")
public class NeptuniumArmor
extends ArmorItem {
    private static final AttributeModifier INCREASED_SWIM_SPEED = new AttributeModifier(UUID.fromString("d820cadc-2d19-421c-b19f-4c1f5b84a418"), "Neptunium Boots swim speed boost", 0.5, AttributeModifier.Operation.ADDITION);
    private String texture;

    public NeptuniumArmor(IArmorMaterial armorMaterial, EquipmentSlotType equipmentSlot) {
        super(armorMaterial, equipmentSlot, new Item.Properties().func_200916_a(Aquaculture.GROUP));
    }

    public void onArmorTick(@Nonnull ItemStack stack, World world, PlayerEntity player) {
        ModifiableAttributeInstance swimSpeed = player.func_110148_a((Attribute)ForgeMod.SWIM_SPEED.get());
        if (player.func_208600_a((ITag)FluidTags.field_206959_a)) {
            if (this.field_77881_a == EquipmentSlotType.HEAD) {
                player.func_195064_c(new EffectInstance(Effects.field_76439_r, 20, 0, false, false, false));
            } else if (this.field_77881_a == EquipmentSlotType.CHEST) {
                player.func_195064_c(new EffectInstance(Effects.field_76427_o, 20, 0, false, false, false));
            } else if (this.field_77881_a == EquipmentSlotType.LEGS && !player.func_213453_ef()) {
                player.func_213317_d(player.func_213322_ci().func_72441_c(0.0, (double)player.field_70143_R, 0.0));
            }
        }
    }

    @SubscribeEvent
    public static void onLivingTick(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            ModifiableAttributeInstance swimSpeed;
            PlayerEntity player = event.player;
            if (!player.field_70170_p.field_72995_K && (swimSpeed = player.func_110148_a((Attribute)ForgeMod.SWIM_SPEED.get())) != null) {
                if (player.func_70090_H() && player.func_184582_a(EquipmentSlotType.FEET).func_77973_b() == AquaItems.NEPTUNIUM_BOOTS) {
                    if (!swimSpeed.func_180374_a(INCREASED_SWIM_SPEED)) {
                        swimSpeed.func_233769_c_(INCREASED_SWIM_SPEED);
                    }
                } else if (swimSpeed.func_180374_a(INCREASED_SWIM_SPEED)) {
                    swimSpeed.func_111124_b(INCREASED_SWIM_SPEED);
                }
            }
        }
    }

    public Item setArmorTexture(String string) {
        this.texture = string;
        return this;
    }

    public String getArmorTexture(@Nonnull ItemStack stack, Entity entity, EquipmentSlotType slot, String layer) {
        return "aquaculture:textures/armor/" + this.texture + ".png";
    }
}

