/*
 * Decompiled with CFR 0.152.
 */
package appeng.integration.modules;

import appeng.api.AEApi;
import appeng.api.IAppEngApi;
import appeng.api.definitions.IBlocks;
import appeng.api.exceptions.MissingIngredientError;
import appeng.api.exceptions.RegistrationError;
import appeng.api.features.IGrinderEntry;
import appeng.api.features.IInscriberRecipe;
import appeng.api.recipes.IIngredient;
import appeng.integration.IIntegrationModule;
import appeng.integration.IntegrationHelper;
import appeng.recipes.game.ShapedRecipe;
import appeng.recipes.game.ShapelessRecipe;
import com.google.common.base.Optional;
import cpw.mods.fml.relauncher.ReflectionHelper;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import uristqwerty.CraftGuide.CraftGuideLog;
import uristqwerty.CraftGuide.DefaultRecipeTemplate;
import uristqwerty.CraftGuide.RecipeGeneratorImplementation;
import uristqwerty.CraftGuide.api.ChanceSlot;
import uristqwerty.CraftGuide.api.CraftGuideAPIObject;
import uristqwerty.CraftGuide.api.ItemSlot;
import uristqwerty.CraftGuide.api.RecipeGenerator;
import uristqwerty.CraftGuide.api.RecipeProvider;
import uristqwerty.CraftGuide.api.RecipeTemplate;
import uristqwerty.CraftGuide.api.Slot;
import uristqwerty.CraftGuide.api.SlotType;
import uristqwerty.gui_craftguide.texture.DynamicTexture;
import uristqwerty.gui_craftguide.texture.Texture;
import uristqwerty.gui_craftguide.texture.TextureClip;

public final class CraftGuide
extends CraftGuideAPIObject
implements IIntegrationModule,
RecipeProvider {
    private static final int SLOT_SIZE = 16;
    private static final int TEXTURE_WIDTH = 79;
    private static final int TEXTURE_HEIGHT = 58;
    private static final int GRINDER_RATIO = 10000;
    private static final Slot[] GRINDER_SLOTS = new Slot[]{new ItemSlot(3, 21, 16, 16).drawOwnBackground(), new ItemSlot(41, 21, 16, 16, true).drawOwnBackground().setSlotType(SlotType.OUTPUT_SLOT), new ChanceSlot(59, 12, 16, 16, true).setRatio(10000).setFormatString(" (%1$.2f%% chance)").drawOwnBackground().setSlotType(SlotType.OUTPUT_SLOT), new ChanceSlot(59, 30, 16, 16, true).setRatio(10000).setFormatString(" (%1$.2f%% chance)").drawOwnBackground().setSlotType(SlotType.OUTPUT_SLOT), new ItemSlot(22, 12, 16, 16).setSlotType(SlotType.MACHINE_SLOT), new ItemSlot(22, 30, 16, 16).setSlotType(SlotType.MACHINE_SLOT)};
    private static final Slot[] INSCRIBER_SLOTS = new Slot[]{new ItemSlot(12, 21, 16, 16).drawOwnBackground(), new ItemSlot(21, 3, 16, 16).drawOwnBackground(), new ItemSlot(21, 39, 16, 16).drawOwnBackground(), new ItemSlot(50, 21, 16, 16, true).drawOwnBackground().setSlotType(SlotType.OUTPUT_SLOT), new ItemSlot(31, 21, 16, 16).setSlotType(SlotType.MACHINE_SLOT)};
    private static final Slot[] SHAPELESS_CRAFTING_SLOTS = new Slot[]{new ItemSlot(3, 3, 16, 16), new ItemSlot(21, 3, 16, 16), new ItemSlot(39, 3, 16, 16), new ItemSlot(3, 21, 16, 16), new ItemSlot(21, 21, 16, 16), new ItemSlot(39, 21, 16, 16), new ItemSlot(3, 39, 16, 16), new ItemSlot(21, 39, 16, 16), new ItemSlot(39, 39, 16, 16), new ItemSlot(59, 21, 16, 16, true).setSlotType(SlotType.OUTPUT_SLOT)};
    private static final Slot[] CRAFTING_SLOTS_OWN_BG = new Slot[]{new ItemSlot(3, 3, 16, 16).drawOwnBackground(), new ItemSlot(21, 3, 16, 16).drawOwnBackground(), new ItemSlot(39, 3, 16, 16).drawOwnBackground(), new ItemSlot(3, 21, 16, 16).drawOwnBackground(), new ItemSlot(21, 21, 16, 16).drawOwnBackground(), new ItemSlot(39, 21, 16, 16).drawOwnBackground(), new ItemSlot(3, 39, 16, 16).drawOwnBackground(), new ItemSlot(21, 39, 16, 16).drawOwnBackground(), new ItemSlot(39, 39, 16, 16).drawOwnBackground(), new ItemSlot(59, 21, 16, 16, true).setSlotType(SlotType.OUTPUT_SLOT).drawOwnBackground()};
    private static final Slot[] SMALL_CRAFTING_SLOTS_OWN_BG = new Slot[]{new ItemSlot(12, 12, 16, 16).drawOwnBackground(), new ItemSlot(30, 12, 16, 16).drawOwnBackground(), new ItemSlot(12, 30, 16, 16).drawOwnBackground(), new ItemSlot(30, 30, 16, 16).drawOwnBackground(), new ItemSlot(59, 21, 16, 16, true).setSlotType(SlotType.OUTPUT_SLOT).drawOwnBackground()};
    private static final Slot[] CRTAFTING_SLOTS = new Slot[]{new ItemSlot(3, 3, 16, 16), new ItemSlot(21, 3, 16, 16), new ItemSlot(39, 3, 16, 16), new ItemSlot(3, 21, 16, 16), new ItemSlot(21, 21, 16, 16), new ItemSlot(39, 21, 16, 16), new ItemSlot(3, 39, 16, 16), new ItemSlot(21, 39, 16, 16), new ItemSlot(39, 39, 16, 16), new ItemSlot(59, 21, 16, 16, true).setSlotType(SlotType.OUTPUT_SLOT)};
    private static final Slot[] SMALL_CRAFTING_SLOTS = new Slot[]{new ItemSlot(12, 12, 16, 16), new ItemSlot(30, 12, 16, 16), new ItemSlot(12, 30, 16, 16), new ItemSlot(30, 30, 16, 16), new ItemSlot(59, 21, 16, 16, true).setSlotType(SlotType.OUTPUT_SLOT)};
    public static CraftGuide instance;

    public CraftGuide() {
        IntegrationHelper.testClassExistence(this, CraftGuideLog.class);
        IntegrationHelper.testClassExistence(this, DefaultRecipeTemplate.class);
        IntegrationHelper.testClassExistence(this, RecipeGeneratorImplementation.class);
        IntegrationHelper.testClassExistence(this, ChanceSlot.class);
        IntegrationHelper.testClassExistence(this, CraftGuideAPIObject.class);
        IntegrationHelper.testClassExistence(this, ItemSlot.class);
        IntegrationHelper.testClassExistence(this, RecipeGenerator.class);
        IntegrationHelper.testClassExistence(this, RecipeProvider.class);
        IntegrationHelper.testClassExistence(this, RecipeTemplate.class);
        IntegrationHelper.testClassExistence(this, Slot.class);
        IntegrationHelper.testClassExistence(this, SlotType.class);
        IntegrationHelper.testClassExistence(this, DynamicTexture.class);
        IntegrationHelper.testClassExistence(this, TextureClip.class);
    }

    @Override
    public void init() throws Throwable {
    }

    @Override
    public void postInit() {
    }

    public void generateRecipes(RecipeGenerator generator) {
        RecipeTemplate smallTemplate;
        RecipeTemplate craftingTemplate;
        if (uristqwerty.CraftGuide.CraftGuide.newerBackgroundStyle) {
            craftingTemplate = generator.createRecipeTemplate(CRAFTING_SLOTS_OWN_BG, null);
            smallTemplate = generator.createRecipeTemplate(SMALL_CRAFTING_SLOTS_OWN_BG, null);
        } else {
            TextureClip craftingBG = new TextureClip(DynamicTexture.instance((String)"recipe_backgrounds"), 1, 1, 79, 58);
            TextureClip craftingSelected = new TextureClip(DynamicTexture.instance((String)"recipe_backgrounds"), 82, 1, 79, 58);
            craftingTemplate = new DefaultRecipeTemplate(CRTAFTING_SLOTS, RecipeGeneratorImplementation.workbench, (Texture)craftingBG, (Texture)craftingSelected);
            TextureClip smallBG = new TextureClip(DynamicTexture.instance((String)"recipe_backgrounds"), 1, 61, 79, 58);
            TextureClip smallSelected = new TextureClip(DynamicTexture.instance((String)"recipe_backgrounds"), 82, 61, 79, 58);
            smallTemplate = new DefaultRecipeTemplate(SMALL_CRAFTING_SLOTS, RecipeGeneratorImplementation.workbench, (Texture)smallBG, (Texture)smallSelected);
        }
        TextureClip shapelessBG = new TextureClip(DynamicTexture.instance((String)"recipe_backgrounds"), 1, 121, 79, 58);
        TextureClip shapelessSelected = new TextureClip(DynamicTexture.instance((String)"recipe_backgrounds"), 82, 121, 79, 58);
        DefaultRecipeTemplate shapelessTemplate = new DefaultRecipeTemplate(SHAPELESS_CRAFTING_SLOTS, RecipeGeneratorImplementation.workbench, (Texture)shapelessBG, (Texture)shapelessSelected);
        this.addCraftingRecipes(craftingTemplate, smallTemplate, (RecipeTemplate)shapelessTemplate, generator);
        IAppEngApi api = AEApi.instance();
        IBlocks aeBlocks = api.definitions().blocks();
        Optional<ItemStack> grindstone = aeBlocks.grindStone().maybeStack(1);
        Optional<ItemStack> inscriber = aeBlocks.inscriber().maybeStack(1);
        if (grindstone.isPresent()) {
            this.addGrinderRecipes(api, (ItemStack)grindstone.get(), generator);
        }
        if (inscriber.isPresent()) {
            this.addInscriberRecipes(api, (ItemStack)inscriber.get(), generator);
        }
    }

    private List<IRecipe> getUncheckedRecipes() {
        return CraftingManager.func_77594_a().func_77592_b();
    }

    private void addCraftingRecipes(RecipeTemplate template, RecipeTemplate templateSmall, RecipeTemplate templateShapeless, RecipeGenerator generator) {
        List<IRecipe> recipes = this.getUncheckedRecipes();
        int errCount = 0;
        for (IRecipe recipe : recipes) {
            try {
                Object[] items = this.getCraftingRecipe(recipe, true);
                if (items == null) continue;
                if (items.length == 5) {
                    generator.addRecipe(templateSmall, items);
                    continue;
                }
                if (recipe instanceof ShapelessRecipe) {
                    generator.addRecipe(templateShapeless, items);
                    continue;
                }
                generator.addRecipe(template, items);
            }
            catch (Exception e) {
                if (errCount >= 5) {
                    CraftGuideLog.log((String)"AppEng CraftGuide integration: Stack trace limit reached, further stack traces from this invocation will not be logged to the console. They will still be logged to (.minecraft)/config/CraftGuide/CraftGuide.log", (boolean)true);
                } else {
                    e.printStackTrace();
                }
                ++errCount;
                CraftGuideLog.log((Throwable)e);
            }
        }
    }

    private void addGrinderRecipes(IAppEngApi api, ItemStack grindstone, RecipeGenerator generator) {
        ItemStack handle = (ItemStack)api.definitions().blocks().crankHandle().maybeStack(1).orNull();
        RecipeTemplate grinderTemplate = generator.createRecipeTemplate(GRINDER_SLOTS, grindstone);
        for (IGrinderEntry recipe : api.registries().grinder().getRecipes()) {
            generator.addRecipe(grinderTemplate, new Object[]{recipe.getInput(), recipe.getOutput(), new Object[]{recipe.getOptionalOutput(), (int)(recipe.getOptionalChance() * 10000.0f)}, new Object[]{recipe.getSecondOptionalOutput(), (int)(recipe.getOptionalChance() * 10000.0f)}, handle, grindstone});
        }
    }

    private void addInscriberRecipes(IAppEngApi api, ItemStack inscriber, RecipeGenerator generator) {
        RecipeTemplate inscriberTemplate = generator.createRecipeTemplate(INSCRIBER_SLOTS, inscriber);
        for (IInscriberRecipe recipe : api.registries().inscriber().getRecipes()) {
            generator.addRecipe(inscriberTemplate, new Object[]{recipe.getInputs(), recipe.getTopOptional().orNull(), recipe.getBottomOptional().orNull(), recipe.getOutput(), inscriber});
        }
    }

    private Object[] getCraftingShapelessRecipe(List<?> items, ItemStack recipeOutput) {
        Object[] output = new Object[10];
        for (int i = 0; i < items.size(); ++i) {
            output[i] = items.get(i);
            if (output[i] instanceof ItemStack[]) {
                output[i] = Arrays.asList((ItemStack[])output[i]);
            }
            if (!(output[i] instanceof IIngredient)) continue;
            try {
                output[i] = this.toCG(((IIngredient)output[i]).getItemStackSet());
                continue;
            }
            catch (RegistrationError registrationError) {
                continue;
            }
            catch (MissingIngredientError missingIngredientError) {
                // empty catch block
            }
        }
        output[9] = recipeOutput;
        return output;
    }

    private Object[] getSmallShapedRecipe(int width, int height, Object[] items, ItemStack recipeOutput) {
        Object[] output = new Object[5];
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                int i = y * 2 + x;
                output[i] = items[y * width + x];
                if (output[i] instanceof ItemStack[]) {
                    output[i] = Arrays.asList((ItemStack[])output[i]);
                }
                if (!(output[i] instanceof IIngredient)) continue;
                try {
                    output[i] = this.toCG(((IIngredient)output[i]).getItemStackSet());
                    continue;
                }
                catch (RegistrationError registrationError) {
                    continue;
                }
                catch (MissingIngredientError missingIngredientError) {
                    // empty catch block
                }
            }
        }
        output[4] = recipeOutput;
        return output;
    }

    private Object[] getCraftingShapedRecipe(int width, int height, Object[] items, ItemStack recipeOutput) {
        Object[] output = new Object[10];
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                int i = y * 3 + x;
                output[i] = items[y * width + x];
                if (output[i] instanceof ItemStack[]) {
                    output[i] = Arrays.asList((ItemStack[])output[i]);
                }
                if (!(output[i] instanceof IIngredient)) continue;
                try {
                    output[i] = this.toCG(((IIngredient)output[i]).getItemStackSet());
                    continue;
                }
                catch (RegistrationError registrationError) {
                    continue;
                }
                catch (MissingIngredientError missingIngredientError) {
                    // empty catch block
                }
            }
        }
        output[9] = recipeOutput;
        return output;
    }

    private Object toCG(ItemStack[] itemStackSet) {
        List<ItemStack> list = Arrays.asList(itemStackSet);
        for (int x = 0; x < list.size(); ++x) {
            list.set(x, list.get(x).func_77946_l());
            if (list.get((int)x).field_77994_a != 0) continue;
            list.get((int)x).field_77994_a = 1;
        }
        return list;
    }

    @Nullable
    private Object[] getCraftingRecipe(IRecipe recipe, boolean allowSmallGrid) {
        if (recipe instanceof ShapelessRecipe) {
            List items = (List)ReflectionHelper.getPrivateValue(ShapelessRecipe.class, (Object)((ShapelessRecipe)recipe), (String[])new String[]{"input"});
            return this.getCraftingShapelessRecipe(items, recipe.func_77571_b());
        }
        if (recipe instanceof ShapedRecipe) {
            int width = (Integer)ReflectionHelper.getPrivateValue(ShapedRecipe.class, (Object)((ShapedRecipe)recipe), (String[])new String[]{"width"});
            int height = (Integer)ReflectionHelper.getPrivateValue(ShapedRecipe.class, (Object)((ShapedRecipe)recipe), (String[])new String[]{"height"});
            Object[] items = (Object[])ReflectionHelper.getPrivateValue(ShapedRecipe.class, (Object)((ShapedRecipe)recipe), (String[])new String[]{"input"});
            if (allowSmallGrid && width < 3 && height < 3) {
                return this.getSmallShapedRecipe(width, height, items, recipe.func_77571_b());
            }
            return this.getCraftingShapedRecipe(width, height, items, recipe.func_77571_b());
        }
        return null;
    }
}

