/*
 * Decompiled with CFR 0.152.
 */
package appeng.me.cache.helpers;

import appeng.api.networking.IGridNode;
import appeng.api.networking.ticking.IGridTickable;
import appeng.api.networking.ticking.TickingRequest;
import appeng.api.util.DimensionalCoord;
import appeng.me.cache.TickManagerCache;
import appeng.parts.AEBasePart;
import javax.annotation.Nonnull;
import net.minecraft.crash.CrashReportCategory;

public class TickTracker
implements Comparable<TickTracker> {
    private final TickingRequest request;
    private final IGridTickable gt;
    private final IGridNode node;
    private final TickManagerCache host;
    private final long LastFiveTicksTime = 0L;
    private long lastTick;
    private int currentRate;

    public TickTracker(TickingRequest req, IGridNode node, IGridTickable gt, long currentTick, TickManagerCache tickManagerCache) {
        this.request = req;
        this.gt = gt;
        this.node = node;
        this.setCurrentRate((req.minTickRate + req.maxTickRate) / 2);
        this.setLastTick(currentTick);
        this.host = tickManagerCache;
    }

    public long getAvgNanos() {
        return this.LastFiveTicksTime / 5L;
    }

    public void setRate(int rate) {
        this.setCurrentRate(rate);
        if (this.getCurrentRate() < this.getRequest().minTickRate) {
            this.setCurrentRate(this.getRequest().minTickRate);
        }
        if (this.getCurrentRate() > this.getRequest().maxTickRate) {
            this.setCurrentRate(this.getRequest().maxTickRate);
        }
    }

    @Override
    public int compareTo(@Nonnull TickTracker t) {
        int nextTick = (int)(this.getLastTick() - this.host.getCurrentTick() + (long)this.getCurrentRate());
        int ts_nextTick = (int)(t.getLastTick() - this.host.getCurrentTick() + (long)t.getCurrentRate());
        return nextTick - ts_nextTick;
    }

    public void addEntityCrashInfo(CrashReportCategory crashreportcategory) {
        if (this.getGridTickable() instanceof AEBasePart) {
            AEBasePart part = (AEBasePart)((Object)this.getGridTickable());
            part.addEntityCrashInfo(crashreportcategory);
        }
        crashreportcategory.func_71507_a("CurrentTickRate", (Object)this.getCurrentRate());
        crashreportcategory.func_71507_a("MinTickRate", (Object)this.getRequest().minTickRate);
        crashreportcategory.func_71507_a("MaxTickRate", (Object)this.getRequest().maxTickRate);
        crashreportcategory.func_71507_a("MachineType", (Object)this.getGridTickable().getClass().getName());
        crashreportcategory.func_71507_a("GridBlockType", (Object)this.getNode().getGridBlock().getClass().getName());
        crashreportcategory.func_71507_a("ConnectedSides", this.getNode().getConnectedSides());
        DimensionalCoord dc = this.getNode().getGridBlock().getLocation();
        if (dc != null) {
            crashreportcategory.func_71507_a("Location", (Object)dc);
        }
    }

    public int getCurrentRate() {
        return this.currentRate;
    }

    public void setCurrentRate(int currentRate) {
        this.currentRate = currentRate;
    }

    public long getLastTick() {
        return this.lastTick;
    }

    public void setLastTick(long lastTick) {
        this.lastTick = lastTick;
    }

    public IGridNode getNode() {
        return this.node;
    }

    public IGridTickable getGridTickable() {
        return this.gt;
    }

    public TickingRequest getRequest() {
        return this.request;
    }
}

