/*
 * Decompiled with CFR 0.152.
 */
package squeek.applecore.asm.module;

import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.LocalVariableNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;
import squeek.applecore.AppleCore;
import squeek.applecore.asm.ASMConstants;
import squeek.applecore.asm.IClassTransformerModule;
import squeek.asmhelper.applecore.ASMHelper;

public class ModuleDrawTooltip
implements IClassTransformerModule {
    @Override
    public String[] getClassesToTransform() {
        return new String[]{"net.minecraft.client.gui.GuiScreen", "codechicken.lib.gui.GuiDraw"};
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public byte[] transform(String name, String transformedName, byte[] bytes) {
        ClassNode classNode = ASMHelper.readClassFromBytes(bytes);
        if (transformedName.equals("net.minecraft.client.gui.GuiScreen")) {
            MethodNode methodNode = ASMHelper.findMethodNodeOfClass(classNode, "drawHoveringText", "(Ljava/util/List;IILnet/minecraft/client/gui/FontRenderer;)V");
            if (methodNode == null) throw new RuntimeException("GuiScreen.drawHoveringText not found");
            this.addDrawHoveringTextHook(methodNode, "onDrawHoveringText", "(IIII)V");
            return ASMHelper.writeClassToBytes(classNode);
        } else {
            if (!name.equals("codechicken.lib.gui.GuiDraw")) return ASMHelper.writeClassToBytes(classNode);
            MethodNode methodNode = ASMHelper.findMethodNodeOfClass(classNode, "drawTooltipBox", "(IIII)V");
            if (methodNode != null) {
                this.addCodeChickenDrawHoveringTextHook(methodNode, "onDrawHoveringText", "(IIII)V");
                return ASMHelper.writeClassToBytes(classNode);
            } else {
                AppleCore.Log.error("drawTooltipBox method in codechicken.lib.gui.GuiDraw not found");
            }
        }
        return ASMHelper.writeClassToBytes(classNode);
    }

    public void addDrawHoveringTextHook(MethodNode method, String hookMethod, String hookDesc) {
        AbstractInsnNode targetNode = null;
        for (AbstractInsnNode instruction : method.instructions.toArray()) {
            if (instruction.getOpcode() != 182) continue;
            MethodInsnNode methodInsn = (MethodInsnNode)instruction;
            if (!methodInsn.desc.equals("(IIIIII)V")) continue;
            targetNode = instruction;
        }
        if (targetNode == null) {
            throw new RuntimeException("Unexpected instruction pattern encountered in " + method.name);
        }
        LocalVariableNode x = ASMHelper.findLocalVariableOfMethod(method, "j2", "I");
        LocalVariableNode y = ASMHelper.findLocalVariableOfMethod(method, "k2", "I");
        LocalVariableNode w = ASMHelper.findLocalVariableOfMethod(method, "k", "I");
        LocalVariableNode h = ASMHelper.findLocalVariableOfMethod(method, "i1", "I");
        if (x == null || y == null || w == null || h == null) {
            AppleCore.Log.warn("Could not patch " + method.name + "; local variables not found");
            return;
        }
        InsnList toInject = new InsnList();
        toInject.add((AbstractInsnNode)new VarInsnNode(21, x.index));
        toInject.add((AbstractInsnNode)new VarInsnNode(21, y.index));
        toInject.add((AbstractInsnNode)new VarInsnNode(21, w.index));
        toInject.add((AbstractInsnNode)new VarInsnNode(21, h.index));
        toInject.add((AbstractInsnNode)new MethodInsnNode(184, ASMConstants.HooksInternalClass, hookMethod, hookDesc, false));
        method.instructions.insert(targetNode, toInject);
    }

    public void addCodeChickenDrawHoveringTextHook(MethodNode method, String hookMethod, String hookDesc) {
        AbstractInsnNode targetNode = ASMHelper.findFirstInstruction(method);
        InsnList toInject = new InsnList();
        toInject.add((AbstractInsnNode)new VarInsnNode(21, 0));
        toInject.add((AbstractInsnNode)new VarInsnNode(21, 1));
        toInject.add((AbstractInsnNode)new VarInsnNode(21, 2));
        toInject.add((AbstractInsnNode)new VarInsnNode(21, 3));
        toInject.add((AbstractInsnNode)new MethodInsnNode(184, ASMConstants.HooksInternalClass, hookMethod, hookDesc, false));
        method.instructions.insertBefore(targetNode, toInject);
    }
}

