/*
 * Decompiled with CFR 0.152.
 */
package hunternif.mc.atlas.network.server;

import cpw.mods.fml.relauncher.Side;
import hunternif.mc.atlas.AntiqueAtlasMod;
import hunternif.mc.atlas.network.AbstractMessage;
import hunternif.mc.atlas.util.Log;
import java.io.IOException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;

public class BrowsingPositionPacket
extends AbstractMessage.AbstractServerMessage<BrowsingPositionPacket> {
    public static final double ZOOM_SCALE_FACTOR = 1024.0;
    private int atlasID;
    private int dimension;
    private int x;
    private int y;
    private double zoom;

    public BrowsingPositionPacket() {
    }

    public BrowsingPositionPacket(int atlasID, int dimension, int x, int y, double zoom) {
        this.atlasID = atlasID;
        this.dimension = dimension;
        this.x = x;
        this.y = y;
        this.zoom = zoom;
    }

    @Override
    protected void read(PacketBuffer buffer) throws IOException {
        this.atlasID = buffer.func_150792_a();
        this.dimension = buffer.func_150792_a();
        this.x = buffer.func_150792_a();
        this.y = buffer.func_150792_a();
        this.zoom = (double)buffer.func_150792_a() / 1024.0;
    }

    @Override
    protected void write(PacketBuffer buffer) throws IOException {
        buffer.func_150787_b(this.atlasID);
        buffer.func_150787_b(this.dimension);
        buffer.func_150787_b(this.x);
        buffer.func_150787_b(this.y);
        buffer.func_150787_b((int)Math.round(this.zoom * 1024.0));
    }

    @Override
    protected void process(EntityPlayer player, Side side) {
        if (!player.field_71071_by.func_70431_c(new ItemStack((Item)AntiqueAtlasMod.itemAtlas, 1, this.atlasID))) {
            Log.warn("Player %s attempted to put marker into someone else's Atlas #%d", player.func_146103_bH().getName(), this.atlasID);
            return;
        }
        AntiqueAtlasMod.atlasData.getAtlasData(this.atlasID, player.field_70170_p).getDimensionData(this.dimension).setBrowsingPosition(this.x, this.y, this.zoom);
    }
}

