/*
 * Decompiled with CFR 0.152.
 */
package hunternif.mc.atlas.network.client;

import cpw.mods.fml.relauncher.Side;
import hunternif.mc.atlas.AntiqueAtlasMod;
import hunternif.mc.atlas.core.AtlasData;
import hunternif.mc.atlas.core.DimensionData;
import hunternif.mc.atlas.core.TileGroup;
import hunternif.mc.atlas.network.AbstractMessage;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.ArrayList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;

public class TileGroupsPacket
extends AbstractMessage.AbstractClientMessage<TileGroupsPacket> {
    public int atlasID;
    public int dimension;
    public ArrayList<TileGroup> tileGroups;
    public static final int TILE_GROUPS_PER_PACKET = 100;

    public TileGroupsPacket() {
        this.tileGroups = new ArrayList();
    }

    public TileGroupsPacket(ArrayList<TileGroup> tileGroups, int atlasID, int dimension) {
        this.tileGroups = tileGroups;
        this.atlasID = atlasID;
        this.dimension = dimension;
    }

    @Override
    protected void read(PacketBuffer buffer) throws IOException {
        this.atlasID = buffer.func_150792_a();
        this.dimension = buffer.func_150792_a();
        int length = buffer.func_150792_a();
        this.tileGroups = new ArrayList(length);
        for (int i = 0; i < length; ++i) {
            TileGroup newbie = new TileGroup(0, 0);
            newbie.readFromNBT(TileGroupsPacket.readNBT((ByteBuf)buffer));
            this.tileGroups.add(newbie);
        }
    }

    @Override
    protected void write(PacketBuffer buffer) throws IOException {
        buffer.func_150787_b(this.atlasID);
        buffer.func_150787_b(this.dimension);
        buffer.func_150787_b(this.tileGroups.size());
        for (TileGroup t : this.tileGroups) {
            NBTTagCompound me = new NBTTagCompound();
            t.writeToNBT(me);
            TileGroupsPacket.writeNBT((ByteBuf)buffer, me);
        }
    }

    @Override
    protected void process(EntityPlayer player, Side side) {
        AtlasData atlasData = AntiqueAtlasMod.atlasData.getAtlasData(this.atlasID, player.field_70170_p);
        DimensionData dimData = atlasData.getDimensionData(this.dimension);
        for (TileGroup t : this.tileGroups) {
            dimData.putTileGroup(t);
        }
    }
}

