/*
 * Decompiled with CFR 0.152.
 */
package hunternif.mc.atlas.item;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.PlayerEvent;
import hunternif.mc.atlas.AntiqueAtlasMod;
import hunternif.mc.atlas.core.AtlasData;
import hunternif.mc.atlas.marker.Marker;
import hunternif.mc.atlas.marker.MarkersData;
import java.util.ArrayList;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.world.World;

public class RecipeAtlasCombining
implements IRecipe {
    public boolean func_77569_a(InventoryCrafting inv, World world) {
        return this.matches((IInventory)inv);
    }

    private boolean matches(IInventory inv) {
        int atlasesFound = 0;
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack stack = inv.func_70301_a(i);
            if (stack == null || stack.func_77973_b() != AntiqueAtlasMod.itemAtlas) continue;
            ++atlasesFound;
        }
        return atlasesFound > 1;
    }

    public ItemStack func_77572_b(InventoryCrafting inv) {
        ItemStack firstAtlas = null;
        ArrayList<Integer> atlasIds = new ArrayList<Integer>(9);
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack stack = inv.func_70301_a(i);
            if (stack == null || stack.func_77973_b() != AntiqueAtlasMod.itemAtlas) continue;
            if (firstAtlas == null) {
                firstAtlas = stack;
                continue;
            }
            atlasIds.add(stack.func_77960_j());
        }
        if (atlasIds.size() < 1) {
            return null;
        }
        return firstAtlas;
    }

    public int func_77570_a() {
        return 9;
    }

    public ItemStack func_77571_b() {
        return null;
    }

    @SubscribeEvent
    public void onCrafted(PlayerEvent.ItemCraftedEvent event) {
        if (event.crafting.func_77973_b() != AntiqueAtlasMod.itemAtlas || !this.matches(event.craftMatrix)) {
            return;
        }
        World world = event.player.field_70170_p;
        if (world.field_72995_K) {
            return;
        }
        int atlasID = world.func_72841_b("aAtlas");
        AtlasData destBiomes = AntiqueAtlasMod.atlasData.getAtlasData(atlasID, world);
        destBiomes.func_76185_a();
        MarkersData destMarkers = AntiqueAtlasMod.markersData.getMarkersData(atlasID, world);
        destMarkers.func_76185_a();
        for (int i = 0; i < event.craftMatrix.func_70302_i_(); ++i) {
            ItemStack stack = event.craftMatrix.func_70301_a(i);
            if (stack == null) continue;
            AtlasData srcBiomes = AntiqueAtlasMod.atlasData.getAtlasData(stack, world);
            if (destBiomes != null && srcBiomes != null && destBiomes != srcBiomes) {
                for (int dim : srcBiomes.getVisitedDimensions()) {
                    destBiomes.getSeenChunksInDimension(dim).putAll(srcBiomes.getSeenChunksInDimension(dim));
                }
            }
            MarkersData srcMarkers = AntiqueAtlasMod.markersData.getMarkersData(stack, world);
            if (destMarkers == null || srcMarkers == null || destMarkers == srcMarkers) continue;
            for (int dim : srcMarkers.getVisitedDimensions()) {
                for (Marker marker : srcMarkers.getMarkersDataInDimension(dim).getAllMarkers()) {
                    destMarkers.createAndSaveMarker(marker.getType(), marker.getLabel(), dim, marker.getX(), marker.getZ(), marker.isVisibleAhead());
                }
            }
        }
        event.crafting.func_77964_b(atlasID);
    }
}

