/*
 * Decompiled with CFR 0.152.
 */
package hunternif.mc.atlas.core;

import hunternif.mc.atlas.core.Tile;
import hunternif.mc.atlas.util.Log;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.WorldSavedData;

class DimensionSubData
extends WorldSavedData {
    public static final String VERSION_NUMBER = "v";
    public static final String X_Y_DIMENSION = "p";
    public static final String TILE_DATA = "t";
    public static final int VERSION = 1;
    public static final int WIDTH = 16;
    public static final int HEIGHT = 16;
    protected int x;
    protected int y;
    protected int dimension;
    Tile[][] tileData = new Tile[16][16];

    public DimensionSubData(String p_i2141_1_) {
        super(p_i2141_1_);
    }

    public void func_76184_a(NBTTagCompound compound) {
        int version = compound.func_74762_e(VERSION_NUMBER);
        if (version < 1) {
            Log.warn("Future atlas data format! Was %d but current is %d", version, 1);
            this.func_76185_a();
        }
        int[] pos = compound.func_74759_k(X_Y_DIMENSION);
        this.x = pos[0];
        this.y = pos[1];
        this.dimension = pos[2];
        int[] array = compound.func_74759_k(TILE_DATA);
        for (int i = 0; i < array.length; ++i) {
            this.tileData[i % 16][i / 16] = new Tile(array[i]);
        }
    }

    public void func_76187_b(NBTTagCompound compound) {
        compound.func_74768_a(VERSION_NUMBER, 1);
        int[] pos = new int[]{this.x, this.y, this.dimension};
        compound.func_74783_a(X_Y_DIMENSION, pos);
        int[] array = new int[256];
        for (int x = 0; x < 16; ++x) {
            for (int y = 0; y < 16; ++y) {
                array[y * 16 + x] = this.tileData[x][y].biomeID;
            }
        }
        compound.func_74783_a(TILE_DATA, array);
    }
}

