/*
 * Decompiled with CFR 0.152.
 */
package hunternif.mc.atlas.core;

import hunternif.mc.atlas.core.IBiomeDetector;
import hunternif.mc.atlas.ext.ExtTileIdMap;
import hunternif.mc.atlas.util.ByteUtil;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.BiomeDictionary;

public class BiomeDetectorBase
implements IBiomeDetector {
    private boolean doScanPonds = true;
    private static final int waterPoolBiomeID = BiomeGenBase.field_76781_i.field_76756_M;
    private static final int priorityWaterPool = 3;
    private static final int prioritylavaPool = 6;
    private static final boolean[] waterBiomes = new boolean[256];
    private static final boolean[] beachBiomes = new boolean[256];

    public static void scanBiomeTypes() {
        for (BiomeGenBase biome : BiomeDictionary.getBiomesForType((BiomeDictionary.Type)BiomeDictionary.Type.WATER)) {
            BiomeDetectorBase.waterBiomes[biome.field_76756_M] = true;
        }
        for (BiomeGenBase biome : BiomeDictionary.getBiomesForType((BiomeDictionary.Type)BiomeDictionary.Type.BEACH)) {
            BiomeDetectorBase.beachBiomes[biome.field_76756_M] = true;
        }
    }

    public void setScanPonds(boolean value) {
        this.doScanPonds = value;
    }

    protected int priorityForBiome(BiomeGenBase biome) {
        if (waterBiomes[biome.field_76756_M]) {
            return 4;
        }
        if (beachBiomes[biome.field_76756_M]) {
            return 3;
        }
        return 1;
    }

    @Override
    public int getBiomeID(Chunk chunk) {
        BiomeGenBase[] biomes = BiomeGenBase.func_150565_n();
        int[] chunkBiomes = ByteUtil.unsignedByteToIntArray(chunk.func_76605_m());
        int[] biomeOccurrences = new int[biomes.length];
        int lavaOccurences = 0;
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                int y;
                int biomeID = chunkBiomes[x << 4 | z];
                if (this.doScanPonds && (y = chunk.func_76611_b(x, z)) > 0) {
                    Block topBlock = chunk.func_150810_a(x, y - 1, z);
                    Block topBlock2 = chunk.func_150810_a(x, y, z);
                    if (topBlock == Blocks.field_150355_j && biomeID != BiomeGenBase.field_76780_h.field_76756_M && biomeID != BiomeGenBase.field_76780_h.field_76756_M + 128) {
                        int n = waterPoolBiomeID;
                        biomeOccurrences[n] = biomeOccurrences[n] + 3;
                    } else if (topBlock2 == Blocks.field_150353_l) {
                        lavaOccurences += 6;
                    }
                }
                if (biomeID < 0 || biomeID >= biomes.length || biomes[biomeID] == null) continue;
                int n = biomeID;
                biomeOccurrences[n] = biomeOccurrences[n] + this.priorityForBiome(biomes[biomeID]);
            }
        }
        int meanBiomeId = -1;
        int meanBiomeOccurences = 0;
        for (int i = 0; i < biomeOccurrences.length; ++i) {
            if (biomeOccurrences[i] <= meanBiomeOccurences) continue;
            meanBiomeId = i;
            meanBiomeOccurences = biomeOccurrences[i];
        }
        if (meanBiomeOccurences < lavaOccurences) {
            return ExtTileIdMap.instance().getPseudoBiomeID("lava");
        }
        return meanBiomeId;
    }
}

