/*
 * Decompiled with CFR 0.152.
 */
package hunternif.mc.atlas.client.gui;

import com.google.common.collect.ImmutableMap;
import hunternif.mc.atlas.client.Textures;
import hunternif.mc.atlas.client.gui.core.GuiComponent;
import hunternif.mc.atlas.util.AtlasRenderHelper;
import java.util.Arrays;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.ResourceLocation;

public class GuiScaleBar
extends GuiComponent {
    public static final int WIDTH = 20;
    public static final int HEIGHT = 8;
    private static Map<Double, ResourceLocation> textureMap;
    private double mapScale;

    public GuiScaleBar() {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.put((Object)0.0625, (Object)Textures.SCALEBAR_512);
        builder.put((Object)0.125, (Object)Textures.SCALEBAR_256);
        builder.put((Object)0.25, (Object)Textures.SCALEBAR_128);
        builder.put((Object)0.5, (Object)Textures.SCALEBAR_64);
        builder.put((Object)1.0, (Object)Textures.SCALEBAR_32);
        builder.put((Object)2.0, (Object)Textures.SCALEBAR_16);
        builder.put((Object)4.0, (Object)Textures.SCALEBAR_8);
        builder.put((Object)8.0, (Object)Textures.SCALEBAR_4);
        textureMap = builder.build();
        this.mapScale = 1.0;
        this.setSize(20, 8);
    }

    public void setMapScale(double scale) {
        this.mapScale = scale;
    }

    private ResourceLocation getTexture() {
        return textureMap.get(this.mapScale);
    }

    public void func_73866_w_() {
        super.func_73866_w_();
    }

    @Override
    public void func_73863_a(int mouseX, int mouseY, float partialTick) {
        ResourceLocation texture = this.getTexture();
        if (texture == null) {
            return;
        }
        AtlasRenderHelper.drawFullTexture(texture, this.getGuiX(), this.getGuiY(), 20, 8);
        if (this.isMouseOver) {
            this.drawTooltip(Arrays.asList(I18n.func_135052_a((String)"gui.antiqueatlas.scalebar", (Object[])new Object[0])), Minecraft.func_71410_x().field_71466_p);
        }
    }
}

