/*
 * Decompiled with CFR 0.152.
 */
package hunternif.mc.atlas.client;

import hunternif.mc.atlas.client.BiomeTextureMap;
import hunternif.mc.atlas.client.SubTile;
import hunternif.mc.atlas.client.SubTileQuartet;
import hunternif.mc.atlas.client.TextureSet;
import hunternif.mc.atlas.core.ITileStorage;
import hunternif.mc.atlas.core.Tile;
import hunternif.mc.atlas.util.Rect;
import java.util.Iterator;

public class TileRenderIterator
implements Iterator<SubTileQuartet> {
    private final ITileStorage tiles;
    private int step = 1;
    private final Rect scope = new Rect();
    private Tile a;
    private Tile b;
    private Tile c;
    private Tile d;
    private Tile e;
    private Tile f;
    private Tile g;
    private Tile h;
    private Tile i;
    private Tile j;
    private Tile k;
    private Tile l;
    private final SubTile _d = new SubTile(SubTile.Part.BOTTOM_RIGHT);
    private final SubTile _e = new SubTile(SubTile.Part.BOTTOM_LEFT);
    private final SubTile _h = new SubTile(SubTile.Part.TOP_RIGHT);
    private final SubTile _i = new SubTile(SubTile.Part.TOP_LEFT);
    private final SubTileQuartet quartet = new SubTileQuartet(this._d, this._e, this._h, this._i);
    private int chunkX;
    private int chunkY;
    private int subtileX = -1;
    private int subtileY = -1;

    public void setStep(int step) {
        if (step >= 1) {
            this.step = step;
        }
    }

    public void setScope(int minX, int minY, int maxX, int maxY) {
        this.scope.set(minX, minY, maxX, maxY);
        this.chunkX = minX;
        this.chunkY = minY;
    }

    public void setScope(Rect scope) {
        this.scope.set(scope);
        this.chunkX = scope.minX;
        this.chunkY = scope.minY;
    }

    public TileRenderIterator(ITileStorage tiles) {
        this.tiles = tiles;
        this.setScope(tiles.getScope());
    }

    @Override
    public boolean hasNext() {
        return this.chunkX >= this.scope.minX && this.chunkX <= this.scope.maxX + 1 && this.chunkY >= this.scope.minY && this.chunkY <= this.scope.maxY + 1;
    }

    @Override
    public SubTileQuartet next() {
        this.a = this.b;
        this.b = this.tiles.getTile(this.chunkX, this.chunkY - this.step * 2);
        this.c = this.d;
        this.d = this.e;
        this.e = this.f;
        this.f = this.tiles.getTile(this.chunkX + this.step, this.chunkY - this.step);
        this.g = this.h;
        this.h = this.i;
        this.i = this.j;
        this.j = this.tiles.getTile(this.chunkX + this.step, this.chunkY);
        this.k = this.l;
        this.l = this.tiles.getTile(this.chunkX, this.chunkY + this.step);
        this.quartet.setCoords(this.subtileX, this.subtileY);
        this._d.tile = this.d;
        this._e.tile = this.e;
        this._h.tile = this.h;
        this._i.tile = this.i;
        for (SubTile subtile : this.quartet) {
            subtile.shape = SubTile.Shape.CONVEX;
        }
        if (TileRenderIterator.shouldStitchToHorizontally(this.d, this.e)) {
            TileRenderIterator.stitchHorizontally(this._d);
        }
        if (TileRenderIterator.shouldStitchToHorizontally(this.e, this.d)) {
            TileRenderIterator.stitchHorizontally(this._e);
        }
        if (TileRenderIterator.shouldStitchToHorizontally(this.h, this.i)) {
            TileRenderIterator.stitchHorizontally(this._h);
        }
        if (TileRenderIterator.shouldStitchToHorizontally(this.i, this.h)) {
            TileRenderIterator.stitchHorizontally(this._i);
        }
        if (TileRenderIterator.shouldStitchToVertically(this.d, this.h)) {
            TileRenderIterator.stitchVertically(this._d);
            if (this._d.shape == SubTile.Shape.CONCAVE && TileRenderIterator.shouldStitchTo(this.d, this.i)) {
                this._d.shape = SubTile.Shape.FULL;
            }
        }
        if (TileRenderIterator.shouldStitchToVertically(this.h, this.d)) {
            TileRenderIterator.stitchVertically(this._h);
            if (this._h.shape == SubTile.Shape.CONCAVE && TileRenderIterator.shouldStitchTo(this.h, this.e)) {
                this._h.shape = SubTile.Shape.FULL;
            }
        }
        if (TileRenderIterator.shouldStitchToVertically(this.e, this.i)) {
            TileRenderIterator.stitchVertically(this._e);
            if (this._e.shape == SubTile.Shape.CONCAVE && TileRenderIterator.shouldStitchTo(this.e, this.h)) {
                this._e.shape = SubTile.Shape.FULL;
            }
        }
        if (TileRenderIterator.shouldStitchToVertically(this.i, this.e)) {
            TileRenderIterator.stitchVertically(this._i);
            if (this._i.shape == SubTile.Shape.CONCAVE && TileRenderIterator.shouldStitchTo(this.i, this.d)) {
                this._i.shape = SubTile.Shape.FULL;
            }
        }
        if (this._d.shape == SubTile.Shape.CONVEX && !TileRenderIterator.shouldStitchToVertically(this.d, this.a) && !TileRenderIterator.shouldStitchToHorizontally(this.d, this.c)) {
            this._d.shape = SubTile.Shape.SINGLE_OBJECT;
        }
        if (this._e.shape == SubTile.Shape.CONVEX && !TileRenderIterator.shouldStitchToVertically(this.e, this.b) && !TileRenderIterator.shouldStitchToHorizontally(this.e, this.f)) {
            this._e.shape = SubTile.Shape.SINGLE_OBJECT;
        }
        if (this._h.shape == SubTile.Shape.CONVEX && !TileRenderIterator.shouldStitchToHorizontally(this.h, this.g) && !TileRenderIterator.shouldStitchToVertically(this.h, this.k)) {
            this._h.shape = SubTile.Shape.SINGLE_OBJECT;
        }
        if (this._i.shape == SubTile.Shape.CONVEX && !TileRenderIterator.shouldStitchToHorizontally(this.i, this.j) && !TileRenderIterator.shouldStitchToVertically(this.i, this.l)) {
            this._i.shape = SubTile.Shape.SINGLE_OBJECT;
        }
        this.chunkX += this.step;
        this.subtileX += 2;
        if (this.chunkX > this.scope.maxX + 1) {
            this.chunkX = this.scope.minX;
            this.subtileX = -1;
            this.chunkY += this.step;
            this.subtileY += 2;
            this.a = null;
            this.b = null;
            this.c = null;
            this.d = null;
            this.e = null;
            this.f = this.tiles.getTile(this.chunkX, this.chunkY - this.step);
            this.g = null;
            this.h = null;
            this.i = null;
            this.j = this.tiles.getTile(this.chunkX, this.chunkY);
            this.k = null;
            this.l = null;
        }
        return this.quartet;
    }

    private static boolean shouldStitchTo(Tile tile, Tile to) {
        if (tile == null) {
            return false;
        }
        TextureSet set = BiomeTextureMap.instance().getTextureSet(tile);
        TextureSet toSet = BiomeTextureMap.instance().getTextureSet(to);
        return set == null ? false : set.shouldStitchTo(toSet);
    }

    private static boolean shouldStitchToHorizontally(Tile tile, Tile to) {
        if (tile == null) {
            return false;
        }
        TextureSet set = BiomeTextureMap.instance().getTextureSet(tile);
        TextureSet toSet = BiomeTextureMap.instance().getTextureSet(to);
        return set == null ? false : set.shouldStitchToHorizontally(toSet);
    }

    private static boolean shouldStitchToVertically(Tile tile, Tile to) {
        if (tile == null) {
            return false;
        }
        TextureSet set = BiomeTextureMap.instance().getTextureSet(tile);
        TextureSet toSet = BiomeTextureMap.instance().getTextureSet(to);
        return set == null ? false : set.shouldStitchToVertically(toSet);
    }

    private static void stitchVertically(SubTile subtile) {
        if (subtile.shape == SubTile.Shape.HORIZONTAL) {
            subtile.shape = SubTile.Shape.CONCAVE;
        }
        if (subtile.shape == SubTile.Shape.CONVEX) {
            subtile.shape = SubTile.Shape.VERTICAL;
        }
    }

    private static void stitchHorizontally(SubTile subtile) {
        if (subtile.shape == SubTile.Shape.VERTICAL) {
            subtile.shape = SubTile.Shape.CONCAVE;
        }
        if (subtile.shape == SubTile.Shape.CONVEX) {
            subtile.shape = SubTile.Shape.HORIZONTAL;
        }
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("cannot remove subtiles from tile storage");
    }
}

