/*
 * Decompiled with CFR 0.152.
 */
package hunternif.mc.atlas.network.client;

import hunternif.mc.atlas.AntiqueAtlasMod;
import hunternif.mc.atlas.core.AtlasData;
import hunternif.mc.atlas.core.Tile;
import hunternif.mc.atlas.network.AbstractMessage;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.io.IOException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.relauncher.Side;

public class DimensionUpdatePacket
extends AbstractMessage.AbstractClientMessage<DimensionUpdatePacket> {
    private static final int ENTRY_SIZE_BYTES = 6;
    private int atlasID;
    private int dimension;
    private int tileCount;
    private ByteBuf tileData;

    public DimensionUpdatePacket() {
    }

    public DimensionUpdatePacket(int atlasID, int dimension) {
        this.dimension = dimension;
        this.tileCount = 0;
        this.tileData = Unpooled.buffer();
    }

    public DimensionUpdatePacket addTile(int x, int y, int biomeID) {
        this.tileData.writeShort(x);
        this.tileData.writeShort(y);
        this.tileData.writeShort(biomeID);
        ++this.tileCount;
        return this;
    }

    public boolean isEmpty() {
        return this.tileCount == 0;
    }

    @Override
    public void read(PacketBuffer buffer) throws IOException {
        this.atlasID = buffer.func_150792_a();
        this.dimension = buffer.func_150792_a();
        this.tileCount = buffer.func_150792_a();
        this.tileData = buffer.readBytes(this.tileCount * 6);
    }

    @Override
    public void write(PacketBuffer buffer) throws IOException {
        buffer.func_150787_b(this.atlasID);
        buffer.func_150787_b(this.dimension);
        buffer.func_150787_b(this.tileCount);
        buffer.writeBytes(this.tileData);
    }

    @Override
    protected void process(EntityPlayer player, Side side) {
        AtlasData data = AntiqueAtlasMod.atlasData.getAtlasData(this.atlasID, player.field_70170_p);
        for (int i = 0; i < this.tileCount; ++i) {
            data.getDimensionData(this.dimension).setTile(this.tileData.readShort(), this.tileData.readShort(), new Tile(this.tileData.readShort()));
        }
    }
}

