/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.alexsmobs.entity.ai;

import com.github.alexthe666.alexsmobs.AlexsMobs;
import com.github.alexthe666.alexsmobs.entity.EntityElephant;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.util.math.vector.Vector3d;

public class ElephantAIFollowCaravan
extends Goal {
    public final EntityElephant elephant;
    private double speedModifier;
    private int distCheckCounter;

    public ElephantAIFollowCaravan(EntityElephant llamaIn, double speedModifierIn) {
        this.elephant = llamaIn;
        this.speedModifier = speedModifierIn;
        this.func_220684_a(EnumSet.of(Goal.Flag.MOVE));
    }

    public boolean func_75250_a() {
        if (this.elephant.aiItemFlag || this.elephant.func_184179_bs() != null) {
            return false;
        }
        if (!(this.elephant.isTusked() || this.elephant.inCaravan() || this.elephant.isSitting())) {
            double dist = 32.0;
            List list = this.elephant.field_70170_p.func_217357_a(EntityElephant.class, this.elephant.func_174813_aQ().func_72314_b(dist, dist / 2.0, dist));
            EntityElephant elephant = null;
            double d0 = Double.MAX_VALUE;
            for (Entity entity : list) {
                double d1;
                EntityElephant elephant1 = (EntityElephant)entity;
                if (!elephant1.inCaravan() || elephant1.hasCaravanTrail() || (d1 = this.elephant.func_70068_e((Entity)elephant1)) > d0) continue;
                d0 = d1;
                elephant = elephant1;
            }
            if (elephant == null) {
                for (Entity entity1 : list) {
                    double d2;
                    EntityElephant llamaentity2 = (EntityElephant)entity1;
                    if (!llamaentity2.isTusked() || llamaentity2.func_70631_g_() || llamaentity2.hasCaravanTrail() || (d2 = this.elephant.func_70068_e((Entity)llamaentity2)) > d0) continue;
                    d0 = d2;
                    elephant = llamaentity2;
                }
            }
            if (elephant == null) {
                return false;
            }
            if (d0 < 5.0) {
                return false;
            }
            if (!(elephant.isTusked() || elephant.func_70631_g_() || this.firstIsTusk(elephant, 1))) {
                return false;
            }
            this.elephant.joinCaravan(elephant);
            return true;
        }
        return false;
    }

    public boolean func_75253_b() {
        if (this.elephant.isSitting() || this.elephant.aiItemFlag) {
            return false;
        }
        if (this.elephant.inCaravan() && this.elephant.getCaravanHead().func_70089_S() && this.firstIsTusk(this.elephant, 0)) {
            double d0 = this.elephant.func_70068_e((Entity)this.elephant.getCaravanHead());
            if (d0 > 676.0) {
                if (this.speedModifier <= 1.0) {
                    this.speedModifier *= 1.2;
                    this.distCheckCounter = 40;
                    return true;
                }
                if (this.distCheckCounter == 0) {
                    return false;
                }
            }
            if (this.distCheckCounter > 0) {
                --this.distCheckCounter;
            }
            return true;
        }
        return false;
    }

    public void func_75251_c() {
        this.elephant.leaveCaravan();
        this.speedModifier = 1.0;
    }

    public void func_75246_d() {
        EntityElephant llamaentity;
        if (this.elephant.inCaravan() && !this.elephant.isSitting() && (llamaentity = this.elephant.getCaravanHead()) != null) {
            double d0 = this.elephant.func_70032_d((Entity)llamaentity);
            Vector3d vector3d = new Vector3d(llamaentity.func_226277_ct_() - this.elephant.func_226277_ct_(), llamaentity.func_226278_cu_() - this.elephant.func_226278_cu_(), llamaentity.func_226281_cx_() - this.elephant.func_226281_cx_()).func_72432_b().func_186678_a(Math.max(d0 - 4.0, 0.0));
            if (this.elephant.func_70661_as().func_75500_f()) {
                try {
                    this.elephant.func_70661_as().func_75492_a(this.elephant.func_226277_ct_() + vector3d.field_72450_a, this.elephant.func_226278_cu_() + vector3d.field_72448_b, this.elephant.func_226281_cx_() + vector3d.field_72449_c, this.speedModifier);
                }
                catch (NullPointerException e) {
                    AlexsMobs.LOGGER.warn("elephant encountered issue following caravan head");
                }
            }
        }
    }

    private boolean firstIsTusk(EntityElephant llama, int p_190858_2_) {
        if (p_190858_2_ > 8) {
            return false;
        }
        if (llama.inCaravan()) {
            if (llama.getCaravanHead().isTusked() && !llama.getCaravanHead().func_70631_g_()) {
                return true;
            }
            EntityElephant llamaentity = llama.getCaravanHead();
            return this.firstIsTusk(llamaentity, ++p_190858_2_);
        }
        return false;
    }
}

