/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.alexsmobs.entity;

import com.github.alexthe666.alexsmobs.entity.AMEntityRegistry;
import com.github.alexthe666.alexsmobs.entity.EntityOrca;
import com.github.alexthe666.alexsmobs.entity.IHerdPanic;
import com.github.alexthe666.alexsmobs.entity.ISemiAquatic;
import com.github.alexthe666.alexsmobs.entity.ITargetsDroppedItems;
import com.github.alexthe666.alexsmobs.entity.ai.AnimalAIFindWater;
import com.github.alexthe666.alexsmobs.entity.ai.AnimalAIHerdPanic;
import com.github.alexthe666.alexsmobs.entity.ai.AnimalAILeaveWater;
import com.github.alexthe666.alexsmobs.entity.ai.AquaticMoveController;
import com.github.alexthe666.alexsmobs.entity.ai.CreatureAITargetItems;
import com.github.alexthe666.alexsmobs.entity.ai.GroundPathNavigatorWide;
import com.github.alexthe666.alexsmobs.entity.ai.SealAIBask;
import com.github.alexthe666.alexsmobs.entity.ai.SealAIDiveForItems;
import com.github.alexthe666.alexsmobs.entity.ai.SemiAquaticPathNavigator;
import com.github.alexthe666.alexsmobs.item.AMItemRegistry;
import com.github.alexthe666.alexsmobs.misc.AMSoundRegistry;
import com.github.alexthe666.alexsmobs.misc.AMTagRegistry;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.controller.MovementController;
import net.minecraft.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.entity.ai.goal.BreatheAirGoal;
import net.minecraft.entity.ai.goal.BreedGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.ai.goal.RandomSwimmingGoal;
import net.minecraft.entity.ai.goal.TemptGoal;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.BlockParticleData;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.DamageSource;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biomes;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.BiomeDictionary;

public class EntitySeal
extends AnimalEntity
implements ISemiAquatic,
IHerdPanic,
ITargetsDroppedItems {
    private static final DataParameter<Float> SWIM_ANGLE = EntityDataManager.func_187226_a(EntitySeal.class, (IDataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Boolean> BASKING = EntityDataManager.func_187226_a(EntitySeal.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> DIGGING = EntityDataManager.func_187226_a(EntitySeal.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> ARCTIC = EntityDataManager.func_187226_a(EntitySeal.class, (IDataSerializer)DataSerializers.field_187198_h);
    public float prevSwimAngle;
    public float prevBaskProgress;
    public float baskProgress;
    public float prevDigProgress;
    public float digProgress;
    public int revengeCooldown = 0;
    public UUID feederUUID = null;
    private int baskingTimer = 0;
    private int swimTimer = -1000;
    private int ticksSinceInWater = 0;
    private boolean isLandNavigator;
    public int fishFeedings = 0;

    protected EntitySeal(EntityType type, World worldIn) {
        super(type, worldIn);
        this.func_184644_a(PathNodeType.WATER, 0.0f);
        this.func_184644_a(PathNodeType.WATER_BORDER, 0.0f);
        this.switchNavigator(false);
    }

    protected SoundEvent func_184639_G() {
        return AMSoundRegistry.SEAL_IDLE;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return AMSoundRegistry.SEAL_HURT;
    }

    protected SoundEvent func_184615_bR() {
        return AMSoundRegistry.SEAL_HURT;
    }

    public static AttributeModifierMap.MutableAttribute bakeAttributes() {
        return MonsterEntity.func_234295_eP_().func_233815_a_(Attributes.field_233818_a_, 10.0).func_233815_a_(Attributes.field_233823_f_, 2.0).func_233815_a_(Attributes.field_233821_d_, (double)0.18f);
    }

    public static boolean canSealSpawn(EntityType<? extends AnimalEntity> animal, IWorld worldIn, SpawnReason reason, BlockPos pos, Random random) {
        Optional optional = worldIn.func_242406_i(pos);
        if (!Objects.equals(optional, Optional.of(Biomes.field_76776_l)) && !Objects.equals(optional, Optional.of(Biomes.field_203620_Z))) {
            boolean spawnBlock = BlockTags.func_199896_a().func_199910_a(AMTagRegistry.SEAL_SPAWNS).func_230235_a_((Object)worldIn.func_180495_p(pos.func_177977_b()).func_177230_c());
            return spawnBlock && worldIn.func_226659_b_(pos, 0) > 8;
        }
        return worldIn.func_226659_b_(pos, 0) > 8 && worldIn.func_180495_p(pos.func_177977_b()).func_203425_a(Blocks.field_150432_aD);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (Goal)new SealAIBask(this));
        this.field_70714_bg.func_75776_a(1, (Goal)new BreatheAirGoal((CreatureEntity)this));
        this.field_70714_bg.func_75776_a(2, (Goal)new BreedGoal((AnimalEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(3, (Goal)new AnimalAIFindWater((CreatureEntity)this));
        this.field_70714_bg.func_75776_a(3, (Goal)new AnimalAILeaveWater((CreatureEntity)this));
        this.field_70714_bg.func_75776_a(4, (Goal)new AnimalAIHerdPanic((CreatureEntity)this, 1.6));
        this.field_70714_bg.func_75776_a(5, (Goal)new MeleeAttackGoal((CreatureEntity)this, 1.0, true));
        this.field_70714_bg.func_75776_a(6, (Goal)new SealAIDiveForItems(this));
        this.field_70714_bg.func_75776_a(7, (Goal)new RandomSwimmingGoal((CreatureEntity)this, 1.0, 7));
        this.field_70714_bg.func_75776_a(8, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(8, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 6.0f));
        this.field_70714_bg.func_75776_a(9, (Goal)new AvoidEntityGoal((CreatureEntity)this, EntityOrca.class, 20.0f, 1.3, 1.0));
        this.field_70714_bg.func_75776_a(10, (Goal)new TemptGoal((CreatureEntity)this, 1.1, Ingredient.func_199805_a((ITag)ItemTags.func_199903_a().func_199910_a(AMTagRegistry.SEAL_FOODSTUFFS)), false));
        this.field_70715_bh.func_75776_a(1, new CreatureAITargetItems((CreatureEntity)this, false));
    }

    private void switchNavigator(boolean onLand) {
        if (onLand) {
            this.field_70765_h = new MovementController((MobEntity)this);
            this.field_70699_by = new GroundPathNavigatorWide((MobEntity)this, this.field_70170_p);
            this.isLandNavigator = true;
        } else {
            this.field_70765_h = new AquaticMoveController((CreatureEntity)this, 1.5f);
            this.field_70699_by = new SemiAquaticPathNavigator((MobEntity)this, this.field_70170_p);
            this.isLandNavigator = false;
        }
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        boolean prev = super.func_70097_a(source, amount);
        if (prev) {
            int fleeTime;
            double range = 15.0;
            this.revengeCooldown = fleeTime = 100 + this.func_70681_au().nextInt(150);
            List list = this.field_70170_p.func_217357_a(this.getClass(), this.func_174813_aQ().func_72314_b(range, range / 2.0, range));
            for (EntitySeal gaz : list) {
                gaz.revengeCooldown = fleeTime;
                gaz.setBasking(false);
            }
            this.setBasking(false);
        }
        return prev;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(SWIM_ANGLE, (Object)Float.valueOf(0.0f));
        this.field_70180_af.func_187214_a(BASKING, (Object)false);
        this.field_70180_af.func_187214_a(DIGGING, (Object)false);
        this.field_70180_af.func_187214_a(ARCTIC, (Object)false);
    }

    public float getSwimAngle() {
        return ((Float)this.field_70180_af.func_187225_a(SWIM_ANGLE)).floatValue();
    }

    public void setSwimAngle(float progress) {
        this.field_70180_af.func_187227_b(SWIM_ANGLE, (Object)Float.valueOf(progress));
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        this.prevBaskProgress = this.baskProgress;
        this.prevDigProgress = this.digProgress;
        this.prevSwimAngle = this.getSwimAngle();
        boolean dig = this.isDigging() && this.func_203005_aq();
        float f2 = (float)(-((double)((float)this.func_213322_ci().field_72448_b) * 57.2957763671875));
        if (this.func_70090_H()) {
            this.field_70125_A = f2 * 2.5f;
        }
        if (this.func_70090_H() && this.isLandNavigator) {
            this.switchNavigator(false);
        }
        if (!this.func_70090_H() && !this.isLandNavigator) {
            this.switchNavigator(true);
        }
        if (this.isBasking() && this.baskProgress < 5.0f) {
            this.baskProgress += 1.0f;
        }
        if (!this.isBasking() && this.baskProgress > 0.0f) {
            this.baskProgress -= 1.0f;
        }
        if (dig && this.digProgress < 5.0f) {
            this.digProgress += 1.0f;
        }
        if (!dig && this.digProgress > 0.0f) {
            this.digProgress -= 1.0f;
        }
        if (dig && this.field_70170_p.func_180495_p(this.func_226270_aj_()).func_200132_m()) {
            BlockPos posit = this.func_226270_aj_();
            BlockState understate = this.field_70170_p.func_180495_p(posit);
            for (int i = 0; i < 4 + this.field_70146_Z.nextInt(2); ++i) {
                double particleX = (float)posit.func_177958_n() + this.field_70146_Z.nextFloat();
                double particleY = (float)posit.func_177956_o() + 1.0f;
                double particleZ = (float)posit.func_177952_p() + this.field_70146_Z.nextFloat();
                double motX = this.field_70146_Z.nextGaussian() * 0.02;
                double motY = 0.1f + this.field_70146_Z.nextFloat() * 0.2f;
                double motZ = this.field_70146_Z.nextGaussian() * 0.02;
                this.field_70170_p.func_195594_a((IParticleData)new BlockParticleData(ParticleTypes.field_197611_d, understate), particleX, particleY, particleZ, motX, motY, motZ);
            }
        }
        if (!this.field_70170_p.field_72995_K) {
            if (this.isBasking()) {
                if (this.func_70643_av() != null || this.func_70880_s() || this.revengeCooldown > 0 || this.func_203005_aq() || this.func_70638_az() != null || this.baskingTimer > 1000 && this.func_70681_au().nextInt(100) == 0) {
                    this.setBasking(false);
                }
            } else if (!(this.func_70638_az() != null || this.func_70880_s() || this.func_70643_av() != null || this.revengeCooldown != 0 || this.isBasking() || this.baskingTimer != 0 || this.func_70681_au().nextInt(15) != 0 || this.func_203005_aq())) {
                this.setBasking(true);
            }
            if (this.revengeCooldown > 0) {
                --this.revengeCooldown;
            }
            if (this.revengeCooldown == 0 && this.func_70643_av() != null) {
                this.func_70604_c(null);
            }
            float threshold = 0.05f;
            if (this.func_70090_H() && this.field_70126_B - this.field_70177_z > threshold) {
                this.setSwimAngle(this.getSwimAngle() + 2.0f);
            } else if (this.func_70090_H() && this.field_70126_B - this.field_70177_z < -threshold) {
                this.setSwimAngle(this.getSwimAngle() - 2.0f);
            } else if (this.getSwimAngle() > 0.0f) {
                this.setSwimAngle(Math.max(this.getSwimAngle() - 10.0f, 0.0f));
            } else if (this.getSwimAngle() < 0.0f) {
                this.setSwimAngle(Math.min(this.getSwimAngle() + 10.0f, 0.0f));
            }
            this.setSwimAngle(MathHelper.func_76131_a((float)this.getSwimAngle(), (float)-70.0f, (float)70.0f));
            this.baskingTimer = this.isBasking() ? ++this.baskingTimer : 0;
            if (this.func_70090_H()) {
                ++this.swimTimer;
                this.ticksSinceInWater = 0;
            } else {
                ++this.ticksSinceInWater;
                --this.swimTimer;
            }
        }
    }

    public boolean isBasking() {
        return (Boolean)this.field_70180_af.func_187225_a(BASKING);
    }

    public void setBasking(boolean basking) {
        this.field_70180_af.func_187227_b(BASKING, (Object)basking);
    }

    public boolean isDigging() {
        return (Boolean)this.field_70180_af.func_187225_a(DIGGING);
    }

    public void setDigging(boolean digging) {
        this.field_70180_af.func_187227_b(DIGGING, (Object)digging);
    }

    public boolean isArctic() {
        return (Boolean)this.field_70180_af.func_187225_a(ARCTIC);
    }

    public void setArctic(boolean arctic) {
        this.field_70180_af.func_187227_b(ARCTIC, (Object)arctic);
    }

    public int func_205010_bg() {
        return 4800;
    }

    protected int func_207300_l(int currentAir) {
        return this.func_205010_bg();
    }

    public int func_70646_bf() {
        return 1;
    }

    public int func_184649_cE() {
        return 1;
    }

    @Nullable
    public ILivingEntityData func_213386_a(IServerWorld worldIn, DifficultyInstance difficultyIn, SpawnReason reason, @Nullable ILivingEntityData spawnDataIn, @Nullable CompoundNBT dataTag) {
        this.setArctic(this.isBiomeArctic((IWorld)worldIn, this.func_233580_cy_()));
        this.func_70050_g(this.func_205010_bg());
        this.field_70125_A = 0.0f;
        return super.func_213386_a(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74757_a("Arctic", this.isArctic());
        compound.func_74757_a("Basking", this.isBasking());
        compound.func_74768_a("BaskingTimer", this.baskingTimer);
        compound.func_74768_a("SwimTimer", this.swimTimer);
        compound.func_74768_a("FishFeedings", this.fishFeedings);
        if (this.feederUUID != null) {
            compound.func_186854_a("FeederUUID", this.feederUUID);
        }
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.setArctic(compound.func_74767_n("Arctic"));
        this.setBasking(compound.func_74767_n("Basking"));
        this.baskingTimer = compound.func_74762_e("BaskingTimer");
        this.swimTimer = compound.func_74762_e("SwimTimer");
        this.fishFeedings = compound.func_74762_e("FishFeedings");
        if (compound.func_186855_b("FeederUUID")) {
            this.feederUUID = compound.func_186857_a("FeederUUID");
        }
    }

    private boolean isBiomeArctic(IWorld worldIn, BlockPos position) {
        RegistryKey biomeKey = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239720_u_, (ResourceLocation)worldIn.func_226691_t_(position).getRegistryName());
        return BiomeDictionary.hasType((RegistryKey)biomeKey, (BiomeDictionary.Type)BiomeDictionary.Type.COLD);
    }

    public void func_213352_e(Vector3d travelVector) {
        if (this.func_70613_aW() && this.func_70090_H()) {
            this.func_213309_a(this.func_70689_ay(), travelVector);
            this.func_213315_a(MoverType.SELF, this.func_213322_ci());
            this.func_213317_d(this.func_213322_ci().func_186678_a(0.9));
            if (this.func_70638_az() == null) {
                this.func_213317_d(this.func_213322_ci().func_72441_c(0.0, -0.005, 0.0));
            }
            if (this.isDigging()) {
                this.func_213317_d(this.func_213322_ci().func_72441_c(0.0, -0.02, 0.0));
            }
        } else {
            super.func_213352_e(travelVector);
        }
    }

    public boolean func_70877_b(ItemStack stack) {
        return stack.func_77973_b() == AMItemRegistry.LOBSTER_TAIL;
    }

    @Nullable
    public AgeableEntity func_241840_a(ServerWorld serverWorld, AgeableEntity ageableEntity) {
        EntitySeal seal = (EntitySeal)AMEntityRegistry.SEAL.func_200721_a((World)serverWorld);
        seal.setArctic(this.isBiomeArctic((IWorld)serverWorld, this.func_233580_cy_()));
        return seal;
    }

    @Override
    public boolean shouldEnterWater() {
        return !this.shouldLeaveWater() && this.swimTimer <= -1000;
    }

    @Override
    public boolean shouldLeaveWater() {
        if (!this.func_184188_bt().isEmpty()) {
            return false;
        }
        if (this.func_70638_az() != null && !this.func_70638_az().func_70090_H()) {
            return true;
        }
        return this.swimTimer > 600;
    }

    @Override
    public boolean shouldStopMoving() {
        return this.isBasking();
    }

    @Override
    public int getWaterSearchRange() {
        return 32;
    }

    @Override
    public boolean canTargetItem(ItemStack stack) {
        return ItemTags.func_199903_a().func_199910_a(AMTagRegistry.SEAL_FOODSTUFFS).func_230235_a_((Object)stack.func_77973_b());
    }

    @Override
    public void onGetItem(ItemEntity e) {
        if (ItemTags.func_199903_a().func_199910_a(AMTagRegistry.SEAL_FOODSTUFFS).func_230235_a_((Object)e.func_92059_d().func_77973_b())) {
            ++this.fishFeedings;
            this.func_184185_a(SoundEvents.field_219607_aG, this.func_70599_aP(), this.func_70647_i());
            if (this.fishFeedings >= 3) {
                this.feederUUID = e.func_200214_m();
                this.fishFeedings = 0;
            }
        } else {
            this.feederUUID = null;
        }
        this.func_70691_i(10.0f);
    }

    @Override
    public void onPanic() {
    }

    @Override
    public boolean canPanic() {
        return !this.isBasking();
    }
}

