/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.alexsmobs.entity;

import com.github.alexthe666.alexsmobs.config.AMConfig;
import com.github.alexthe666.alexsmobs.effect.AMEffectRegistry;
import com.github.alexthe666.alexsmobs.entity.AMEntityRegistry;
import com.github.alexthe666.alexsmobs.entity.EntityCachalotWhale;
import com.github.alexthe666.alexsmobs.entity.OrcaAIMelee;
import com.github.alexthe666.alexsmobs.entity.ai.EntityAINearestTarget3D;
import com.github.alexthe666.alexsmobs.entity.ai.OrcaAIJump;
import com.github.alexthe666.alexsmobs.entity.ai.OrcaAIMeleeJump;
import com.github.alexthe666.alexsmobs.entity.ai.SwimmerJumpPathNavigator;
import com.github.alexthe666.alexsmobs.misc.AMSoundRegistry;
import com.github.alexthe666.alexsmobs.misc.AMTagRegistry;
import com.github.alexthe666.citadel.animation.Animation;
import com.github.alexthe666.citadel.animation.AnimationHandler;
import com.github.alexthe666.citadel.animation.IAnimatedEntity;
import java.util.EnumSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityPredicate;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.Pose;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.controller.DolphinLookController;
import net.minecraft.entity.ai.controller.MovementController;
import net.minecraft.entity.ai.goal.BreatheAirGoal;
import net.minecraft.entity.ai.goal.FindWaterGoal;
import net.minecraft.entity.ai.goal.FollowBoatGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.RandomSwimmingGoal;
import net.minecraft.entity.monster.DrownedEntity;
import net.minecraft.entity.monster.GuardianEntity;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.passive.TameableEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.pathfinding.PathNavigator;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.potion.EffectInstance;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biomes;
import net.minecraft.world.server.ServerWorld;

public class EntityOrca
extends TameableEntity
implements IAnimatedEntity {
    public static final Animation ANIMATION_BITE = Animation.create((int)8);
    public static final Animation ANIMATION_TAILSWING = Animation.create((int)20);
    private static final DataParameter<Integer> MOISTNESS = EntityDataManager.func_187226_a(EntityOrca.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final EntityPredicate PLAYER_PREDICATE = new EntityPredicate().func_221013_a(24.0).func_221011_b().func_221008_a().func_221014_c();
    public int jumpCooldown;
    private int animationTick;
    private Animation currentAnimation;
    private int blockBreakCounter;
    public static final Predicate<LivingEntity> TARGET_BABY = animal -> animal.func_70631_g_();

    protected EntityOrca(EntityType type, World worldIn) {
        super(type, worldIn);
        this.func_184644_a(PathNodeType.WATER, 0.0f);
        this.field_70765_h = new MoveHelperController(this);
        this.field_70749_g = new DolphinLookController((MobEntity)this, 10);
    }

    public boolean func_213397_c(double distanceToClosestPlayer) {
        return !this.func_70909_n();
    }

    public boolean func_213380_a(IWorld worldIn, SpawnReason spawnReasonIn) {
        return AMEntityRegistry.rollSpawn(AMConfig.orcaSpawnRolls, this.func_70681_au(), spawnReasonIn);
    }

    public static AttributeModifierMap.MutableAttribute bakeAttributes() {
        return MonsterEntity.func_234295_eP_().func_233815_a_(Attributes.field_233818_a_, 60.0).func_233815_a_(Attributes.field_233819_b_, 64.0).func_233815_a_(Attributes.field_233826_i_, 0.0).func_233815_a_(Attributes.field_233823_f_, 10.0).func_233815_a_(Attributes.field_233820_c_, (double)0.7f).func_233815_a_(Attributes.field_233821_d_, (double)1.35f);
    }

    protected PathNavigator func_175447_b(World worldIn) {
        return new SwimmerJumpPathNavigator((MobEntity)this, worldIn);
    }

    public int getMoistness() {
        return (Integer)this.field_70180_af.func_187225_a(MOISTNESS);
    }

    public void setMoistness(int p_211137_1_) {
        this.field_70180_af.func_187227_b(MOISTNESS, (Object)p_211137_1_);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(MOISTNESS, (Object)2400);
    }

    protected SoundEvent func_184639_G() {
        return AMSoundRegistry.ORCA_IDLE;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return AMSoundRegistry.ORCA_HURT;
    }

    protected SoundEvent func_184615_bR() {
        return AMSoundRegistry.ORCA_DIE;
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (Goal)new BreatheAirGoal((CreatureEntity)this));
        this.field_70714_bg.func_75776_a(1, (Goal)new FindWaterGoal((CreatureEntity)this));
        this.field_70714_bg.func_75776_a(2, (Goal)new SwimWithPlayerGoal(this, 4.0));
        this.field_70714_bg.func_75776_a(4, (Goal)new RandomSwimmingGoal((CreatureEntity)this, 1.0, 10));
        this.field_70714_bg.func_75776_a(4, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(5, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 6.0f));
        this.field_70714_bg.func_75776_a(5, (Goal)new OrcaAIJump(this, 10));
        this.field_70714_bg.func_75776_a(6, (Goal)new OrcaAIMeleeJump(this));
        this.field_70714_bg.func_75776_a(6, (Goal)new OrcaAIMelee(this, 1.2f, true));
        this.field_70714_bg.func_75776_a(8, (Goal)new FollowBoatGoal((CreatureEntity)this));
        this.field_70715_bh.func_75776_a(1, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]).func_220794_a(new Class[0]));
        this.field_70715_bh.func_75776_a(2, new EntityAINearestTarget3D<EntityCachalotWhale>((MobEntity)this, EntityCachalotWhale.class, 5, false, false, TARGET_BABY));
        this.field_70715_bh.func_75776_a(3, new EntityAINearestTarget3D<LivingEntity>((MobEntity)this, LivingEntity.class, 200, false, true, AMEntityRegistry.buildPredicateFromTag(EntityTypeTags.func_219762_a().func_199910_a(AMTagRegistry.ORCA_TARGETS))));
    }

    public Animation getAnimation() {
        return this.currentAnimation;
    }

    public void setAnimation(Animation animation) {
        this.currentAnimation = animation;
    }

    public Animation[] getAnimations() {
        return new Animation[]{ANIMATION_BITE, ANIMATION_TAILSWING};
    }

    public void func_213352_e(Vector3d travelVector) {
        if (this.func_70613_aW() && this.func_70090_H()) {
            this.func_213309_a(this.func_70689_ay(), travelVector);
            this.func_213315_a(MoverType.SELF, this.func_213322_ci());
            this.func_213317_d(this.func_213322_ci().func_186678_a(0.9));
            if (this.func_70638_az() == null) {
                this.func_213317_d(this.func_213322_ci().func_72441_c(0.0, -0.005, 0.0));
            }
        } else {
            super.func_213352_e(travelVector);
        }
    }

    public void func_70619_bc() {
        super.func_70619_bc();
        this.breakBlock();
    }

    public void breakBlock() {
        if (this.blockBreakCounter > 0) {
            --this.blockBreakCounter;
            return;
        }
        boolean flag = false;
        if (!this.field_70170_p.field_72995_K && this.blockBreakCounter == 0) {
            for (int a = (int)Math.round(this.func_174813_aQ().field_72340_a); a <= (int)Math.round(this.func_174813_aQ().field_72336_d); ++a) {
                for (int b = (int)Math.round(this.func_174813_aQ().field_72338_b) - 1; b <= (int)Math.round(this.func_174813_aQ().field_72337_e) + 1 && b <= 127; ++b) {
                    for (int c = (int)Math.round(this.func_174813_aQ().field_72339_c); c <= (int)Math.round(this.func_174813_aQ().field_72334_f); ++c) {
                        BlockPos pos = new BlockPos(a, b, c);
                        BlockState state = this.field_70170_p.func_180495_p(pos);
                        FluidState fluidState = this.field_70170_p.func_204610_c(pos);
                        Block block = state.func_177230_c();
                        if (state.func_196958_f() || state.func_196954_c((IBlockReader)this.field_70170_p, pos).func_197766_b() || !BlockTags.func_199896_a().func_199910_a(AMTagRegistry.ORCA_BREAKABLES).func_230235_a_((Object)state.func_177230_c()) || !fluidState.func_206888_e() || block == Blocks.field_150350_a) continue;
                        this.func_213317_d(this.func_213322_ci().func_216372_d((double)0.6f, 1.0, (double)0.6f));
                        flag = true;
                        this.field_70170_p.func_175655_b(pos, true);
                        if (!state.func_177230_c().func_203417_a((ITag)BlockTags.field_205213_E)) continue;
                        this.field_70170_p.func_175656_a(pos, Blocks.field_150355_j.func_176223_P());
                    }
                }
            }
        }
        if (flag) {
            this.blockBreakCounter = 20;
        }
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.jumpCooldown > 0) {
            float f2;
            --this.jumpCooldown;
            this.field_70125_A = f2 = (float)(-((double)((float)this.func_213322_ci().field_72448_b) * 57.2957763671875));
        }
        if (this.func_175446_cd()) {
            this.func_70050_g(this.func_205010_bg());
        } else {
            if (this.func_203008_ap()) {
                this.setMoistness(2400);
            } else {
                this.setMoistness(this.getMoistness() - 1);
                if (this.getMoistness() <= 0) {
                    this.func_70097_a(DamageSource.field_205132_u, 1.0f);
                }
                if (this.field_70122_E) {
                    this.func_213317_d(this.func_213322_ci().func_72441_c((double)((this.field_70146_Z.nextFloat() * 2.0f - 1.0f) * 0.2f), 0.5, (double)((this.field_70146_Z.nextFloat() * 2.0f - 1.0f) * 0.2f)));
                    this.field_70177_z = this.field_70146_Z.nextFloat() * 360.0f;
                    this.field_70122_E = false;
                    this.field_70160_al = true;
                }
            }
            if (this.field_70170_p.field_72995_K && this.func_70090_H() && this.func_213322_ci().func_189985_c() > 0.03) {
                Vector3d vector3d = this.func_70676_i(0.0f);
                float f = MathHelper.func_76134_b((float)(this.field_70177_z * ((float)Math.PI / 180))) * 0.9f;
                float f1 = MathHelper.func_76126_a((float)(this.field_70177_z * ((float)Math.PI / 180))) * 0.9f;
                float f2 = 1.2f - this.field_70146_Z.nextFloat() * 0.7f;
                for (int i = 0; i < 2; ++i) {
                    this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_206864_X, this.func_226277_ct_() - vector3d.field_72450_a * (double)f2 + (double)f, this.func_226278_cu_() - vector3d.field_72448_b, this.func_226281_cx_() - vector3d.field_72449_c * (double)f2 + (double)f1, 0.0, 0.0, 0.0);
                    this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_206864_X, this.func_226277_ct_() - vector3d.field_72450_a * (double)f2 - (double)f, this.func_226278_cu_() - vector3d.field_72448_b, this.func_226281_cx_() - vector3d.field_72449_c * (double)f2 - (double)f1, 0.0, 0.0, 0.0);
                }
            }
        }
        LivingEntity attackTarget = this.func_70638_az();
        if (attackTarget != null && this.func_70032_d((Entity)attackTarget) < attackTarget.func_213311_cf() + this.func_213311_cf() + 2.0f) {
            float damage;
            if (this.getAnimation() == ANIMATION_BITE && this.getAnimationTick() == 4) {
                boolean flag;
                damage = (int)this.func_233637_b_(Attributes.field_233823_f_);
                if (attackTarget instanceof DrownedEntity || attackTarget instanceof GuardianEntity) {
                    damage *= 2.0f;
                }
                if (flag = attackTarget.func_70097_a(DamageSource.func_76358_a((LivingEntity)this), damage)) {
                    this.func_174815_a((LivingEntity)this, (Entity)attackTarget);
                    this.func_184185_a(SoundEvents.field_205205_aV, 1.0f, 1.0f);
                }
            }
            if (this.getAnimation() == ANIMATION_TAILSWING && this.getAnimationTick() == 6) {
                boolean flag;
                damage = (int)this.func_233637_b_(Attributes.field_233823_f_);
                if (attackTarget instanceof DrownedEntity || attackTarget instanceof GuardianEntity) {
                    damage *= 2.0f;
                }
                if (flag = attackTarget.func_70097_a(DamageSource.func_76358_a((LivingEntity)this), damage)) {
                    this.func_174815_a((LivingEntity)this, (Entity)attackTarget);
                    this.func_184185_a(SoundEvents.field_205205_aV, 1.0f, 1.0f);
                }
                attackTarget.func_233627_a_(1.0f, (double)MathHelper.func_76126_a((float)(this.field_70177_z * ((float)Math.PI / 180))), (double)(-MathHelper.func_76134_b((float)(this.field_70177_z * ((float)Math.PI / 180)))));
                float knockbackResist = (float)MathHelper.func_151237_a((double)(1.0 - this.func_233637_b_(Attributes.field_233820_c_)), (double)0.0, (double)1.0);
                this.func_70638_az().func_213317_d(this.func_70638_az().func_213322_ci().func_72441_c(0.0, (double)(knockbackResist * 0.4f), 0.0));
            }
        }
        if (attackTarget != null && attackTarget instanceof PlayerEntity && attackTarget.func_70644_a(AMEffectRegistry.ORCAS_MIGHT)) {
            attackTarget.func_195063_d(AMEffectRegistry.ORCAS_MIGHT);
        }
        AnimationHandler.INSTANCE.updateAnimations((Entity)this);
    }

    public int getAnimationTick() {
        return this.animationTick;
    }

    public void setAnimationTick(int tick) {
        this.animationTick = tick;
    }

    public boolean func_70652_k(Entity entityIn) {
        if (this.func_203005_aq() && this.field_70146_Z.nextBoolean()) {
            this.setAnimation(ANIMATION_TAILSWING);
        } else {
            this.setAnimation(ANIMATION_BITE);
        }
        return true;
    }

    public int func_205010_bg() {
        return 4800;
    }

    protected int func_207300_l(int currentAir) {
        return this.func_205010_bg();
    }

    protected float func_213348_b(Pose poseIn, EntitySize sizeIn) {
        return 1.0f;
    }

    public int func_70646_bf() {
        return 1;
    }

    public int func_184649_cE() {
        return 1;
    }

    public boolean func_70877_b(ItemStack stack) {
        return stack.func_77973_b() == Items.field_196087_aX;
    }

    @Nullable
    public AgeableEntity func_241840_a(ServerWorld serverWorld, AgeableEntity p_241840_2_) {
        return (AgeableEntity)AMEntityRegistry.ORCA.func_200721_a((World)serverWorld);
    }

    public boolean shouldUseJumpAttack(LivingEntity attackTarget) {
        if (attackTarget.func_70090_H()) {
            BlockPos up = attackTarget.func_233580_cy_().func_177984_a();
            return this.field_70170_p.func_204610_c(up.func_177984_a()).func_206888_e() && this.field_70170_p.func_204610_c(up.func_177981_b(2)).func_206888_e() && this.jumpCooldown == 0;
        }
        return this.jumpCooldown == 0;
    }

    @Nullable
    public ILivingEntityData func_213386_a(IServerWorld worldIn, DifficultyInstance difficultyIn, SpawnReason reason, @Nullable ILivingEntityData spawnDataIn, @Nullable CompoundNBT dataTag) {
        this.func_70050_g(this.func_205010_bg());
        this.field_70125_A = 0.0f;
        this.setMoistness(2400);
        return super.func_213386_a(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
    }

    public boolean func_70648_aU() {
        return false;
    }

    public void func_70030_z() {
        int i = this.func_70086_ai();
        super.func_70030_z();
        this.updateAir(i);
    }

    public boolean func_96092_aw() {
        return false;
    }

    public CreatureAttribute func_70668_bt() {
        return CreatureAttribute.field_203100_e;
    }

    public boolean func_205019_a(IWorldReader worldIn) {
        return worldIn.func_226668_i_((Entity)this);
    }

    protected void updateAir(int p_209207_1_) {
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74768_a("Moistness", this.getMoistness());
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.setMoistness(compound.func_74762_e("Moistness"));
    }

    public void onJumpHit(LivingEntity entityIn) {
        boolean flag = entityIn.func_70097_a(DamageSource.func_76358_a((LivingEntity)this), (float)((int)this.func_233637_b_(Attributes.field_233823_f_)));
        if (flag) {
            this.func_174815_a((LivingEntity)this, (Entity)entityIn);
            this.func_184185_a(SoundEvents.field_205205_aV, 1.0f, 1.0f);
        }
    }

    public static boolean canOrcaSpawn(EntityType<EntityOrca> p_223364_0_, IWorld p_223364_1_, SpawnReason reason, BlockPos p_223364_3_, Random p_223364_4_) {
        if (p_223364_3_.func_177956_o() > 45 && p_223364_3_.func_177956_o() < p_223364_1_.func_181545_F()) {
            Optional optional = p_223364_1_.func_242406_i(p_223364_3_);
            return (!Objects.equals(optional, Optional.of(Biomes.field_76771_b)) || !Objects.equals(optional, Optional.of(Biomes.field_150575_M))) && p_223364_1_.func_204610_c(p_223364_3_).func_206884_a((ITag)FluidTags.field_206959_a);
        }
        return false;
    }

    static class MoveHelperController
    extends MovementController {
        private final EntityOrca dolphin;

        public MoveHelperController(EntityOrca dolphinIn) {
            super((MobEntity)dolphinIn);
            this.dolphin = dolphinIn;
        }

        public void func_75641_c() {
            if (this.dolphin.func_70090_H()) {
                this.dolphin.func_213317_d(this.dolphin.func_213322_ci().func_72441_c(0.0, 0.005, 0.0));
            }
            if (this.field_188491_h == MovementController.Action.MOVE_TO && !this.dolphin.func_70661_as().func_75500_f()) {
                double d2;
                double d1;
                double d0 = this.field_75646_b - this.dolphin.func_226277_ct_();
                double d3 = d0 * d0 + (d1 = this.field_75647_c - this.dolphin.func_226278_cu_()) * d1 + (d2 = this.field_75644_d - this.dolphin.func_226281_cx_()) * d2;
                if (d3 < 2.500000277905201E-7) {
                    this.field_75648_a.func_191989_p(0.0f);
                } else {
                    float f = (float)(MathHelper.func_181159_b((double)d2, (double)d0) * 57.2957763671875) - 90.0f;
                    this.dolphin.field_70761_aq = this.dolphin.field_70177_z = this.func_75639_a(this.dolphin.field_70177_z, f, 10.0f);
                    this.dolphin.field_70759_as = this.dolphin.field_70177_z;
                    float f1 = (float)(this.field_75645_e * this.dolphin.func_233637_b_(Attributes.field_233821_d_));
                    if (this.dolphin.func_70090_H()) {
                        this.dolphin.func_70659_e(f1 * 0.02f);
                        float f2 = -((float)(MathHelper.func_181159_b((double)d1, (double)MathHelper.func_76133_a((double)(d0 * d0 + d2 * d2))) * 57.2957763671875));
                        f2 = MathHelper.func_76131_a((float)MathHelper.func_76142_g((float)f2), (float)-85.0f, (float)85.0f);
                        this.dolphin.field_70125_A = this.func_75639_a(this.dolphin.field_70125_A, f2, 5.0f);
                        float f3 = MathHelper.func_76134_b((float)(this.dolphin.field_70125_A * ((float)Math.PI / 180)));
                        float f4 = MathHelper.func_76126_a((float)(this.dolphin.field_70125_A * ((float)Math.PI / 180)));
                        this.dolphin.field_191988_bg = f3 * f1;
                        this.dolphin.field_70701_bs = -f4 * f1;
                    } else {
                        this.dolphin.func_70659_e(f1 * 0.1f);
                    }
                }
            } else {
                this.dolphin.func_70659_e(0.0f);
                this.dolphin.func_184646_p(0.0f);
                this.dolphin.func_70657_f(0.0f);
                this.dolphin.func_191989_p(0.0f);
            }
        }
    }

    static class SwimWithPlayerGoal
    extends Goal {
        private final EntityOrca dolphin;
        private final double speed;
        private PlayerEntity targetPlayer;

        SwimWithPlayerGoal(EntityOrca dolphinIn, double speedIn) {
            this.dolphin = dolphinIn;
            this.speed = speedIn;
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean func_75250_a() {
            this.targetPlayer = this.dolphin.field_70170_p.func_217370_a(PLAYER_PREDICATE, (LivingEntity)this.dolphin);
            if (this.targetPlayer == null) {
                return false;
            }
            return this.targetPlayer.func_203007_ba() && this.dolphin.func_70638_az() != this.targetPlayer;
        }

        public boolean func_75253_b() {
            return this.targetPlayer != null && this.dolphin.func_70638_az() != this.targetPlayer && this.targetPlayer.func_203007_ba() && this.dolphin.func_70068_e((Entity)this.targetPlayer) < 256.0;
        }

        public void func_75249_e() {
        }

        public void func_75251_c() {
            this.targetPlayer = null;
            this.dolphin.func_70661_as().func_75499_g();
        }

        public void func_75246_d() {
            this.dolphin.func_70671_ap().func_75651_a((Entity)this.targetPlayer, (float)(this.dolphin.func_184649_cE() + 20), (float)this.dolphin.func_70646_bf());
            if (this.dolphin.func_70068_e((Entity)this.targetPlayer) < 10.0) {
                this.dolphin.func_70661_as().func_75499_g();
            } else {
                this.dolphin.func_70661_as().func_75497_a((Entity)this.targetPlayer, this.speed);
            }
            if (this.targetPlayer.func_203007_ba() && this.targetPlayer.field_70170_p.field_73012_v.nextInt(6) == 0) {
                this.targetPlayer.func_195064_c(new EffectInstance(AMEffectRegistry.ORCAS_MIGHT, 1000));
            }
        }
    }
}

