/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.alexsmobs.entity;

import com.github.alexthe666.alexsmobs.block.BlockHummingbirdFeeder;
import com.github.alexthe666.alexsmobs.config.AMConfig;
import com.github.alexthe666.alexsmobs.entity.AMEntityRegistry;
import com.github.alexthe666.alexsmobs.entity.ai.FlightMoveController;
import com.github.alexthe666.alexsmobs.entity.ai.HummingbirdAIPollinate;
import com.github.alexthe666.alexsmobs.entity.ai.HummingbirdAIWander;
import com.github.alexthe666.alexsmobs.misc.AMPointOfInterestRegistry;
import com.github.alexthe666.alexsmobs.misc.AMSoundRegistry;
import com.google.common.base.Predicates;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.command.arguments.EntityAnchorArgument;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.BreedGoal;
import net.minecraft.entity.ai.goal.FollowParentGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.TemptGoal;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.pathfinding.FlyingPathNavigator;
import net.minecraft.pathfinding.PathNavigator;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.state.Property;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.village.PointOfInterestManager;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class EntityHummingbird
extends AnimalEntity {
    private static final DataParameter<Boolean> FLYING = EntityDataManager.func_187226_a(EntityHummingbird.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Integer> VARIANT = EntityDataManager.func_187226_a(EntityHummingbird.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> CROPS_POLLINATED = EntityDataManager.func_187226_a(EntityHummingbird.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Optional<BlockPos>> FEEDER_POS = EntityDataManager.func_187226_a(EntityHummingbird.class, (IDataSerializer)DataSerializers.field_187201_k);
    public float flyProgress;
    public float prevFlyProgress;
    public float movingProgress;
    public float prevMovingProgress;
    public int hummingStill = 0;
    public int pollinateCooldown = 0;
    public int sipCooldown = 0;
    private int loopSoundTick = 0;
    private boolean sippy;
    public float sipProgress;
    public float prevSipProgress;

    protected EntityHummingbird(EntityType type, World worldIn) {
        super(type, worldIn);
        this.field_70765_h = new FlightMoveController((MobEntity)this, 1.5f);
        this.func_184644_a(PathNodeType.DANGER_FIRE, -1.0f);
        this.func_184644_a(PathNodeType.WATER, -1.0f);
        this.func_184644_a(PathNodeType.WATER_BORDER, 16.0f);
        this.func_184644_a(PathNodeType.COCOA, -1.0f);
        this.func_184644_a(PathNodeType.FENCE, -1.0f);
        this.func_184644_a(PathNodeType.LEAVES, 0.0f);
    }

    public boolean func_213380_a(IWorld worldIn, SpawnReason spawnReasonIn) {
        return AMEntityRegistry.rollSpawn(AMConfig.hummingbirdSpawnRolls, this.func_70681_au(), spawnReasonIn);
    }

    protected SoundEvent func_184639_G() {
        return AMSoundRegistry.HUMMINGBIRD_IDLE;
    }

    public int func_70627_aG() {
        return 60;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return AMSoundRegistry.HUMMINGBIRD_HURT;
    }

    protected SoundEvent func_184615_bR() {
        return AMSoundRegistry.HUMMINGBIRD_HURT;
    }

    public static AttributeModifierMap.MutableAttribute bakeAttributes() {
        return MonsterEntity.func_234295_eP_().func_233815_a_(Attributes.field_233818_a_, 4.0).func_233815_a_(Attributes.field_233822_e_, 7.0).func_233815_a_(Attributes.field_233823_f_, 0.0).func_233815_a_(Attributes.field_233821_d_, (double)0.45f);
    }

    public boolean func_70877_b(ItemStack stack) {
        return stack.func_77973_b().func_206844_a((ITag)ItemTags.field_226159_I_);
    }

    public int func_70641_bl() {
        return 7;
    }

    public boolean func_204209_c(int sizeIn) {
        return false;
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, (Goal)new BreedGoal((AnimalEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(2, (Goal)new TemptGoal((CreatureEntity)this, 1.0, Ingredient.func_199805_a((ITag)ItemTags.field_226159_I_), false));
        this.field_70714_bg.func_75776_a(3, (Goal)new FollowParentGoal((AnimalEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(4, (Goal)new AIUseFeeder(this));
        this.field_70714_bg.func_75776_a(4, (Goal)new HummingbirdAIPollinate(this));
        this.field_70714_bg.func_75776_a(5, (Goal)new HummingbirdAIWander(this, 16, 6, 15, 1.0f));
        this.field_70714_bg.func_75776_a(6, (Goal)new SwimGoal((MobEntity)this));
    }

    protected void func_180429_a(BlockPos pos, BlockState blockIn) {
    }

    protected PathNavigator func_175447_b(World worldIn) {
        FlyingPathNavigator flyingpathnavigator = new FlyingPathNavigator((MobEntity)this, worldIn){

            public boolean func_188555_b(BlockPos pos) {
                return !this.field_75513_b.func_180495_p(pos.func_177979_c(2)).func_196958_f();
            }
        };
        flyingpathnavigator.func_192879_a(false);
        flyingpathnavigator.func_212239_d(false);
        flyingpathnavigator.func_192878_b(true);
        return flyingpathnavigator;
    }

    public boolean func_225503_b_(float distance, float damageMultiplier) {
        return false;
    }

    protected void func_184231_a(double y, boolean onGroundIn, BlockState state, BlockPos pos) {
    }

    protected boolean func_191957_ae() {
        return true;
    }

    protected float func_213348_b(Pose poseIn, EntitySize sizeIn) {
        return this.func_70631_g_() ? sizeIn.field_220316_b * 0.5f : sizeIn.field_220316_b * 0.5f;
    }

    public float func_205022_a(BlockPos pos, IWorldReader worldIn) {
        return worldIn.func_180495_p(pos).func_196958_f() ? 10.0f : 0.0f;
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74768_a("Variant", this.getVariant());
        compound.func_74768_a("CropsPollinated", this.getCropsPollinated());
        compound.func_74768_a("PollinateCooldown", this.pollinateCooldown);
        BlockPos blockpos = this.getFeederPos();
        if (blockpos != null) {
            compound.func_74768_a("HLPX", blockpos.func_177958_n());
            compound.func_74768_a("HLPY", blockpos.func_177956_o());
            compound.func_74768_a("HLPZ", blockpos.func_177952_p());
        }
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.setVariant(compound.func_74762_e("Variant"));
        this.setCropsPollinated(compound.func_74762_e("CropsPollinated"));
        this.pollinateCooldown = compound.func_74762_e("PollinateCooldown");
        if (compound.func_74764_b("HLPX")) {
            int i = compound.func_74762_e("HLPX");
            int j = compound.func_74762_e("HLPY");
            int k = compound.func_74762_e("HLPZ");
            this.field_70180_af.func_187227_b(FEEDER_POS, Optional.of(new BlockPos(i, j, k)));
        } else {
            this.field_70180_af.func_187227_b(FEEDER_POS, Optional.empty());
        }
    }

    public BlockPos getFeederPos() {
        return ((Optional)this.field_70180_af.func_187225_a(FEEDER_POS)).orElse(null);
    }

    public void setFeederPos(BlockPos pos) {
        this.field_70180_af.func_187227_b(FEEDER_POS, Optional.ofNullable(pos));
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(FLYING, (Object)false);
        this.field_70180_af.func_187214_a(VARIANT, (Object)0);
        this.field_70180_af.func_187214_a(CROPS_POLLINATED, (Object)0);
        this.field_70180_af.func_187214_a(FEEDER_POS, Optional.empty());
    }

    @Nullable
    public ILivingEntityData func_213386_a(IServerWorld worldIn, DifficultyInstance difficultyIn, SpawnReason reason, @Nullable ILivingEntityData spawnDataIn, @Nullable CompoundNBT dataTag) {
        this.setVariant(this.func_70681_au().nextInt(3));
        return super.func_213386_a(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
    }

    private List<BlockPos> getNearbyFeeders(BlockPos blockpos, ServerWorld world, int range) {
        PointOfInterestManager pointofinterestmanager = world.func_217443_B();
        Stream stream = pointofinterestmanager.func_225399_a(AMPointOfInterestRegistry.HUMMINGBIRD_FEEDER.func_221045_c(), (Predicate)Predicates.alwaysTrue(), blockpos, range, PointOfInterestManager.Status.ANY);
        return stream.collect(Collectors.toList());
    }

    public boolean isFlying() {
        return (Boolean)this.field_70180_af.func_187225_a(FLYING);
    }

    public void setFlying(boolean flying) {
        this.field_70180_af.func_187227_b(FLYING, (Object)flying);
    }

    public int getVariant() {
        return (Integer)this.field_70180_af.func_187225_a(VARIANT);
    }

    public void setVariant(int variant) {
        this.field_70180_af.func_187227_b(VARIANT, (Object)variant);
    }

    public int getCropsPollinated() {
        return (Integer)this.field_70180_af.func_187225_a(CROPS_POLLINATED);
    }

    public void setCropsPollinated(int crops) {
        this.field_70180_af.func_187227_b(CROPS_POLLINATED, (Object)crops);
    }

    public void func_70071_h_() {
        boolean flag;
        super.func_70071_h_();
        Vector3d vector3d = this.func_213322_ci();
        boolean bl = flag = this.func_213322_ci().field_72450_a * this.func_213322_ci().field_72450_a + this.func_213322_ci().field_72449_c * this.func_213322_ci().field_72449_c >= 0.001;
        if (!this.field_70122_E && vector3d.field_72448_b < 0.0) {
            this.func_213317_d(vector3d.func_216372_d(1.0, 0.4, 1.0));
        }
        this.setFlying(true);
        this.func_189654_d(true);
        if (this.isFlying() && this.flyProgress < 5.0f) {
            this.flyProgress += 1.0f;
        }
        if (!this.isFlying() && this.flyProgress > 0.0f) {
            this.flyProgress -= 1.0f;
        }
        if (this.sippy && this.sipProgress < 5.0f) {
            this.sipProgress += 1.0f;
        }
        if (!this.sippy && this.sipProgress > 0.0f) {
            this.sipProgress -= 1.0f;
        }
        if (this.sippy && this.sipProgress == 5.0f) {
            this.sippy = false;
        }
        if (flag && this.movingProgress < 5.0f) {
            this.movingProgress += 1.0f;
        }
        if (!flag && this.movingProgress > 0.0f) {
            this.movingProgress -= 1.0f;
        }
        this.hummingStill = this.func_213322_ci().func_189985_c() < 1.0E-7 ? ++this.hummingStill : 0;
        if (this.pollinateCooldown > 0) {
            --this.pollinateCooldown;
        }
        if (this.sipCooldown > 0) {
            --this.sipCooldown;
        }
        if (this.loopSoundTick == 0) {
            this.func_184185_a(AMSoundRegistry.HUMMINGBIRD_LOOP, this.func_70599_aP() * 0.33f, this.func_70647_i());
        }
        ++this.loopSoundTick;
        if (this.loopSoundTick > 27) {
            this.loopSoundTick = 0;
        }
        this.prevFlyProgress = this.flyProgress;
        this.prevMovingProgress = this.movingProgress;
        this.prevSipProgress = this.sipProgress;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_70103_a(byte id) {
        if (id == 68) {
            if (this.getFeederPos() != null) {
                if (this.field_70146_Z.nextFloat() < 0.2f) {
                    double d2 = this.field_70146_Z.nextGaussian() * 0.02;
                    double d0 = this.field_70146_Z.nextGaussian() * 0.02;
                    double d1 = this.field_70146_Z.nextGaussian() * 0.02;
                    this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_229430_aj_, (double)((float)this.getFeederPos().func_177958_n() + 0.2f) + (double)(this.field_70146_Z.nextFloat() * 0.6f), (double)((float)this.getFeederPos().func_177956_o() + 0.1f), (double)((float)this.getFeederPos().func_177952_p() + 0.2f) + (double)(this.field_70146_Z.nextFloat() * 0.6f), d0, d1, d2);
                }
                this.sippy = true;
            }
        } else {
            super.func_70103_a(id);
        }
    }

    @Nullable
    public AgeableEntity func_241840_a(ServerWorld serverWorld, AgeableEntity ageableEntity) {
        return (AgeableEntity)AMEntityRegistry.HUMMINGBIRD.func_200721_a((World)serverWorld);
    }

    public static <T extends MobEntity> boolean canHummingbirdSpawn(EntityType<EntityHummingbird> hummingbird, IWorld worldIn, SpawnReason reason, BlockPos p_223317_3_, Random random) {
        BlockState blockstate = worldIn.func_180495_p(p_223317_3_.func_177977_b());
        return (blockstate.func_235714_a_((ITag)BlockTags.field_206952_E) || blockstate.func_203425_a(Blocks.field_196658_i) || blockstate.func_235714_a_((ITag)BlockTags.field_200031_h) || blockstate.func_203425_a(Blocks.field_150350_a)) && worldIn.func_226659_b_(p_223317_3_, 0) > 8;
    }

    public boolean canBlockBeSeen(BlockPos pos) {
        double x = (float)pos.func_177958_n() + 0.5f;
        double y = (float)pos.func_177956_o() + 0.5f;
        double z = (float)pos.func_177952_p() + 0.5f;
        BlockRayTraceResult result = this.field_70170_p.func_217299_a(new RayTraceContext(new Vector3d(this.func_226277_ct_(), this.func_226278_cu_() + (double)this.func_70047_e(), this.func_226281_cx_()), new Vector3d(x, y, z), RayTraceContext.BlockMode.COLLIDER, RayTraceContext.FluidMode.NONE, (Entity)this));
        double dist = result.func_216347_e().func_186679_c(x, y, z);
        return dist <= 1.0 || result.func_216346_c() == RayTraceResult.Type.MISS;
    }

    private class AIUseFeeder
    extends Goal {
        int runCooldown = 0;
        private int idleAtFlowerTime = 0;
        private BlockPos localFeeder;

        public AIUseFeeder(EntityHummingbird entityHummingbird2) {
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.JUMP));
        }

        public void func_75251_c() {
            this.localFeeder = null;
            this.idleAtFlowerTime = 0;
        }

        public boolean func_75250_a() {
            if (EntityHummingbird.this.sipCooldown > 0) {
                return false;
            }
            if (this.runCooldown > 0) {
                --this.runCooldown;
            } else {
                BlockPos feedPos = EntityHummingbird.this.getFeederPos();
                if (feedPos != null && this.isValidFeeder(EntityHummingbird.this.field_70170_p.func_180495_p(feedPos))) {
                    this.localFeeder = feedPos;
                    return true;
                }
                List beacons = EntityHummingbird.this.getNearbyFeeders(EntityHummingbird.this.func_233580_cy_(), (ServerWorld)EntityHummingbird.this.field_70170_p, 64);
                BlockPos closest = null;
                for (BlockPos pos : beacons) {
                    if (closest != null && !(EntityHummingbird.this.func_70092_e(closest.func_177958_n(), closest.func_177956_o(), closest.func_177952_p()) > EntityHummingbird.this.func_70092_e(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p())) || !this.isValidFeeder(EntityHummingbird.this.field_70170_p.func_180495_p(pos))) continue;
                    closest = pos;
                }
                if (closest != null && this.isValidFeeder(EntityHummingbird.this.field_70170_p.func_180495_p(closest))) {
                    this.localFeeder = closest;
                    return true;
                }
            }
            this.runCooldown = 400 + EntityHummingbird.this.field_70146_Z.nextInt(600);
            return false;
        }

        public boolean func_75253_b() {
            return this.localFeeder != null && this.isValidFeeder(EntityHummingbird.this.field_70170_p.func_180495_p(this.localFeeder)) && EntityHummingbird.this.sipCooldown == 0;
        }

        public void func_75246_d() {
            if (this.localFeeder != null && this.isValidFeeder(EntityHummingbird.this.field_70170_p.func_180495_p(this.localFeeder))) {
                if (EntityHummingbird.this.func_226278_cu_() > (double)this.localFeeder.func_177956_o() && !EntityHummingbird.this.func_233570_aj_()) {
                    EntityHummingbird.this.func_70605_aq().func_75642_a((double)((float)this.localFeeder.func_177958_n() + 0.5f), (double)((float)this.localFeeder.func_177956_o() + 0.1f), (double)((float)this.localFeeder.func_177952_p() + 0.5f), 1.0);
                } else {
                    EntityHummingbird.this.func_70605_aq().func_75642_a((double)(this.localFeeder.func_177958_n() + EntityHummingbird.this.field_70146_Z.nextInt(4) - 2), EntityHummingbird.this.func_226278_cu_() + 1.0, (double)(this.localFeeder.func_177952_p() + EntityHummingbird.this.field_70146_Z.nextInt(4) - 2), 1.0);
                }
                Vector3d vec = Vector3d.func_237490_a_((Vector3i)this.localFeeder, (double)0.1f);
                double dist = MathHelper.func_76133_a((double)EntityHummingbird.this.func_195048_a(vec));
                if (dist < 2.5 && EntityHummingbird.this.func_226278_cu_() > (double)this.localFeeder.func_177956_o()) {
                    EntityHummingbird.this.func_200602_a(EntityAnchorArgument.Type.EYES, vec);
                    ++this.idleAtFlowerTime;
                    EntityHummingbird.this.setFeederPos(this.localFeeder);
                    EntityHummingbird.this.field_70170_p.func_72960_a((Entity)EntityHummingbird.this, (byte)68);
                    if (this.idleAtFlowerTime > 55) {
                        if (EntityHummingbird.this.getCropsPollinated() > 2 && EntityHummingbird.this.field_70146_Z.nextInt(25) == 0 && this.isValidFeeder(EntityHummingbird.this.field_70170_p.func_180495_p(this.localFeeder))) {
                            EntityHummingbird.this.field_70170_p.func_175656_a(this.localFeeder, (BlockState)EntityHummingbird.this.field_70170_p.func_180495_p(this.localFeeder).func_206870_a((Property)BlockHummingbirdFeeder.CONTENTS, (Comparable)Integer.valueOf(0)));
                        }
                        EntityHummingbird.this.setCropsPollinated(EntityHummingbird.this.getCropsPollinated() + 1);
                        EntityHummingbird.this.sipCooldown = 120 + EntityHummingbird.this.field_70146_Z.nextInt(1200);
                        EntityHummingbird.this.pollinateCooldown = Math.max(0, EntityHummingbird.this.pollinateCooldown / 3);
                        this.runCooldown = 400 + EntityHummingbird.this.field_70146_Z.nextInt(600);
                        this.func_75251_c();
                    }
                }
            }
        }

        public boolean isValidFeeder(BlockState state) {
            return state.func_177230_c() instanceof BlockHummingbirdFeeder && (Integer)state.func_177229_b((Property)BlockHummingbirdFeeder.CONTENTS) == 3;
        }
    }
}

