/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.alexsmobs.entity;

import com.github.alexthe666.alexsmobs.AlexsMobs;
import com.github.alexthe666.alexsmobs.config.AMConfig;
import com.github.alexthe666.alexsmobs.entity.AMEntityRegistry;
import com.github.alexthe666.alexsmobs.entity.EntityMosquitoSpit;
import com.github.alexthe666.alexsmobs.entity.EntityMungus;
import com.github.alexthe666.alexsmobs.entity.EntityWarpedMosco;
import com.github.alexthe666.alexsmobs.entity.ai.EntityAINearestTarget3D;
import com.github.alexthe666.alexsmobs.item.AMItemRegistry;
import com.github.alexthe666.alexsmobs.message.MessageMosquitoDismount;
import com.github.alexthe666.alexsmobs.message.MessageMosquitoMountPlayer;
import com.github.alexthe666.alexsmobs.misc.AMAdvancementTriggerRegistry;
import com.github.alexthe666.alexsmobs.misc.AMSoundRegistry;
import com.github.alexthe666.alexsmobs.misc.AMTagRegistry;
import java.util.EnumSet;
import java.util.Random;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.controller.MovementController;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.passive.StriderEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class EntityCrimsonMosquito
extends MonsterEntity {
    public static final ResourceLocation FULL_LOOT = new ResourceLocation("alexsmobs", "entities/crimson_mosquito_full");
    public static final ResourceLocation FROM_FLY_LOOT = new ResourceLocation("alexsmobs", "entities/crimson_mosquito_fly");
    public static final ResourceLocation FROM_FLY_FULL_LOOT = new ResourceLocation("alexsmobs", "entities/crimson_mosquito_fly_full");
    protected static final EntitySize FLIGHT_SIZE = EntitySize.func_220311_c((float)1.2f, (float)1.8f);
    private static final DataParameter<Boolean> FLYING = EntityDataManager.func_187226_a(EntityCrimsonMosquito.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> SHOOTING = EntityDataManager.func_187226_a(EntityCrimsonMosquito.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Integer> BLOOD_LEVEL = EntityDataManager.func_187226_a(EntityCrimsonMosquito.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Boolean> SHRINKING = EntityDataManager.func_187226_a(EntityCrimsonMosquito.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> FROM_FLY = EntityDataManager.func_187226_a(EntityCrimsonMosquito.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Float> MOSQUITO_SCALE = EntityDataManager.func_187226_a(EntityCrimsonMosquito.class, (IDataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Boolean> SICK = EntityDataManager.func_187226_a(EntityCrimsonMosquito.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final Predicate<AnimalEntity> WARM_BLOODED = mob -> !(mob instanceof StriderEntity);
    public float prevFlyProgress;
    public float flyProgress;
    public float prevShootProgress;
    public float shootProgress;
    public int shootingTicks;
    public int randomWingFlapTick = 0;
    private int flightTicks = 0;
    private int sickTicks = 0;
    private boolean prevFlying = false;
    private int spitCooldown = 0;
    private int loopSoundTick = 0;
    private int drinkTime = 0;
    public float prevMosquitoScale = 1.0f;

    protected EntityCrimsonMosquito(EntityType type, World worldIn) {
        super(type, worldIn);
        this.field_70765_h = new MoveHelperController(this);
        this.func_184644_a(PathNodeType.WATER, -1.0f);
        this.func_184644_a(PathNodeType.LAVA, 0.0f);
        this.func_184644_a(PathNodeType.DANGER_FIRE, 0.0f);
        this.func_184644_a(PathNodeType.DAMAGE_FIRE, 0.0f);
    }

    public void onSpawnFromFly() {
        this.prevMosquitoScale = 0.2f;
        this.setShrink(false);
        this.setMosquitoScale(0.2f);
        this.setFromFly(true);
        for (int j = 0; j < 4; ++j) {
            this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197625_r, this.func_226277_ct_() + this.field_70146_Z.nextDouble() / 2.0, this.func_226283_e_(0.5), this.func_226281_cx_() + this.field_70146_Z.nextDouble() / 2.0, this.field_70146_Z.nextDouble() * 0.5 + 0.5, 0.0, 0.0);
        }
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return AMSoundRegistry.MOSQUITO_HURT;
    }

    protected SoundEvent func_184615_bR() {
        return AMSoundRegistry.MOSQUITO_DIE;
    }

    public boolean func_213380_a(IWorld worldIn, SpawnReason spawnReasonIn) {
        return AMEntityRegistry.rollSpawn(AMConfig.crimsonMosquitoSpawnRolls, this.func_70681_au(), spawnReasonIn);
    }

    public static AttributeModifierMap.MutableAttribute bakeAttributes() {
        return MonsterEntity.func_234295_eP_().func_233815_a_(Attributes.field_233818_a_, 10.0).func_233815_a_(Attributes.field_233819_b_, 32.0).func_233815_a_(Attributes.field_233826_i_, 0.0).func_233815_a_(Attributes.field_233823_f_, 5.0).func_233815_a_(Attributes.field_233821_d_, 0.25);
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        if (this.getBloodLevel() > 0) {
            return this.isFromFly() ? FROM_FLY_FULL_LOOT : FULL_LOOT;
        }
        return this.isFromFly() ? FROM_FLY_LOOT : super.func_184647_J();
    }

    public boolean canRiderInteract() {
        return true;
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(2, (Goal)new FlyTowardsTarget(this));
        this.field_70714_bg.func_75776_a(2, (Goal)new FlyAwayFromTarget(this));
        this.field_70714_bg.func_75776_a(3, (Goal)new RandomFlyGoal(this));
        this.field_70714_bg.func_75776_a(4, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 32.0f));
        this.field_70714_bg.func_75776_a(5, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70715_bh.func_75776_a(1, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[]{EntityCrimsonMosquito.class, EntityWarpedMosco.class}));
        this.field_70715_bh.func_75776_a(2, new EntityAINearestTarget3D<PlayerEntity>((MobEntity)this, PlayerEntity.class, true));
        this.field_70715_bh.func_75776_a(2, new EntityAINearestTarget3D<LivingEntity>((MobEntity)this, LivingEntity.class, 50, false, true, AMEntityRegistry.buildPredicateFromTag(EntityTypeTags.func_219762_a().func_199910_a(AMTagRegistry.CRIMSON_MOSQUITO_TARGETS))));
    }

    public static boolean canMosquitoSpawn(EntityType<? extends MobEntity> typeIn, IServerWorld worldIn, SpawnReason reason, BlockPos pos, Random randomIn) {
        BlockPos blockpos = pos.func_177977_b();
        boolean spawnBlock = worldIn.func_180495_p(blockpos).func_200132_m();
        return reason == SpawnReason.SPAWNER || spawnBlock && worldIn.func_180495_p(blockpos).func_215688_a((IBlockReader)worldIn, blockpos, typeIn) && EntityCrimsonMosquito.func_223323_a((IServerWorld)worldIn, (BlockPos)pos, (Random)randomIn) && EntityCrimsonMosquito.func_223315_a(AMEntityRegistry.CRIMSON_MOSQUITO, (IWorld)worldIn, (SpawnReason)reason, (BlockPos)pos, (Random)randomIn);
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74768_a("FlightTicks", this.flightTicks);
        compound.func_74768_a("SickTicks", this.sickTicks);
        compound.func_74776_a("MosquitoScale", this.getMosquitoScale());
        compound.func_74757_a("Flying", this.isFlying());
        compound.func_74757_a("Shrinking", this.isShrinking());
        compound.func_74757_a("IsFromFly", this.isFromFly());
        compound.func_74757_a("Sick", this.isSick());
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.flightTicks = compound.func_74762_e("FlightTicks");
        this.sickTicks = compound.func_74762_e("SickTicks");
        this.setMosquitoScale(compound.func_74760_g("MosquitoScale"));
        this.setFlying(compound.func_74767_n("Flying"));
        this.setShrink(compound.func_74767_n("Shrinking"));
        this.setFromFly(compound.func_74767_n("IsFromFly"));
        this.setSick(compound.func_74767_n("Sick"));
    }

    private void spit(LivingEntity target) {
        if (this.isSick()) {
            return;
        }
        EntityMosquitoSpit llamaspitentity = new EntityMosquitoSpit(this.field_70170_p, this);
        double d0 = target.func_226277_ct_() - this.func_226277_ct_();
        double d1 = target.func_226283_e_(0.3333333333333333) - llamaspitentity.func_226278_cu_();
        double d2 = target.func_226281_cx_() - this.func_226281_cx_();
        float f = MathHelper.func_76133_a((double)(d0 * d0 + d2 * d2)) * 0.2f;
        llamaspitentity.shoot(d0, d1 + (double)f, d2, 1.5f, 10.0f);
        if (!this.func_174814_R()) {
            this.field_70170_p.func_184148_a(null, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), SoundEvents.field_191255_dF, this.func_184176_by(), 1.0f, 1.0f + (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f);
        }
        if (this.getBloodLevel() > 0) {
            this.setBloodLevel(this.getBloodLevel() - 1);
        }
        this.field_70170_p.func_217376_c((Entity)llamaspitentity);
    }

    public boolean func_180431_b(DamageSource source) {
        return source == DamageSource.field_76379_h || source == DamageSource.field_76369_e || source == DamageSource.field_76368_d || source == DamageSource.field_82729_p || source == DamageSource.field_76371_c || source.func_76347_k() || super.func_180431_b(source);
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (source.func_76346_g() != null && this.func_184208_bv() == source.func_76346_g().func_184208_bv()) {
            return super.func_70097_a(source, amount * 0.333f);
        }
        if (this.flightTicks < 0) {
            this.flightTicks = 0;
        }
        return super.func_70097_a(source, amount);
    }

    public void func_70098_U() {
        Entity entity = this.func_184187_bx();
        if (this.func_184218_aH() && !entity.func_70089_S()) {
            this.func_184210_p();
        } else {
            Entity mount;
            this.func_213293_j(0.0, 0.0, 0.0);
            this.func_70071_h_();
            if (this.func_184218_aH() && (mount = this.func_184187_bx()) instanceof LivingEntity) {
                this.field_70761_aq = ((LivingEntity)mount).field_70761_aq;
                this.field_70177_z = ((LivingEntity)mount).field_70177_z;
                this.field_70759_as = ((LivingEntity)mount).field_70759_as;
                this.field_70126_B = ((LivingEntity)mount).field_70759_as;
                float radius = 1.0f;
                float angle = (float)Math.PI / 180 * ((LivingEntity)mount).field_70761_aq;
                double extraX = radius * MathHelper.func_76126_a((float)((float)(Math.PI + (double)angle)));
                double extraZ = radius * MathHelper.func_76134_b((float)angle);
                this.func_70107_b(mount.func_226277_ct_() + extraX, Math.max(mount.func_226278_cu_() + (double)(mount.func_70047_e() * 0.25f), mount.func_226278_cu_()), mount.func_226281_cx_() + extraZ);
                if (!mount.func_70089_S() || mount instanceof PlayerEntity && ((PlayerEntity)mount).func_184812_l_()) {
                    this.func_233575_bb_();
                }
                if (this.drinkTime % 20 == 0 && !this.field_70170_p.field_72995_K && this.func_70089_S()) {
                    boolean mungus = AMConfig.warpedMoscoTransformation && mount instanceof EntityMungus && ((EntityMungus)mount).isWarpedMoscoReady();
                    boolean sick = this.isNonMungusWarpedTrigger(mount);
                    if (mount.func_70097_a(DamageSource.func_76358_a((LivingEntity)this), mungus ? 7.0f : 2.0f)) {
                        if (mungus) {
                            ((EntityMungus)mount).disableExplosion();
                        }
                        if (sick || mungus) {
                            if (!this.isSick() && !this.field_70170_p.field_72995_K) {
                                for (ServerPlayerEntity serverplayerentity : this.field_70170_p.func_217357_a(ServerPlayerEntity.class, this.func_174813_aQ().func_72314_b(40.0, 25.0, 40.0))) {
                                    AMAdvancementTriggerRegistry.MOSQUITO_SICK.trigger(serverplayerentity);
                                }
                            }
                            this.setSick(true);
                            this.setFlying(false);
                            this.flightTicks = -150 - this.field_70146_Z.nextInt(200);
                        }
                        this.func_184185_a(SoundEvents.field_226141_eV_, this.func_70599_aP(), this.func_70647_i());
                        this.setBloodLevel(this.getBloodLevel() + 1);
                        if (this.getBloodLevel() > 3) {
                            this.func_233575_bb_();
                            AlexsMobs.sendMSGToAll(new MessageMosquitoDismount(this.func_145782_y(), mount.func_145782_y()));
                            this.setFlying(false);
                            this.flightTicks = -15;
                        }
                    }
                }
                if (this.drinkTime > 81 && !this.field_70170_p.field_72995_K) {
                    this.drinkTime = -100;
                    this.func_233575_bb_();
                    AlexsMobs.sendMSGToAll(new MessageMosquitoDismount(this.func_145782_y(), mount.func_145782_y()));
                    this.setFlying(false);
                    this.flightTicks = -15;
                }
            }
        }
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(FLYING, (Object)false);
        this.field_70180_af.func_187214_a(SHOOTING, (Object)false);
        this.field_70180_af.func_187214_a(SICK, (Object)false);
        this.field_70180_af.func_187214_a(BLOOD_LEVEL, (Object)0);
        this.field_70180_af.func_187214_a(SHRINKING, (Object)false);
        this.field_70180_af.func_187214_a(FROM_FLY, (Object)false);
        this.field_70180_af.func_187214_a(MOSQUITO_SCALE, (Object)Float.valueOf(1.0f));
    }

    public boolean isFlying() {
        return (Boolean)this.field_70180_af.func_187225_a(FLYING);
    }

    public void setFlying(boolean flying) {
        this.field_70180_af.func_187227_b(FLYING, (Object)flying);
    }

    public void setupShooting() {
        this.field_70180_af.func_187227_b(SHOOTING, (Object)true);
        this.shootingTicks = 5;
    }

    public int getBloodLevel() {
        return Math.min((Integer)this.field_70180_af.func_187225_a(BLOOD_LEVEL), 4);
    }

    public void setBloodLevel(int bloodLevel) {
        this.field_70180_af.func_187227_b(BLOOD_LEVEL, (Object)bloodLevel);
    }

    public boolean isShrinking() {
        return (Boolean)this.field_70180_af.func_187225_a(SHRINKING);
    }

    public boolean isFromFly() {
        return (Boolean)this.field_70180_af.func_187225_a(FROM_FLY);
    }

    public void setShrink(boolean shrink) {
        this.field_70180_af.func_187227_b(SHRINKING, (Object)shrink);
    }

    public void setFromFly(boolean fromFly) {
        this.field_70180_af.func_187227_b(FROM_FLY, (Object)fromFly);
    }

    public float getMosquitoScale() {
        return ((Float)this.field_70180_af.func_187225_a(MOSQUITO_SCALE)).floatValue();
    }

    public void setMosquitoScale(float scale) {
        this.field_70180_af.func_187227_b(MOSQUITO_SCALE, (Object)Float.valueOf(scale));
    }

    public boolean isSick() {
        return (Boolean)this.field_70180_af.func_187225_a(SICK);
    }

    public void setSick(boolean shrink) {
        this.field_70180_af.func_187227_b(SICK, (Object)shrink);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        boolean shooting = (Boolean)this.field_70180_af.func_187225_a(SHOOTING);
        if (this.prevFlying != this.isFlying()) {
            this.func_213323_x_();
        }
        if (shooting && this.shootProgress < 5.0f) {
            this.shootProgress += 1.0f;
        }
        if (!shooting && this.shootProgress > 0.0f) {
            this.shootProgress -= 1.0f;
        }
        if (this.isFlying() && this.flyProgress < 5.0f) {
            this.flyProgress += 1.0f;
        }
        if (!this.isFlying() && this.flyProgress > 0.0f) {
            this.flyProgress -= 1.0f;
        }
        if (!this.field_70170_p.field_72995_K && this.func_184218_aH()) {
            this.setFlying(false);
        }
        if (!this.field_70170_p.field_72995_K) {
            if (this.isFlying()) {
                this.func_189654_d(true);
            } else {
                this.func_189654_d(false);
            }
        }
        if (this.flyProgress == 0.0f && this.field_70146_Z.nextInt(200) == 0) {
            this.randomWingFlapTick = 5 + this.field_70146_Z.nextInt(15);
        }
        if (this.randomWingFlapTick > 0) {
            --this.randomWingFlapTick;
        }
        if (!this.field_70170_p.field_72995_K && this.func_233570_aj_() && !this.isFlying() && (this.flightTicks >= 0 && this.field_70146_Z.nextInt(5) == 0 || this.func_70638_az() != null)) {
            this.setFlying(true);
            this.func_213317_d(this.func_213322_ci().func_72441_c((double)((this.field_70146_Z.nextFloat() * 2.0f - 1.0f) * 0.2f), 0.5, (double)((this.field_70146_Z.nextFloat() * 2.0f - 1.0f) * 0.2f)));
            this.field_70122_E = false;
            this.field_70160_al = true;
        }
        if (this.flightTicks < 0) {
            ++this.flightTicks;
        }
        if (this.isFlying() & !this.field_70170_p.field_72995_K) {
            BlockPos above;
            ++this.flightTicks;
            if (!(this.flightTicks <= 200 || this.func_70638_az() != null && this.func_70638_az().func_70089_S() || !this.field_70170_p.func_204610_c(above = this.getGroundPosition(this.func_233580_cy_().func_177984_a())).func_206888_e() || this.field_70170_p.func_180495_p(above).func_196958_f())) {
                this.func_213322_ci().func_72441_c(0.0, -0.2, 0.0);
                if (this.func_233570_aj_()) {
                    this.setFlying(false);
                    this.flightTicks = -150 - this.field_70146_Z.nextInt(200);
                }
            }
        }
        this.prevMosquitoScale = this.getMosquitoScale();
        if (this.isShrinking()) {
            if (this.getMosquitoScale() > 0.4f) {
                this.setMosquitoScale(this.getMosquitoScale() - 0.1f);
            }
        } else if (this.getMosquitoScale() < 1.0f && !this.isSick()) {
            this.setMosquitoScale(this.getMosquitoScale() + 0.05f);
        }
        if (!this.field_70170_p.field_72995_K && this.shootingTicks > 0) {
            --this.shootingTicks;
            if (this.shootingTicks == 0) {
                if (this.func_70638_az() != null && this.getBloodLevel() > 0) {
                    this.spit(this.func_70638_az());
                }
                this.field_70180_af.func_187227_b(SHOOTING, (Object)false);
            }
        }
        if (this.isFlying()) {
            if (this.loopSoundTick == 0) {
                this.func_184185_a(AMSoundRegistry.MOSQUITO_LOOP, this.func_70599_aP(), this.func_70647_i());
            }
            ++this.loopSoundTick;
            if (this.loopSoundTick > 100) {
                this.loopSoundTick = 0;
            }
        }
        if (this.func_184218_aH() || this.drinkTime < 0) {
            if (this.func_184218_aH() && this.drinkTime < 0) {
                this.drinkTime = 0;
            }
            ++this.drinkTime;
        }
        this.prevFlyProgress = this.flyProgress;
        this.prevShootProgress = this.shootProgress;
        this.prevFlying = this.isFlying();
        if (this.isSick()) {
            ++this.sickTicks;
            if (this.func_70638_az() != null && !this.func_184218_aH()) {
                this.func_70624_b(null);
            }
            if (this.sickTicks > 100) {
                this.setShrink(false);
                this.setMosquitoScale(this.getMosquitoScale() + 0.015f);
                if (this.sickTicks > 160) {
                    EntityWarpedMosco mosco = (EntityWarpedMosco)AMEntityRegistry.WARPED_MOSCO.func_200721_a(this.field_70170_p);
                    mosco.func_82149_j((Entity)this);
                    if (!this.field_70170_p.field_72995_K) {
                        mosco.func_213386_a((IServerWorld)this.field_70170_p, this.field_70170_p.func_175649_E(this.func_233580_cy_()), SpawnReason.CONVERSION, null, null);
                    }
                    if (!this.field_70170_p.field_72995_K) {
                        this.field_70170_p.func_72960_a((Entity)this, (byte)79);
                        this.field_70170_p.func_217376_c((Entity)mosco);
                    }
                    this.func_70106_y();
                }
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_70103_a(byte id) {
        if (id == 79) {
            for (int i = 0; i < 27; ++i) {
                double d0 = this.field_70146_Z.nextGaussian() * 0.02;
                double d1 = this.field_70146_Z.nextGaussian() * 0.02;
                double d2 = this.field_70146_Z.nextGaussian() * 0.02;
                double d3 = 10.0;
                this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197627_t, this.func_226282_d_(1.6), this.func_226278_cu_() + (double)(this.field_70146_Z.nextFloat() * 3.4f), this.func_226287_g_(1.6), d0, d1, d2);
            }
        } else {
            super.func_70103_a(id);
        }
    }

    public boolean func_225503_b_(float distance, float damageMultiplier) {
        return false;
    }

    public CreatureAttribute func_70668_bt() {
        return CreatureAttribute.field_223224_c_;
    }

    protected void func_184231_a(double y, boolean onGroundIn, BlockState state, BlockPos pos) {
    }

    public EntitySize func_213305_a(Pose poseIn) {
        return this.isFlying() ? FLIGHT_SIZE : super.func_213305_a(poseIn);
    }

    public void func_213352_e(Vector3d vec3d) {
        if (this.func_233570_aj_() && !this.isFlying()) {
            if (this.func_70661_as().func_75505_d() != null) {
                this.func_70661_as().func_75499_g();
            }
            vec3d = Vector3d.field_186680_a;
        }
        super.func_213352_e(vec3d);
    }

    public ActionResultType func_230254_b_(PlayerEntity player, Hand hand) {
        ItemStack itemstack = player.func_184586_b(hand);
        Item item = itemstack.func_77973_b();
        ActionResultType type = super.func_230254_b_(player, hand);
        if (item == AMItemRegistry.WARPED_MIXTURE && !this.isSick()) {
            this.func_199701_a_(item.getContainerItem(itemstack));
            if (!player.func_184812_l_()) {
                itemstack.func_190918_g(1);
            }
            this.setSick(true);
            return ActionResultType.SUCCESS;
        }
        return type;
    }

    public boolean isTargetBlocked(Vector3d target) {
        Vector3d Vector3d2 = new Vector3d(this.func_226277_ct_(), this.func_226280_cw_(), this.func_226281_cx_());
        return this.field_70170_p.func_217299_a(new RayTraceContext(Vector3d2, target, RayTraceContext.BlockMode.COLLIDER, RayTraceContext.FluidMode.NONE, (Entity)this)).func_216346_c() != RayTraceResult.Type.MISS;
    }

    private BlockPos getGroundPosition(BlockPos radialPos) {
        while (radialPos.func_177956_o() > 1 && this.field_70170_p.func_175623_d(radialPos)) {
            radialPos = radialPos.func_177977_b();
        }
        return radialPos;
    }

    public boolean isNonMungusWarpedTrigger(Entity entity) {
        String name = entity.func_200600_R().getRegistryName().toString();
        return !AMConfig.warpedMoscoMobTriggers.isEmpty() && AMConfig.warpedMoscoMobTriggers.contains(name);
    }

    public class FlyAwayFromTarget
    extends Goal {
        private final EntityCrimsonMosquito parentEntity;
        private int spitCooldown = 0;
        private BlockPos shootPos = null;

        public FlyAwayFromTarget(EntityCrimsonMosquito mosquito) {
            this.parentEntity = mosquito;
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean func_75250_a() {
            if (!this.parentEntity.isFlying() || this.parentEntity.getBloodLevel() <= 0 && this.parentEntity.drinkTime >= 0) {
                return false;
            }
            if (!this.parentEntity.func_184218_aH() && this.parentEntity.func_70638_az() != null) {
                this.shootPos = this.getBlockInTargetsViewMosquito(this.parentEntity.func_70638_az());
                return true;
            }
            return false;
        }

        public boolean func_75253_b() {
            return this.parentEntity.func_70638_az() != null && (this.parentEntity.getBloodLevel() > 0 || this.parentEntity.drinkTime < 0) && this.parentEntity.isFlying() && !this.parentEntity.field_70123_F;
        }

        public void func_75251_c() {
            this.spitCooldown = 20;
        }

        public void func_75246_d() {
            if (this.spitCooldown > 0) {
                --this.spitCooldown;
            }
            if (this.parentEntity.func_70638_az() != null) {
                if (this.shootPos == null) {
                    this.shootPos = this.getBlockInTargetsViewMosquito(this.parentEntity.func_70638_az());
                } else {
                    this.parentEntity.func_70605_aq().func_75642_a((double)this.shootPos.func_177958_n() + 0.5, (double)this.shootPos.func_177956_o() + 0.5, (double)this.shootPos.func_177952_p() + 0.5, 1.0);
                    this.parentEntity.func_70625_a((Entity)this.parentEntity.func_70638_az(), 30.0f, 30.0f);
                    if (this.parentEntity.func_195048_a(Vector3d.func_237489_a_((Vector3i)this.shootPos)) < 2.5) {
                        if (this.spitCooldown == 0 && this.parentEntity.getBloodLevel() > 0) {
                            this.parentEntity.setupShooting();
                            this.spitCooldown = 20;
                        }
                        this.shootPos = null;
                    }
                }
            }
        }

        public BlockPos getBlockInTargetsViewMosquito(LivingEntity target) {
            float radius = 4 + this.parentEntity.func_70681_au().nextInt(5);
            float neg = this.parentEntity.func_70681_au().nextBoolean() ? 1.0f : -1.0f;
            float angle = (float)Math.PI / 180 * (target.field_70759_as + 90.0f + (float)this.parentEntity.func_70681_au().nextInt(180));
            double extraX = radius * MathHelper.func_76126_a((float)((float)(Math.PI + (double)angle)));
            double extraZ = radius * MathHelper.func_76134_b((float)angle);
            BlockPos radialPos = new BlockPos(target.func_226277_ct_() + extraX, target.func_226278_cu_() + 1.0, target.func_226281_cx_() + extraZ);
            BlockPos ground = radialPos;
            if (this.parentEntity.func_195048_a(Vector3d.func_237489_a_((Vector3i)ground)) > 30.0 && !this.parentEntity.isTargetBlocked(Vector3d.func_237489_a_((Vector3i)ground)) && this.parentEntity.func_195048_a(Vector3d.func_237489_a_((Vector3i)ground)) > 6.0) {
                return ground;
            }
            return this.parentEntity.func_233580_cy_();
        }
    }

    public class FlyTowardsTarget
    extends Goal {
        private final EntityCrimsonMosquito parentEntity;

        public FlyTowardsTarget(EntityCrimsonMosquito mosquito) {
            this.parentEntity = mosquito;
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean func_75250_a() {
            if (!this.parentEntity.isFlying() || this.parentEntity.getBloodLevel() > 0 || this.parentEntity.drinkTime < 0) {
                return false;
            }
            return !this.parentEntity.func_184218_aH() && this.parentEntity.func_70638_az() != null && !this.isBittenByMosquito((Entity)this.parentEntity.func_70638_az());
        }

        public boolean func_75253_b() {
            return this.parentEntity.drinkTime >= 0 && this.parentEntity.func_70638_az() != null && !this.isBittenByMosquito((Entity)this.parentEntity.func_70638_az()) && !this.parentEntity.field_70123_F && this.parentEntity.getBloodLevel() == 0 && this.parentEntity.isFlying() && this.parentEntity.func_70605_aq().func_75640_a();
        }

        public boolean isBittenByMosquito(Entity entity) {
            for (Entity e : entity.func_184188_bt()) {
                if (!(e instanceof EntityCrimsonMosquito)) continue;
                return true;
            }
            return false;
        }

        public void func_75251_c() {
        }

        public void func_75246_d() {
            if (this.parentEntity.func_70638_az() != null) {
                this.parentEntity.func_70605_aq().func_75642_a(this.parentEntity.func_70638_az().func_226277_ct_(), this.parentEntity.func_70638_az().func_226278_cu_(), this.parentEntity.func_70638_az().func_226281_cx_(), 1.0);
                if (this.parentEntity.func_174813_aQ().func_72314_b((double)0.3f, (double)0.3f, (double)0.3f).func_72326_a(this.parentEntity.func_70638_az().func_174813_aQ()) && !this.isBittenByMosquito((Entity)this.parentEntity.func_70638_az()) && this.parentEntity.drinkTime == 0) {
                    this.parentEntity.func_184205_a((Entity)this.parentEntity.func_70638_az(), true);
                    if (!this.parentEntity.field_70170_p.field_72995_K) {
                        AlexsMobs.sendMSGToAll(new MessageMosquitoMountPlayer(this.parentEntity.func_145782_y(), this.parentEntity.func_70638_az().func_145782_y()));
                    }
                }
            }
        }
    }

    static class MoveHelperController
    extends MovementController {
        private final EntityCrimsonMosquito parentEntity;

        public MoveHelperController(EntityCrimsonMosquito sunbird) {
            super((MobEntity)sunbird);
            this.parentEntity = sunbird;
        }

        public void func_75641_c() {
            if (this.field_75645_e >= 1.0 && this.parentEntity.isSick()) {
                this.field_75645_e = 0.35;
            }
            if (this.parentEntity.isFlying()) {
                if (this.field_188491_h == MovementController.Action.STRAFE) {
                    Vector3d vector3d = new Vector3d(this.field_75646_b - this.parentEntity.func_226277_ct_(), this.field_75647_c - this.parentEntity.func_226278_cu_(), this.field_75644_d - this.parentEntity.func_226281_cx_());
                    double d0 = vector3d.func_72433_c();
                    this.parentEntity.func_213317_d(this.parentEntity.func_213322_ci().func_72441_c(0.0, vector3d.func_186678_a(this.field_75645_e * 0.05 / d0).func_82617_b(), 0.0));
                    float f = (float)this.field_75648_a.func_233637_b_(Attributes.field_233821_d_);
                    float f1 = (float)this.field_75645_e * f;
                    float f2 = this.field_188489_f;
                    float f3 = this.field_188490_g;
                    float f4 = MathHelper.func_76129_c((float)(f2 * f2 + f3 * f3));
                    if (f4 < 1.0f) {
                        f4 = 1.0f;
                    }
                    f4 = f1 / f4;
                    float f5 = MathHelper.func_76126_a((float)(this.field_75648_a.field_70177_z * ((float)Math.PI / 180)));
                    float f6 = MathHelper.func_76134_b((float)(this.field_75648_a.field_70177_z * ((float)Math.PI / 180)));
                    float f7 = (f2 *= f4) * f6 - (f3 *= f4) * f5;
                    float f8 = f3 * f6 + f2 * f5;
                    this.field_188489_f = 1.0f;
                    this.field_188490_g = 0.0f;
                    this.field_75648_a.func_70659_e(f1);
                    this.field_75648_a.func_191989_p(this.field_188489_f);
                    this.field_75648_a.func_184646_p(this.field_188490_g);
                    this.field_188491_h = MovementController.Action.WAIT;
                } else if (this.field_188491_h == MovementController.Action.MOVE_TO) {
                    Vector3d vector3d = new Vector3d(this.field_75646_b - this.parentEntity.func_226277_ct_(), this.field_75647_c - this.parentEntity.func_226278_cu_(), this.field_75644_d - this.parentEntity.func_226281_cx_());
                    double d0 = vector3d.func_72433_c();
                    if (d0 < this.parentEntity.func_174813_aQ().func_72320_b()) {
                        this.field_188491_h = MovementController.Action.WAIT;
                        this.parentEntity.func_213317_d(this.parentEntity.func_213322_ci().func_186678_a(0.5));
                    } else {
                        this.parentEntity.func_213317_d(this.parentEntity.func_213322_ci().func_178787_e(vector3d.func_186678_a(this.field_75645_e * 0.05 / d0)));
                        if (this.parentEntity.func_70638_az() == null) {
                            Vector3d vector3d1 = this.parentEntity.func_213322_ci();
                            this.parentEntity.field_70761_aq = this.parentEntity.field_70177_z = -((float)MathHelper.func_181159_b((double)vector3d1.field_72450_a, (double)vector3d1.field_72449_c)) * 57.295776f;
                        } else {
                            double d2 = this.parentEntity.func_70638_az().func_226277_ct_() - this.parentEntity.func_226277_ct_();
                            double d1 = this.parentEntity.func_70638_az().func_226281_cx_() - this.parentEntity.func_226281_cx_();
                            this.parentEntity.field_70761_aq = this.parentEntity.field_70177_z = -((float)MathHelper.func_181159_b((double)d2, (double)d1)) * 57.295776f;
                        }
                    }
                }
            } else {
                this.field_188491_h = MovementController.Action.WAIT;
                this.field_75648_a.func_70659_e(0.0f);
                this.field_75648_a.func_191989_p(0.0f);
                this.field_75648_a.func_184646_p(0.0f);
            }
        }

        private boolean func_220673_a(Vector3d p_220673_1_, int p_220673_2_) {
            AxisAlignedBB axisalignedbb = this.parentEntity.func_174813_aQ();
            for (int i = 1; i < p_220673_2_; ++i) {
                if (this.parentEntity.field_70170_p.func_226665_a__((Entity)this.parentEntity, axisalignedbb = axisalignedbb.func_191194_a(p_220673_1_))) continue;
                return false;
            }
            return true;
        }
    }

    static class RandomFlyGoal
    extends Goal {
        private final EntityCrimsonMosquito parentEntity;
        private BlockPos target = null;

        public RandomFlyGoal(EntityCrimsonMosquito mosquito) {
            this.parentEntity = mosquito;
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean func_75250_a() {
            MovementController movementcontroller = this.parentEntity.func_70605_aq();
            if (!this.parentEntity.isFlying() || this.parentEntity.func_70638_az() != null) {
                return false;
            }
            if (!movementcontroller.func_75640_a() || this.target == null) {
                this.target = this.getBlockInViewMosquito();
                if (this.target != null) {
                    this.parentEntity.func_70605_aq().func_75642_a((double)this.target.func_177958_n() + 0.5, (double)this.target.func_177956_o() + 0.5, (double)this.target.func_177952_p() + 0.5, 1.0);
                }
                return true;
            }
            return false;
        }

        public boolean func_75253_b() {
            return this.target != null && this.parentEntity.isFlying() && this.parentEntity.func_195048_a(Vector3d.func_237489_a_((Vector3i)this.target)) > 2.4 && this.parentEntity.func_70605_aq().func_75640_a() && !this.parentEntity.field_70123_F;
        }

        public void func_75251_c() {
            this.target = null;
        }

        public void func_75246_d() {
            if (this.target == null) {
                this.target = this.getBlockInViewMosquito();
            }
            if (this.target != null) {
                this.parentEntity.func_70605_aq().func_75642_a((double)this.target.func_177958_n() + 0.5, (double)this.target.func_177956_o() + 0.5, (double)this.target.func_177952_p() + 0.5, 1.0);
                if (this.parentEntity.func_195048_a(Vector3d.func_237489_a_((Vector3i)this.target)) < 2.5) {
                    this.target = null;
                }
            }
        }

        public BlockPos getBlockInViewMosquito() {
            float radius = 1 + this.parentEntity.func_70681_au().nextInt(5);
            float neg = this.parentEntity.func_70681_au().nextBoolean() ? 1.0f : -1.0f;
            float renderYawOffset = this.parentEntity.field_70761_aq;
            float angle = (float)Math.PI / 180 * renderYawOffset + 3.15f + this.parentEntity.func_70681_au().nextFloat() * neg;
            double extraX = radius * MathHelper.func_76126_a((float)((float)(Math.PI + (double)angle)));
            double extraZ = radius * MathHelper.func_76134_b((float)angle);
            BlockPos radialPos = new BlockPos(this.parentEntity.func_226277_ct_() + extraX, this.parentEntity.func_226278_cu_() + 2.0, this.parentEntity.func_226281_cx_() + extraZ);
            BlockPos ground = this.parentEntity.getGroundPosition(radialPos);
            int up = this.parentEntity.isSick() ? 2 : 6;
            BlockPos newPos = ground.func_177981_b(1 + this.parentEntity.func_70681_au().nextInt(up));
            if (!this.parentEntity.isTargetBlocked(Vector3d.func_237489_a_((Vector3i)newPos)) && this.parentEntity.func_195048_a(Vector3d.func_237489_a_((Vector3i)newPos)) > 6.0) {
                return newPos;
            }
            return null;
        }
    }
}

