/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.alexsmobs.entity;

import com.github.alexthe666.alexsmobs.client.particle.AMParticleRegistry;
import com.github.alexthe666.alexsmobs.config.AMConfig;
import com.github.alexthe666.alexsmobs.entity.AMEntityRegistry;
import com.github.alexthe666.alexsmobs.entity.EntityCachalotEcho;
import com.github.alexthe666.alexsmobs.entity.EntityCachalotPart;
import com.github.alexthe666.alexsmobs.entity.ai.AnimalAIFollowParentRanged;
import com.github.alexthe666.alexsmobs.entity.ai.AnimalAIHurtByTargetNotBaby;
import com.github.alexthe666.alexsmobs.entity.ai.AnimalAIRandomSwimming;
import com.github.alexthe666.alexsmobs.entity.ai.AnimalSwimMoveControllerSink;
import com.github.alexthe666.alexsmobs.entity.ai.EntityAINearestTarget3D;
import com.github.alexthe666.alexsmobs.item.AMItemRegistry;
import com.github.alexthe666.alexsmobs.misc.AMSoundRegistry;
import com.github.alexthe666.alexsmobs.misc.AMTagRegistry;
import java.util.EnumSet;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityPredicate;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.controller.DolphinLookController;
import net.minecraft.entity.ai.goal.BreedGoal;
import net.minecraft.entity.ai.goal.FindWaterGoal;
import net.minecraft.entity.ai.goal.FollowBoatGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.item.BoatEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.pathfinding.PathNavigator;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.pathfinding.PathType;
import net.minecraft.pathfinding.SwimmerPathNavigator;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.entity.PartEntity;
import net.minecraftforge.event.ForgeEventFactory;

public class EntityCachalotWhale
extends AnimalEntity {
    private static final EntityPredicate REWARD_PLAYER_PREDICATE = new EntityPredicate().func_221013_a(50.0).func_221008_a().func_221011_b().func_221009_d();
    private static final DataParameter<Boolean> CHARGING = EntityDataManager.func_187226_a(EntityCachalotWhale.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> SLEEPING = EntityDataManager.func_187226_a(EntityCachalotWhale.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> BEACHED = EntityDataManager.func_187226_a(EntityCachalotWhale.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> ALBINO = EntityDataManager.func_187226_a(EntityCachalotWhale.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> DESPAWN_BEACH = EntityDataManager.func_187226_a(EntityCachalotWhale.class, (IDataSerializer)DataSerializers.field_187198_h);
    public final double[][] ringBuffer = new double[64][3];
    public final EntityCachalotPart headPart;
    public final EntityCachalotPart bodyFrontPart;
    public final EntityCachalotPart bodyPart;
    public final EntityCachalotPart tail1Part;
    public final EntityCachalotPart tail2Part;
    public final EntityCachalotPart tail3Part;
    public final EntityCachalotPart[] whaleParts;
    public int ringBufferIndex = -1;
    public float prevChargingProgress;
    public float chargeProgress;
    public float prevSleepProgress;
    public float sleepProgress;
    public float prevBeachedProgress;
    public float beachedProgress;
    private boolean receivedEcho = false;
    private boolean waitForEchoFlag = true;
    private int echoTimer = 0;
    private boolean prevEyesInWater = false;
    private int spoutTimer = 0;
    private int chargeCooldown = 0;
    private float whaleSpeedMod = 1.0f;
    private int rewardTime = 0;
    private PlayerEntity rewardPlayer;
    private int blockBreakCounter;
    private int despawnDelay = 47999;
    private int ambergrisDrops = 0;
    private boolean hasAlbinoAttribute = false;
    private int echoSoundCooldown = 0;

    public EntityCachalotWhale(EntityType type, World world) {
        super(type, world);
        this.func_184644_a(PathNodeType.WATER, 0.0f);
        this.field_70765_h = new AnimalSwimMoveControllerSink((CreatureEntity)this, 1.0f, 1.0f, 3.0f);
        this.field_70749_g = new DolphinLookController((MobEntity)this, 4);
        this.headPart = new EntityCachalotPart(this, 3.0f, 3.5f);
        this.bodyFrontPart = new EntityCachalotPart(this, 4.0f, 4.0f);
        this.bodyPart = new EntityCachalotPart(this, 5.0f, 4.0f);
        this.tail1Part = new EntityCachalotPart(this, 4.0f, 3.0f);
        this.tail2Part = new EntityCachalotPart(this, 3.0f, 2.0f);
        this.tail3Part = new EntityCachalotPart(this, 3.0f, 0.7f);
        this.whaleParts = new EntityCachalotPart[]{this.headPart, this.bodyFrontPart, this.bodyPart, this.tail1Part, this.tail2Part, this.tail3Part};
    }

    public static AttributeModifierMap.MutableAttribute bakeAttributes() {
        return MonsterEntity.func_234295_eP_().func_233815_a_(Attributes.field_233818_a_, 160.0).func_233815_a_(Attributes.field_233820_c_, 1.0).func_233815_a_(Attributes.field_233819_b_, 32.0).func_233815_a_(Attributes.field_233821_d_, (double)1.2f).func_233815_a_(Attributes.field_233823_f_, 30.0);
    }

    public static <T extends MobEntity> boolean canCachalotWhaleSpawn(EntityType<T> entityType, IServerWorld iServerWorld, SpawnReason reason, BlockPos pos, Random random) {
        return iServerWorld.func_204610_c(pos).func_206884_a((ITag)FluidTags.field_206959_a);
    }

    public boolean func_213397_c(double distanceToClosestPlayer) {
        return !this.func_70608_bn() && !this.isCharging() && !this.isDespawnBeach() && !this.isAlbino();
    }

    private boolean canDespawn() {
        return this.isDespawnBeach();
    }

    private void tryDespawn() {
        if (this.canDespawn()) {
            --this.despawnDelay;
            if (this.despawnDelay <= 0) {
                this.func_110160_i(true, false);
                this.func_70106_y();
            }
        }
    }

    protected SoundEvent func_184639_G() {
        return AMSoundRegistry.CACHALOT_WHALE_IDLE;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return AMSoundRegistry.CACHALOT_WHALE_HURT;
    }

    protected SoundEvent func_184615_bR() {
        return AMSoundRegistry.CACHALOT_WHALE_HURT;
    }

    public void scaleParts() {
        for (EntityCachalotPart parts : this.whaleParts) {
            float prev = parts.scale;
            float f = parts.scale = this.func_70631_g_() ? 0.5f : 1.0f;
            if (prev == parts.scale) continue;
            parts.func_213323_x_();
        }
    }

    public boolean func_70067_L() {
        return false;
    }

    public void func_85033_bc() {
    }

    public ActionResultType func_230254_b_(PlayerEntity p_230254_1_, Hand p_230254_2_) {
        return super.func_230254_b_(p_230254_1_, p_230254_2_);
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74757_a("Albino", this.isAlbino());
        compound.func_74757_a("Beached", this.isBeached());
        compound.func_74757_a("BeachedDespawnFlag", this.isDespawnBeach());
        compound.func_74768_a("DespawnDelay", this.despawnDelay);
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.setAlbino(compound.func_74767_n("Albino"));
        this.setBeached(compound.func_74767_n("Beached"));
        this.setDespawnBeach(compound.func_74767_n("BeachedDespawnFlag"));
        if (compound.func_150297_b("DespawnDelay", 99)) {
            this.despawnDelay = compound.func_74762_e("DespawnDelay");
        }
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(CHARGING, (Object)false);
        this.field_70180_af.func_187214_a(SLEEPING, (Object)false);
        this.field_70180_af.func_187214_a(BEACHED, (Object)false);
        this.field_70180_af.func_187214_a(ALBINO, (Object)false);
        this.field_70180_af.func_187214_a(DESPAWN_BEACH, (Object)false);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (Goal)new AIBreathe());
        this.field_70714_bg.func_75776_a(1, (Goal)new FindWaterGoal((CreatureEntity)this));
        this.field_70714_bg.func_75776_a(2, (Goal)new BreedGoal((AnimalEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(3, (Goal)new AnimalAIFollowParentRanged(this, 1.1f, 32.0f, 10.0f));
        this.field_70714_bg.func_75776_a(4, (Goal)new AnimalAIRandomSwimming(this, 0.6, 10, 24, true){

            @Override
            public boolean func_75250_a() {
                return !EntityCachalotWhale.this.func_70608_bn() && !EntityCachalotWhale.this.isBeached() && super.func_75250_a();
            }
        });
        this.field_70714_bg.func_75776_a(5, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(6, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 20.0f));
        this.field_70714_bg.func_75776_a(7, (Goal)new FollowBoatGoal((CreatureEntity)this));
        this.field_70715_bh.func_75776_a(1, (Goal)new AnimalAIHurtByTargetNotBaby(this, new Class[0]).func_220794_a(new Class[0]));
        this.field_70715_bh.func_75776_a(2, (Goal)new EntityAINearestTarget3D((MobEntity)this, LivingEntity.class, 30, false, true, AMEntityRegistry.buildPredicateFromTag(EntityTypeTags.func_219762_a().func_199910_a(AMTagRegistry.CACHALOT_WHALE_TARGETS))){

            public boolean func_75250_a() {
                return !EntityCachalotWhale.this.func_70608_bn() && !EntityCachalotWhale.this.isBeached() && super.func_75250_a();
            }
        });
    }

    protected PathNavigator func_175447_b(World worldIn) {
        return new SwimmerPathNavigator((MobEntity)this, worldIn);
    }

    public void func_70619_bc() {
        super.func_70619_bc();
        this.breakBlock();
    }

    public void breakBlock() {
        ResourceLocation breakables;
        if (this.blockBreakCounter > 0) {
            --this.blockBreakCounter;
            return;
        }
        boolean flag = false;
        ResourceLocation resourceLocation = breakables = this.isCharging() && this.func_70638_az() != null ? AMTagRegistry.CACHALOT_WHALE_BREAKABLES : AMTagRegistry.ORCA_BREAKABLES;
        if (!this.field_70170_p.field_72995_K && this.blockBreakCounter == 0 && ForgeEventFactory.getMobGriefingEvent((World)this.field_70170_p, (Entity)this)) {
            for (int a = (int)Math.round(this.func_174813_aQ().field_72340_a); a <= (int)Math.round(this.func_174813_aQ().field_72336_d); ++a) {
                for (int b = (int)Math.round(this.func_174813_aQ().field_72338_b) - 1; b <= (int)Math.round(this.func_174813_aQ().field_72337_e) + 1 && b <= 127; ++b) {
                    for (int c = (int)Math.round(this.func_174813_aQ().field_72339_c); c <= (int)Math.round(this.func_174813_aQ().field_72334_f); ++c) {
                        BlockPos pos = new BlockPos(a, b, c);
                        BlockState state = this.field_70170_p.func_180495_p(pos);
                        FluidState fluidState = this.field_70170_p.func_204610_c(pos);
                        Block block = state.func_177230_c();
                        if (state.func_196958_f() || state.func_196954_c((IBlockReader)this.field_70170_p, pos).func_197766_b() || !BlockTags.func_199896_a().func_199910_a(breakables).func_230235_a_((Object)state.func_177230_c()) || !fluidState.func_206888_e() || block == Blocks.field_150350_a) continue;
                        this.func_213317_d(this.func_213322_ci().func_216372_d((double)0.6f, 1.0, (double)0.6f));
                        flag = true;
                        this.field_70170_p.func_175655_b(pos, true);
                        if (!state.func_177230_c().func_203417_a((ITag)BlockTags.field_205213_E)) continue;
                        this.field_70170_p.func_175656_a(pos, Blocks.field_150355_j.func_176223_P());
                    }
                }
            }
        }
        if (flag) {
            this.blockBreakCounter = this.isCharging() && this.func_70638_az() != null ? 2 : 20;
        }
    }

    public void func_213352_e(Vector3d travelVector) {
        if (this.func_70613_aW() && this.func_70090_H()) {
            this.func_213309_a(this.func_70689_ay(), travelVector);
            this.func_213315_a(MoverType.SELF, this.func_213322_ci());
            this.func_213317_d(this.func_213322_ci().func_186678_a(0.9));
        } else {
            super.func_213352_e(travelVector);
        }
    }

    private void spawnSpoutParticles() {
        if (this.func_70089_S()) {
            for (int j = 0; j < 5 + this.field_70146_Z.nextInt(4); ++j) {
                float radius = this.headPart.func_213311_cf() * 0.5f;
                float angle = (float)Math.PI / 180 * this.field_70761_aq;
                double extraX = (double)(radius * (1.0f + this.field_70146_Z.nextFloat() * 0.13f) * MathHelper.func_76126_a((float)((float)(Math.PI + (double)angle))) + (this.field_70146_Z.nextFloat() - 0.5f)) + this.func_213322_ci().field_72450_a * 2.0;
                double extraZ = (double)(radius * (1.0f + this.field_70146_Z.nextFloat() * 0.13f) * MathHelper.func_76134_b((float)angle) + (this.field_70146_Z.nextFloat() - 0.5f)) + this.func_213322_ci().field_72449_c * 2.0;
                double motX = this.field_70146_Z.nextGaussian();
                double motZ = this.field_70146_Z.nextGaussian();
                this.field_70170_p.func_195594_a((IParticleData)AMParticleRegistry.WHALE_SPLASH, this.headPart.func_226277_ct_() + extraX, this.headPart.func_226278_cu_() + (double)this.headPart.func_213302_cg(), this.headPart.func_226281_cx_() + extraZ, motX * (double)0.1f + this.func_213322_ci().field_72450_a, 2.0, motZ * (double)0.1f + this.func_213322_ci().field_72449_c);
            }
        }
    }

    public boolean isCharging() {
        return (Boolean)this.field_70180_af.func_187225_a(CHARGING);
    }

    public void setCharging(boolean charging) {
        this.field_70180_af.func_187227_b(CHARGING, (Object)charging);
    }

    public boolean func_70608_bn() {
        return (Boolean)this.field_70180_af.func_187225_a(SLEEPING);
    }

    public void setSleeping(boolean charging) {
        this.field_70180_af.func_187227_b(SLEEPING, (Object)charging);
    }

    public boolean isBeached() {
        return (Boolean)this.field_70180_af.func_187225_a(BEACHED);
    }

    public void setBeached(boolean charging) {
        this.field_70180_af.func_187227_b(BEACHED, (Object)charging);
    }

    public boolean isAlbino() {
        return (Boolean)this.field_70180_af.func_187225_a(ALBINO);
    }

    public void setAlbino(boolean albino) {
        boolean prev = this.isAlbino();
        if (!prev && albino) {
            this.func_110148_a(Attributes.field_233818_a_).func_111128_a(230.0);
            this.func_110148_a(Attributes.field_233823_f_).func_111128_a(45.0);
            this.func_70606_j(160.0f);
        } else {
            this.func_110148_a(Attributes.field_233818_a_).func_111128_a(160.0);
            this.func_110148_a(Attributes.field_233823_f_).func_111128_a(30.0);
        }
        this.field_70180_af.func_187227_b(ALBINO, (Object)albino);
    }

    public boolean isDespawnBeach() {
        return (Boolean)this.field_70180_af.func_187225_a(DESPAWN_BEACH);
    }

    public void setDespawnBeach(boolean despawn) {
        this.field_70180_af.func_187227_b(DESPAWN_BEACH, (Object)despawn);
    }

    protected float func_70599_aP() {
        return this.func_174814_R() ? 0.0f : (float)AMConfig.cachalotVolume;
    }

    public void func_70636_d() {
        float targetPitch;
        float targetYaw;
        double d3;
        double d2;
        double d1;
        double d0;
        super.func_70636_d();
        this.scaleParts();
        if (this.echoSoundCooldown > 0) {
            --this.echoSoundCooldown;
        }
        if (this.func_70608_bn()) {
            this.func_70661_as().func_75499_g();
            this.field_70125_A = -90.0f;
            this.whaleSpeedMod = 0.0f;
            if (this.func_208600_a((ITag)FluidTags.field_206959_a) && this.func_70086_ai() < 200) {
                this.func_213317_d(this.func_213322_ci().func_72441_c(0.0, 0.06, 0.0));
            } else {
                BlockPos waterPos = this.func_233580_cy_();
                while (this.field_70170_p.func_204610_c(waterPos).func_206884_a((ITag)FluidTags.field_206959_a) && waterPos.func_177956_o() < 255) {
                    waterPos = waterPos.func_177984_a();
                }
                double d = (double)waterPos.func_177956_o() - this.func_226278_cu_();
                int n = this.func_70631_g_() ? 7 : 12;
                if (d < (double)n) {
                    this.func_213317_d(this.func_213322_ci().func_72441_c(0.0, -0.06, 0.0));
                }
                if (this.field_70146_Z.nextInt(100) == 0) {
                    this.func_213317_d(this.func_213322_ci().func_72441_c(0.0, this.field_70146_Z.nextGaussian() * 0.06, 0.0));
                }
            }
        } else if (this.whaleSpeedMod == 0.0f) {
            this.whaleSpeedMod = 1.0f;
        }
        float rPitch = (float)(-((double)((float)this.func_213322_ci().field_72448_b) * 57.2957763671875));
        this.field_70125_A = MathHelper.func_76131_a((float)rPitch, (float)-90.0f, (float)90.0f);
        if (this.func_233570_aj_() && !this.func_203005_aq()) {
            this.setBeached(true);
            this.field_70125_A = 0.0f;
            this.setSleeping(false);
        }
        if (this.isBeached()) {
            this.whaleSpeedMod = 0.0f;
            this.func_213317_d(this.func_213322_ci().func_216372_d(0.5, 0.5, 0.5));
            if (this.func_208600_a((ITag)FluidTags.field_206959_a)) {
                PlayerEntity entity = this.field_70170_p.func_217370_a(REWARD_PLAYER_PREDICATE, (LivingEntity)this);
                if (this.func_70643_av() != entity) {
                    this.rewardTime = 15;
                    this.rewardPlayer = entity;
                }
                this.despawnDelay = 47999;
                this.setBeached(false);
            }
        }
        if (!this.isBeached() && this.rewardTime > 0) {
            float dif = 0.0f;
            if (this.rewardPlayer != null) {
                d0 = this.rewardPlayer.func_226277_ct_() - this.func_226277_ct_();
                d1 = this.rewardPlayer.func_226280_cw_() - this.func_226280_cw_();
                d2 = this.rewardPlayer.func_226281_cx_() - this.func_226281_cx_();
                d3 = MathHelper.func_76133_a((double)(d0 * d0 + d2 * d2));
                targetYaw = (float)(MathHelper.func_181159_b((double)d2, (double)d0) * 57.2957763671875) - 90.0f;
                targetPitch = (float)(-(MathHelper.func_181159_b((double)d1, (double)d3) * 57.2957763671875));
                this.field_70177_z += MathHelper.func_76131_a((float)(targetYaw - this.field_70177_z), (float)-2.0f, (float)2.0f);
                this.field_70125_A += MathHelper.func_76131_a((float)(targetPitch - this.field_70125_A), (float)-2.0f, (float)2.0f);
                this.field_70761_aq = this.field_70177_z;
                dif = Math.abs(MathHelper.func_76142_g((float)targetYaw) - MathHelper.func_76142_g((float)this.field_70177_z));
            }
            if (dif < 5.0f) {
                if (this.rewardTime % 5 == 0 && this.ambergrisDrops < 2 + this.field_70146_Z.nextInt(1) && this.isDespawnBeach()) {
                    ++this.ambergrisDrops;
                    if (!this.field_70170_p.field_72995_K) {
                        Vector3d vec = this.getMouthVec();
                        ItemEntity itementity = new ItemEntity(this.field_70170_p, vec.field_72450_a, vec.field_72448_b, vec.field_72449_c, new ItemStack((IItemProvider)AMItemRegistry.AMBERGRIS));
                        itementity.func_174869_p();
                        this.field_70170_p.func_217376_c((Entity)itementity);
                    }
                }
                --this.rewardTime;
            }
            if (this.rewardTime <= 2) {
                this.setDespawnBeach(false);
                this.setCharging(false);
                this.whaleSpeedMod = 1.0f;
            } else {
                this.setCharging(true);
                this.whaleSpeedMod = 0.2f;
            }
        }
        this.prevChargingProgress = this.chargeProgress;
        this.prevSleepProgress = this.sleepProgress;
        this.prevBeachedProgress = this.beachedProgress;
        if (this.isCharging() && this.chargeProgress < 10.0f) {
            this.chargeProgress += 1.0f;
        }
        if (!this.isCharging() && this.chargeProgress > 0.0f) {
            this.chargeProgress -= 1.0f;
        }
        if (this.func_70608_bn() && this.sleepProgress < 10.0f) {
            this.sleepProgress += 1.0f;
        }
        if (!this.func_70608_bn() && this.sleepProgress > 0.0f) {
            this.sleepProgress -= 1.0f;
        }
        if (this.isBeached() && this.beachedProgress < 10.0f) {
            this.beachedProgress += 1.0f;
        }
        if (!this.isBeached() && this.beachedProgress > 0.0f) {
            this.beachedProgress -= 1.0f;
        }
        this.field_70759_as = this.field_70177_z;
        this.field_70761_aq = this.field_70177_z;
        if (!this.func_175446_cd()) {
            if (this.ringBufferIndex < 0) {
                for (int i = 0; i < this.ringBuffer.length; ++i) {
                    this.ringBuffer[i][0] = this.field_70177_z;
                    this.ringBuffer[i][1] = this.func_226278_cu_();
                }
            }
            ++this.ringBufferIndex;
            if (this.ringBufferIndex == this.ringBuffer.length) {
                this.ringBufferIndex = 0;
            }
            this.ringBuffer[this.ringBufferIndex][0] = this.field_70177_z;
            this.ringBuffer[this.ringBufferIndex][1] = this.func_226278_cu_();
            Vector3d[] avector3d = new Vector3d[this.whaleParts.length];
            for (int j = 0; j < this.whaleParts.length; ++j) {
                this.whaleParts[j].collideWithNearbyEntities();
                avector3d[j] = new Vector3d(this.whaleParts[j].func_226277_ct_(), this.whaleParts[j].func_226278_cu_(), this.whaleParts[j].func_226281_cx_());
            }
            float f4 = MathHelper.func_76126_a((float)(this.field_70177_z * ((float)Math.PI / 180) - 0.0f));
            float f19 = MathHelper.func_76134_b((float)(this.field_70177_z * ((float)Math.PI / 180) - 0.0f));
            float f15 = (float)(this.getMovementOffsets(5, 1.0f)[1] - this.getMovementOffsets(10, 1.0f)[1]) * 10.0f * ((float)Math.PI / 180);
            float f16 = MathHelper.func_76134_b((float)f15);
            float f2 = MathHelper.func_76126_a((float)f15);
            float f17 = this.field_70177_z * ((float)Math.PI / 180);
            float pitch = this.field_70125_A * ((float)Math.PI / 180);
            float f3 = MathHelper.func_76126_a((float)f17) * (1.0f - Math.abs(this.field_70125_A / 90.0f));
            float f18 = MathHelper.func_76134_b((float)f17) * (1.0f - Math.abs(this.field_70125_A / 90.0f));
            this.setPartPosition(this.bodyPart, f3 * 0.5f, -pitch * 0.5f, -f18 * 0.5f);
            this.setPartPosition(this.bodyFrontPart, f3 * -3.5f, -pitch * 3.0f, f18 * 3.5f);
            this.setPartPosition(this.headPart, f3 * -7.0f, -pitch * 5.0f, -f18 * -7.0f);
            double[] adouble = this.getMovementOffsets(5, 1.0f);
            for (int k = 0; k < 3; ++k) {
                EntityCachalotPart enderdragonpartentity = null;
                if (k == 0) {
                    enderdragonpartentity = this.tail1Part;
                }
                if (k == 1) {
                    enderdragonpartentity = this.tail2Part;
                }
                if (k == 2) {
                    enderdragonpartentity = this.tail3Part;
                }
                double[] adouble1 = this.getMovementOffsets(15 + k * 5, 1.0f);
                float f7 = this.field_70177_z * ((float)Math.PI / 180) + (float)MathHelper.func_76138_g((double)(adouble1[0] - adouble[0])) * ((float)Math.PI / 180);
                float f20 = MathHelper.func_76126_a((float)f7) * (1.0f - Math.abs(this.field_70125_A / 90.0f));
                float f21 = MathHelper.func_76134_b((float)f7) * (1.0f - Math.abs(this.field_70125_A / 90.0f));
                float f22 = k == 2 ? -3.6f : -3.6f;
                float f23 = (float)(k + 1) * f22 - 2.0f;
                this.setPartPosition(enderdragonpartentity, -(f3 * 0.5f + f20 * f23) * f16, pitch * 1.5f * (float)(k + 1), (f18 * 0.5f + f21 * f23) * f16);
            }
            for (int l = 0; l < this.whaleParts.length; ++l) {
                this.whaleParts[l].field_70169_q = avector3d[l].field_72450_a;
                this.whaleParts[l].field_70167_r = avector3d[l].field_72448_b;
                this.whaleParts[l].field_70166_s = avector3d[l].field_72449_c;
                this.whaleParts[l].field_70142_S = avector3d[l].field_72450_a;
                this.whaleParts[l].field_70137_T = avector3d[l].field_72448_b;
                this.whaleParts[l].field_70136_U = avector3d[l].field_72449_c;
            }
        }
        if (!this.field_70170_p.field_72995_K) {
            LivingEntity target = this.func_70638_az();
            if (target == null || !target.func_70089_S()) {
                this.whaleSpeedMod = this.func_70608_bn() ? 0.0f : 1.0f;
                this.setCharging(false);
            } else if (!this.isBeached() && !this.func_70608_bn()) {
                this.func_70625_a((Entity)target, 360.0f, 360.0f);
                boolean bl = this.waitForEchoFlag = this.func_70643_av() == null || !this.func_70643_av().func_70028_i((Entity)target);
                if (target instanceof PlayerEntity || !target.func_203005_aq()) {
                    this.waitForEchoFlag = false;
                }
                if (this.waitForEchoFlag && !this.receivedEcho) {
                    this.setCharging(false);
                    this.whaleSpeedMod = 0.25f;
                    if (this.echoTimer % 10 == 0) {
                        if (this.echoTimer % 40 == 0) {
                            this.func_184185_a(AMSoundRegistry.CACHALOT_WHALE_CLICK, this.func_70599_aP(), this.func_70647_i());
                        }
                        EntityCachalotEcho echo = new EntityCachalotEcho(this.field_70170_p, this);
                        float radius = this.headPart.func_213311_cf() * 0.5f;
                        float angle = (float)Math.PI / 180 * this.field_70761_aq;
                        double extraX = (double)(radius * (1.0f + this.field_70146_Z.nextFloat() * 0.13f) * MathHelper.func_76126_a((float)((float)(Math.PI + (double)angle))) + (this.field_70146_Z.nextFloat() - 0.5f)) + this.func_213322_ci().field_72450_a * 2.0;
                        double extraZ = (double)(radius * (1.0f + this.field_70146_Z.nextFloat() * 0.13f) * MathHelper.func_76134_b((float)angle) + (this.field_70146_Z.nextFloat() - 0.5f)) + this.func_213322_ci().field_72449_c * 2.0;
                        double x = this.headPart.func_226277_ct_() + extraX;
                        double y = this.headPart.func_226278_cu_() + (double)this.headPart.func_213302_cg() * 0.5;
                        double z = this.headPart.func_226281_cx_() + extraZ;
                        double d02 = target.func_226277_ct_() - x;
                        double d12 = target.func_226283_e_(0.1) - y;
                        double d22 = target.func_226281_cx_() - z;
                        echo.func_70107_b(x, y, z);
                        echo.shoot(d02, d12, d22, 1.0f, 0.0f);
                        this.field_70170_p.func_217376_c((Entity)echo);
                    }
                    ++this.echoTimer;
                }
                if (!this.waitForEchoFlag || this.receivedEcho) {
                    d0 = target.func_226277_ct_() - this.func_226277_ct_();
                    d1 = target.func_226280_cw_() - this.func_226280_cw_();
                    d2 = target.func_226281_cx_() - this.func_226281_cx_();
                    d3 = MathHelper.func_76133_a((double)(d0 * d0 + d2 * d2));
                    targetYaw = (float)(MathHelper.func_181159_b((double)d2, (double)d0) * 57.2957763671875) - 90.0f;
                    targetPitch = (float)(-(MathHelper.func_181159_b((double)d1, (double)d3) * 57.2957763671875));
                    this.field_70125_A += MathHelper.func_76131_a((float)(targetPitch - this.field_70125_A), (float)-2.0f, (float)2.0f);
                    if (d0 * d0 + d2 * d2 >= 4.0) {
                        this.field_70177_z += MathHelper.func_76131_a((float)(targetYaw - this.field_70177_z), (float)-2.0f, (float)2.0f);
                        this.field_70761_aq = this.field_70177_z;
                    }
                    float dif = Math.abs(MathHelper.func_76142_g((float)targetYaw) - MathHelper.func_76142_g((float)this.field_70177_z));
                    if (this.chargeCooldown <= 0 && dif < 4.0f) {
                        this.setCharging(true);
                        this.whaleSpeedMod = 1.5f;
                        if (d0 * d0 + d2 * d2 < 4.0) {
                            this.field_70177_z = this.field_70126_B;
                            this.field_70761_aq = this.field_70126_B;
                            this.func_213317_d(this.func_213322_ci().func_216372_d(0.8, 1.0, 0.8));
                        } else {
                            this.func_70605_aq().func_75642_a(target.func_226277_ct_(), target.func_226278_cu_(), target.func_226281_cx_(), 1.0);
                        }
                        if (this.isCharging() && this.func_70032_d((Entity)target) < this.func_213311_cf() && this.chargeProgress > 4.0f) {
                            target.func_70097_a(DamageSource.func_76358_a((LivingEntity)this), (float)this.func_233637_b_(Attributes.field_233823_f_));
                            this.setCharging(false);
                            if (target.func_184187_bx() instanceof BoatEntity) {
                                BoatEntity boat = (BoatEntity)target.func_184187_bx();
                                for (int i = 0; i < 3; ++i) {
                                    this.func_199703_a((IItemProvider)boat.func_184453_r().func_195933_b());
                                }
                                for (int j = 0; j < 2; ++j) {
                                    this.func_199703_a((IItemProvider)Items.field_151055_y);
                                }
                                target.func_233575_bb_();
                                boat.func_70097_a(DamageSource.func_76358_a((LivingEntity)this), 1000.0f);
                                boat.func_70106_y();
                            }
                            int n = this.chargeCooldown = target instanceof PlayerEntity ? 30 : 100;
                            if (this.field_70146_Z.nextInt(10) == 0 && !this.field_70170_p.field_72995_K) {
                                Vector3d vec = this.getMouthVec();
                                ItemEntity itementity = new ItemEntity(this.field_70170_p, vec.field_72450_a, vec.field_72448_b, vec.field_72449_c, new ItemStack((IItemProvider)AMItemRegistry.CACHALOT_WHALE_TOOTH));
                                itementity.func_174869_p();
                                this.field_70170_p.func_217376_c((Entity)itementity);
                            }
                        }
                    }
                }
            }
            if (this.chargeCooldown > 0) {
                --this.chargeCooldown;
            }
            if (this.spoutTimer > 0) {
                this.field_70170_p.func_72960_a((Entity)this, (byte)67);
                --this.spoutTimer;
                this.field_70125_A = 0.0f;
                this.func_213317_d(this.func_213322_ci().func_216372_d(0.0, 0.0, 0.0));
            }
            if (this.isSleepTime() && !this.func_70608_bn() && this.func_203005_aq() && this.func_70638_az() == null) {
                this.setSleeping(true);
            }
            if (this.func_70608_bn() && (!this.isSleepTime() || this.func_70638_az() != null)) {
                this.setSleeping(false);
            }
        }
        if (this.func_70089_S() && this.isCharging()) {
            for (Entity entity : this.field_70170_p.func_175647_a(LivingEntity.class, this.headPart.func_174813_aQ().func_186662_g(1.0), null)) {
                if (this.func_184191_r(entity) || entity instanceof EntityCachalotPart || entity == this) continue;
                this.launch(entity, true);
            }
        }
        if (this.func_70090_H() && !this.func_208600_a((ITag)FluidTags.field_206959_a) && this.func_70086_ai() > 140) {
            this.func_213317_d(this.func_213322_ci().func_72441_c(0.0, -0.06, 0.0));
        }
        if (!this.field_70170_p.field_72995_K) {
            this.tryDespawn();
        }
        this.prevEyesInWater = this.func_208600_a((ITag)FluidTags.field_206959_a);
    }

    private void launch(Entity e, boolean huge) {
        if (e.func_233570_aj_() || e.func_70090_H()) {
            double d0 = e.func_226277_ct_() - this.func_226277_ct_();
            double d1 = e.func_226281_cx_() - this.func_226281_cx_();
            double d2 = Math.max(d0 * d0 + d1 * d1, 0.001);
            float f = huge ? 2.0f : 0.5f;
            e.func_70024_g(d0 / d2 * (double)f, huge ? 0.5 : (double)0.2f, d1 / d2 * (double)f);
        }
    }

    private boolean isSleepTime() {
        long time = this.field_70170_p.func_72820_D();
        return time > 18000L && time < 22812L && this.func_203005_aq();
    }

    public Vector3d getReturnEchoVector() {
        float radius = this.headPart.func_213311_cf() * 0.5f;
        float angle = (float)Math.PI / 180 * this.field_70761_aq;
        double extraX = (double)(radius * (1.0f + this.field_70146_Z.nextFloat() * 0.13f) * MathHelper.func_76126_a((float)((float)(Math.PI + (double)angle))) + (this.field_70146_Z.nextFloat() - 0.5f)) + this.func_213322_ci().field_72450_a * 2.0;
        double extraZ = (double)(radius * (1.0f + this.field_70146_Z.nextFloat() * 0.13f) * MathHelper.func_76134_b((float)angle) + (this.field_70146_Z.nextFloat() - 0.5f)) + this.func_213322_ci().field_72449_c * 2.0;
        double x = this.headPart.func_226277_ct_() + extraX;
        double y = this.headPart.func_226278_cu_() + (double)this.headPart.func_213302_cg() * 0.5;
        double z = this.headPart.func_226281_cx_() + extraZ;
        return new Vector3d(x, y, z);
    }

    public Vector3d getMouthVec() {
        float radius = this.headPart.func_213311_cf() * 0.5f;
        float angle = (float)Math.PI / 180 * this.field_70761_aq;
        double extraX = (double)(radius * (1.0f + this.field_70146_Z.nextFloat() * 0.13f) * MathHelper.func_76126_a((float)((float)(Math.PI + (double)angle))) + (this.field_70146_Z.nextFloat() - 0.5f)) + this.func_213322_ci().field_72450_a * 2.0;
        double extraZ = (double)(radius * (1.0f + this.field_70146_Z.nextFloat() * 0.13f) * MathHelper.func_76134_b((float)angle) + (this.field_70146_Z.nextFloat() - 0.5f)) + this.func_213322_ci().field_72449_c * 2.0;
        double x = this.headPart.func_226277_ct_() + extraX;
        double y = this.headPart.func_226278_cu_() + 0.25;
        double z = this.headPart.func_226281_cx_() + extraZ;
        return new Vector3d(x, y, z);
    }

    public void func_70624_b(@Nullable LivingEntity entitylivingbaseIn) {
        LivingEntity prev = this.func_70638_az();
        if (prev != entitylivingbaseIn && entitylivingbaseIn != null) {
            this.receivedEcho = false;
        }
        super.func_70624_b(entitylivingbaseIn);
    }

    public double[] getMovementOffsets(int p_70974_1_, float partialTicks) {
        if (this.func_233643_dh_()) {
            partialTicks = 0.0f;
        }
        partialTicks = 1.0f - partialTicks;
        int i = this.ringBufferIndex - p_70974_1_ & 0x3F;
        int j = this.ringBufferIndex - p_70974_1_ - 1 & 0x3F;
        double[] adouble = new double[3];
        double d0 = this.ringBuffer[i][0];
        double d1 = this.ringBuffer[j][0] - d0;
        adouble[0] = d0 + d1 * (double)partialTicks;
        d0 = this.ringBuffer[i][1];
        d1 = this.ringBuffer[j][1] - d0;
        adouble[1] = d0 + d1 * (double)partialTicks;
        adouble[2] = MathHelper.func_219803_d((double)partialTicks, (double)this.ringBuffer[i][2], (double)this.ringBuffer[j][2]);
        return adouble;
    }

    public void func_70108_f(Entity entityIn) {
    }

    private void setPartPosition(EntityCachalotPart part, double offsetX, double offsetY, double offsetZ) {
        part.func_70107_b(this.func_226277_ct_() + offsetX * (double)part.scale, this.func_226278_cu_() + offsetY * (double)part.scale, this.func_226281_cx_() + offsetZ * (double)part.scale);
    }

    public boolean isMultipartEntity() {
        return true;
    }

    public PartEntity<?>[] getParts() {
        return this.whaleParts;
    }

    @Nullable
    public AgeableEntity func_241840_a(ServerWorld serverWorld, AgeableEntity ageableEntity) {
        EntityCachalotWhale whale = (EntityCachalotWhale)AMEntityRegistry.CACHALOT_WHALE.func_200721_a((World)serverWorld);
        whale.setAlbino(this.isAlbino());
        return whale;
    }

    public boolean attackEntityPartFrom(EntityCachalotPart entityCachalotPart, DamageSource source, float amount) {
        return this.func_70097_a(source, amount);
    }

    @Nullable
    public ILivingEntityData func_213386_a(IServerWorld worldIn, DifficultyInstance difficultyIn, SpawnReason reason, @Nullable ILivingEntityData spawnDataIn, @Nullable CompoundNBT dataTag) {
        this.func_70050_g(this.func_205010_bg());
        this.field_70125_A = 0.0f;
        if (spawnDataIn == null) {
            spawnDataIn = new AgeableEntity.AgeableData(0.75f);
        }
        this.setAlbino(this.field_70146_Z.nextInt(100) == 0);
        return super.func_213386_a(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
    }

    public boolean func_70648_aU() {
        return false;
    }

    public void func_70030_z() {
        int i = this.func_70086_ai();
        super.func_70030_z();
        this.updateAir(i);
    }

    public boolean func_96092_aw() {
        return false;
    }

    public CreatureAttribute func_70668_bt() {
        return CreatureAttribute.field_203100_e;
    }

    public boolean func_205019_a(IWorldReader worldIn) {
        return worldIn.func_226668_i_((Entity)this);
    }

    protected void updateAir(int p_209207_1_) {
    }

    public int func_205010_bg() {
        return 4000;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_70103_a(byte id) {
        if (id == 67) {
            this.spawnSpoutParticles();
        } else {
            super.func_70103_a(id);
        }
    }

    protected int func_207300_l(int currentAir) {
        if (!this.func_208600_a((ITag)FluidTags.field_206959_a) && this.prevEyesInWater && !this.field_70170_p.field_72995_K && this.spoutTimer <= 0 && currentAir < this.func_205010_bg() / 2) {
            this.spoutTimer = 20 + this.field_70146_Z.nextInt(10);
        }
        return this.func_205010_bg();
    }

    public int func_70646_bf() {
        return 1;
    }

    public int func_184649_cE() {
        return 3;
    }

    public void recieveEcho() {
        this.receivedEcho = true;
    }

    public boolean func_213380_a(IWorld worldIn, SpawnReason spawnReasonIn) {
        return AMEntityRegistry.rollSpawn(AMConfig.cachalotWhaleSpawnRolls, this.func_70681_au(), spawnReasonIn);
    }

    class AIBreathe
    extends Goal {
        public AIBreathe() {
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean func_75250_a() {
            return EntityCachalotWhale.this.func_70086_ai() < 140;
        }

        public boolean func_75253_b() {
            return this.func_75250_a();
        }

        public boolean func_220685_C_() {
            return false;
        }

        public void func_75249_e() {
            this.navigate();
        }

        private void navigate() {
            Iterable lvt_1_1_ = BlockPos.func_191531_b((int)MathHelper.func_76128_c((double)(EntityCachalotWhale.this.func_226277_ct_() - 1.0)), (int)MathHelper.func_76128_c((double)EntityCachalotWhale.this.func_226278_cu_()), (int)MathHelper.func_76128_c((double)(EntityCachalotWhale.this.func_226281_cx_() - 1.0)), (int)MathHelper.func_76128_c((double)(EntityCachalotWhale.this.func_226277_ct_() + 1.0)), (int)MathHelper.func_76128_c((double)(EntityCachalotWhale.this.func_226278_cu_() + 8.0)), (int)MathHelper.func_76128_c((double)(EntityCachalotWhale.this.func_226281_cx_() + 1.0)));
            BlockPos lvt_2_1_ = null;
            for (BlockPos lvt_4_1_ : lvt_1_1_) {
                if (!this.canBreatheAt((IWorldReader)EntityCachalotWhale.this.field_70170_p, lvt_4_1_)) continue;
                lvt_2_1_ = lvt_4_1_.func_177979_c((int)((double)EntityCachalotWhale.this.func_213302_cg() * 0.25));
                break;
            }
            if (lvt_2_1_ == null) {
                lvt_2_1_ = new BlockPos(EntityCachalotWhale.this.func_226277_ct_(), EntityCachalotWhale.this.func_226278_cu_() + 4.0, EntityCachalotWhale.this.func_226281_cx_());
            }
            if (EntityCachalotWhale.this.func_208600_a((ITag)FluidTags.field_206959_a)) {
                EntityCachalotWhale.this.func_213317_d(EntityCachalotWhale.this.func_213322_ci().func_72441_c(0.0, (double)0.05f, 0.0));
            }
            EntityCachalotWhale.this.func_70661_as().func_75492_a((double)lvt_2_1_.func_177958_n(), (double)lvt_2_1_.func_177956_o(), (double)lvt_2_1_.func_177952_p(), 0.7);
        }

        public void func_75246_d() {
            this.navigate();
        }

        private boolean canBreatheAt(IWorldReader p_205140_1_, BlockPos p_205140_2_) {
            BlockState lvt_3_1_ = p_205140_1_.func_180495_p(p_205140_2_);
            return (p_205140_1_.func_204610_c(p_205140_2_).func_206888_e() || lvt_3_1_.func_203425_a(Blocks.field_203203_C)) && lvt_3_1_.func_196957_g((IBlockReader)p_205140_1_, p_205140_2_, PathType.LAND);
        }
    }
}

