/*
 * Decompiled with CFR 0.152.
 */
package com.InfinityRaider.AgriCraft.renderers.player.renderhooks;

import com.InfinityRaider.AgriCraft.renderers.particles.DustFX;
import com.InfinityRaider.AgriCraft.renderers.player.renderhooks.PlayerEffectRenderer;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.RenderPlayer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Vec3;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class PlayerEffectRendererButterfly
extends PlayerEffectRenderer {
    private short counter = 0;
    private final ResourceLocation texture = new ResourceLocation("agricraft", "textures/entities/player/butterfly/butterfly.png");
    private final ResourceLocation sparkle = new ResourceLocation("agricraft", "textures/entities/player/butterfly/sparkle.png");

    protected PlayerEffectRendererButterfly() {
    }

    @Override
    ArrayList<String> getDisplayNames() {
        ArrayList<String> names = new ArrayList<String>();
        names.add("ValsNoisyToys");
        return names;
    }

    @Override
    void renderEffects(EntityPlayer player, RenderPlayer renderer, float partialTick) {
        double[] pos = this.getPosition();
        GL11.glTranslated((double)pos[0], (double)pos[1], (double)pos[2]);
        this.renderWings();
        this.spawnParticles(player, pos[1], partialTick);
        GL11.glTranslated((double)(-pos[0]), (double)(-pos[1]), (double)(-pos[2]));
    }

    private double[] getPosition() {
        double arg = Math.toRadians(360L * (System.currentTimeMillis() & 0x3FFFL) / 16383L);
        double vY = 10.0;
        double aY = 0.1f;
        double dy = aY * Math.cos(vY * arg);
        return new double[]{0.0, -1.0 + dy, 0.5};
    }

    private void renderWings() {
        Tessellator tessellator = Tessellator.field_78398_a;
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glDisable((int)2896);
        Minecraft.func_71410_x().field_71446_o.func_110577_a(this.texture);
        float arg = (float)Math.toRadians(14400L * (System.currentTimeMillis() & 0x3FFFL) / 16383L % 360L);
        float sin = (float)(20.0 * Math.sin(arg));
        float scale = 0.25f;
        GL11.glRotatef((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)-45.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glRotatef((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glRotatef((float)(45.0f + sin), (float)1.0f, (float)0.0f, (float)0.0f);
        this.draw(tessellator, scale);
        GL11.glRotatef((float)(2.0f * (-45.0f - sin)), (float)1.0f, (float)0.0f, (float)0.0f);
        this.draw(tessellator, scale);
        GL11.glRotatef((float)(45.0f + sin), (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glRotatef((float)-90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glRotatef((float)45.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glRotatef((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glEnable((int)2896);
    }

    private void draw(Tessellator tessellator, float scale) {
        tessellator.func_78382_b();
        tessellator.func_78374_a(0.0, 0.0, 0.0, 0.0, 1.0);
        tessellator.func_78374_a(0.0, 0.0, (double)scale, 1.0, 1.0);
        tessellator.func_78374_a((double)scale, 0.0, (double)scale, 1.0, 0.0);
        tessellator.func_78374_a((double)scale, 0.0, 0.0, 0.0, 0.0);
        tessellator.func_78374_a(0.0, 0.0, 0.0, 0.0, 1.0);
        tessellator.func_78374_a((double)scale, 0.0, 0.0, 0.0, 0.0);
        tessellator.func_78374_a((double)scale, 0.0, (double)scale, 1.0, 0.0);
        tessellator.func_78374_a(0.0, 0.0, (double)scale, 1.0, 1.0);
        tessellator.func_78381_a();
    }

    private void spawnParticles(EntityPlayer player, double y, float partialTick) {
        short delay = 20;
        this.counter = (short)(this.counter + 1);
        if (this.counter >= delay) {
            this.counter = 0;
            double x = 0.0;
            y += player == Minecraft.func_71410_x().field_71439_g ? 0.62 : 0.0;
            double z = -0.5;
            double yaw = Math.toRadians(player.field_70760_ar + (player.field_70761_aq - player.field_70760_ar) * partialTick);
            double cos = Math.cos(yaw);
            double sin = Math.sin(yaw);
            double xNew = x * cos - z * sin;
            double zNew = x * sin + z * cos;
            Vec3 vector = Vec3.func_72443_a((double)0.0, (double)0.0, (double)0.0);
            float scale = player.field_70170_p.field_73012_v.nextFloat();
            double radius = 0.3 * player.field_70170_p.field_73012_v.nextDouble();
            double angle = Math.toRadians(player.field_70170_p.field_73012_v.nextInt(360));
            DustFX particle = new DustFX(player.field_70170_p, player.field_70165_t + xNew + radius * Math.cos(angle), player.field_70163_u - 2.0 * y, player.field_70161_v + zNew + radius * Math.sin(angle), scale, 0.01f, vector, this.sparkle);
            Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)particle);
        }
    }
}

