/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.agricraft.render.models;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.infinityraider.agricraft.AgriCraft;
import com.infinityraider.agricraft.api.v1.content.items.IAgriSeedBagItem;
import com.infinityraider.agricraft.api.v1.plant.IAgriGrowable;
import com.infinityraider.agricraft.api.v1.plant.IAgriPlant;
import com.infinityraider.agricraft.content.tools.ItemSeedBag;
import com.infinityraider.agricraft.impl.v1.plant.AgriPlantRegistry;
import com.infinityraider.infinitylib.render.IRenderUtilities;
import com.infinityraider.infinitylib.render.model.InfModelLoader;
import com.infinityraider.infinitylib.render.tessellation.ITessellator;
import com.mojang.datafixers.util.Pair;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.IModelTransform;
import net.minecraft.client.renderer.model.IUnbakedModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.model.ItemOverrideList;
import net.minecraft.client.renderer.model.ModelBakery;
import net.minecraft.client.renderer.model.RenderMaterial;
import net.minecraft.client.renderer.model.SimpleBakedModel;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.item.ItemStack;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.model.IModelConfiguration;
import net.minecraftforge.client.model.geometry.IModelGeometry;

@OnlyIn(value=Dist.CLIENT)
public class AgriSeedBagSeedModelLoader
implements InfModelLoader<Geometry> {
    private static final ResourceLocation ID = new ResourceLocation(AgriCraft.instance.getModId(), "seed_bag_loader");
    private static final AgriSeedBagSeedModelLoader INSTANCE = new AgriSeedBagSeedModelLoader();
    private final Geometry geometry = new Geometry();

    public static AgriSeedBagSeedModelLoader getInstance() {
        return INSTANCE;
    }

    private AgriSeedBagSeedModelLoader() {
    }

    protected Geometry getGeometry() {
        return this.geometry;
    }

    public ResourceLocation getId() {
        return ID;
    }

    public void func_195410_a(@Nonnull IResourceManager resourceManager) {
    }

    @Nonnull
    public Geometry read(@Nonnull JsonDeserializationContext deserializationContext, @Nonnull JsonObject modelContents) {
        return this.getGeometry();
    }

    public static class BakedModel
    implements IBakedModel,
    IRenderUtilities {
        private final Map<IAgriPlant, IBakedModel> seedQuads = Maps.newIdentityHashMap();
        private final Map<Direction, List<BakedQuad>> emptyMap = this.generateEmptyQuadMap();
        private final IModelConfiguration owner;
        private final ItemOverrideList overrides;
        private IBakedModel baseModelEmpty;
        private IBakedModel baseModelPartial;
        private IBakedModel baseModelFull;

        private BakedModel(IModelConfiguration owner, ItemOverrideList overrides) {
            this.owner = owner;
            this.overrides = overrides;
        }

        @Nonnull
        public List<BakedQuad> func_200117_a(@Nullable BlockState state, @Nullable Direction side, @Nonnull Random rand) {
            return ImmutableList.of();
        }

        public boolean func_177555_b() {
            return false;
        }

        public boolean func_177556_c() {
            return true;
        }

        public boolean func_230044_c_() {
            return false;
        }

        public boolean func_188618_c() {
            return false;
        }

        @Nonnull
        public TextureAtlasSprite func_177554_e() {
            return this.getMissingSprite();
        }

        @Nonnull
        @Deprecated
        public ItemCameraTransforms func_177552_f() {
            return this.owner.getCameraTransforms();
        }

        @Nonnull
        public ItemOverrideList func_188617_f() {
            return this.overrides;
        }

        public boolean isLayered() {
            return true;
        }

        public List<Pair<IBakedModel, RenderType>> getLayerModels(ItemStack stack, boolean fabulous) {
            if (!(stack.func_77973_b() instanceof ItemSeedBag)) {
                return Collections.emptyList();
            }
            ItemSeedBag bag = (ItemSeedBag)stack.func_77973_b();
            if (!bag.isActivated(stack)) {
                return Collections.singletonList(Pair.of((Object)this.getEmptyBagModel(), (Object)RenderTypeLookup.func_239219_a_((ItemStack)stack, (boolean)fabulous)));
            }
            IAgriSeedBagItem.Contents contents = bag.getContents(stack);
            if (!contents.getPlant().isPlant()) {
                return Collections.singletonList(Pair.of((Object)this.getEmptyBagModel(), (Object)RenderTypeLookup.func_239219_a_((ItemStack)stack, (boolean)fabulous)));
            }
            RenderType type = RenderTypeLookup.func_239219_a_((ItemStack)stack, (boolean)fabulous);
            return Lists.newArrayList((Object[])new Pair[]{Pair.of((Object)(contents.isFull() ? this.getFullBagModel() : this.getPartialBagModel()), (Object)type), Pair.of((Object)this.getOrBakeSeedModel(contents.getPlant()), (Object)type)});
        }

        protected IBakedModel getEmptyBagModel() {
            if (this.baseModelEmpty == null) {
                this.baseModelEmpty = this.getModelManager().getModel(new ResourceLocation(AgriCraft.instance.getModId(), "item/agri_seed_bag_empty"));
            }
            return this.baseModelEmpty;
        }

        protected IBakedModel getPartialBagModel() {
            if (this.baseModelPartial == null) {
                this.baseModelPartial = this.getModelManager().getModel(new ResourceLocation(AgriCraft.instance.getModId(), "item/agri_seed_bag_partial"));
            }
            return this.baseModelPartial;
        }

        protected IBakedModel getFullBagModel() {
            if (this.baseModelFull == null) {
                this.baseModelFull = this.getModelManager().getModel(new ResourceLocation(AgriCraft.instance.getModId(), "item/agri_seed_bag_full"));
            }
            return this.baseModelFull;
        }

        protected IBakedModel getOrBakeSeedModel(IAgriPlant plant) {
            return this.seedQuads.computeIfAbsent(plant, this::bakeSeedModel);
        }

        protected IBakedModel bakeSeedModel(IAgriPlant plant) {
            ResourceLocation texture = plant.getSeedTexture();
            TextureAtlasSprite sprite = this.getSprite(texture);
            return new SimpleBakedModel(this.bakeQuads(sprite), this.emptyMap, false, true, false, sprite, ItemCameraTransforms.field_178357_a, ItemOverrideList.field_188022_a);
        }

        protected List<BakedQuad> bakeQuads(TextureAtlasSprite sprite) {
            ITessellator tessellator = this.getBakedQuadTessellator();
            tessellator.startDrawingQuads();
            tessellator.setFace(ITessellator.Face.GENERAL);
            tessellator.drawScaledFace(4.0f, 2.0f, 12.0f, 10.0f, Direction.NORTH, sprite, 7.499f, 0.0f, 0.0f, 16.0f, 16.0f);
            tessellator.drawScaledFace(4.0f, 2.0f, 12.0f, 10.0f, Direction.SOUTH, sprite, 8.501f, 0.0f, 0.0f, 16.0f, 16.0f);
            ImmutableList quads = tessellator.getQuads();
            tessellator.draw();
            return quads;
        }

        private Map<Direction, List<BakedQuad>> generateEmptyQuadMap() {
            EnumMap map = Maps.newEnumMap(Direction.class);
            List quads = Collections.emptyList();
            Arrays.stream(Direction.values()).forEach(dir -> map.put(dir, quads));
            return ImmutableMap.copyOf((Map)map);
        }
    }

    public static class Geometry
    implements IModelGeometry<Geometry>,
    IRenderUtilities {
        private Geometry() {
        }

        public IBakedModel bake(IModelConfiguration owner, ModelBakery bakery, Function<RenderMaterial, TextureAtlasSprite> spriteGetter, IModelTransform transforms, ItemOverrideList overrides, ResourceLocation modelLocation) {
            return new BakedModel(owner, overrides);
        }

        public Collection<RenderMaterial> getTextures(IModelConfiguration owner, Function<ResourceLocation, IUnbakedModel> modelGetter, Set<Pair<String, String>> missingTextureErrors) {
            ImmutableList.Builder builder = new ImmutableList.Builder();
            AgriPlantRegistry.getInstance().all().stream().map(IAgriGrowable.WithSeed::getSeedTexture).forEach(rl -> builder.add((Object)new RenderMaterial(this.getTextureAtlasLocation(), rl)));
            return builder.build();
        }
    }
}

