/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.agricraft.render.items.journal.page;

import com.google.common.collect.ImmutableList;
import com.infinityraider.agricraft.AgriCraft;
import com.infinityraider.agricraft.api.v1.AgriApi;
import com.infinityraider.agricraft.api.v1.crop.IAgriGrowthStage;
import com.infinityraider.agricraft.api.v1.genetics.IAgriMutation;
import com.infinityraider.agricraft.api.v1.plant.IAgriPlant;
import com.infinityraider.agricraft.api.v1.requirement.AgriSeason;
import com.infinityraider.agricraft.api.v1.requirement.IAgriGrowthRequirement;
import com.infinityraider.agricraft.api.v1.requirement.IAgriSoil;
import com.infinityraider.agricraft.capability.CapabilityResearchedPlants;
import com.infinityraider.agricraft.config.Config;
import com.infinityraider.agricraft.impl.v1.plant.NoPlant;
import com.infinityraider.agricraft.network.MessagePlantResearched;
import com.infinityraider.agricraft.render.items.journal.PageRenderer;
import com.infinityraider.agricraft.render.items.journal.page.BasePage;
import com.infinityraider.infinitylib.render.IRenderUtilities;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.Comparator;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public final class PlantPage
extends BasePage
implements IRenderUtilities {
    private static final ITextComponent GROWTH_STAGES = new TranslationTextComponent("agricraft.tooltip.growth_stages");
    private static final ITextComponent GROWTH_REQUIREMENTS = new TranslationTextComponent("agricraft.tooltip.growth_requirements");
    private static final ITextComponent PRODUCTS = new TranslationTextComponent("agricraft.tooltip.products");
    private static final ITextComponent MUTATIONS = new TranslationTextComponent("agricraft.tooltip.mutations");
    private final IAgriPlant plant;
    private final List<IAgriPlant> all;
    private final List<IAgriGrowthStage> stages;
    private final boolean[] brightnessMask;
    private final boolean[] humidityMask;
    private final boolean[] acidityMask;
    private final boolean[] nutrientsMask;
    private final boolean[] seasonMask;
    private final List<ItemStack> drops;
    private final List<List<IAgriPlant>> mutationsOnPage;
    private final List<List<IAgriPlant>> mutationsOffPage;

    public PlantPage(IAgriPlant plant, List<IAgriPlant> all) {
        this.plant = plant;
        this.all = all;
        this.stages = plant.getGrowthStages().stream().sorted(Comparator.comparingDouble(IAgriGrowthStage::growthPercentage)).collect(Collectors.toList());
        this.brightnessMask = new boolean[16];
        IAgriGrowthRequirement req = this.plant.getGrowthRequirement(this.plant.getInitialGrowthStage());
        for (int light = 0; light < this.brightnessMask.length; ++light) {
            this.brightnessMask[light] = req.getLightLevelResponse(light, 1).isFertile();
        }
        this.humidityMask = new boolean[IAgriSoil.Humidity.values().length - 1];
        for (int humidity = 0; humidity < this.humidityMask.length; ++humidity) {
            this.humidityMask[humidity] = req.getSoilHumidityResponse(IAgriSoil.Humidity.values()[humidity], 1).isFertile();
        }
        this.acidityMask = new boolean[IAgriSoil.Acidity.values().length - 1];
        for (int acidity = 0; acidity < this.acidityMask.length; ++acidity) {
            this.acidityMask[acidity] = req.getSoilAcidityResponse(IAgriSoil.Acidity.values()[acidity], 1).isFertile();
        }
        this.nutrientsMask = new boolean[IAgriSoil.Nutrients.values().length - 1];
        for (int nutrients = 0; nutrients < this.nutrientsMask.length; ++nutrients) {
            this.nutrientsMask[nutrients] = req.getSoilNutrientsResponse(IAgriSoil.Nutrients.values()[nutrients], 1).isFertile();
        }
        this.seasonMask = new boolean[AgriSeason.values().length - 1];
        for (int season = 0; season < this.seasonMask.length; ++season) {
            this.seasonMask[season] = req.getSeasonResponse(AgriSeason.values()[season], 1).isFertile();
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        this.plant.getAllPossibleProducts(arg_0 -> ((ImmutableList.Builder)builder).add(arg_0));
        this.drops = builder.build();
        List mutations = Stream.concat(this.gatherMutationSprites(mutation -> mutation.hasParent(this.plant)), this.gatherMutationSprites(mutation -> mutation.hasChild(this.plant))).collect(Collectors.toList());
        int count = mutations.size();
        if (count <= 6) {
            this.mutationsOnPage = mutations.subList(0, count);
            this.mutationsOffPage = ImmutableList.of();
        } else {
            this.mutationsOnPage = mutations.subList(0, 6);
            this.mutationsOffPage = mutations.subList(6, count);
        }
    }

    protected Stream<List<IAgriPlant>> gatherMutationSprites(Predicate<IAgriMutation> filter) {
        return AgriApi.getMutationRegistry().stream().filter(filter).map(mutation -> Stream.of(mutation.getParents().get(0), mutation.getParents().get(1), mutation.getChild()).map(plant -> {
            if (this.isPlantKnown((IAgriPlant)plant)) {
                return plant;
            }
            return NoPlant.getInstance();
        }).collect(Collectors.toList()));
    }

    protected boolean isPlantKnown(IAgriPlant plant) {
        if (((Config)AgriCraft.instance.getConfig()).progressiveJEI()) {
            return this.all.contains(plant) || CapabilityResearchedPlants.getInstance().isPlantResearched(AgriCraft.instance.getClientPlayer(), plant);
        }
        return true;
    }

    @Override
    public void onPageOpened() {
        if (!CapabilityResearchedPlants.getInstance().isPlantResearched(AgriCraft.instance.getClientPlayer(), this.plant)) {
            new MessagePlantResearched(this.plant).sendToServer();
        }
    }

    public List<List<IAgriPlant>> getOffPageMutations() {
        return this.mutationsOffPage;
    }

    @Override
    public void drawLeftSheet(PageRenderer renderer, MatrixStack transforms) {
        renderer.drawTexture(transforms, BasePage.Textures.TITLE, 0.0f, 2.0f, 128.0f, 20.0f);
        renderer.drawText(transforms, (ITextComponent)this.plant.getSeedName(), 30.0f, 10.0f);
        float offset = renderer.drawText(transforms, (ITextComponent)this.plant.getInformation(), 10.0f, 30.0f, 0.7f);
        this.drawGrowthRequirements(renderer, transforms, 35.0f + offset);
        this.plant.getGuiRenderer().drawSeed(this.plant, renderer, transforms, 4.0f, 5.0f, 16.0f, 16.0f);
        this.drawGrowthStages(renderer, transforms);
    }

    @Override
    public void drawRightSheet(PageRenderer renderer, MatrixStack transforms) {
        this.drawProducts(renderer, transforms);
        this.drawMutations(renderer, transforms);
    }

    protected void drawGrowthRequirements(PageRenderer renderer, MatrixStack transforms, float offset) {
        int w;
        int dx;
        int i;
        float dy = Math.max(offset, 60.0f);
        dy += renderer.drawText(transforms, GROWTH_REQUIREMENTS, 10.0f, dy, 0.8f) + 1.0f;
        renderer.drawTexture(transforms, BasePage.Textures.BRIGHTNESS_BAR, 6.0f, dy, 66.0f, 8.0f);
        transforms.func_227860_a_();
        transforms.func_227861_a_(0.0, 0.0, (double)-0.001f);
        for (i = 0; i < this.brightnessMask.length; ++i) {
            boolean current = this.brightnessMask[i];
            if (!current) continue;
            boolean prev = i > 0 && this.brightnessMask[i - 1];
            boolean next = i < this.brightnessMask.length - 1 && this.brightnessMask[i + 1];
            renderer.drawTexture(transforms, BasePage.Textures.BRIGHTNESS_HIGHLIGHT, 6 + 4 * i + 1, dy, 4.0f, 8.0f, 0.25f, 0.0f, 0.75f, 1.0f);
            if (!prev) {
                renderer.drawTexture(transforms, BasePage.Textures.BRIGHTNESS_HIGHLIGHT, 6 + 4 * i, dy, 1.0f, 8.0f, 0.0f, 0.0f, 0.25f, 1.0f);
            }
            if (next) continue;
            renderer.drawTexture(transforms, BasePage.Textures.BRIGHTNESS_HIGHLIGHT, 6 + 4 * i + 5, dy, 1.0f, 8.0f, 0.75f, 0.0f, 1.0f, 1.0f);
        }
        dy += 9.0f;
        transforms.func_227865_b_();
        if (AgriApi.getSeasonLogic().isActive()) {
            for (i = 0; i < this.seasonMask.length; ++i) {
                dx = 70;
                w = 10;
                int h = 12;
                int x = i % 2 * (w + 2) + 5;
                int y = i / 2 * (h + 2) + 6;
                float v1 = (0.0f + (float)(i * h)) / 48.0f;
                float v2 = (0.0f + (float)((i + 1) * h)) / 48.0f;
                if (this.seasonMask[i]) {
                    renderer.drawTexture(transforms, BasePage.Textures.SEASONS_FILLED, x + dx, (float)y + dy, w, h, 0.0f, v1, 1.0f, v2);
                    continue;
                }
                renderer.drawTexture(transforms, BasePage.Textures.SEASONS_EMPTY, x + dx, (float)y + dy, w, h, 0.0f, v1, 1.0f, v2);
            }
        }
        for (i = 0; i < this.humidityMask.length; ++i) {
            dx = BasePage.Textures.HUMIDITY_OFFSETS[i];
            w = BasePage.Textures.HUMIDITY_OFFSETS[i + 1] - BasePage.Textures.HUMIDITY_OFFSETS[i];
            float u1 = ((float)dx + 0.0f) / 53.0f;
            float u2 = ((float)(dx + w) + 0.0f) / 53.0f;
            if (this.humidityMask[i]) {
                renderer.drawTexture(transforms, BasePage.Textures.HUMIDITY_FILLED, 10 + dx, dy, w, 12.0f, u1, 0.0f, u2, 1.0f);
                continue;
            }
            renderer.drawTexture(transforms, BasePage.Textures.HUMIDITY_EMPTY, 10 + dx, dy, w, 12.0f, u1, 0.0f, u2, 1.0f);
        }
        dy += 13.0f;
        for (i = 0; i < this.acidityMask.length; ++i) {
            dx = BasePage.Textures.ACIDITY_OFFSETS[i];
            w = BasePage.Textures.ACIDITY_OFFSETS[i + 1] - BasePage.Textures.ACIDITY_OFFSETS[i];
            float u1 = ((float)dx + 0.0f) / 53.0f;
            float u2 = ((float)(dx + w) + 0.0f) / 53.0f;
            if (this.acidityMask[i]) {
                renderer.drawTexture(transforms, BasePage.Textures.ACIDITY_FILLED, 10 + dx, dy, w, 12.0f, u1, 0.0f, u2, 1.0f);
                continue;
            }
            renderer.drawTexture(transforms, BasePage.Textures.ACIDITY_EMPTY, 10 + dx, dy, w, 12.0f, u1, 0.0f, u2, 1.0f);
        }
        dy += 13.0f;
        for (i = 0; i < this.nutrientsMask.length; ++i) {
            dx = BasePage.Textures.NUTRIENTS_OFFSETS[i];
            w = BasePage.Textures.NUTRIENTS_OFFSETS[i + 1] - BasePage.Textures.NUTRIENTS_OFFSETS[i];
            float u1 = ((float)dx + 0.0f) / 53.0f;
            float u2 = ((float)(dx + w) + 0.0f) / 53.0f;
            if (this.nutrientsMask[i]) {
                renderer.drawTexture(transforms, BasePage.Textures.NUTRIENTS_FILLED, 10 + dx, dy, w, 12.0f, u1, 0.0f, u2, 1.0f);
                continue;
            }
            renderer.drawTexture(transforms, BasePage.Textures.NUTRIENTS_EMPTY, 10 + dx, dy, w, 12.0f, u1, 0.0f, u2, 1.0f);
        }
    }

    protected void drawGrowthStages(PageRenderer renderer, MatrixStack transforms) {
        int y0 = 170;
        int delta = 20;
        int rows = this.stages.size() / 6 + (this.stages.size() % 6 > 0 ? 1 : 0);
        int columns = this.stages.size() / rows + (this.stages.size() % rows > 0 ? 1 : 0);
        int row = 0;
        int dx = (renderer.getPageWidth() - 16 * columns) / (columns + 1);
        for (int i = 0; i < this.stages.size(); ++i) {
            int column = i % columns;
            if (i > 0 && column == 0) {
                ++row;
            }
            renderer.drawTexture(transforms, BasePage.Textures.GROWTH_STAGE, dx * (column + 1) + 16 * column - 1, y0 - delta * (rows - row - 1) - 1, 18.0f, 18.0f);
            transforms.func_227860_a_();
            transforms.func_227861_a_(0.0, 0.0, (double)-0.001f);
            this.plant.getGuiRenderer().drawGrowthStage(this.plant, this.stages.get(i), renderer, transforms, dx * (column + 1) + 16 * column, y0 - delta * (rows - row - 1), 16.0f, 16.0f);
            transforms.func_227865_b_();
        }
        renderer.drawText(transforms, GROWTH_STAGES, 10.0f, y0 - delta * rows + 4, 0.9f);
    }

    protected void drawProducts(PageRenderer renderer, MatrixStack transforms) {
        renderer.drawText(transforms, PRODUCTS, 10.0f, 10.0f, 0.8f);
        for (int i = 0; i < this.drops.size(); ++i) {
            renderer.drawTexture(transforms, BasePage.Textures.MUTATION, 10 + i * 20, 19.0f, 18.0f, 18.0f, 0.0f, 0.0f, 0.20930232f, 1.0f);
            renderer.drawItem(transforms, this.drops.get(i), 11 + i * 20, 20.0f);
        }
    }

    protected void drawMutations(PageRenderer renderer, MatrixStack transforms) {
        renderer.drawText(transforms, MUTATIONS, 10.0f, 45.0f, 0.8f);
        int posX = 10;
        int posY = 54;
        int dy = 20;
        for (List<IAgriPlant> plants : this.mutationsOnPage) {
            this.drawMutation(renderer, transforms, posX, posY, plants);
            posY += dy;
        }
    }
}

