/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.agricraft.render.items.journal;

import com.infinityraider.agricraft.api.v1.client.IAgriGrowableGuiRenderer;
import com.infinityraider.infinitylib.render.IRenderUtilities;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.WorldVertexBufferUploader;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Quaternion;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import org.apache.commons.lang3.mutable.MutableFloat;

public class PageRenderer
implements IRenderUtilities,
IAgriGrowableGuiRenderer.RenderContext {
    private static final Quaternion ROTATION_180 = Vector3f.field_229179_b_.func_229187_a_(180.0f);
    private static final Matrix4f PROJECTION = new Matrix4f(new float[]{1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f});
    private final int page_width;
    private final int page_height;
    private final float scale_width;
    private final float scale_height;
    private final float colorModifier;

    protected PageRenderer(float width, float height, float colorModifier) {
        this.page_width = (int)(32.0f * (width - 1.0f));
        this.page_height = (int)(32.0f * (height - 1.0f));
        this.scale_width = (width - 1.0f) / 16.0f;
        this.scale_height = (height - 1.0f) / 16.0f;
        this.colorModifier = colorModifier;
    }

    public int getPageWidth() {
        return this.page_width;
    }

    int getPageHeight() {
        return this.page_height;
    }

    public void drawFullPageTexture(MatrixStack transforms, ResourceLocation texture) {
        this.drawTexture(transforms, texture, 0.0f, 0.0f, this.getPageWidth(), this.getPageHeight());
    }

    public void drawTexture(MatrixStack transforms, ResourceLocation texture, float x, float y, float w, float h) {
        this.drawTexture(transforms, texture, x, y, w, h, 0.0f, 0.0f, 1.0f, 1.0f);
    }

    public void drawTexture(MatrixStack transforms, ResourceLocation texture, float x, float y, float w, float h, float u1, float v1, float u2, float v2) {
        this.bindTexture(texture);
        this.drawTexture(transforms, x, y, w, h, u1, v1, u2, v2, this.colorModifier, this.colorModifier, this.colorModifier, 1.0f);
    }

    public void draw(MatrixStack transforms, TextureAtlasSprite texture, float x, float y, float w, float h) {
        this.draw(transforms, texture, x, y, w, h, 1.0f, 1.0f, 1.0f, 1.0f);
    }

    @Override
    public void draw(MatrixStack transforms, TextureAtlasSprite texture, float x, float y, float w, float h, float r, float g, float b, float a) {
        this.bindTextureAtlas();
        this.drawTexture(transforms, x, y, w, h, texture.func_94209_e(), texture.func_94206_g(), texture.func_94212_f(), texture.func_94210_h(), this.colorModifier * r, this.colorModifier * g, this.colorModifier * b, a);
    }

    protected void drawTexture(MatrixStack transforms, float x, float y, float w, float h, float u1, float v1, float u2, float v2, float r, float g, float b, float a) {
        BufferBuilder bufferbuilder = Tessellator.func_178181_a().func_178180_c();
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181709_i);
        Matrix4f matrix = transforms.func_227866_c_().func_227870_a_();
        float x1 = this.scale_width * x / (float)this.getPageWidth();
        float y1 = this.scale_height * y / (float)this.getPageHeight();
        float x2 = this.scale_width * (x + w) / (float)this.getPageWidth();
        float y2 = this.scale_height * (y + h) / (float)this.getPageHeight();
        bufferbuilder.func_227888_a_(matrix, x1, y2, 0.0f).func_225583_a_(u1, v2).func_227885_a_(r, g, b, a).func_181675_d();
        bufferbuilder.func_227888_a_(matrix, x2, y2, 0.0f).func_225583_a_(u2, v2).func_227885_a_(r, g, b, a).func_181675_d();
        bufferbuilder.func_227888_a_(matrix, x2, y1, 0.0f).func_225583_a_(u2, v1).func_227885_a_(r, g, b, a).func_181675_d();
        bufferbuilder.func_227888_a_(matrix, x1, y1, 0.0f).func_225583_a_(u1, v1).func_227885_a_(r, g, b, a).func_181675_d();
        bufferbuilder.func_178977_d();
        RenderSystem.enableAlphaTest();
        WorldVertexBufferUploader.func_181679_a((BufferBuilder)bufferbuilder);
    }

    public float drawText(MatrixStack transforms, ITextComponent text, float x, float y) {
        return this.drawText(transforms, text, x, y, 1.0f);
    }

    public float drawText(MatrixStack transforms, ITextComponent text, float x, float y, float scale) {
        transforms.func_227860_a_();
        transforms.func_227861_a_((double)(this.scale_width * x / (float)this.getPageWidth()), (double)(this.scale_height * y / (float)this.getPageHeight()), 0.0);
        float f = scale * this.scale_width / (float)this.getPageWidth();
        transforms.func_227862_a_(f, f, 1.0f);
        int l = (int)(((float)this.getPageWidth() - x - 2.0f) / scale);
        MutableFloat dy = new MutableFloat();
        this.getFontRenderer().func_238425_b_((ITextProperties)text, l).forEach(t -> {
            this.getFontRenderer().func_238422_b_(transforms, t, 0.0f, 0.0f, 0);
            this.getFontRenderer().getClass();
            dy.add(9.0f);
            this.getFontRenderer().getClass();
            transforms.func_227861_a_(0.0, 9.0, 0.0);
        });
        transforms.func_227865_b_();
        return dy.getValue().floatValue() * scale;
    }

    public void drawItem(MatrixStack transforms, ItemStack item, float x, float y) {
        transforms.func_227860_a_();
        transforms.func_227861_a_((double)(this.scale_width * (x + 8.0f) / (float)this.getPageWidth()), (double)(this.scale_height * (y + 8.0f) / (float)this.getPageHeight()), 0.0);
        transforms.func_227863_a_(ROTATION_180);
        transforms.func_227860_a_();
        float f = this.scale_width / 8.0f;
        transforms.func_227862_a_(f, f, 1.0f);
        transforms.func_227860_a_();
        transforms.func_227866_c_().func_227870_a_().func_226595_a_(PROJECTION);
        this.renderItem(item, ItemCameraTransforms.TransformType.GUI, 0xF000F0, transforms, (IRenderTypeBuffer)this.getRenderTypeBuffer());
        transforms.func_227865_b_();
        transforms.func_227865_b_();
        transforms.func_227865_b_();
    }

    @Override
    public TextureAtlasSprite getSprite(ResourceLocation location) {
        return super.getSprite(location);
    }
}

