/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.agricraft.render.blocks;

import com.infinityraider.agricraft.AgriCraft;
import com.infinityraider.agricraft.content.world.BlockGreenHouseAir;
import com.infinityraider.agricraft.util.debug.DebugModeGreenHouse;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

@OnlyIn(value=Dist.CLIENT)
public class BlockGreenHouseAirRenderer {
    private static final BlockGreenHouseAirRenderer INSTANCE = new BlockGreenHouseAirRenderer();
    private static final int RANGE = 32;
    private static final float CUBE_SIZE = 0.375f;
    private static final float P1 = 0.3125f;
    private static final float P2 = 0.6875f;

    public static BlockGreenHouseAirRenderer getInstance() {
        return INSTANCE;
    }

    private BlockGreenHouseAirRenderer() {
    }

    @SubscribeEvent
    public void render(RenderWorldLastEvent event) {
        PlayerEntity player = AgriCraft.instance.getClientPlayer();
        ItemStack stack = player.func_184614_ca();
        if (stack.func_77973_b() != AgriCraft.instance.getModItemRegistry().debugger) {
            return;
        }
        if (AgriCraft.instance.getModItemRegistry().debugger.getDebugMode(stack) instanceof DebugModeGreenHouse) {
            this.highlightGreenHouseAirBlocks(player.func_130014_f_(), player.func_233580_cy_(), event.getMatrixStack());
        }
    }

    protected void highlightGreenHouseAirBlocks(World world, BlockPos origin, MatrixStack transforms) {
        IRenderTypeBuffer.Impl buffer = Minecraft.func_71410_x().func_228019_au_().func_228487_b_();
        IVertexBuilder builder = buffer.getBuffer(this.getRenderType());
        transforms.func_227860_a_();
        Vector3d projectedView = Minecraft.func_71410_x().field_71460_t.func_215316_n().func_216785_c();
        transforms.func_227861_a_(-projectedView.field_72450_a, -projectedView.field_72448_b, -projectedView.field_72449_c);
        Matrix4f matrix4f = transforms.func_227866_c_().func_227870_a_();
        BlockPos.Mutable pos = origin.func_239590_i_();
        for (int x = -32; x <= 32; ++x) {
            for (int y = -32; y <= 32; ++y) {
                for (int z = -32; z <= 32; ++z) {
                    pos.func_181079_c(origin.func_177958_n() + x, origin.func_177956_o() + y, origin.func_177952_p() + z);
                    if (!(world.func_180495_p((BlockPos)pos).func_177230_c() instanceof BlockGreenHouseAir)) continue;
                    this.renderWireFrameCube(builder, matrix4f, (BlockPos)pos);
                }
            }
        }
        transforms.func_227865_b_();
        buffer.func_228462_a_(this.getRenderType());
    }

    protected void renderWireFrameCube(IVertexBuilder builder, Matrix4f transforms, BlockPos pos) {
        int x = pos.func_177958_n();
        int y = pos.func_177956_o();
        int z = pos.func_177952_p();
        this.drawLine(builder, transforms, (float)x + 0.3125f, (float)y + 0.3125f, (float)z + 0.3125f, (float)x + 0.6875f, (float)y + 0.3125f, (float)z + 0.3125f);
        this.drawLine(builder, transforms, (float)x + 0.3125f, (float)y + 0.6875f, (float)z + 0.3125f, (float)x + 0.6875f, (float)y + 0.6875f, (float)z + 0.3125f);
        this.drawLine(builder, transforms, (float)x + 0.3125f, (float)y + 0.3125f, (float)z + 0.6875f, (float)x + 0.6875f, (float)y + 0.3125f, (float)z + 0.6875f);
        this.drawLine(builder, transforms, (float)x + 0.3125f, (float)y + 0.6875f, (float)z + 0.6875f, (float)x + 0.6875f, (float)y + 0.6875f, (float)z + 0.6875f);
        this.drawLine(builder, transforms, (float)x + 0.3125f, (float)y + 0.3125f, (float)z + 0.3125f, (float)x + 0.3125f, (float)y + 0.6875f, (float)z + 0.3125f);
        this.drawLine(builder, transforms, (float)x + 0.6875f, (float)y + 0.3125f, (float)z + 0.3125f, (float)x + 0.6875f, (float)y + 0.6875f, (float)z + 0.3125f);
        this.drawLine(builder, transforms, (float)x + 0.3125f, (float)y + 0.3125f, (float)z + 0.6875f, (float)x + 0.3125f, (float)y + 0.6875f, (float)z + 0.6875f);
        this.drawLine(builder, transforms, (float)x + 0.6875f, (float)y + 0.3125f, (float)z + 0.6875f, (float)x + 0.6875f, (float)y + 0.6875f, (float)z + 0.6875f);
        this.drawLine(builder, transforms, (float)x + 0.3125f, (float)y + 0.3125f, (float)z + 0.3125f, (float)x + 0.3125f, (float)y + 0.3125f, (float)z + 0.6875f);
        this.drawLine(builder, transforms, (float)x + 0.3125f, (float)y + 0.6875f, (float)z + 0.3125f, (float)x + 0.3125f, (float)y + 0.6875f, (float)z + 0.6875f);
        this.drawLine(builder, transforms, (float)x + 0.6875f, (float)y + 0.3125f, (float)z + 0.3125f, (float)x + 0.6875f, (float)y + 0.3125f, (float)z + 0.6875f);
        this.drawLine(builder, transforms, (float)x + 0.6875f, (float)y + 0.6875f, (float)z + 0.3125f, (float)x + 0.6875f, (float)y + 0.6875f, (float)z + 0.6875f);
    }

    protected void drawLine(IVertexBuilder builder, Matrix4f transforms, float x1, float y1, float z1, float x2, float y2, float z2) {
        builder.func_227888_a_(transforms, x1, y1, z1).func_227885_a_(0.0f, 1.0f, 0.0f, 1.0f).func_181675_d();
        builder.func_227888_a_(transforms, x2, y2, z2).func_227885_a_(0.0f, 1.0f, 0.0f, 1.0f).func_181675_d();
    }

    protected RenderType getRenderType() {
        return RenderType.func_228659_m_();
    }
}

