/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.agricraft.proxy;

import com.infinityraider.agricraft.capability.CapabilityCrop;
import com.infinityraider.agricraft.capability.CapabilityEatCropGoal;
import com.infinityraider.agricraft.capability.CapabilityGeneInspector;
import com.infinityraider.agricraft.capability.CapabilityGreenHouseData;
import com.infinityraider.agricraft.capability.CapabilityResearchedPlants;
import com.infinityraider.agricraft.capability.CapabilitySeedBagContents;
import com.infinityraider.agricraft.config.Config;
import com.infinityraider.agricraft.content.tools.ItemMagnifyingGlass;
import com.infinityraider.agricraft.handler.AnvilHandler;
import com.infinityraider.agricraft.handler.BlockUpdateHandler;
import com.infinityraider.agricraft.handler.BonemealHandler;
import com.infinityraider.agricraft.handler.DataHandler;
import com.infinityraider.agricraft.handler.JsonSyncHandler;
import com.infinityraider.agricraft.handler.PlayerConnectToServerHandler;
import com.infinityraider.agricraft.handler.SeedBagEnchantingHandler;
import com.infinityraider.agricraft.handler.VanillaSeedConversionHandler;
import com.infinityraider.agricraft.impl.v1.CoreHandler;
import com.infinityraider.agricraft.impl.v1.PluginHandler;
import com.infinityraider.infinitylib.capability.ICapabilityImplementation;
import com.infinityraider.infinitylib.modules.playeranimations.ModulePlayerAnimations;
import com.infinityraider.infinitylib.proxy.base.IProxyBase;
import java.util.function.Function;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Hand;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;
import net.minecraftforge.fml.event.lifecycle.InterModProcessEvent;
import net.minecraftforge.fml.event.server.FMLServerStartingEvent;

public interface IProxy
extends IProxyBase<Config> {
    default public Function<ForgeConfigSpec.Builder, Config> getConfigConstructor() {
        return Config.Server::new;
    }

    default public void onCommonSetupEvent(FMLCommonSetupEvent event) {
        PluginHandler.onCommonSetup(event);
    }

    default public void onInterModEnqueueEvent(InterModEnqueueEvent event) {
        PluginHandler.onInterModEnqueueEvent(event);
    }

    default public void onInterModProcessEvent(InterModProcessEvent event) {
        PluginHandler.onInterModProcessEvent(event);
    }

    default public void onModLoadCompleteEvent(FMLLoadCompleteEvent event) {
        PluginHandler.populateRegistries();
    }

    default public void registerCapabilities() {
        this.registerCapability((ICapabilityImplementation)CapabilityCrop.getInstance());
        this.registerCapability((ICapabilityImplementation)CapabilityEatCropGoal.getInstance());
        this.registerCapability((ICapabilityImplementation)CapabilityGeneInspector.getInstance());
        this.registerCapability((ICapabilityImplementation)CapabilityGreenHouseData.getInstance());
        this.registerCapability((ICapabilityImplementation)CapabilityResearchedPlants.getInstance());
        this.registerCapability((ICapabilityImplementation)CapabilitySeedBagContents.getInstance());
    }

    default public void registerEventHandlers() {
        this.registerEventHandler(AnvilHandler.getInstance());
        this.registerEventHandler(BlockUpdateHandler.getInstance());
        this.registerEventHandler(BonemealHandler.getInstance());
        this.registerEventHandler(JsonSyncHandler.getInstance());
        this.registerEventHandler(SeedBagEnchantingHandler.getInstance());
        this.registerEventHandler(PlayerConnectToServerHandler.getInstance());
        this.registerEventHandler(VanillaSeedConversionHandler.getInstance());
    }

    default public void registerFMLEventHandlers(IEventBus bus) {
        bus.addListener(DataHandler.getInstance()::onGatherDataEvent);
    }

    default public void activateRequiredModules() {
        ModulePlayerAnimations.getInstance().activate();
    }

    default public void onServerStartingEvent(FMLServerStartingEvent event) {
        CoreHandler.init();
    }

    default public boolean isValidRenderType(String renderType) {
        return true;
    }

    default public void toggleSeedAnalyzerActive(boolean status) {
    }

    default public void toggleSeedAnalyzerObserving(boolean status) {
    }

    default public boolean toggleJournalObserving(ItemStack journal, Hand hand) {
        return false;
    }

    default public void toggleMagnifyingGlassObserving(Hand hand) {
    }

    default public boolean isMagnifyingGlassObserving(PlayerEntity player) {
        return ItemMagnifyingGlass.isObserving(player);
    }

    default public int getParticleSetting() {
        return 0;
    }
}

