/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.agricraft.plugins.jei;

import com.google.common.collect.ImmutableList;
import com.infinityraider.agricraft.api.v1.requirement.IAgriSoil;
import com.infinityraider.agricraft.render.items.journal.page.BasePage;
import com.infinityraider.infinitylib.render.IRenderUtilities;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.List;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.client.gui.GuiUtils;

@OnlyIn(value=Dist.CLIENT)
public class SoilPropertyIconRenderer
implements IRenderUtilities {
    private static final SoilPropertyIconRenderer INSTANCE = new SoilPropertyIconRenderer();
    private final ResourceLocation texture_humidity = BasePage.Textures.HUMIDITY_FILLED;
    private final ResourceLocation texture_acidity = BasePage.Textures.ACIDITY_FILLED;
    private final ResourceLocation texture_nutrients = BasePage.Textures.NUTRIENTS_FILLED;
    private final int[] dxHumidity = new int[]{8, 8, 10, 10, 10, 7};
    private final int[] dxAcidity = new int[]{7, 8, 7, 8, 8, 8, 6};
    private final int[] dxNutrients = new int[]{6, 8, 9, 9, 11, 10};

    public static SoilPropertyIconRenderer getInstance() {
        return INSTANCE;
    }

    private SoilPropertyIconRenderer() {
    }

    public void drawHumidityIcon(IAgriSoil.SoilProperty property, MatrixStack transforms, int x, int y, double mX, double mY) {
        this.drawIcon(property, transforms, x, y, mX, mY, this.texture_humidity);
    }

    public void drawAcidityIcon(IAgriSoil.SoilProperty property, MatrixStack transforms, int x, int y, double mX, double mY) {
        this.drawIcon(property, transforms, x, y, mX, mY, this.texture_acidity);
    }

    public void drawNutrientsIcon(IAgriSoil.SoilProperty property, MatrixStack transforms, int x, int y, double mX, double mY) {
        this.drawIcon(property, transforms, x, y, mX, mY, this.texture_nutrients);
    }

    public void drawIcon(IAgriSoil.SoilProperty property, MatrixStack transforms, int x, int y, double mX, double mY, ResourceLocation texture) {
        if (property.isValid()) {
            int index = property.ordinal();
            int[] offsets = this.getOffsets(property);
            int x1 = 0;
            for (int i = 0; i < index; ++i) {
                x1 += offsets[i];
            }
            int w = offsets[index];
            this.bindTexture(texture);
            AbstractGui.func_238466_a_((MatrixStack)transforms, (int)(x + x1), (int)y, (int)w, (int)12, (float)x1, (float)0.0f, (int)w, (int)12, (int)53, (int)12);
            if (mX >= (double)(x + x1) && mX < (double)(x + x1 + w) && mY >= (double)y && mY <= (double)(y + 12)) {
                ImmutableList tooltip = ImmutableList.of((Object)property.getDescription());
                this.drawTooltip(transforms, (List<ITextComponent>)tooltip, mX, mY + 12.0);
            }
        }
    }

    protected void drawTooltip(MatrixStack transforms, List<ITextComponent> tooltip, double x, double y) {
        int w = this.getScaledWindowWidth();
        int h = this.getScaledWindowHeight();
        GuiUtils.drawHoveringText((MatrixStack)transforms, tooltip, (int)((int)x), (int)((int)y), (int)w, (int)h, (int)-1, (FontRenderer)this.getFontRenderer());
    }

    protected int[] getOffsets(IAgriSoil.SoilProperty property) {
        if (property instanceof IAgriSoil.Humidity) {
            return this.dxHumidity;
        }
        if (property instanceof IAgriSoil.Acidity) {
            return this.dxAcidity;
        }
        return this.dxNutrients;
    }
}

