/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.agricraft.plugins.jade;

import com.infinityraider.agricraft.AgriCraft;
import com.infinityraider.agricraft.api.v1.AgriApi;
import com.infinityraider.agricraft.api.v1.plant.IAgriPlant;
import com.infinityraider.agricraft.config.Config;
import com.infinityraider.agricraft.content.core.BlockCropPlant;
import com.infinityraider.agricraft.content.core.TileEntityCropPlant;
import com.infinityraider.agricraft.proxy.IProxy;
import com.infinityraider.agricraft.reference.AgriToolTips;
import java.util.List;
import mcp.mobius.waila.api.IComponentProvider;
import mcp.mobius.waila.api.IDataAccessor;
import mcp.mobius.waila.api.IPluginConfig;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IBlockReader;

public class AgriWailaCropBlockInfoProvider
implements IComponentProvider {
    private static final AgriWailaCropBlockInfoProvider INSTANCE = new AgriWailaCropBlockInfoProvider();

    public static AgriWailaCropBlockInfoProvider getInstance() {
        return INSTANCE;
    }

    private AgriWailaCropBlockInfoProvider() {
    }

    public ItemStack getStack(IDataAccessor accessor, IPluginConfig config) {
        TileEntityCropPlant crop;
        IAgriPlant plant;
        TileEntity tile;
        if (accessor.getBlock() instanceof BlockCropPlant && (tile = accessor.getTileEntity()) instanceof TileEntityCropPlant && (plant = (crop = (TileEntityCropPlant)tile).getPlant()).isPlant()) {
            return plant.toItemStack();
        }
        return ItemStack.field_190927_a;
    }

    public void appendHead(List<ITextComponent> tooltip, IDataAccessor accessor, IPluginConfig config) {
        if (accessor.getBlock() instanceof BlockCropPlant) {
            tooltip.clear();
            tooltip.add(this.getStack(accessor, config).func_200301_q());
        }
    }

    public void appendBody(List<ITextComponent> tooltip, IDataAccessor accessor, IPluginConfig config) {
        AgriApi.getCrop((IBlockReader)accessor.getWorld(), accessor.getPosition()).ifPresent(crop -> {
            PlayerEntity player = accessor.getPlayer();
            if (player.func_184614_ca().func_77973_b() == AgriCraft.instance.getModItemRegistry().debugger) {
                crop.addDisplayInfo(tooltip::add);
                tooltip.add(AgriToolTips.GENOME);
                crop.getGenome().map(genome -> {
                    genome.addDisplayInfo(tooltip::add);
                    return true;
                }).orElseGet(() -> {
                    tooltip.add((ITextComponent)AgriToolTips.UNKNOWN);
                    return false;
                });
            } else if (this.shouldAddInfo(player)) {
                crop.addDisplayInfo(tooltip::add);
            }
        });
        AgriApi.getSoil((IBlockReader)accessor.getWorld(), accessor.getPosition()).ifPresent(soil -> soil.addDisplayInfo(tooltip::add));
    }

    protected boolean shouldAddInfo(PlayerEntity player) {
        if (((Config)AgriCraft.instance.getConfig()).doesMagnifyingGlassControlTOP()) {
            return ((IProxy)AgriCraft.instance.proxy()).isMagnifyingGlassObserving(player);
        }
        return true;
    }
}

